// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.22.0
// 	protoc        v3.11.2
// source: google/privacy/dlp/v2/storage.proto

package dlp

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Categorization of results based on how likely they are to represent a match,
// based on the number of elements they contain which imply a match.
type Likelihood int32

const (
	// Default value; same as POSSIBLE.
	Likelihood_LIKELIHOOD_UNSPECIFIED Likelihood = 0
	// Few matching elements.
	Likelihood_VERY_UNLIKELY Likelihood = 1
	Likelihood_UNLIKELY      Likelihood = 2
	// Some matching elements.
	Likelihood_POSSIBLE Likelihood = 3
	Likelihood_LIKELY   Likelihood = 4
	// Many matching elements.
	Likelihood_VERY_LIKELY Likelihood = 5
)

// Enum value maps for Likelihood.
var (
	Likelihood_name = map[int32]string{
		0: "LIKELIHOOD_UNSPECIFIED",
		1: "VERY_UNLIKELY",
		2: "UNLIKELY",
		3: "POSSIBLE",
		4: "LIKELY",
		5: "VERY_LIKELY",
	}
	Likelihood_value = map[string]int32{
		"LIKELIHOOD_UNSPECIFIED": 0,
		"VERY_UNLIKELY":          1,
		"UNLIKELY":               2,
		"POSSIBLE":               3,
		"LIKELY":                 4,
		"VERY_LIKELY":            5,
	}
)

func (x Likelihood) Enum() *Likelihood {
	p := new(Likelihood)
	*p = x
	return p
}

func (x Likelihood) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Likelihood) Descriptor() protoreflect.EnumDescriptor {
	return file_google_privacy_dlp_v2_storage_proto_enumTypes[0].Descriptor()
}

func (Likelihood) Type() protoreflect.EnumType {
	return &file_google_privacy_dlp_v2_storage_proto_enumTypes[0]
}

func (x Likelihood) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Likelihood.Descriptor instead.
func (Likelihood) EnumDescriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_storage_proto_rawDescGZIP(), []int{0}
}

// Definitions of file type groups to scan.
type FileType int32

const (
	// Includes all files.
	FileType_FILE_TYPE_UNSPECIFIED FileType = 0
	// Includes all file extensions not covered by text file types.
	FileType_BINARY_FILE FileType = 1
	// Included file extensions:
	//   asc, brf, c, cc, cpp, csv, cxx, c++, cs, css, dart, eml, go, h, hh, hpp,
	//   hxx, h++, hs, html, htm, shtml, shtm, xhtml, lhs, ini, java, js, json,
	//   ocaml, md, mkd, markdown, m, ml, mli, pl, pm, php, phtml, pht, py, pyw,
	//   rb, rbw, rs, rc, scala, sh, sql, tex, txt, text, tsv, vcard, vcs, wml,
	//   xml, xsl, xsd, yml, yaml.
	FileType_TEXT_FILE FileType = 2
	// Included file extensions:
	//   bmp, gif, jpg, jpeg, jpe, png.
	// bytes_limit_per_file has no effect on image files.
	// Image inspection is restricted to 'global', 'us', 'asia', and 'europe'.
	FileType_IMAGE FileType = 3
	// Included file extensions:
	//   docx, dotx, docm, dotm
	FileType_WORD FileType = 5
	// Included file extensions:
	//   pdf
	FileType_PDF FileType = 6
	// Included file extensions:
	//   avro
	FileType_AVRO FileType = 7
)

// Enum value maps for FileType.
var (
	FileType_name = map[int32]string{
		0: "FILE_TYPE_UNSPECIFIED",
		1: "BINARY_FILE",
		2: "TEXT_FILE",
		3: "IMAGE",
		5: "WORD",
		6: "PDF",
		7: "AVRO",
	}
	FileType_value = map[string]int32{
		"FILE_TYPE_UNSPECIFIED": 0,
		"BINARY_FILE":           1,
		"TEXT_FILE":             2,
		"IMAGE":                 3,
		"WORD":                  5,
		"PDF":                   6,
		"AVRO":                  7,
	}
)

func (x FileType) Enum() *FileType {
	p := new(FileType)
	*p = x
	return p
}

func (x FileType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FileType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_privacy_dlp_v2_storage_proto_enumTypes[1].Descriptor()
}

func (FileType) Type() protoreflect.EnumType {
	return &file_google_privacy_dlp_v2_storage_proto_enumTypes[1]
}

func (x FileType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FileType.Descriptor instead.
func (FileType) EnumDescriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_storage_proto_rawDescGZIP(), []int{1}
}

type CustomInfoType_ExclusionType int32

const (
	// A finding of this custom info type will not be excluded from results.
	CustomInfoType_EXCLUSION_TYPE_UNSPECIFIED CustomInfoType_ExclusionType = 0
	// A finding of this custom info type will be excluded from final results,
	// but can still affect rule execution.
	CustomInfoType_EXCLUSION_TYPE_EXCLUDE CustomInfoType_ExclusionType = 1
)

// Enum value maps for CustomInfoType_ExclusionType.
var (
	CustomInfoType_ExclusionType_name = map[int32]string{
		0: "EXCLUSION_TYPE_UNSPECIFIED",
		1: "EXCLUSION_TYPE_EXCLUDE",
	}
	CustomInfoType_ExclusionType_value = map[string]int32{
		"EXCLUSION_TYPE_UNSPECIFIED": 0,
		"EXCLUSION_TYPE_EXCLUDE":     1,
	}
)

func (x CustomInfoType_ExclusionType) Enum() *CustomInfoType_ExclusionType {
	p := new(CustomInfoType_ExclusionType)
	*p = x
	return p
}

func (x CustomInfoType_ExclusionType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CustomInfoType_ExclusionType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_privacy_dlp_v2_storage_proto_enumTypes[2].Descriptor()
}

func (CustomInfoType_ExclusionType) Type() protoreflect.EnumType {
	return &file_google_privacy_dlp_v2_storage_proto_enumTypes[2]
}

func (x CustomInfoType_ExclusionType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CustomInfoType_ExclusionType.Descriptor instead.
func (CustomInfoType_ExclusionType) EnumDescriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_storage_proto_rawDescGZIP(), []int{2, 0}
}

// How to sample bytes if not all bytes are scanned. Meaningful only when used
// in conjunction with bytes_limit_per_file. If not specified, scanning would
// start from the top.
type CloudStorageOptions_SampleMethod int32

const (
	CloudStorageOptions_SAMPLE_METHOD_UNSPECIFIED CloudStorageOptions_SampleMethod = 0
	// Scan from the top (default).
	CloudStorageOptions_TOP CloudStorageOptions_SampleMethod = 1
	// For each file larger than bytes_limit_per_file, randomly pick the offset
	// to start scanning. The scanned bytes are contiguous.
	CloudStorageOptions_RANDOM_START CloudStorageOptions_SampleMethod = 2
)

// Enum value maps for CloudStorageOptions_SampleMethod.
var (
	CloudStorageOptions_SampleMethod_name = map[int32]string{
		0: "SAMPLE_METHOD_UNSPECIFIED",
		1: "TOP",
		2: "RANDOM_START",
	}
	CloudStorageOptions_SampleMethod_value = map[string]int32{
		"SAMPLE_METHOD_UNSPECIFIED": 0,
		"TOP":                       1,
		"RANDOM_START":              2,
	}
)

func (x CloudStorageOptions_SampleMethod) Enum() *CloudStorageOptions_SampleMethod {
	p := new(CloudStorageOptions_SampleMethod)
	*p = x
	return p
}

func (x CloudStorageOptions_SampleMethod) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CloudStorageOptions_SampleMethod) Descriptor() protoreflect.EnumDescriptor {
	return file_google_privacy_dlp_v2_storage_proto_enumTypes[3].Descriptor()
}

func (CloudStorageOptions_SampleMethod) Type() protoreflect.EnumType {
	return &file_google_privacy_dlp_v2_storage_proto_enumTypes[3]
}

func (x CloudStorageOptions_SampleMethod) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CloudStorageOptions_SampleMethod.Descriptor instead.
func (CloudStorageOptions_SampleMethod) EnumDescriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_storage_proto_rawDescGZIP(), []int{8, 0}
}

// How to sample rows if not all rows are scanned. Meaningful only when used
// in conjunction with either rows_limit or rows_limit_percent. If not
// specified, scanning would start from the top.
type BigQueryOptions_SampleMethod int32

const (
	BigQueryOptions_SAMPLE_METHOD_UNSPECIFIED BigQueryOptions_SampleMethod = 0
	// Scan from the top (default).
	BigQueryOptions_TOP BigQueryOptions_SampleMethod = 1
	// Randomly pick the row to start scanning. The scanned rows are contiguous.
	BigQueryOptions_RANDOM_START BigQueryOptions_SampleMethod = 2
)

// Enum value maps for BigQueryOptions_SampleMethod.
var (
	BigQueryOptions_SampleMethod_name = map[int32]string{
		0: "SAMPLE_METHOD_UNSPECIFIED",
		1: "TOP",
		2: "RANDOM_START",
	}
	BigQueryOptions_SampleMethod_value = map[string]int32{
		"SAMPLE_METHOD_UNSPECIFIED": 0,
		"TOP":                       1,
		"RANDOM_START":              2,
	}
)

func (x BigQueryOptions_SampleMethod) Enum() *BigQueryOptions_SampleMethod {
	p := new(BigQueryOptions_SampleMethod)
	*p = x
	return p
}

func (x BigQueryOptions_SampleMethod) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BigQueryOptions_SampleMethod) Descriptor() protoreflect.EnumDescriptor {
	return file_google_privacy_dlp_v2_storage_proto_enumTypes[4].Descriptor()
}

func (BigQueryOptions_SampleMethod) Type() protoreflect.EnumType {
	return &file_google_privacy_dlp_v2_storage_proto_enumTypes[4]
}

func (x BigQueryOptions_SampleMethod) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BigQueryOptions_SampleMethod.Descriptor instead.
func (BigQueryOptions_SampleMethod) EnumDescriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_storage_proto_rawDescGZIP(), []int{11, 0}
}

// Type of information detected by the API.
type InfoType struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the information type. Either a name of your choosing when
	// creating a CustomInfoType, or one of the names listed
	// at https://cloud.google.com/dlp/docs/infotypes-reference when specifying
	// a built-in type. InfoType names should conform to the pattern
	// `[a-zA-Z0-9_]{1,64}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *InfoType) Reset() {
	*x = InfoType{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_storage_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InfoType) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InfoType) ProtoMessage() {}

func (x *InfoType) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_storage_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InfoType.ProtoReflect.Descriptor instead.
func (*InfoType) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_storage_proto_rawDescGZIP(), []int{0}
}

func (x *InfoType) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// A reference to a StoredInfoType to use with scanning.
type StoredType struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resource name of the requested `StoredInfoType`, for example
	// `organizations/433245324/storedInfoTypes/432452342` or
	// `projects/project-id/storedInfoTypes/432452342`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Timestamp indicating when the version of the `StoredInfoType` used for
	// inspection was created. Output-only field, populated by the system.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
}

func (x *StoredType) Reset() {
	*x = StoredType{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_storage_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StoredType) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StoredType) ProtoMessage() {}

func (x *StoredType) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_storage_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StoredType.ProtoReflect.Descriptor instead.
func (*StoredType) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_storage_proto_rawDescGZIP(), []int{1}
}

func (x *StoredType) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *StoredType) GetCreateTime() *timestamp.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

// Custom information type provided by the user. Used to find domain-specific
// sensitive information configurable to the data in question.
type CustomInfoType struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// CustomInfoType can either be a new infoType, or an extension of built-in
	// infoType, when the name matches one of existing infoTypes and that infoType
	// is specified in `InspectContent.info_types` field. Specifying the latter
	// adds findings to the one detected by the system. If built-in info type is
	// not specified in `InspectContent.info_types` list then the name is treated
	// as a custom info type.
	InfoType *InfoType `protobuf:"bytes,1,opt,name=info_type,json=infoType,proto3" json:"info_type,omitempty"`
	// Likelihood to return for this CustomInfoType. This base value can be
	// altered by a detection rule if the finding meets the criteria specified by
	// the rule. Defaults to `VERY_LIKELY` if not specified.
	Likelihood Likelihood `protobuf:"varint,6,opt,name=likelihood,proto3,enum=google.privacy.dlp.v2.Likelihood" json:"likelihood,omitempty"`
	// Types that are assignable to Type:
	//	*CustomInfoType_Dictionary_
	//	*CustomInfoType_Regex_
	//	*CustomInfoType_SurrogateType_
	//	*CustomInfoType_StoredType
	Type isCustomInfoType_Type `protobuf_oneof:"type"`
	// Set of detection rules to apply to all findings of this CustomInfoType.
	// Rules are applied in order that they are specified. Not supported for the
	// `surrogate_type` CustomInfoType.
	DetectionRules []*CustomInfoType_DetectionRule `protobuf:"bytes,7,rep,name=detection_rules,json=detectionRules,proto3" json:"detection_rules,omitempty"`
	// If set to EXCLUSION_TYPE_EXCLUDE this infoType will not cause a finding
	// to be returned. It still can be used for rules matching.
	ExclusionType CustomInfoType_ExclusionType `protobuf:"varint,8,opt,name=exclusion_type,json=exclusionType,proto3,enum=google.privacy.dlp.v2.CustomInfoType_ExclusionType" json:"exclusion_type,omitempty"`
}

func (x *CustomInfoType) Reset() {
	*x = CustomInfoType{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_storage_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CustomInfoType) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CustomInfoType) ProtoMessage() {}

func (x *CustomInfoType) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_storage_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CustomInfoType.ProtoReflect.Descriptor instead.
func (*CustomInfoType) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_storage_proto_rawDescGZIP(), []int{2}
}

func (x *CustomInfoType) GetInfoType() *InfoType {
	if x != nil {
		return x.InfoType
	}
	return nil
}

func (x *CustomInfoType) GetLikelihood() Likelihood {
	if x != nil {
		return x.Likelihood
	}
	return Likelihood_LIKELIHOOD_UNSPECIFIED
}

func (m *CustomInfoType) GetType() isCustomInfoType_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (x *CustomInfoType) GetDictionary() *CustomInfoType_Dictionary {
	if x, ok := x.GetType().(*CustomInfoType_Dictionary_); ok {
		return x.Dictionary
	}
	return nil
}

func (x *CustomInfoType) GetRegex() *CustomInfoType_Regex {
	if x, ok := x.GetType().(*CustomInfoType_Regex_); ok {
		return x.Regex
	}
	return nil
}

func (x *CustomInfoType) GetSurrogateType() *CustomInfoType_SurrogateType {
	if x, ok := x.GetType().(*CustomInfoType_SurrogateType_); ok {
		return x.SurrogateType
	}
	return nil
}

func (x *CustomInfoType) GetStoredType() *StoredType {
	if x, ok := x.GetType().(*CustomInfoType_StoredType); ok {
		return x.StoredType
	}
	return nil
}

func (x *CustomInfoType) GetDetectionRules() []*CustomInfoType_DetectionRule {
	if x != nil {
		return x.DetectionRules
	}
	return nil
}

func (x *CustomInfoType) GetExclusionType() CustomInfoType_ExclusionType {
	if x != nil {
		return x.ExclusionType
	}
	return CustomInfoType_EXCLUSION_TYPE_UNSPECIFIED
}

type isCustomInfoType_Type interface {
	isCustomInfoType_Type()
}

type CustomInfoType_Dictionary_ struct {
	// A list of phrases to detect as a CustomInfoType.
	Dictionary *CustomInfoType_Dictionary `protobuf:"bytes,2,opt,name=dictionary,proto3,oneof"`
}

type CustomInfoType_Regex_ struct {
	// Regular expression based CustomInfoType.
	Regex *CustomInfoType_Regex `protobuf:"bytes,3,opt,name=regex,proto3,oneof"`
}

type CustomInfoType_SurrogateType_ struct {
	// Message for detecting output from deidentification transformations that
	// support reversing.
	SurrogateType *CustomInfoType_SurrogateType `protobuf:"bytes,4,opt,name=surrogate_type,json=surrogateType,proto3,oneof"`
}

type CustomInfoType_StoredType struct {
	// Load an existing `StoredInfoType` resource for use in
	// `InspectDataSource`. Not currently supported in `InspectContent`.
	StoredType *StoredType `protobuf:"bytes,5,opt,name=stored_type,json=storedType,proto3,oneof"`
}

func (*CustomInfoType_Dictionary_) isCustomInfoType_Type() {}

func (*CustomInfoType_Regex_) isCustomInfoType_Type() {}

func (*CustomInfoType_SurrogateType_) isCustomInfoType_Type() {}

func (*CustomInfoType_StoredType) isCustomInfoType_Type() {}

// General identifier of a data field in a storage service.
type FieldId struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name describing the field.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *FieldId) Reset() {
	*x = FieldId{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_storage_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FieldId) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FieldId) ProtoMessage() {}

func (x *FieldId) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_storage_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FieldId.ProtoReflect.Descriptor instead.
func (*FieldId) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_storage_proto_rawDescGZIP(), []int{3}
}

func (x *FieldId) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Datastore partition ID.
// A partition ID identifies a grouping of entities. The grouping is always
// by project and namespace, however the namespace ID may be empty.
//
// A partition ID contains several dimensions:
// project ID and namespace ID.
type PartitionId struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the project to which the entities belong.
	ProjectId string `protobuf:"bytes,2,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// If not empty, the ID of the namespace to which the entities belong.
	NamespaceId string `protobuf:"bytes,4,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
}

func (x *PartitionId) Reset() {
	*x = PartitionId{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_storage_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PartitionId) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PartitionId) ProtoMessage() {}

func (x *PartitionId) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_storage_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PartitionId.ProtoReflect.Descriptor instead.
func (*PartitionId) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_storage_proto_rawDescGZIP(), []int{4}
}

func (x *PartitionId) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *PartitionId) GetNamespaceId() string {
	if x != nil {
		return x.NamespaceId
	}
	return ""
}

// A representation of a Datastore kind.
type KindExpression struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the kind.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *KindExpression) Reset() {
	*x = KindExpression{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_storage_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KindExpression) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KindExpression) ProtoMessage() {}

func (x *KindExpression) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_storage_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KindExpression.ProtoReflect.Descriptor instead.
func (*KindExpression) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_storage_proto_rawDescGZIP(), []int{5}
}

func (x *KindExpression) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Options defining a data set within Google Cloud Datastore.
type DatastoreOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A partition ID identifies a grouping of entities. The grouping is always
	// by project and namespace, however the namespace ID may be empty.
	PartitionId *PartitionId `protobuf:"bytes,1,opt,name=partition_id,json=partitionId,proto3" json:"partition_id,omitempty"`
	// The kind to process.
	Kind *KindExpression `protobuf:"bytes,2,opt,name=kind,proto3" json:"kind,omitempty"`
}

func (x *DatastoreOptions) Reset() {
	*x = DatastoreOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_storage_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DatastoreOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DatastoreOptions) ProtoMessage() {}

func (x *DatastoreOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_storage_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DatastoreOptions.ProtoReflect.Descriptor instead.
func (*DatastoreOptions) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_storage_proto_rawDescGZIP(), []int{6}
}

func (x *DatastoreOptions) GetPartitionId() *PartitionId {
	if x != nil {
		return x.PartitionId
	}
	return nil
}

func (x *DatastoreOptions) GetKind() *KindExpression {
	if x != nil {
		return x.Kind
	}
	return nil
}

// Message representing a set of files in a Cloud Storage bucket. Regular
// expressions are used to allow fine-grained control over which files in the
// bucket to include.
//
// Included files are those that match at least one item in `include_regex` and
// do not match any items in `exclude_regex`. Note that a file that matches
// items from both lists will _not_ be included. For a match to occur, the
// entire file path (i.e., everything in the url after the bucket name) must
// match the regular expression.
//
// For example, given the input `{bucket_name: "mybucket", include_regex:
// ["directory1/.*"], exclude_regex:
// ["directory1/excluded.*"]}`:
//
// * `gs://mybucket/directory1/myfile` will be included
// * `gs://mybucket/directory1/directory2/myfile` will be included (`.*` matches
// across `/`)
// * `gs://mybucket/directory0/directory1/myfile` will _not_ be included (the
// full path doesn't match any items in `include_regex`)
// * `gs://mybucket/directory1/excludedfile` will _not_ be included (the path
// matches an item in `exclude_regex`)
//
// If `include_regex` is left empty, it will match all files by default
// (this is equivalent to setting `include_regex: [".*"]`).
//
// Some other common use cases:
//
// * `{bucket_name: "mybucket", exclude_regex: [".*\.pdf"]}` will include all
// files in `mybucket` except for .pdf files
// * `{bucket_name: "mybucket", include_regex: ["directory/[^/]+"]}` will
// include all files directly under `gs://mybucket/directory/`, without matching
// across `/`
type CloudStorageRegexFileSet struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of a Cloud Storage bucket. Required.
	BucketName string `protobuf:"bytes,1,opt,name=bucket_name,json=bucketName,proto3" json:"bucket_name,omitempty"`
	// A list of regular expressions matching file paths to include. All files in
	// the bucket that match at least one of these regular expressions will be
	// included in the set of files, except for those that also match an item in
	// `exclude_regex`. Leaving this field empty will match all files by default
	// (this is equivalent to including `.*` in the list).
	//
	// Regular expressions use RE2
	// [syntax](https://github.com/google/re2/wiki/Syntax); a guide can be found
	// under the google/re2 repository on GitHub.
	IncludeRegex []string `protobuf:"bytes,2,rep,name=include_regex,json=includeRegex,proto3" json:"include_regex,omitempty"`
	// A list of regular expressions matching file paths to exclude. All files in
	// the bucket that match at least one of these regular expressions will be
	// excluded from the scan.
	//
	// Regular expressions use RE2
	// [syntax](https://github.com/google/re2/wiki/Syntax); a guide can be found
	// under the google/re2 repository on GitHub.
	ExcludeRegex []string `protobuf:"bytes,3,rep,name=exclude_regex,json=excludeRegex,proto3" json:"exclude_regex,omitempty"`
}

func (x *CloudStorageRegexFileSet) Reset() {
	*x = CloudStorageRegexFileSet{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_storage_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CloudStorageRegexFileSet) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloudStorageRegexFileSet) ProtoMessage() {}

func (x *CloudStorageRegexFileSet) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_storage_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloudStorageRegexFileSet.ProtoReflect.Descriptor instead.
func (*CloudStorageRegexFileSet) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_storage_proto_rawDescGZIP(), []int{7}
}

func (x *CloudStorageRegexFileSet) GetBucketName() string {
	if x != nil {
		return x.BucketName
	}
	return ""
}

func (x *CloudStorageRegexFileSet) GetIncludeRegex() []string {
	if x != nil {
		return x.IncludeRegex
	}
	return nil
}

func (x *CloudStorageRegexFileSet) GetExcludeRegex() []string {
	if x != nil {
		return x.ExcludeRegex
	}
	return nil
}

// Options defining a file or a set of files within a Google Cloud Storage
// bucket.
type CloudStorageOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The set of one or more files to scan.
	FileSet *CloudStorageOptions_FileSet `protobuf:"bytes,1,opt,name=file_set,json=fileSet,proto3" json:"file_set,omitempty"`
	// Max number of bytes to scan from a file. If a scanned file's size is bigger
	// than this value then the rest of the bytes are omitted. Only one
	// of bytes_limit_per_file and bytes_limit_per_file_percent can be specified.
	BytesLimitPerFile int64 `protobuf:"varint,4,opt,name=bytes_limit_per_file,json=bytesLimitPerFile,proto3" json:"bytes_limit_per_file,omitempty"`
	// Max percentage of bytes to scan from a file. The rest are omitted. The
	// number of bytes scanned is rounded down. Must be between 0 and 100,
	// inclusively. Both 0 and 100 means no limit. Defaults to 0. Only one
	// of bytes_limit_per_file and bytes_limit_per_file_percent can be specified.
	BytesLimitPerFilePercent int32 `protobuf:"varint,8,opt,name=bytes_limit_per_file_percent,json=bytesLimitPerFilePercent,proto3" json:"bytes_limit_per_file_percent,omitempty"`
	// List of file type groups to include in the scan.
	// If empty, all files are scanned and available data format processors
	// are applied. In addition, the binary content of the selected files
	// is always scanned as well.
	// Images are scanned only as binary if the specified region
	// does not support image inspection and no file_types were specified.
	// Image inspection is restricted to 'global', 'us', 'asia', and 'europe'.
	FileTypes    []FileType                       `protobuf:"varint,5,rep,packed,name=file_types,json=fileTypes,proto3,enum=google.privacy.dlp.v2.FileType" json:"file_types,omitempty"`
	SampleMethod CloudStorageOptions_SampleMethod `protobuf:"varint,6,opt,name=sample_method,json=sampleMethod,proto3,enum=google.privacy.dlp.v2.CloudStorageOptions_SampleMethod" json:"sample_method,omitempty"`
	// Limits the number of files to scan to this percentage of the input FileSet.
	// Number of files scanned is rounded down. Must be between 0 and 100,
	// inclusively. Both 0 and 100 means no limit. Defaults to 0.
	FilesLimitPercent int32 `protobuf:"varint,7,opt,name=files_limit_percent,json=filesLimitPercent,proto3" json:"files_limit_percent,omitempty"`
}

func (x *CloudStorageOptions) Reset() {
	*x = CloudStorageOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_storage_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CloudStorageOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloudStorageOptions) ProtoMessage() {}

func (x *CloudStorageOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_storage_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloudStorageOptions.ProtoReflect.Descriptor instead.
func (*CloudStorageOptions) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_storage_proto_rawDescGZIP(), []int{8}
}

func (x *CloudStorageOptions) GetFileSet() *CloudStorageOptions_FileSet {
	if x != nil {
		return x.FileSet
	}
	return nil
}

func (x *CloudStorageOptions) GetBytesLimitPerFile() int64 {
	if x != nil {
		return x.BytesLimitPerFile
	}
	return 0
}

func (x *CloudStorageOptions) GetBytesLimitPerFilePercent() int32 {
	if x != nil {
		return x.BytesLimitPerFilePercent
	}
	return 0
}

func (x *CloudStorageOptions) GetFileTypes() []FileType {
	if x != nil {
		return x.FileTypes
	}
	return nil
}

func (x *CloudStorageOptions) GetSampleMethod() CloudStorageOptions_SampleMethod {
	if x != nil {
		return x.SampleMethod
	}
	return CloudStorageOptions_SAMPLE_METHOD_UNSPECIFIED
}

func (x *CloudStorageOptions) GetFilesLimitPercent() int32 {
	if x != nil {
		return x.FilesLimitPercent
	}
	return 0
}

// Message representing a set of files in Cloud Storage.
type CloudStorageFileSet struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The url, in the format `gs://<bucket>/<path>`. Trailing wildcard in the
	// path is allowed.
	Url string `protobuf:"bytes,1,opt,name=url,proto3" json:"url,omitempty"`
}

func (x *CloudStorageFileSet) Reset() {
	*x = CloudStorageFileSet{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_storage_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CloudStorageFileSet) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloudStorageFileSet) ProtoMessage() {}

func (x *CloudStorageFileSet) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_storage_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloudStorageFileSet.ProtoReflect.Descriptor instead.
func (*CloudStorageFileSet) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_storage_proto_rawDescGZIP(), []int{9}
}

func (x *CloudStorageFileSet) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

// Message representing a single file or path in Cloud Storage.
type CloudStoragePath struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A url representing a file or path (no wildcards) in Cloud Storage.
	// Example: gs://[BUCKET_NAME]/dictionary.txt
	Path string `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
}

func (x *CloudStoragePath) Reset() {
	*x = CloudStoragePath{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_storage_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CloudStoragePath) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloudStoragePath) ProtoMessage() {}

func (x *CloudStoragePath) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_storage_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloudStoragePath.ProtoReflect.Descriptor instead.
func (*CloudStoragePath) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_storage_proto_rawDescGZIP(), []int{10}
}

func (x *CloudStoragePath) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

// Options defining BigQuery table and row identifiers.
type BigQueryOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Complete BigQuery table reference.
	TableReference *BigQueryTable `protobuf:"bytes,1,opt,name=table_reference,json=tableReference,proto3" json:"table_reference,omitempty"`
	// Table fields that may uniquely identify a row within the table. When
	// `actions.saveFindings.outputConfig.table` is specified, the values of
	// columns specified here are available in the output table under
	// `location.content_locations.record_location.record_key.id_values`. Nested
	// fields such as `person.birthdate.year` are allowed.
	IdentifyingFields []*FieldId `protobuf:"bytes,2,rep,name=identifying_fields,json=identifyingFields,proto3" json:"identifying_fields,omitempty"`
	// Max number of rows to scan. If the table has more rows than this value, the
	// rest of the rows are omitted. If not set, or if set to 0, all rows will be
	// scanned. Only one of rows_limit and rows_limit_percent can be specified.
	// Cannot be used in conjunction with TimespanConfig.
	RowsLimit int64 `protobuf:"varint,3,opt,name=rows_limit,json=rowsLimit,proto3" json:"rows_limit,omitempty"`
	// Max percentage of rows to scan. The rest are omitted. The number of rows
	// scanned is rounded down. Must be between 0 and 100, inclusively. Both 0 and
	// 100 means no limit. Defaults to 0. Only one of rows_limit and
	// rows_limit_percent can be specified. Cannot be used in conjunction with
	// TimespanConfig.
	RowsLimitPercent int32                        `protobuf:"varint,6,opt,name=rows_limit_percent,json=rowsLimitPercent,proto3" json:"rows_limit_percent,omitempty"`
	SampleMethod     BigQueryOptions_SampleMethod `protobuf:"varint,4,opt,name=sample_method,json=sampleMethod,proto3,enum=google.privacy.dlp.v2.BigQueryOptions_SampleMethod" json:"sample_method,omitempty"`
	// References to fields excluded from scanning. This allows you to skip
	// inspection of entire columns which you know have no findings.
	ExcludedFields []*FieldId `protobuf:"bytes,5,rep,name=excluded_fields,json=excludedFields,proto3" json:"excluded_fields,omitempty"`
}

func (x *BigQueryOptions) Reset() {
	*x = BigQueryOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_storage_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BigQueryOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQueryOptions) ProtoMessage() {}

func (x *BigQueryOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_storage_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQueryOptions.ProtoReflect.Descriptor instead.
func (*BigQueryOptions) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_storage_proto_rawDescGZIP(), []int{11}
}

func (x *BigQueryOptions) GetTableReference() *BigQueryTable {
	if x != nil {
		return x.TableReference
	}
	return nil
}

func (x *BigQueryOptions) GetIdentifyingFields() []*FieldId {
	if x != nil {
		return x.IdentifyingFields
	}
	return nil
}

func (x *BigQueryOptions) GetRowsLimit() int64 {
	if x != nil {
		return x.RowsLimit
	}
	return 0
}

func (x *BigQueryOptions) GetRowsLimitPercent() int32 {
	if x != nil {
		return x.RowsLimitPercent
	}
	return 0
}

func (x *BigQueryOptions) GetSampleMethod() BigQueryOptions_SampleMethod {
	if x != nil {
		return x.SampleMethod
	}
	return BigQueryOptions_SAMPLE_METHOD_UNSPECIFIED
}

func (x *BigQueryOptions) GetExcludedFields() []*FieldId {
	if x != nil {
		return x.ExcludedFields
	}
	return nil
}

// Shared message indicating Cloud storage type.
type StorageConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Type:
	//	*StorageConfig_DatastoreOptions
	//	*StorageConfig_CloudStorageOptions
	//	*StorageConfig_BigQueryOptions
	//	*StorageConfig_HybridOptions
	Type           isStorageConfig_Type          `protobuf_oneof:"type"`
	TimespanConfig *StorageConfig_TimespanConfig `protobuf:"bytes,6,opt,name=timespan_config,json=timespanConfig,proto3" json:"timespan_config,omitempty"`
}

func (x *StorageConfig) Reset() {
	*x = StorageConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_storage_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StorageConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StorageConfig) ProtoMessage() {}

func (x *StorageConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_storage_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StorageConfig.ProtoReflect.Descriptor instead.
func (*StorageConfig) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_storage_proto_rawDescGZIP(), []int{12}
}

func (m *StorageConfig) GetType() isStorageConfig_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (x *StorageConfig) GetDatastoreOptions() *DatastoreOptions {
	if x, ok := x.GetType().(*StorageConfig_DatastoreOptions); ok {
		return x.DatastoreOptions
	}
	return nil
}

func (x *StorageConfig) GetCloudStorageOptions() *CloudStorageOptions {
	if x, ok := x.GetType().(*StorageConfig_CloudStorageOptions); ok {
		return x.CloudStorageOptions
	}
	return nil
}

func (x *StorageConfig) GetBigQueryOptions() *BigQueryOptions {
	if x, ok := x.GetType().(*StorageConfig_BigQueryOptions); ok {
		return x.BigQueryOptions
	}
	return nil
}

func (x *StorageConfig) GetHybridOptions() *HybridOptions {
	if x, ok := x.GetType().(*StorageConfig_HybridOptions); ok {
		return x.HybridOptions
	}
	return nil
}

func (x *StorageConfig) GetTimespanConfig() *StorageConfig_TimespanConfig {
	if x != nil {
		return x.TimespanConfig
	}
	return nil
}

type isStorageConfig_Type interface {
	isStorageConfig_Type()
}

type StorageConfig_DatastoreOptions struct {
	// Google Cloud Datastore options.
	DatastoreOptions *DatastoreOptions `protobuf:"bytes,2,opt,name=datastore_options,json=datastoreOptions,proto3,oneof"`
}

type StorageConfig_CloudStorageOptions struct {
	// Google Cloud Storage options.
	CloudStorageOptions *CloudStorageOptions `protobuf:"bytes,3,opt,name=cloud_storage_options,json=cloudStorageOptions,proto3,oneof"`
}

type StorageConfig_BigQueryOptions struct {
	// BigQuery options.
	BigQueryOptions *BigQueryOptions `protobuf:"bytes,4,opt,name=big_query_options,json=bigQueryOptions,proto3,oneof"`
}

type StorageConfig_HybridOptions struct {
	// Hybrid inspection options.
	// Early access feature is in a pre-release state and might change or have
	// limited support. For more information, see
	// https://cloud.google.com/products#product-launch-stages.
	HybridOptions *HybridOptions `protobuf:"bytes,9,opt,name=hybrid_options,json=hybridOptions,proto3,oneof"`
}

func (*StorageConfig_DatastoreOptions) isStorageConfig_Type() {}

func (*StorageConfig_CloudStorageOptions) isStorageConfig_Type() {}

func (*StorageConfig_BigQueryOptions) isStorageConfig_Type() {}

func (*StorageConfig_HybridOptions) isStorageConfig_Type() {}

// Configuration to control jobs where the content being inspected is outside
// of Google Cloud Platform.
type HybridOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A short description of where the data is coming from. Will be stored once
	// in the job. 256 max length.
	Description string `protobuf:"bytes,1,opt,name=description,proto3" json:"description,omitempty"`
	// These are labels that each inspection request must include within their
	// 'finding_labels' map. Request may contain others, but any missing one of
	// these will be rejected.
	//
	// Label keys must be between 1 and 63 characters long and must conform
	// to the following regular expression: `[a-z]([-a-z0-9]*[a-z0-9])?`.
	//
	// No more than 10 keys can be required.
	RequiredFindingLabelKeys []string `protobuf:"bytes,2,rep,name=required_finding_label_keys,json=requiredFindingLabelKeys,proto3" json:"required_finding_label_keys,omitempty"`
	// To organize findings, these labels will be added to each finding.
	//
	// Label keys must be between 1 and 63 characters long and must conform
	// to the following regular expression: `[a-z]([-a-z0-9]*[a-z0-9])?`.
	//
	// Label values must be between 0 and 63 characters long and must conform
	// to the regular expression `([a-z]([-a-z0-9]*[a-z0-9])?)?`.
	//
	// No more than 10 labels can be associated with a given finding.
	//
	// Examples:
	// * `"environment" : "production"`
	// * `"pipeline" : "etl"`
	Labels map[string]string `protobuf:"bytes,3,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// If the container is a table, additional information to make findings
	// meaningful such as the columns that are primary keys.
	TableOptions *TableOptions `protobuf:"bytes,4,opt,name=table_options,json=tableOptions,proto3" json:"table_options,omitempty"`
}

func (x *HybridOptions) Reset() {
	*x = HybridOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_storage_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HybridOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HybridOptions) ProtoMessage() {}

func (x *HybridOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_storage_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HybridOptions.ProtoReflect.Descriptor instead.
func (*HybridOptions) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_storage_proto_rawDescGZIP(), []int{13}
}

func (x *HybridOptions) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *HybridOptions) GetRequiredFindingLabelKeys() []string {
	if x != nil {
		return x.RequiredFindingLabelKeys
	}
	return nil
}

func (x *HybridOptions) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *HybridOptions) GetTableOptions() *TableOptions {
	if x != nil {
		return x.TableOptions
	}
	return nil
}

// Row key for identifying a record in BigQuery table.
type BigQueryKey struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Complete BigQuery table reference.
	TableReference *BigQueryTable `protobuf:"bytes,1,opt,name=table_reference,json=tableReference,proto3" json:"table_reference,omitempty"`
	// Row number inferred at the time the table was scanned. This value is
	// nondeterministic, cannot be queried, and may be null for inspection
	// jobs. To locate findings within a table, specify
	// `inspect_job.storage_config.big_query_options.identifying_fields` in
	// `CreateDlpJobRequest`.
	RowNumber int64 `protobuf:"varint,2,opt,name=row_number,json=rowNumber,proto3" json:"row_number,omitempty"`
}

func (x *BigQueryKey) Reset() {
	*x = BigQueryKey{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_storage_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BigQueryKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQueryKey) ProtoMessage() {}

func (x *BigQueryKey) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_storage_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQueryKey.ProtoReflect.Descriptor instead.
func (*BigQueryKey) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_storage_proto_rawDescGZIP(), []int{14}
}

func (x *BigQueryKey) GetTableReference() *BigQueryTable {
	if x != nil {
		return x.TableReference
	}
	return nil
}

func (x *BigQueryKey) GetRowNumber() int64 {
	if x != nil {
		return x.RowNumber
	}
	return 0
}

// Record key for a finding in Cloud Datastore.
type DatastoreKey struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Datastore entity key.
	EntityKey *Key `protobuf:"bytes,1,opt,name=entity_key,json=entityKey,proto3" json:"entity_key,omitempty"`
}

func (x *DatastoreKey) Reset() {
	*x = DatastoreKey{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_storage_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DatastoreKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DatastoreKey) ProtoMessage() {}

func (x *DatastoreKey) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_storage_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DatastoreKey.ProtoReflect.Descriptor instead.
func (*DatastoreKey) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_storage_proto_rawDescGZIP(), []int{15}
}

func (x *DatastoreKey) GetEntityKey() *Key {
	if x != nil {
		return x.EntityKey
	}
	return nil
}

// A unique identifier for a Datastore entity.
// If a key's partition ID or any of its path kinds or names are
// reserved/read-only, the key is reserved/read-only.
// A reserved/read-only key is forbidden in certain documented contexts.
type Key struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Entities are partitioned into subsets, currently identified by a project
	// ID and namespace ID.
	// Queries are scoped to a single partition.
	PartitionId *PartitionId `protobuf:"bytes,1,opt,name=partition_id,json=partitionId,proto3" json:"partition_id,omitempty"`
	// The entity path.
	// An entity path consists of one or more elements composed of a kind and a
	// string or numerical identifier, which identify entities. The first
	// element identifies a _root entity_, the second element identifies
	// a _child_ of the root entity, the third element identifies a child of the
	// second entity, and so forth. The entities identified by all prefixes of
	// the path are called the element's _ancestors_.
	//
	// A path can never be empty, and a path can have at most 100 elements.
	Path []*Key_PathElement `protobuf:"bytes,2,rep,name=path,proto3" json:"path,omitempty"`
}

func (x *Key) Reset() {
	*x = Key{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_storage_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Key) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Key) ProtoMessage() {}

func (x *Key) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_storage_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Key.ProtoReflect.Descriptor instead.
func (*Key) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_storage_proto_rawDescGZIP(), []int{16}
}

func (x *Key) GetPartitionId() *PartitionId {
	if x != nil {
		return x.PartitionId
	}
	return nil
}

func (x *Key) GetPath() []*Key_PathElement {
	if x != nil {
		return x.Path
	}
	return nil
}

// Message for a unique key indicating a record that contains a finding.
type RecordKey struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Type:
	//	*RecordKey_DatastoreKey
	//	*RecordKey_BigQueryKey
	Type isRecordKey_Type `protobuf_oneof:"type"`
	// Values of identifying columns in the given row. Order of values matches
	// the order of `identifying_fields` specified in the scanning request.
	IdValues []string `protobuf:"bytes,5,rep,name=id_values,json=idValues,proto3" json:"id_values,omitempty"`
}

func (x *RecordKey) Reset() {
	*x = RecordKey{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_storage_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RecordKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RecordKey) ProtoMessage() {}

func (x *RecordKey) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_storage_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RecordKey.ProtoReflect.Descriptor instead.
func (*RecordKey) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_storage_proto_rawDescGZIP(), []int{17}
}

func (m *RecordKey) GetType() isRecordKey_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (x *RecordKey) GetDatastoreKey() *DatastoreKey {
	if x, ok := x.GetType().(*RecordKey_DatastoreKey); ok {
		return x.DatastoreKey
	}
	return nil
}

func (x *RecordKey) GetBigQueryKey() *BigQueryKey {
	if x, ok := x.GetType().(*RecordKey_BigQueryKey); ok {
		return x.BigQueryKey
	}
	return nil
}

func (x *RecordKey) GetIdValues() []string {
	if x != nil {
		return x.IdValues
	}
	return nil
}

type isRecordKey_Type interface {
	isRecordKey_Type()
}

type RecordKey_DatastoreKey struct {
	DatastoreKey *DatastoreKey `protobuf:"bytes,2,opt,name=datastore_key,json=datastoreKey,proto3,oneof"`
}

type RecordKey_BigQueryKey struct {
	BigQueryKey *BigQueryKey `protobuf:"bytes,3,opt,name=big_query_key,json=bigQueryKey,proto3,oneof"`
}

func (*RecordKey_DatastoreKey) isRecordKey_Type() {}

func (*RecordKey_BigQueryKey) isRecordKey_Type() {}

// Message defining the location of a BigQuery table. A table is uniquely
// identified  by its project_id, dataset_id, and table_name. Within a query
// a table is often referenced with a string in the format of:
// `<project_id>:<dataset_id>.<table_id>` or
// `<project_id>.<dataset_id>.<table_id>`.
type BigQueryTable struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Google Cloud Platform project ID of the project containing the table.
	// If omitted, project ID is inferred from the API call.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Dataset ID of the table.
	DatasetId string `protobuf:"bytes,2,opt,name=dataset_id,json=datasetId,proto3" json:"dataset_id,omitempty"`
	// Name of the table.
	TableId string `protobuf:"bytes,3,opt,name=table_id,json=tableId,proto3" json:"table_id,omitempty"`
}

func (x *BigQueryTable) Reset() {
	*x = BigQueryTable{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_storage_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BigQueryTable) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQueryTable) ProtoMessage() {}

func (x *BigQueryTable) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_storage_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQueryTable.ProtoReflect.Descriptor instead.
func (*BigQueryTable) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_storage_proto_rawDescGZIP(), []int{18}
}

func (x *BigQueryTable) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *BigQueryTable) GetDatasetId() string {
	if x != nil {
		return x.DatasetId
	}
	return ""
}

func (x *BigQueryTable) GetTableId() string {
	if x != nil {
		return x.TableId
	}
	return ""
}

// Message defining a field of a BigQuery table.
type BigQueryField struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Source table of the field.
	Table *BigQueryTable `protobuf:"bytes,1,opt,name=table,proto3" json:"table,omitempty"`
	// Designated field in the BigQuery table.
	Field *FieldId `protobuf:"bytes,2,opt,name=field,proto3" json:"field,omitempty"`
}

func (x *BigQueryField) Reset() {
	*x = BigQueryField{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_storage_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BigQueryField) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQueryField) ProtoMessage() {}

func (x *BigQueryField) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_storage_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQueryField.ProtoReflect.Descriptor instead.
func (*BigQueryField) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_storage_proto_rawDescGZIP(), []int{19}
}

func (x *BigQueryField) GetTable() *BigQueryTable {
	if x != nil {
		return x.Table
	}
	return nil
}

func (x *BigQueryField) GetField() *FieldId {
	if x != nil {
		return x.Field
	}
	return nil
}

// An entity in a dataset is a field or set of fields that correspond to a
// single person. For example, in medical records the `EntityId` might be a
// patient identifier, or for financial records it might be an account
// identifier. This message is used when generalizations or analysis must take
// into account that multiple rows correspond to the same entity.
type EntityId struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Composite key indicating which field contains the entity identifier.
	Field *FieldId `protobuf:"bytes,1,opt,name=field,proto3" json:"field,omitempty"`
}

func (x *EntityId) Reset() {
	*x = EntityId{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_storage_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EntityId) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EntityId) ProtoMessage() {}

func (x *EntityId) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_storage_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EntityId.ProtoReflect.Descriptor instead.
func (*EntityId) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_storage_proto_rawDescGZIP(), []int{20}
}

func (x *EntityId) GetField() *FieldId {
	if x != nil {
		return x.Field
	}
	return nil
}

// Instructions regarding the table content being inspected.
type TableOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The columns that are the primary keys for table objects included in
	// ContentItem. A copy of this cell's value will stored alongside alongside
	// each finding so that the finding can be traced to the specific row it came
	// from. No more than 3 may be provided.
	IdentifyingFields []*FieldId `protobuf:"bytes,1,rep,name=identifying_fields,json=identifyingFields,proto3" json:"identifying_fields,omitempty"`
}

func (x *TableOptions) Reset() {
	*x = TableOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_storage_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TableOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TableOptions) ProtoMessage() {}

func (x *TableOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_storage_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TableOptions.ProtoReflect.Descriptor instead.
func (*TableOptions) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_storage_proto_rawDescGZIP(), []int{21}
}

func (x *TableOptions) GetIdentifyingFields() []*FieldId {
	if x != nil {
		return x.IdentifyingFields
	}
	return nil
}

// Custom information type based on a dictionary of words or phrases. This can
// be used to match sensitive information specific to the data, such as a list
// of employee IDs or job titles.
//
// Dictionary words are case-insensitive and all characters other than letters
// and digits in the unicode [Basic Multilingual
// Plane](https://en.wikipedia.org/wiki/Plane_%28Unicode%29#Basic_Multilingual_Plane)
// will be replaced with whitespace when scanning for matches, so the
// dictionary phrase "Sam Johnson" will match all three phrases "sam johnson",
// "Sam, Johnson", and "Sam (Johnson)". Additionally, the characters
// surrounding any match must be of a different type than the adjacent
// characters within the word, so letters must be next to non-letters and
// digits next to non-digits. For example, the dictionary word "jen" will
// match the first three letters of the text "jen123" but will return no
// matches for "jennifer".
//
// Dictionary words containing a large number of characters that are not
// letters or digits may result in unexpected findings because such characters
// are treated as whitespace. The
// [limits](https://cloud.google.com/dlp/limits) page contains details about
// the size limits of dictionaries. For dictionaries that do not fit within
// these constraints, consider using `LargeCustomDictionaryConfig` in the
// `StoredInfoType` API.
type CustomInfoType_Dictionary struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Source:
	//	*CustomInfoType_Dictionary_WordList_
	//	*CustomInfoType_Dictionary_CloudStoragePath
	Source isCustomInfoType_Dictionary_Source `protobuf_oneof:"source"`
}

func (x *CustomInfoType_Dictionary) Reset() {
	*x = CustomInfoType_Dictionary{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_storage_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CustomInfoType_Dictionary) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CustomInfoType_Dictionary) ProtoMessage() {}

func (x *CustomInfoType_Dictionary) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_storage_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CustomInfoType_Dictionary.ProtoReflect.Descriptor instead.
func (*CustomInfoType_Dictionary) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_storage_proto_rawDescGZIP(), []int{2, 0}
}

func (m *CustomInfoType_Dictionary) GetSource() isCustomInfoType_Dictionary_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *CustomInfoType_Dictionary) GetWordList() *CustomInfoType_Dictionary_WordList {
	if x, ok := x.GetSource().(*CustomInfoType_Dictionary_WordList_); ok {
		return x.WordList
	}
	return nil
}

func (x *CustomInfoType_Dictionary) GetCloudStoragePath() *CloudStoragePath {
	if x, ok := x.GetSource().(*CustomInfoType_Dictionary_CloudStoragePath); ok {
		return x.CloudStoragePath
	}
	return nil
}

type isCustomInfoType_Dictionary_Source interface {
	isCustomInfoType_Dictionary_Source()
}

type CustomInfoType_Dictionary_WordList_ struct {
	// List of words or phrases to search for.
	WordList *CustomInfoType_Dictionary_WordList `protobuf:"bytes,1,opt,name=word_list,json=wordList,proto3,oneof"`
}

type CustomInfoType_Dictionary_CloudStoragePath struct {
	// Newline-delimited file of words in Cloud Storage. Only a single file
	// is accepted.
	CloudStoragePath *CloudStoragePath `protobuf:"bytes,3,opt,name=cloud_storage_path,json=cloudStoragePath,proto3,oneof"`
}

func (*CustomInfoType_Dictionary_WordList_) isCustomInfoType_Dictionary_Source() {}

func (*CustomInfoType_Dictionary_CloudStoragePath) isCustomInfoType_Dictionary_Source() {}

// Message defining a custom regular expression.
type CustomInfoType_Regex struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Pattern defining the regular expression. Its syntax
	// (https://github.com/google/re2/wiki/Syntax) can be found under the
	// google/re2 repository on GitHub.
	Pattern string `protobuf:"bytes,1,opt,name=pattern,proto3" json:"pattern,omitempty"`
	// The index of the submatch to extract as findings. When not
	// specified, the entire match is returned. No more than 3 may be included.
	GroupIndexes []int32 `protobuf:"varint,2,rep,packed,name=group_indexes,json=groupIndexes,proto3" json:"group_indexes,omitempty"`
}

func (x *CustomInfoType_Regex) Reset() {
	*x = CustomInfoType_Regex{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_storage_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CustomInfoType_Regex) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CustomInfoType_Regex) ProtoMessage() {}

func (x *CustomInfoType_Regex) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_storage_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CustomInfoType_Regex.ProtoReflect.Descriptor instead.
func (*CustomInfoType_Regex) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_storage_proto_rawDescGZIP(), []int{2, 1}
}

func (x *CustomInfoType_Regex) GetPattern() string {
	if x != nil {
		return x.Pattern
	}
	return ""
}

func (x *CustomInfoType_Regex) GetGroupIndexes() []int32 {
	if x != nil {
		return x.GroupIndexes
	}
	return nil
}

// Message for detecting output from deidentification transformations
// such as
// [`CryptoReplaceFfxFpeConfig`](/dlp/docs/reference/rest/v2/organizations.deidentifyTemplates#cryptoreplaceffxfpeconfig).
// These types of transformations are
// those that perform pseudonymization, thereby producing a "surrogate" as
// output. This should be used in conjunction with a field on the
// transformation such as `surrogate_info_type`. This CustomInfoType does
// not support the use of `detection_rules`.
type CustomInfoType_SurrogateType struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *CustomInfoType_SurrogateType) Reset() {
	*x = CustomInfoType_SurrogateType{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_storage_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CustomInfoType_SurrogateType) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CustomInfoType_SurrogateType) ProtoMessage() {}

func (x *CustomInfoType_SurrogateType) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_storage_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CustomInfoType_SurrogateType.ProtoReflect.Descriptor instead.
func (*CustomInfoType_SurrogateType) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_storage_proto_rawDescGZIP(), []int{2, 2}
}

// Deprecated; use `InspectionRuleSet` instead. Rule for modifying a
// `CustomInfoType` to alter behavior under certain circumstances, depending
// on the specific details of the rule. Not supported for the `surrogate_type`
// custom infoType.
type CustomInfoType_DetectionRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Type:
	//	*CustomInfoType_DetectionRule_HotwordRule_
	Type isCustomInfoType_DetectionRule_Type `protobuf_oneof:"type"`
}

func (x *CustomInfoType_DetectionRule) Reset() {
	*x = CustomInfoType_DetectionRule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_storage_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CustomInfoType_DetectionRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CustomInfoType_DetectionRule) ProtoMessage() {}

func (x *CustomInfoType_DetectionRule) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_storage_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CustomInfoType_DetectionRule.ProtoReflect.Descriptor instead.
func (*CustomInfoType_DetectionRule) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_storage_proto_rawDescGZIP(), []int{2, 3}
}

func (m *CustomInfoType_DetectionRule) GetType() isCustomInfoType_DetectionRule_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (x *CustomInfoType_DetectionRule) GetHotwordRule() *CustomInfoType_DetectionRule_HotwordRule {
	if x, ok := x.GetType().(*CustomInfoType_DetectionRule_HotwordRule_); ok {
		return x.HotwordRule
	}
	return nil
}

type isCustomInfoType_DetectionRule_Type interface {
	isCustomInfoType_DetectionRule_Type()
}

type CustomInfoType_DetectionRule_HotwordRule_ struct {
	// Hotword-based detection rule.
	HotwordRule *CustomInfoType_DetectionRule_HotwordRule `protobuf:"bytes,1,opt,name=hotword_rule,json=hotwordRule,proto3,oneof"`
}

func (*CustomInfoType_DetectionRule_HotwordRule_) isCustomInfoType_DetectionRule_Type() {}

// Message defining a list of words or phrases to search for in the data.
type CustomInfoType_Dictionary_WordList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Words or phrases defining the dictionary. The dictionary must contain
	// at least one phrase and every phrase must contain at least 2 characters
	// that are letters or digits. [required]
	Words []string `protobuf:"bytes,1,rep,name=words,proto3" json:"words,omitempty"`
}

func (x *CustomInfoType_Dictionary_WordList) Reset() {
	*x = CustomInfoType_Dictionary_WordList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_storage_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CustomInfoType_Dictionary_WordList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CustomInfoType_Dictionary_WordList) ProtoMessage() {}

func (x *CustomInfoType_Dictionary_WordList) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_storage_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CustomInfoType_Dictionary_WordList.ProtoReflect.Descriptor instead.
func (*CustomInfoType_Dictionary_WordList) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_storage_proto_rawDescGZIP(), []int{2, 0, 0}
}

func (x *CustomInfoType_Dictionary_WordList) GetWords() []string {
	if x != nil {
		return x.Words
	}
	return nil
}

// Message for specifying a window around a finding to apply a detection
// rule.
type CustomInfoType_DetectionRule_Proximity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Number of characters before the finding to consider.
	WindowBefore int32 `protobuf:"varint,1,opt,name=window_before,json=windowBefore,proto3" json:"window_before,omitempty"`
	// Number of characters after the finding to consider.
	WindowAfter int32 `protobuf:"varint,2,opt,name=window_after,json=windowAfter,proto3" json:"window_after,omitempty"`
}

func (x *CustomInfoType_DetectionRule_Proximity) Reset() {
	*x = CustomInfoType_DetectionRule_Proximity{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_storage_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CustomInfoType_DetectionRule_Proximity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CustomInfoType_DetectionRule_Proximity) ProtoMessage() {}

func (x *CustomInfoType_DetectionRule_Proximity) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_storage_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CustomInfoType_DetectionRule_Proximity.ProtoReflect.Descriptor instead.
func (*CustomInfoType_DetectionRule_Proximity) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_storage_proto_rawDescGZIP(), []int{2, 3, 0}
}

func (x *CustomInfoType_DetectionRule_Proximity) GetWindowBefore() int32 {
	if x != nil {
		return x.WindowBefore
	}
	return 0
}

func (x *CustomInfoType_DetectionRule_Proximity) GetWindowAfter() int32 {
	if x != nil {
		return x.WindowAfter
	}
	return 0
}

// Message for specifying an adjustment to the likelihood of a finding as
// part of a detection rule.
type CustomInfoType_DetectionRule_LikelihoodAdjustment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Adjustment:
	//	*CustomInfoType_DetectionRule_LikelihoodAdjustment_FixedLikelihood
	//	*CustomInfoType_DetectionRule_LikelihoodAdjustment_RelativeLikelihood
	Adjustment isCustomInfoType_DetectionRule_LikelihoodAdjustment_Adjustment `protobuf_oneof:"adjustment"`
}

func (x *CustomInfoType_DetectionRule_LikelihoodAdjustment) Reset() {
	*x = CustomInfoType_DetectionRule_LikelihoodAdjustment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_storage_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CustomInfoType_DetectionRule_LikelihoodAdjustment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CustomInfoType_DetectionRule_LikelihoodAdjustment) ProtoMessage() {}

func (x *CustomInfoType_DetectionRule_LikelihoodAdjustment) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_storage_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CustomInfoType_DetectionRule_LikelihoodAdjustment.ProtoReflect.Descriptor instead.
func (*CustomInfoType_DetectionRule_LikelihoodAdjustment) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_storage_proto_rawDescGZIP(), []int{2, 3, 1}
}

func (m *CustomInfoType_DetectionRule_LikelihoodAdjustment) GetAdjustment() isCustomInfoType_DetectionRule_LikelihoodAdjustment_Adjustment {
	if m != nil {
		return m.Adjustment
	}
	return nil
}

func (x *CustomInfoType_DetectionRule_LikelihoodAdjustment) GetFixedLikelihood() Likelihood {
	if x, ok := x.GetAdjustment().(*CustomInfoType_DetectionRule_LikelihoodAdjustment_FixedLikelihood); ok {
		return x.FixedLikelihood
	}
	return Likelihood_LIKELIHOOD_UNSPECIFIED
}

func (x *CustomInfoType_DetectionRule_LikelihoodAdjustment) GetRelativeLikelihood() int32 {
	if x, ok := x.GetAdjustment().(*CustomInfoType_DetectionRule_LikelihoodAdjustment_RelativeLikelihood); ok {
		return x.RelativeLikelihood
	}
	return 0
}

type isCustomInfoType_DetectionRule_LikelihoodAdjustment_Adjustment interface {
	isCustomInfoType_DetectionRule_LikelihoodAdjustment_Adjustment()
}

type CustomInfoType_DetectionRule_LikelihoodAdjustment_FixedLikelihood struct {
	// Set the likelihood of a finding to a fixed value.
	FixedLikelihood Likelihood `protobuf:"varint,1,opt,name=fixed_likelihood,json=fixedLikelihood,proto3,enum=google.privacy.dlp.v2.Likelihood,oneof"`
}

type CustomInfoType_DetectionRule_LikelihoodAdjustment_RelativeLikelihood struct {
	// Increase or decrease the likelihood by the specified number of
	// levels. For example, if a finding would be `POSSIBLE` without the
	// detection rule and `relative_likelihood` is 1, then it is upgraded to
	// `LIKELY`, while a value of -1 would downgrade it to `UNLIKELY`.
	// Likelihood may never drop below `VERY_UNLIKELY` or exceed
	// `VERY_LIKELY`, so applying an adjustment of 1 followed by an
	// adjustment of -1 when base likelihood is `VERY_LIKELY` will result in
	// a final likelihood of `LIKELY`.
	RelativeLikelihood int32 `protobuf:"varint,2,opt,name=relative_likelihood,json=relativeLikelihood,proto3,oneof"`
}

func (*CustomInfoType_DetectionRule_LikelihoodAdjustment_FixedLikelihood) isCustomInfoType_DetectionRule_LikelihoodAdjustment_Adjustment() {
}

func (*CustomInfoType_DetectionRule_LikelihoodAdjustment_RelativeLikelihood) isCustomInfoType_DetectionRule_LikelihoodAdjustment_Adjustment() {
}

// The rule that adjusts the likelihood of findings within a certain
// proximity of hotwords.
type CustomInfoType_DetectionRule_HotwordRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Regular expression pattern defining what qualifies as a hotword.
	HotwordRegex *CustomInfoType_Regex `protobuf:"bytes,1,opt,name=hotword_regex,json=hotwordRegex,proto3" json:"hotword_regex,omitempty"`
	// Proximity of the finding within which the entire hotword must reside.
	// The total length of the window cannot exceed 1000 characters. Note that
	// the finding itself will be included in the window, so that hotwords may
	// be used to match substrings of the finding itself. For example, the
	// certainty of a phone number regex "\(\d{3}\) \d{3}-\d{4}" could be
	// adjusted upwards if the area code is known to be the local area code of
	// a company office using the hotword regex "\(xxx\)", where "xxx"
	// is the area code in question.
	Proximity *CustomInfoType_DetectionRule_Proximity `protobuf:"bytes,2,opt,name=proximity,proto3" json:"proximity,omitempty"`
	// Likelihood adjustment to apply to all matching findings.
	LikelihoodAdjustment *CustomInfoType_DetectionRule_LikelihoodAdjustment `protobuf:"bytes,3,opt,name=likelihood_adjustment,json=likelihoodAdjustment,proto3" json:"likelihood_adjustment,omitempty"`
}

func (x *CustomInfoType_DetectionRule_HotwordRule) Reset() {
	*x = CustomInfoType_DetectionRule_HotwordRule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_storage_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CustomInfoType_DetectionRule_HotwordRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CustomInfoType_DetectionRule_HotwordRule) ProtoMessage() {}

func (x *CustomInfoType_DetectionRule_HotwordRule) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_storage_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CustomInfoType_DetectionRule_HotwordRule.ProtoReflect.Descriptor instead.
func (*CustomInfoType_DetectionRule_HotwordRule) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_storage_proto_rawDescGZIP(), []int{2, 3, 2}
}

func (x *CustomInfoType_DetectionRule_HotwordRule) GetHotwordRegex() *CustomInfoType_Regex {
	if x != nil {
		return x.HotwordRegex
	}
	return nil
}

func (x *CustomInfoType_DetectionRule_HotwordRule) GetProximity() *CustomInfoType_DetectionRule_Proximity {
	if x != nil {
		return x.Proximity
	}
	return nil
}

func (x *CustomInfoType_DetectionRule_HotwordRule) GetLikelihoodAdjustment() *CustomInfoType_DetectionRule_LikelihoodAdjustment {
	if x != nil {
		return x.LikelihoodAdjustment
	}
	return nil
}

// Set of files to scan.
type CloudStorageOptions_FileSet struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Cloud Storage url of the file(s) to scan, in the format
	// `gs://<bucket>/<path>`. Trailing wildcard in the path is allowed.
	//
	// If the url ends in a trailing slash, the bucket or directory represented
	// by the url will be scanned non-recursively (content in sub-directories
	// will not be scanned). This means that `gs://mybucket/` is equivalent to
	// `gs://mybucket/*`, and `gs://mybucket/directory/` is equivalent to
	// `gs://mybucket/directory/*`.
	//
	// Exactly one of `url` or `regex_file_set` must be set.
	Url string `protobuf:"bytes,1,opt,name=url,proto3" json:"url,omitempty"`
	// The regex-filtered set of files to scan. Exactly one of `url` or
	// `regex_file_set` must be set.
	RegexFileSet *CloudStorageRegexFileSet `protobuf:"bytes,2,opt,name=regex_file_set,json=regexFileSet,proto3" json:"regex_file_set,omitempty"`
}

func (x *CloudStorageOptions_FileSet) Reset() {
	*x = CloudStorageOptions_FileSet{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_storage_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CloudStorageOptions_FileSet) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloudStorageOptions_FileSet) ProtoMessage() {}

func (x *CloudStorageOptions_FileSet) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_storage_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloudStorageOptions_FileSet.ProtoReflect.Descriptor instead.
func (*CloudStorageOptions_FileSet) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_storage_proto_rawDescGZIP(), []int{8, 0}
}

func (x *CloudStorageOptions_FileSet) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

func (x *CloudStorageOptions_FileSet) GetRegexFileSet() *CloudStorageRegexFileSet {
	if x != nil {
		return x.RegexFileSet
	}
	return nil
}

// Configuration of the timespan of the items to include in scanning.
// Currently only supported when inspecting Google Cloud Storage and BigQuery.
type StorageConfig_TimespanConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Exclude files or rows older than this value.
	StartTime *timestamp.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Exclude files or rows newer than this value.
	// If set to zero, no upper time limit is applied.
	EndTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Specification of the field containing the timestamp of scanned items.
	// Used for data sources like Datastore and BigQuery.
	//
	// For BigQuery:
	// Required to filter out rows based on the given start and
	// end times. If not specified and the table was modified between the given
	// start and end times, the entire table will be scanned.
	// The valid data types of the timestamp field are: `INTEGER`, `DATE`,
	// `TIMESTAMP`, or `DATETIME` BigQuery column.
	//
	// For Datastore.
	// Valid data types of the timestamp field are: `TIMESTAMP`.
	// Datastore entity will be scanned if the timestamp property does not
	// exist or its value is empty or invalid.
	TimestampField *FieldId `protobuf:"bytes,3,opt,name=timestamp_field,json=timestampField,proto3" json:"timestamp_field,omitempty"`
	// When the job is started by a JobTrigger we will automatically figure out
	// a valid start_time to avoid scanning files that have not been modified
	// since the last time the JobTrigger executed. This will be based on the
	// time of the execution of the last run of the JobTrigger.
	EnableAutoPopulationOfTimespanConfig bool `protobuf:"varint,4,opt,name=enable_auto_population_of_timespan_config,json=enableAutoPopulationOfTimespanConfig,proto3" json:"enable_auto_population_of_timespan_config,omitempty"`
}

func (x *StorageConfig_TimespanConfig) Reset() {
	*x = StorageConfig_TimespanConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_storage_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StorageConfig_TimespanConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StorageConfig_TimespanConfig) ProtoMessage() {}

func (x *StorageConfig_TimespanConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_storage_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StorageConfig_TimespanConfig.ProtoReflect.Descriptor instead.
func (*StorageConfig_TimespanConfig) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_storage_proto_rawDescGZIP(), []int{12, 0}
}

func (x *StorageConfig_TimespanConfig) GetStartTime() *timestamp.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *StorageConfig_TimespanConfig) GetEndTime() *timestamp.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *StorageConfig_TimespanConfig) GetTimestampField() *FieldId {
	if x != nil {
		return x.TimestampField
	}
	return nil
}

func (x *StorageConfig_TimespanConfig) GetEnableAutoPopulationOfTimespanConfig() bool {
	if x != nil {
		return x.EnableAutoPopulationOfTimespanConfig
	}
	return false
}

// A (kind, ID/name) pair used to construct a key path.
//
// If either name or ID is set, the element is complete.
// If neither is set, the element is incomplete.
type Key_PathElement struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The kind of the entity.
	// A kind matching regex `__.*__` is reserved/read-only.
	// A kind must not contain more than 1500 bytes when UTF-8 encoded.
	// Cannot be `""`.
	Kind string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	// The type of ID.
	//
	// Types that are assignable to IdType:
	//	*Key_PathElement_Id
	//	*Key_PathElement_Name
	IdType isKey_PathElement_IdType `protobuf_oneof:"id_type"`
}

func (x *Key_PathElement) Reset() {
	*x = Key_PathElement{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_privacy_dlp_v2_storage_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Key_PathElement) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Key_PathElement) ProtoMessage() {}

func (x *Key_PathElement) ProtoReflect() protoreflect.Message {
	mi := &file_google_privacy_dlp_v2_storage_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Key_PathElement.ProtoReflect.Descriptor instead.
func (*Key_PathElement) Descriptor() ([]byte, []int) {
	return file_google_privacy_dlp_v2_storage_proto_rawDescGZIP(), []int{16, 0}
}

func (x *Key_PathElement) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (m *Key_PathElement) GetIdType() isKey_PathElement_IdType {
	if m != nil {
		return m.IdType
	}
	return nil
}

func (x *Key_PathElement) GetId() int64 {
	if x, ok := x.GetIdType().(*Key_PathElement_Id); ok {
		return x.Id
	}
	return 0
}

func (x *Key_PathElement) GetName() string {
	if x, ok := x.GetIdType().(*Key_PathElement_Name); ok {
		return x.Name
	}
	return ""
}

type isKey_PathElement_IdType interface {
	isKey_PathElement_IdType()
}

type Key_PathElement_Id struct {
	// The auto-allocated ID of the entity.
	// Never equal to zero. Values less than zero are discouraged and may not
	// be supported in the future.
	Id int64 `protobuf:"varint,2,opt,name=id,proto3,oneof"`
}

type Key_PathElement_Name struct {
	// The name of the entity.
	// A name matching regex `__.*__` is reserved/read-only.
	// A name must not be more than 1500 bytes when UTF-8 encoded.
	// Cannot be `""`.
	Name string `protobuf:"bytes,3,opt,name=name,proto3,oneof"`
}

func (*Key_PathElement_Id) isKey_PathElement_IdType() {}

func (*Key_PathElement_Name) isKey_PathElement_IdType() {}

var File_google_privacy_dlp_v2_storage_proto protoreflect.FileDescriptor

var file_google_privacy_dlp_v2_storage_proto_rawDesc = []byte{
	0x0a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79,
	0x2f, 0x64, 0x6c, 0x70, 0x2f, 0x76, 0x32, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x1a, 0x19, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x1e, 0x0a, 0x08, 0x49, 0x6e, 0x66, 0x6f,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x5d, 0x0a, 0x0a, 0x53, 0x74, 0x6f, 0x72,
	0x65, 0x64, 0x54, 0x79, 0x70, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x22, 0xe1, 0x0d, 0x0a, 0x0e, 0x43, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x12, 0x3c, 0x0a, 0x09, 0x69, 0x6e,
	0x66, 0x6f, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64,
	0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x52, 0x08,
	0x69, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x12, 0x41, 0x0a, 0x0a, 0x6c, 0x69, 0x6b, 0x65,
	0x6c, 0x69, 0x68, 0x6f, 0x6f, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x21, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c,
	0x70, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x6b, 0x65, 0x6c, 0x69, 0x68, 0x6f, 0x6f, 0x64, 0x52,
	0x0a, 0x6c, 0x69, 0x6b, 0x65, 0x6c, 0x69, 0x68, 0x6f, 0x6f, 0x64, 0x12, 0x52, 0x0a, 0x0a, 0x64,
	0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79,
	0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x49, 0x6e,
	0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x72,
	0x79, 0x48, 0x00, 0x52, 0x0a, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x72, 0x79, 0x12,
	0x43, 0x0a, 0x05, 0x72, 0x65, 0x67, 0x65, 0x78, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e,
	0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x49, 0x6e, 0x66,
	0x6f, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x52, 0x65, 0x67, 0x65, 0x78, 0x48, 0x00, 0x52, 0x05, 0x72,
	0x65, 0x67, 0x65, 0x78, 0x12, 0x5c, 0x0a, 0x0e, 0x73, 0x75, 0x72, 0x72, 0x6f, 0x67, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c,
	0x70, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x49, 0x6e, 0x66, 0x6f, 0x54,
	0x79, 0x70, 0x65, 0x2e, 0x53, 0x75, 0x72, 0x72, 0x6f, 0x67, 0x61, 0x74, 0x65, 0x54, 0x79, 0x70,
	0x65, 0x48, 0x00, 0x52, 0x0d, 0x73, 0x75, 0x72, 0x72, 0x6f, 0x67, 0x61, 0x74, 0x65, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x44, 0x0a, 0x0b, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e,
	0x53, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x54, 0x79, 0x70, 0x65, 0x48, 0x00, 0x52, 0x0a, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x64, 0x54, 0x79, 0x70, 0x65, 0x12, 0x5c, 0x0a, 0x0f, 0x64, 0x65, 0x74, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x0e, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x5a, 0x0a, 0x0e, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73,
	0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x33,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e,
	0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x49, 0x6e, 0x66,
	0x6f, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x45, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x54,
	0x79, 0x70, 0x65, 0x52, 0x0d, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x79,
	0x70, 0x65, 0x1a, 0xeb, 0x01, 0x0a, 0x0a, 0x44, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x72,
	0x79, 0x12, 0x58, 0x0a, 0x09, 0x77, 0x6f, 0x72, 0x64, 0x5f, 0x6c, 0x69, 0x73, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x69, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x61, 0x72, 0x79, 0x2e, 0x57, 0x6f, 0x72, 0x64, 0x4c, 0x69, 0x73, 0x74, 0x48,
	0x00, 0x52, 0x08, 0x77, 0x6f, 0x72, 0x64, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x57, 0x0a, 0x12, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x70, 0x61, 0x74,
	0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x50, 0x61, 0x74, 0x68,
	0x48, 0x00, 0x52, 0x10, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x50, 0x61, 0x74, 0x68, 0x1a, 0x20, 0x0a, 0x08, 0x57, 0x6f, 0x72, 0x64, 0x4c, 0x69, 0x73, 0x74,
	0x12, 0x14, 0x0a, 0x05, 0x77, 0x6f, 0x72, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x05, 0x77, 0x6f, 0x72, 0x64, 0x73, 0x42, 0x08, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x1a, 0x46, 0x0a, 0x05, 0x52, 0x65, 0x67, 0x65, 0x78, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x61, 0x74,
	0x74, 0x65, 0x72, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x61, 0x74, 0x74,
	0x65, 0x72, 0x6e, 0x12, 0x23, 0x0a, 0x0d, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x69, 0x6e, 0x64,
	0x65, 0x78, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x05, 0x52, 0x0c, 0x67, 0x72, 0x6f, 0x75,
	0x70, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x65, 0x73, 0x1a, 0x0f, 0x0a, 0x0d, 0x53, 0x75, 0x72, 0x72,
	0x6f, 0x67, 0x61, 0x74, 0x65, 0x54, 0x79, 0x70, 0x65, 0x1a, 0xba, 0x05, 0x0a, 0x0d, 0x44, 0x65,
	0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x64, 0x0a, 0x0c, 0x68,
	0x6f, 0x74, 0x77, 0x6f, 0x72, 0x64, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x75, 0x6c, 0x65, 0x2e, 0x48, 0x6f, 0x74, 0x77, 0x6f, 0x72, 0x64, 0x52, 0x75,
	0x6c, 0x65, 0x48, 0x00, 0x52, 0x0b, 0x68, 0x6f, 0x74, 0x77, 0x6f, 0x72, 0x64, 0x52, 0x75, 0x6c,
	0x65, 0x1a, 0x53, 0x0a, 0x09, 0x50, 0x72, 0x6f, 0x78, 0x69, 0x6d, 0x69, 0x74, 0x79, 0x12, 0x23,
	0x0a, 0x0d, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x5f, 0x62, 0x65, 0x66, 0x6f, 0x72, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0c, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x42, 0x65, 0x66,
	0x6f, 0x72, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x5f, 0x61, 0x66,
	0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x77, 0x69, 0x6e, 0x64, 0x6f,
	0x77, 0x41, 0x66, 0x74, 0x65, 0x72, 0x1a, 0xa7, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x6b, 0x65, 0x6c,
	0x69, 0x68, 0x6f, 0x6f, 0x64, 0x41, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x12,
	0x4e, 0x0a, 0x10, 0x66, 0x69, 0x78, 0x65, 0x64, 0x5f, 0x6c, 0x69, 0x6b, 0x65, 0x6c, 0x69, 0x68,
	0x6f, 0x6f, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76,
	0x32, 0x2e, 0x4c, 0x69, 0x6b, 0x65, 0x6c, 0x69, 0x68, 0x6f, 0x6f, 0x64, 0x48, 0x00, 0x52, 0x0f,
	0x66, 0x69, 0x78, 0x65, 0x64, 0x4c, 0x69, 0x6b, 0x65, 0x6c, 0x69, 0x68, 0x6f, 0x6f, 0x64, 0x12,
	0x31, 0x0a, 0x13, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x6c, 0x69, 0x6b, 0x65,
	0x6c, 0x69, 0x68, 0x6f, 0x6f, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x48, 0x00, 0x52, 0x12,
	0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x76, 0x65, 0x4c, 0x69, 0x6b, 0x65, 0x6c, 0x69, 0x68, 0x6f,
	0x6f, 0x64, 0x42, 0x0c, 0x0a, 0x0a, 0x61, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74,
	0x1a, 0xbb, 0x02, 0x0a, 0x0b, 0x48, 0x6f, 0x74, 0x77, 0x6f, 0x72, 0x64, 0x52, 0x75, 0x6c, 0x65,
	0x12, 0x50, 0x0a, 0x0d, 0x68, 0x6f, 0x74, 0x77, 0x6f, 0x72, 0x64, 0x5f, 0x72, 0x65, 0x67, 0x65,
	0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e,
	0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x52,
	0x65, 0x67, 0x65, 0x78, 0x52, 0x0c, 0x68, 0x6f, 0x74, 0x77, 0x6f, 0x72, 0x64, 0x52, 0x65, 0x67,
	0x65, 0x78, 0x12, 0x5b, 0x0a, 0x09, 0x70, 0x72, 0x6f, 0x78, 0x69, 0x6d, 0x69, 0x74, 0x79, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x65, 0x74,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6c, 0x65, 0x2e, 0x50, 0x72, 0x6f, 0x78, 0x69,
	0x6d, 0x69, 0x74, 0x79, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x78, 0x69, 0x6d, 0x69, 0x74, 0x79, 0x12,
	0x7d, 0x0a, 0x15, 0x6c, 0x69, 0x6b, 0x65, 0x6c, 0x69, 0x68, 0x6f, 0x6f, 0x64, 0x5f, 0x61, 0x64,
	0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x48,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e,
	0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x49, 0x6e, 0x66,
	0x6f, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x75, 0x6c, 0x65, 0x2e, 0x4c, 0x69, 0x6b, 0x65, 0x6c, 0x69, 0x68, 0x6f, 0x6f, 0x64, 0x41, 0x64,
	0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x14, 0x6c, 0x69, 0x6b, 0x65, 0x6c, 0x69,
	0x68, 0x6f, 0x6f, 0x64, 0x41, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x06,
	0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0x4b, 0x0a, 0x0d, 0x45, 0x78, 0x63, 0x6c, 0x75, 0x73,
	0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1e, 0x0a, 0x1a, 0x45, 0x58, 0x43, 0x4c, 0x55,
	0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1a, 0x0a, 0x16, 0x45, 0x58, 0x43, 0x4c, 0x55,
	0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x45, 0x58, 0x43, 0x4c, 0x55, 0x44,
	0x45, 0x10, 0x01, 0x42, 0x06, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0x1d, 0x0a, 0x07, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x49, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x4f, 0x0a, 0x0b, 0x50, 0x61,
	0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x6e, 0x61, 0x6d, 0x65,
	0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x49, 0x64, 0x22, 0x24, 0x0a, 0x0e, 0x4b,
	0x69, 0x6e, 0x64, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0x94, 0x01, 0x0a, 0x10, 0x44, 0x61, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x4f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x45, 0x0a, 0x0c, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c,
	0x70, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64,
	0x52, 0x0b, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x39, 0x0a,
	0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70,
	0x2e, 0x76, 0x32, 0x2e, 0x4b, 0x69, 0x6e, 0x64, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x22, 0x85, 0x01, 0x0a, 0x18, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x52, 0x65, 0x67, 0x65, 0x78, 0x46, 0x69,
	0x6c, 0x65, 0x53, 0x65, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x62, 0x75, 0x63, 0x6b,
	0x65, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64,
	0x65, 0x5f, 0x72, 0x65, 0x67, 0x65, 0x78, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0c, 0x69,
	0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x52, 0x65, 0x67, 0x65, 0x78, 0x12, 0x23, 0x0a, 0x0d, 0x65,
	0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x72, 0x65, 0x67, 0x65, 0x78, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x0c, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x52, 0x65, 0x67, 0x65, 0x78,
	0x22, 0xe1, 0x04, 0x0a, 0x13, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x4d, 0x0a, 0x08, 0x66, 0x69, 0x6c, 0x65,
	0x5f, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e,
	0x76, 0x32, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x4f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x53, 0x65, 0x74, 0x52, 0x07,
	0x66, 0x69, 0x6c, 0x65, 0x53, 0x65, 0x74, 0x12, 0x2f, 0x0a, 0x14, 0x62, 0x79, 0x74, 0x65, 0x73,
	0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x11, 0x62, 0x79, 0x74, 0x65, 0x73, 0x4c, 0x69, 0x6d, 0x69,
	0x74, 0x50, 0x65, 0x72, 0x46, 0x69, 0x6c, 0x65, 0x12, 0x3e, 0x0a, 0x1c, 0x62, 0x79, 0x74, 0x65,
	0x73, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x66, 0x69, 0x6c, 0x65,
	0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x05, 0x52, 0x18,
	0x62, 0x79, 0x74, 0x65, 0x73, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x50, 0x65, 0x72, 0x46, 0x69, 0x6c,
	0x65, 0x50, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x12, 0x3e, 0x0a, 0x0a, 0x66, 0x69, 0x6c, 0x65,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x1f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c,
	0x70, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x09, 0x66,
	0x69, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x5c, 0x0a, 0x0d, 0x73, 0x61, 0x6d, 0x70,
	0x6c, 0x65, 0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79,
	0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x53, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x53, 0x61, 0x6d, 0x70,
	0x6c, 0x65, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x52, 0x0c, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65,
	0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x12, 0x2e, 0x0a, 0x13, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x5f,
	0x6c, 0x69, 0x6d, 0x69, 0x74, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x11, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x50,
	0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x1a, 0x72, 0x0a, 0x07, 0x46, 0x69, 0x6c, 0x65, 0x53, 0x65,
	0x74, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x75, 0x72, 0x6c, 0x12, 0x55, 0x0a, 0x0e, 0x72, 0x65, 0x67, 0x65, 0x78, 0x5f, 0x66, 0x69, 0x6c,
	0x65, 0x5f, 0x73, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70,
	0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x52, 0x65, 0x67, 0x65, 0x78, 0x46, 0x69, 0x6c, 0x65, 0x53, 0x65, 0x74, 0x52, 0x0c, 0x72, 0x65,
	0x67, 0x65, 0x78, 0x46, 0x69, 0x6c, 0x65, 0x53, 0x65, 0x74, 0x22, 0x48, 0x0a, 0x0c, 0x53, 0x61,
	0x6d, 0x70, 0x6c, 0x65, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x12, 0x1d, 0x0a, 0x19, 0x53, 0x41,
	0x4d, 0x50, 0x4c, 0x45, 0x5f, 0x4d, 0x45, 0x54, 0x48, 0x4f, 0x44, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x07, 0x0a, 0x03, 0x54, 0x4f, 0x50,
	0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x52, 0x41, 0x4e, 0x44, 0x4f, 0x4d, 0x5f, 0x53, 0x54, 0x41,
	0x52, 0x54, 0x10, 0x02, 0x22, 0x27, 0x0a, 0x13, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x53, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x53, 0x65, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x75,
	0x72, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x6c, 0x22, 0x26, 0x0a,
	0x10, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x50, 0x61, 0x74,
	0x68, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x70, 0x61, 0x74, 0x68, 0x22, 0xe9, 0x03, 0x0a, 0x0f, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x4d, 0x0a, 0x0f, 0x74, 0x61, 0x62,
	0x6c, 0x65, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76,
	0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x0e, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x52,
	0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x4d, 0x0a, 0x12, 0x69, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x66, 0x79, 0x69, 0x6e, 0x67, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x65,
	0x6c, 0x64, 0x49, 0x64, 0x52, 0x11, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x69, 0x6e,
	0x67, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x6f, 0x77, 0x73, 0x5f,
	0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x72, 0x6f, 0x77,
	0x73, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x12, 0x2c, 0x0a, 0x12, 0x72, 0x6f, 0x77, 0x73, 0x5f, 0x6c,
	0x69, 0x6d, 0x69, 0x74, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x10, 0x72, 0x6f, 0x77, 0x73, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x50, 0x65, 0x72,
	0x63, 0x65, 0x6e, 0x74, 0x12, 0x58, 0x0a, 0x0d, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x6d,
	0x65, 0x74, 0x68, 0x6f, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x33, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70,
	0x2e, 0x76, 0x32, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x4f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64,
	0x52, 0x0c, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x12, 0x47,
	0x0a, 0x0f, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e,
	0x46, 0x69, 0x65, 0x6c, 0x64, 0x49, 0x64, 0x52, 0x0e, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65,
	0x64, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x22, 0x48, 0x0a, 0x0c, 0x53, 0x61, 0x6d, 0x70, 0x6c,
	0x65, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x12, 0x1d, 0x0a, 0x19, 0x53, 0x41, 0x4d, 0x50, 0x4c,
	0x45, 0x5f, 0x4d, 0x45, 0x54, 0x48, 0x4f, 0x44, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x07, 0x0a, 0x03, 0x54, 0x4f, 0x50, 0x10, 0x01, 0x12,
	0x10, 0x0a, 0x0c, 0x52, 0x41, 0x4e, 0x44, 0x4f, 0x4d, 0x5f, 0x53, 0x54, 0x41, 0x52, 0x54, 0x10,
	0x02, 0x22, 0xfb, 0x05, 0x0a, 0x0d, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x56, 0x0a, 0x11, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e,
	0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x48, 0x00, 0x52, 0x10, 0x64, 0x61, 0x74, 0x61, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x60, 0x0a, 0x15, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x6f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e,
	0x76, 0x32, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x4f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x48, 0x00, 0x52, 0x13, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x53,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x54, 0x0a,
	0x11, 0x62, 0x69, 0x67, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32,
	0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x48, 0x00, 0x52, 0x0f, 0x62, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x4f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x4d, 0x0a, 0x0e, 0x68, 0x79, 0x62, 0x72, 0x69, 0x64, 0x5f, 0x6f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70,
	0x2e, 0x76, 0x32, 0x2e, 0x48, 0x79, 0x62, 0x72, 0x69, 0x64, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x48, 0x00, 0x52, 0x0d, 0x68, 0x79, 0x62, 0x72, 0x69, 0x64, 0x4f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x5c, 0x0a, 0x0f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x6e, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70,
	0x2e, 0x76, 0x32, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x52, 0x0e, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x1a, 0xa4, 0x02, 0x0a, 0x0e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x6e, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x35,
	0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e,
	0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x47, 0x0a, 0x0f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e,
	0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x49, 0x64, 0x52, 0x0e,
	0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x12, 0x57,
	0x0a, 0x29, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x5f, 0x70, 0x6f,
	0x70, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6f, 0x66, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x73, 0x70, 0x61, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x24, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x50, 0x6f, 0x70,
	0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x66, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x70, 0x61,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x06, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x22,
	0xbf, 0x02, 0x0a, 0x0d, 0x48, 0x79, 0x62, 0x72, 0x69, 0x64, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x3d, 0x0a, 0x1b, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x5f,
	0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x6b, 0x65,
	0x79, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x18, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72,
	0x65, 0x64, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x4b, 0x65,
	0x79, 0x73, 0x12, 0x48, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76,
	0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x48, 0x79, 0x62, 0x72, 0x69,
	0x64, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x48, 0x0a, 0x0d,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69,
	0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x61, 0x62, 0x6c,
	0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x0c, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x4f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38,
	0x01, 0x22, 0x7b, 0x0a, 0x0b, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x4b, 0x65, 0x79,
	0x12, 0x4d, 0x0a, 0x0f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76,
	0x32, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x52,
	0x0e, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12,
	0x1d, 0x0a, 0x0a, 0x72, 0x6f, 0x77, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x09, 0x72, 0x6f, 0x77, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x22, 0x49,
	0x0a, 0x0c, 0x44, 0x61, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x4b, 0x65, 0x79, 0x12, 0x39,
	0x0a, 0x0a, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76,
	0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x4b, 0x65, 0x79, 0x52, 0x09,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x4b, 0x65, 0x79, 0x22, 0xde, 0x01, 0x0a, 0x03, 0x4b, 0x65,
	0x79, 0x12, 0x45, 0x0a, 0x0c, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e,
	0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x52, 0x0b, 0x70, 0x61, 0x72,
	0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x3a, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x4b,
	0x65, 0x79, 0x2e, 0x50, 0x61, 0x74, 0x68, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x04,
	0x70, 0x61, 0x74, 0x68, 0x1a, 0x54, 0x0a, 0x0b, 0x50, 0x61, 0x74, 0x68, 0x45, 0x6c, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12, 0x10, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x03, 0x48, 0x00, 0x52, 0x02, 0x69, 0x64, 0x12, 0x14, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x42,
	0x09, 0x0a, 0x07, 0x69, 0x64, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x22, 0xc6, 0x01, 0x0a, 0x09, 0x52,
	0x65, 0x63, 0x6f, 0x72, 0x64, 0x4b, 0x65, 0x79, 0x12, 0x4a, 0x0a, 0x0d, 0x64, 0x61, 0x74, 0x61,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79,
	0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x4b, 0x65, 0x79, 0x48, 0x00, 0x52, 0x0c, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x4b, 0x65, 0x79, 0x12, 0x48, 0x0a, 0x0d, 0x62, 0x69, 0x67, 0x5f, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70,
	0x2e, 0x76, 0x32, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x4b, 0x65, 0x79, 0x48,
	0x00, 0x52, 0x0b, 0x62, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x4b, 0x65, 0x79, 0x12, 0x1b,
	0x0a, 0x09, 0x69, 0x64, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x08, 0x69, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x42, 0x06, 0x0a, 0x04, 0x74,
	0x79, 0x70, 0x65, 0x22, 0x68, 0x0a, 0x0d, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x54,
	0x61, 0x62, 0x6c, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x5f, 0x69,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74,
	0x49, 0x64, 0x12, 0x19, 0x0a, 0x08, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x49, 0x64, 0x22, 0x81, 0x01,
	0x0a, 0x0d, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x12,
	0x3a, 0x0a, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e,
	0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x54,
	0x61, 0x62, 0x6c, 0x65, 0x52, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x34, 0x0a, 0x05, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c, 0x70, 0x2e,
	0x76, 0x32, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x49, 0x64, 0x52, 0x05, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x22, 0x40, 0x0a, 0x08, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x49, 0x64, 0x12, 0x34, 0x0a,
	0x05, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64, 0x6c,
	0x70, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x49, 0x64, 0x52, 0x05, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x22, 0x5d, 0x0a, 0x0c, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x4f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x4d, 0x0a, 0x12, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x69,
	0x6e, 0x67, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79,
	0x2e, 0x64, 0x6c, 0x70, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x49, 0x64, 0x52,
	0x11, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x69, 0x6e, 0x67, 0x46, 0x69, 0x65, 0x6c,
	0x64, 0x73, 0x2a, 0x74, 0x0a, 0x0a, 0x4c, 0x69, 0x6b, 0x65, 0x6c, 0x69, 0x68, 0x6f, 0x6f, 0x64,
	0x12, 0x1a, 0x0a, 0x16, 0x4c, 0x49, 0x4b, 0x45, 0x4c, 0x49, 0x48, 0x4f, 0x4f, 0x44, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x11, 0x0a, 0x0d,
	0x56, 0x45, 0x52, 0x59, 0x5f, 0x55, 0x4e, 0x4c, 0x49, 0x4b, 0x45, 0x4c, 0x59, 0x10, 0x01, 0x12,
	0x0c, 0x0a, 0x08, 0x55, 0x4e, 0x4c, 0x49, 0x4b, 0x45, 0x4c, 0x59, 0x10, 0x02, 0x12, 0x0c, 0x0a,
	0x08, 0x50, 0x4f, 0x53, 0x53, 0x49, 0x42, 0x4c, 0x45, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x4c,
	0x49, 0x4b, 0x45, 0x4c, 0x59, 0x10, 0x04, 0x12, 0x0f, 0x0a, 0x0b, 0x56, 0x45, 0x52, 0x59, 0x5f,
	0x4c, 0x49, 0x4b, 0x45, 0x4c, 0x59, 0x10, 0x05, 0x2a, 0x6d, 0x0a, 0x08, 0x46, 0x69, 0x6c, 0x65,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x19, 0x0a, 0x15, 0x46, 0x49, 0x4c, 0x45, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x0f, 0x0a, 0x0b, 0x42, 0x49, 0x4e, 0x41, 0x52, 0x59, 0x5f, 0x46, 0x49, 0x4c, 0x45, 0x10, 0x01,
	0x12, 0x0d, 0x0a, 0x09, 0x54, 0x45, 0x58, 0x54, 0x5f, 0x46, 0x49, 0x4c, 0x45, 0x10, 0x02, 0x12,
	0x09, 0x0a, 0x05, 0x49, 0x4d, 0x41, 0x47, 0x45, 0x10, 0x03, 0x12, 0x08, 0x0a, 0x04, 0x57, 0x4f,
	0x52, 0x44, 0x10, 0x05, 0x12, 0x07, 0x0a, 0x03, 0x50, 0x44, 0x46, 0x10, 0x06, 0x12, 0x08, 0x0a,
	0x04, 0x41, 0x56, 0x52, 0x4f, 0x10, 0x07, 0x42, 0xa8, 0x01, 0x0a, 0x19, 0x63, 0x6f, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x2e, 0x64,
	0x6c, 0x70, 0x2e, 0x76, 0x32, 0x42, 0x0a, 0x44, 0x6c, 0x70, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x50, 0x01, 0x5a, 0x38, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61,
	0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x63, 0x79, 0x2f, 0x64, 0x6c, 0x70, 0x2f, 0x76, 0x32, 0x3b, 0x64, 0x6c, 0x70, 0xaa, 0x02, 0x13,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x6c, 0x70,
	0x2e, 0x56, 0x32, 0xca, 0x02, 0x13, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x5c, 0x44, 0x6c, 0x70, 0x5c, 0x56, 0x32, 0xea, 0x02, 0x16, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x44, 0x6c, 0x70, 0x3a, 0x3a,
	0x56, 0x32, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_privacy_dlp_v2_storage_proto_rawDescOnce sync.Once
	file_google_privacy_dlp_v2_storage_proto_rawDescData = file_google_privacy_dlp_v2_storage_proto_rawDesc
)

func file_google_privacy_dlp_v2_storage_proto_rawDescGZIP() []byte {
	file_google_privacy_dlp_v2_storage_proto_rawDescOnce.Do(func() {
		file_google_privacy_dlp_v2_storage_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_privacy_dlp_v2_storage_proto_rawDescData)
	})
	return file_google_privacy_dlp_v2_storage_proto_rawDescData
}

var file_google_privacy_dlp_v2_storage_proto_enumTypes = make([]protoimpl.EnumInfo, 5)
var file_google_privacy_dlp_v2_storage_proto_msgTypes = make([]protoimpl.MessageInfo, 34)
var file_google_privacy_dlp_v2_storage_proto_goTypes = []interface{}{
	(Likelihood)(0),                                           // 0: google.privacy.dlp.v2.Likelihood
	(FileType)(0),                                             // 1: google.privacy.dlp.v2.FileType
	(CustomInfoType_ExclusionType)(0),                         // 2: google.privacy.dlp.v2.CustomInfoType.ExclusionType
	(CloudStorageOptions_SampleMethod)(0),                     // 3: google.privacy.dlp.v2.CloudStorageOptions.SampleMethod
	(BigQueryOptions_SampleMethod)(0),                         // 4: google.privacy.dlp.v2.BigQueryOptions.SampleMethod
	(*InfoType)(nil),                                          // 5: google.privacy.dlp.v2.InfoType
	(*StoredType)(nil),                                        // 6: google.privacy.dlp.v2.StoredType
	(*CustomInfoType)(nil),                                    // 7: google.privacy.dlp.v2.CustomInfoType
	(*FieldId)(nil),                                           // 8: google.privacy.dlp.v2.FieldId
	(*PartitionId)(nil),                                       // 9: google.privacy.dlp.v2.PartitionId
	(*KindExpression)(nil),                                    // 10: google.privacy.dlp.v2.KindExpression
	(*DatastoreOptions)(nil),                                  // 11: google.privacy.dlp.v2.DatastoreOptions
	(*CloudStorageRegexFileSet)(nil),                          // 12: google.privacy.dlp.v2.CloudStorageRegexFileSet
	(*CloudStorageOptions)(nil),                               // 13: google.privacy.dlp.v2.CloudStorageOptions
	(*CloudStorageFileSet)(nil),                               // 14: google.privacy.dlp.v2.CloudStorageFileSet
	(*CloudStoragePath)(nil),                                  // 15: google.privacy.dlp.v2.CloudStoragePath
	(*BigQueryOptions)(nil),                                   // 16: google.privacy.dlp.v2.BigQueryOptions
	(*StorageConfig)(nil),                                     // 17: google.privacy.dlp.v2.StorageConfig
	(*HybridOptions)(nil),                                     // 18: google.privacy.dlp.v2.HybridOptions
	(*BigQueryKey)(nil),                                       // 19: google.privacy.dlp.v2.BigQueryKey
	(*DatastoreKey)(nil),                                      // 20: google.privacy.dlp.v2.DatastoreKey
	(*Key)(nil),                                               // 21: google.privacy.dlp.v2.Key
	(*RecordKey)(nil),                                         // 22: google.privacy.dlp.v2.RecordKey
	(*BigQueryTable)(nil),                                     // 23: google.privacy.dlp.v2.BigQueryTable
	(*BigQueryField)(nil),                                     // 24: google.privacy.dlp.v2.BigQueryField
	(*EntityId)(nil),                                          // 25: google.privacy.dlp.v2.EntityId
	(*TableOptions)(nil),                                      // 26: google.privacy.dlp.v2.TableOptions
	(*CustomInfoType_Dictionary)(nil),                         // 27: google.privacy.dlp.v2.CustomInfoType.Dictionary
	(*CustomInfoType_Regex)(nil),                              // 28: google.privacy.dlp.v2.CustomInfoType.Regex
	(*CustomInfoType_SurrogateType)(nil),                      // 29: google.privacy.dlp.v2.CustomInfoType.SurrogateType
	(*CustomInfoType_DetectionRule)(nil),                      // 30: google.privacy.dlp.v2.CustomInfoType.DetectionRule
	(*CustomInfoType_Dictionary_WordList)(nil),                // 31: google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList
	(*CustomInfoType_DetectionRule_Proximity)(nil),            // 32: google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity
	(*CustomInfoType_DetectionRule_LikelihoodAdjustment)(nil), // 33: google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment
	(*CustomInfoType_DetectionRule_HotwordRule)(nil),          // 34: google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule
	(*CloudStorageOptions_FileSet)(nil),                       // 35: google.privacy.dlp.v2.CloudStorageOptions.FileSet
	(*StorageConfig_TimespanConfig)(nil),                      // 36: google.privacy.dlp.v2.StorageConfig.TimespanConfig
	nil,                                                       // 37: google.privacy.dlp.v2.HybridOptions.LabelsEntry
	(*Key_PathElement)(nil),                                   // 38: google.privacy.dlp.v2.Key.PathElement
	(*timestamp.Timestamp)(nil),                               // 39: google.protobuf.Timestamp
}
var file_google_privacy_dlp_v2_storage_proto_depIdxs = []int32{
	39, // 0: google.privacy.dlp.v2.StoredType.create_time:type_name -> google.protobuf.Timestamp
	5,  // 1: google.privacy.dlp.v2.CustomInfoType.info_type:type_name -> google.privacy.dlp.v2.InfoType
	0,  // 2: google.privacy.dlp.v2.CustomInfoType.likelihood:type_name -> google.privacy.dlp.v2.Likelihood
	27, // 3: google.privacy.dlp.v2.CustomInfoType.dictionary:type_name -> google.privacy.dlp.v2.CustomInfoType.Dictionary
	28, // 4: google.privacy.dlp.v2.CustomInfoType.regex:type_name -> google.privacy.dlp.v2.CustomInfoType.Regex
	29, // 5: google.privacy.dlp.v2.CustomInfoType.surrogate_type:type_name -> google.privacy.dlp.v2.CustomInfoType.SurrogateType
	6,  // 6: google.privacy.dlp.v2.CustomInfoType.stored_type:type_name -> google.privacy.dlp.v2.StoredType
	30, // 7: google.privacy.dlp.v2.CustomInfoType.detection_rules:type_name -> google.privacy.dlp.v2.CustomInfoType.DetectionRule
	2,  // 8: google.privacy.dlp.v2.CustomInfoType.exclusion_type:type_name -> google.privacy.dlp.v2.CustomInfoType.ExclusionType
	9,  // 9: google.privacy.dlp.v2.DatastoreOptions.partition_id:type_name -> google.privacy.dlp.v2.PartitionId
	10, // 10: google.privacy.dlp.v2.DatastoreOptions.kind:type_name -> google.privacy.dlp.v2.KindExpression
	35, // 11: google.privacy.dlp.v2.CloudStorageOptions.file_set:type_name -> google.privacy.dlp.v2.CloudStorageOptions.FileSet
	1,  // 12: google.privacy.dlp.v2.CloudStorageOptions.file_types:type_name -> google.privacy.dlp.v2.FileType
	3,  // 13: google.privacy.dlp.v2.CloudStorageOptions.sample_method:type_name -> google.privacy.dlp.v2.CloudStorageOptions.SampleMethod
	23, // 14: google.privacy.dlp.v2.BigQueryOptions.table_reference:type_name -> google.privacy.dlp.v2.BigQueryTable
	8,  // 15: google.privacy.dlp.v2.BigQueryOptions.identifying_fields:type_name -> google.privacy.dlp.v2.FieldId
	4,  // 16: google.privacy.dlp.v2.BigQueryOptions.sample_method:type_name -> google.privacy.dlp.v2.BigQueryOptions.SampleMethod
	8,  // 17: google.privacy.dlp.v2.BigQueryOptions.excluded_fields:type_name -> google.privacy.dlp.v2.FieldId
	11, // 18: google.privacy.dlp.v2.StorageConfig.datastore_options:type_name -> google.privacy.dlp.v2.DatastoreOptions
	13, // 19: google.privacy.dlp.v2.StorageConfig.cloud_storage_options:type_name -> google.privacy.dlp.v2.CloudStorageOptions
	16, // 20: google.privacy.dlp.v2.StorageConfig.big_query_options:type_name -> google.privacy.dlp.v2.BigQueryOptions
	18, // 21: google.privacy.dlp.v2.StorageConfig.hybrid_options:type_name -> google.privacy.dlp.v2.HybridOptions
	36, // 22: google.privacy.dlp.v2.StorageConfig.timespan_config:type_name -> google.privacy.dlp.v2.StorageConfig.TimespanConfig
	37, // 23: google.privacy.dlp.v2.HybridOptions.labels:type_name -> google.privacy.dlp.v2.HybridOptions.LabelsEntry
	26, // 24: google.privacy.dlp.v2.HybridOptions.table_options:type_name -> google.privacy.dlp.v2.TableOptions
	23, // 25: google.privacy.dlp.v2.BigQueryKey.table_reference:type_name -> google.privacy.dlp.v2.BigQueryTable
	21, // 26: google.privacy.dlp.v2.DatastoreKey.entity_key:type_name -> google.privacy.dlp.v2.Key
	9,  // 27: google.privacy.dlp.v2.Key.partition_id:type_name -> google.privacy.dlp.v2.PartitionId
	38, // 28: google.privacy.dlp.v2.Key.path:type_name -> google.privacy.dlp.v2.Key.PathElement
	20, // 29: google.privacy.dlp.v2.RecordKey.datastore_key:type_name -> google.privacy.dlp.v2.DatastoreKey
	19, // 30: google.privacy.dlp.v2.RecordKey.big_query_key:type_name -> google.privacy.dlp.v2.BigQueryKey
	23, // 31: google.privacy.dlp.v2.BigQueryField.table:type_name -> google.privacy.dlp.v2.BigQueryTable
	8,  // 32: google.privacy.dlp.v2.BigQueryField.field:type_name -> google.privacy.dlp.v2.FieldId
	8,  // 33: google.privacy.dlp.v2.EntityId.field:type_name -> google.privacy.dlp.v2.FieldId
	8,  // 34: google.privacy.dlp.v2.TableOptions.identifying_fields:type_name -> google.privacy.dlp.v2.FieldId
	31, // 35: google.privacy.dlp.v2.CustomInfoType.Dictionary.word_list:type_name -> google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList
	15, // 36: google.privacy.dlp.v2.CustomInfoType.Dictionary.cloud_storage_path:type_name -> google.privacy.dlp.v2.CloudStoragePath
	34, // 37: google.privacy.dlp.v2.CustomInfoType.DetectionRule.hotword_rule:type_name -> google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule
	0,  // 38: google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment.fixed_likelihood:type_name -> google.privacy.dlp.v2.Likelihood
	28, // 39: google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule.hotword_regex:type_name -> google.privacy.dlp.v2.CustomInfoType.Regex
	32, // 40: google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule.proximity:type_name -> google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity
	33, // 41: google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule.likelihood_adjustment:type_name -> google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment
	12, // 42: google.privacy.dlp.v2.CloudStorageOptions.FileSet.regex_file_set:type_name -> google.privacy.dlp.v2.CloudStorageRegexFileSet
	39, // 43: google.privacy.dlp.v2.StorageConfig.TimespanConfig.start_time:type_name -> google.protobuf.Timestamp
	39, // 44: google.privacy.dlp.v2.StorageConfig.TimespanConfig.end_time:type_name -> google.protobuf.Timestamp
	8,  // 45: google.privacy.dlp.v2.StorageConfig.TimespanConfig.timestamp_field:type_name -> google.privacy.dlp.v2.FieldId
	46, // [46:46] is the sub-list for method output_type
	46, // [46:46] is the sub-list for method input_type
	46, // [46:46] is the sub-list for extension type_name
	46, // [46:46] is the sub-list for extension extendee
	0,  // [0:46] is the sub-list for field type_name
}

func init() { file_google_privacy_dlp_v2_storage_proto_init() }
func file_google_privacy_dlp_v2_storage_proto_init() {
	if File_google_privacy_dlp_v2_storage_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_privacy_dlp_v2_storage_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InfoType); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_storage_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StoredType); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_storage_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CustomInfoType); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_storage_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FieldId); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_storage_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PartitionId); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_storage_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KindExpression); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_storage_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DatastoreOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_storage_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CloudStorageRegexFileSet); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_storage_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CloudStorageOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_storage_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CloudStorageFileSet); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_storage_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CloudStoragePath); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_storage_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BigQueryOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_storage_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StorageConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_storage_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HybridOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_storage_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BigQueryKey); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_storage_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DatastoreKey); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_storage_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Key); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_storage_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RecordKey); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_storage_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BigQueryTable); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_storage_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BigQueryField); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_storage_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EntityId); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_storage_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TableOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_storage_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CustomInfoType_Dictionary); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_storage_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CustomInfoType_Regex); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_storage_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CustomInfoType_SurrogateType); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_storage_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CustomInfoType_DetectionRule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_storage_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CustomInfoType_Dictionary_WordList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_storage_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CustomInfoType_DetectionRule_Proximity); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_storage_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CustomInfoType_DetectionRule_LikelihoodAdjustment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_storage_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CustomInfoType_DetectionRule_HotwordRule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_storage_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CloudStorageOptions_FileSet); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_storage_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StorageConfig_TimespanConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_privacy_dlp_v2_storage_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Key_PathElement); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_privacy_dlp_v2_storage_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*CustomInfoType_Dictionary_)(nil),
		(*CustomInfoType_Regex_)(nil),
		(*CustomInfoType_SurrogateType_)(nil),
		(*CustomInfoType_StoredType)(nil),
	}
	file_google_privacy_dlp_v2_storage_proto_msgTypes[12].OneofWrappers = []interface{}{
		(*StorageConfig_DatastoreOptions)(nil),
		(*StorageConfig_CloudStorageOptions)(nil),
		(*StorageConfig_BigQueryOptions)(nil),
		(*StorageConfig_HybridOptions)(nil),
	}
	file_google_privacy_dlp_v2_storage_proto_msgTypes[17].OneofWrappers = []interface{}{
		(*RecordKey_DatastoreKey)(nil),
		(*RecordKey_BigQueryKey)(nil),
	}
	file_google_privacy_dlp_v2_storage_proto_msgTypes[22].OneofWrappers = []interface{}{
		(*CustomInfoType_Dictionary_WordList_)(nil),
		(*CustomInfoType_Dictionary_CloudStoragePath)(nil),
	}
	file_google_privacy_dlp_v2_storage_proto_msgTypes[25].OneofWrappers = []interface{}{
		(*CustomInfoType_DetectionRule_HotwordRule_)(nil),
	}
	file_google_privacy_dlp_v2_storage_proto_msgTypes[28].OneofWrappers = []interface{}{
		(*CustomInfoType_DetectionRule_LikelihoodAdjustment_FixedLikelihood)(nil),
		(*CustomInfoType_DetectionRule_LikelihoodAdjustment_RelativeLikelihood)(nil),
	}
	file_google_privacy_dlp_v2_storage_proto_msgTypes[33].OneofWrappers = []interface{}{
		(*Key_PathElement_Id)(nil),
		(*Key_PathElement_Name)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_privacy_dlp_v2_storage_proto_rawDesc,
			NumEnums:      5,
			NumMessages:   34,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_privacy_dlp_v2_storage_proto_goTypes,
		DependencyIndexes: file_google_privacy_dlp_v2_storage_proto_depIdxs,
		EnumInfos:         file_google_privacy_dlp_v2_storage_proto_enumTypes,
		MessageInfos:      file_google_privacy_dlp_v2_storage_proto_msgTypes,
	}.Build()
	File_google_privacy_dlp_v2_storage_proto = out.File
	file_google_privacy_dlp_v2_storage_proto_rawDesc = nil
	file_google_privacy_dlp_v2_storage_proto_goTypes = nil
	file_google_privacy_dlp_v2_storage_proto_depIdxs = nil
}
