import { DecodedValueMap, QueryParamConfigMap } from 'serialize-query-params';
import { QueryParamOptionsWithRequired } from './options';
import { QueryParamAdapter, UrlUpdateType } from './types';
declare type ChangesType<DecodedValueMapType> = Partial<DecodedValueMapType> | ((latestValues: DecodedValueMapType) => Partial<DecodedValueMapType>);
/**
 * Given a ?foo=1&bar=2 and { bar: 3, baz: true } produce ?foo=1&bar=3&baz=1
 * or similar, depending on updateType. The result will be prefixed with "?"
 * or just be the empty string.
 */
export declare function getUpdatedSearchString({ changes, updateType, currentSearchString, paramConfigMap: baseParamConfigMap, options, }: {
    changes: ChangesType<DecodedValueMap<any>>;
    updateType?: UrlUpdateType;
    currentSearchString: string;
    paramConfigMap: QueryParamConfigMap;
    options: QueryParamOptionsWithRequired;
}): string;
/**
 * uses an adapter to update a location object and optionally
 * navigate based on the updateType
 */
export declare function updateSearchString({ searchString, adapter, navigate, updateType, }: {
    searchString: string;
    adapter: QueryParamAdapter;
    navigate: boolean;
    updateType?: UrlUpdateType;
}): void;
declare type UpdateArgs = Parameters<typeof getUpdatedSearchString>[0] & {
    adapter: QueryParamAdapter;
};
/**
 * support batching by enqueuing updates (if immediate is not true)
 */
export declare function enqueueUpdate(args: UpdateArgs, { immediate }?: {
    immediate?: boolean;
}): void;
export {};
