(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory(require("react"), require("uplot"));
	else if(typeof define === 'function' && define.amd)
		define(["react", "uplot"], factory);
	else if(typeof exports === 'object')
		exports["UplotReact"] = factory(require("react"), require("uplot"));
	else
		root["UplotReact"] = factory(root["React"], root["uPlot"]);
})(this, (__WEBPACK_EXTERNAL_MODULE_react__, __WEBPACK_EXTERNAL_MODULE_uplot__) => {
return /******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./common/index.ts":
/*!*************************!*\
  !*** ./common/index.ts ***!
  \*************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "dataMatch": () => (/* binding */ dataMatch),
/* harmony export */   "optionsUpdateState": () => (/* binding */ optionsUpdateState)
/* harmony export */ });
var __rest = undefined && undefined.__rest || function (s, e) {
  var t = {};

  for (var p in s) {
    if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0) t[p] = s[p];
  }

  if (s != null && typeof Object.getOwnPropertySymbols === "function") for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
    if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i])) t[p[i]] = s[p[i]];
  }
  return t;
}; // https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/is


if (!Object.is) {
  // eslint-disable-next-line
  Object.defineProperty(Object, "is", {
    value: function value(x, y) {
      return x === y && (x !== 0 || 1 / x === 1 / y) || x !== x && y !== y;
    }
  });
}

var optionsUpdateState = function optionsUpdateState(_lhs, _rhs) {
  var lhsWidth = _lhs.width,
      lhsHeight = _lhs.height,
      lhs = __rest(_lhs, ["width", "height"]);

  var rhsWidth = _rhs.width,
      rhsHeight = _rhs.height,
      rhs = __rest(_rhs, ["width", "height"]);

  var state = 'keep';

  if (lhsHeight !== rhsHeight || lhsWidth !== rhsWidth) {
    state = 'update';
  }

  if (Object.keys(lhs).length !== Object.keys(rhs).length) {
    return 'create';
  }

  for (var _i = 0, _Object$keys = Object.keys(lhs); _i < _Object$keys.length; _i++) {
    var k = _Object$keys[_i];

    if (!Object.is(lhs[k], rhs[k])) {
      state = 'create';
      break;
    }
  }

  return state;
};
var dataMatch = function dataMatch(lhs, rhs) {
  if (lhs.length !== rhs.length) {
    return false;
  }

  return lhs.every(function (lhsOneSeries, seriesIdx) {
    var rhsOneSeries = rhs[seriesIdx];

    if (lhsOneSeries.length !== rhsOneSeries.length) {
      return false;
    }

    return lhsOneSeries.every(function (value, valueIdx) {
      return value === rhsOneSeries[valueIdx];
    });
  });
};

/***/ }),

/***/ "react":
/*!**************************************************************************************!*\
  !*** external {"amd":"react","commonjs":"react","commonjs2":"react","root":"React"} ***!
  \**************************************************************************************/
/***/ ((module) => {

module.exports = __WEBPACK_EXTERNAL_MODULE_react__;

/***/ }),

/***/ "uplot":
/*!**************************************************************************************!*\
  !*** external {"amd":"uplot","commonjs":"uplot","commonjs2":"uplot","root":"uPlot"} ***!
  \**************************************************************************************/
/***/ ((module) => {

module.exports = __WEBPACK_EXTERNAL_MODULE_uplot__;

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	(() => {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = (module) => {
/******/ 			var getter = module && module.__esModule ?
/******/ 				() => (module['default']) :
/******/ 				() => (module);
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry need to be wrapped in an IIFE because it need to be isolated against other modules in the chunk.
(() => {
/*!*******************************!*\
  !*** ./react/uplot-react.tsx ***!
  \*******************************/
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ UplotReact)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var uplot__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! uplot */ "uplot");
/* harmony import */ var uplot__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(uplot__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var uplot_wrappers_common__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! uplot-wrappers-common */ "./common/index.ts");



function UplotReact(_ref) {
  var options = _ref.options,
      data = _ref.data,
      target = _ref.target,
      onDelete = _ref.onDelete,
      onCreate = _ref.onCreate,
      _ref$resetScales = _ref.resetScales,
      resetScales = _ref$resetScales === void 0 ? true : _ref$resetScales,
      className = _ref.className;
  var chartRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
  var targetRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
  var propOptionsRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(options);
  var propTargetRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(target);
  var propDataRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(data);
  var onCreateRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(onCreate);
  var onDeleteRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(onDelete);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    onCreateRef.current = onCreate;
    onDeleteRef.current = onDelete;
  });
  var destroy = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function (chart) {
    var _a;

    if (chart) {
      (_a = onDeleteRef.current) === null || _a === void 0 ? void 0 : _a.call(onDeleteRef, chart);
      chart.destroy();
      chartRef.current = null;
    }
  }, []);
  var create = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function () {
    var _a;

    var newChart = new (uplot__WEBPACK_IMPORTED_MODULE_1___default())(propOptionsRef.current, propDataRef.current, propTargetRef.current || targetRef.current);
    chartRef.current = newChart;
    (_a = onCreateRef.current) === null || _a === void 0 ? void 0 : _a.call(onCreateRef, newChart);
  }, []);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    create();
    return function () {
      destroy(chartRef.current);
    };
  }, [create, destroy]);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    if (propOptionsRef.current !== options) {
      var optionsState = (0,uplot_wrappers_common__WEBPACK_IMPORTED_MODULE_2__.optionsUpdateState)(propOptionsRef.current, options);
      propOptionsRef.current = options;

      if (!chartRef.current || optionsState === 'create') {
        destroy(chartRef.current);
        create();
      } else if (optionsState === 'update') {
        chartRef.current.setSize({
          width: options.width,
          height: options.height
        });
      }
    }
  }, [options, create, destroy]);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    if (propDataRef.current !== data) {
      if (!chartRef.current) {
        propDataRef.current = data;
        create();
      } else if (!(0,uplot_wrappers_common__WEBPACK_IMPORTED_MODULE_2__.dataMatch)(propDataRef.current, data)) {
        if (resetScales) {
          chartRef.current.setData(data, true);
        } else {
          chartRef.current.setData(data, false);
          chartRef.current.redraw();
        }
      }

      propDataRef.current = data;
    }
  }, [data, resetScales, create]);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    if (propTargetRef.current !== target) {
      propTargetRef.current = target;
      create();
    }

    return function () {
      return destroy(chartRef.current);
    };
  }, [target, create, destroy]);
  return target ? null : /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", {
    ref: targetRef,
    className: className
  });
}
})();

__webpack_exports__ = __webpack_exports__["default"];
/******/ 	return __webpack_exports__;
/******/ })()
;
});
//# sourceMappingURL=uplot-react.js.map