'use client';
'use strict';

var dayjs = require('dayjs');
var getEndOfWeek = require('../get-end-of-week/get-end-of-week.cjs');
var getStartOfWeek = require('../get-start-of-week/get-start-of-week.cjs');

function _interopDefault (e) { return e && e.__esModule ? e : { default: e }; }

var dayjs__default = /*#__PURE__*/_interopDefault(dayjs);

function getMonthDays({
  month,
  firstDayOfWeek = 1,
  consistentWeeks
}) {
  const day = dayjs__default.default(month).subtract(dayjs__default.default(month).date() - 1, "day");
  const start = dayjs__default.default(day.format("YYYY-M-D"));
  const startOfMonth = start.toDate();
  const endOfMonth = start.add(+start.daysInMonth() - 1, "day").toDate();
  const endDate = getEndOfWeek.getEndOfWeek(endOfMonth, firstDayOfWeek);
  const date = getStartOfWeek.getStartOfWeek(startOfMonth, firstDayOfWeek);
  const weeks = [];
  while (date <= endDate) {
    const days = [];
    for (let i = 0; i < 7; i += 1) {
      days.push(new Date(date));
      date.setDate(date.getDate() + 1);
    }
    weeks.push(days);
  }
  if (consistentWeeks && weeks.length < 6) {
    const lastWeek = weeks[weeks.length - 1];
    const lastDay = lastWeek[lastWeek.length - 1];
    const nextDay = new Date(lastDay);
    nextDay.setDate(nextDay.getDate() + 1);
    while (weeks.length < 6) {
      const days = [];
      for (let i = 0; i < 7; i += 1) {
        days.push(new Date(nextDay));
        nextDay.setDate(nextDay.getDate() + 1);
      }
      weeks.push(days);
    }
  }
  return weeks;
}

exports.getMonthDays = getMonthDays;
//# sourceMappingURL=get-month-days.cjs.map
