package security
import (
    "errors"
)
// 
type VulnerabilitySeverity int

const (
    NONE_VULNERABILITYSEVERITY VulnerabilitySeverity = iota
    LOW_VULNERABILITYSEVERITY
    MEDIUM_VULNERABILITYSEVERITY
    HIGH_VULNERABILITYSEVERITY
    CRITICAL_VULNERABILITYSEVERITY
    UNKNOWNFUTUREVALUE_VULNERABILITYSEVERITY
)

func (i VulnerabilitySeverity) String() string {
    return []string{"none", "low", "medium", "high", "critical", "unknownFutureValue"}[i]
}
func ParseVulnerabilitySeverity(v string) (any, error) {
    result := NONE_VULNERABILITYSEVERITY
    switch v {
        case "none":
            result = NONE_VULNERABILITYSEVERITY
        case "low":
            result = LOW_VULNERABILITYSEVERITY
        case "medium":
            result = MEDIUM_VULNERABILITYSEVERITY
        case "high":
            result = HIGH_VULNERABILITYSEVERITY
        case "critical":
            result = CRITICAL_VULNERABILITYSEVERITY
        case "unknownFutureValue":
            result = UNKNOWNFUTUREVALUE_VULNERABILITYSEVERITY
        default:
            return 0, errors.New("Unknown VulnerabilitySeverity value: " + v)
    }
    return &result, nil
}
func SerializeVulnerabilitySeverity(values []VulnerabilitySeverity) []string {
    result := make([]string, len(values))
    for i, v := range values {
        result[i] = v.String()
    }
    return result
}
