package sgw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GenerateMqttToken invokes the sgw.GenerateMqttToken API synchronously
func (client *Client) GenerateMqttToken(request *GenerateMqttTokenRequest) (response *GenerateMqttTokenResponse, err error) {
	response = CreateGenerateMqttTokenResponse()
	err = client.DoAction(request, response)
	return
}

// GenerateMqttTokenWithChan invokes the sgw.GenerateMqttToken API asynchronously
func (client *Client) GenerateMqttTokenWithChan(request *GenerateMqttTokenRequest) (<-chan *GenerateMqttTokenResponse, <-chan error) {
	responseChan := make(chan *GenerateMqttTokenResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GenerateMqttToken(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GenerateMqttTokenWithCallback invokes the sgw.GenerateMqttToken API asynchronously
func (client *Client) GenerateMqttTokenWithCallback(request *GenerateMqttTokenRequest, callback func(response *GenerateMqttTokenResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GenerateMqttTokenResponse
		var err error
		defer close(result)
		response, err = client.GenerateMqttToken(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GenerateMqttTokenRequest is the request struct for api GenerateMqttToken
type GenerateMqttTokenRequest struct {
	*requests.RpcRequest
	ClientUUID    string `position:"Query" name:"ClientUUID"`
	SecurityToken string `position:"Query" name:"SecurityToken"`
	GatewayId     string `position:"Query" name:"GatewayId"`
}

// GenerateMqttTokenResponse is the response struct for api GenerateMqttToken
type GenerateMqttTokenResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	MqttToken string `json:"MqttToken" xml:"MqttToken"`
}

// CreateGenerateMqttTokenRequest creates a request to invoke GenerateMqttToken API
func CreateGenerateMqttTokenRequest() (request *GenerateMqttTokenRequest) {
	request = &GenerateMqttTokenRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sgw", "2018-05-11", "GenerateMqttToken", "hcs_sgw", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGenerateMqttTokenResponse creates a response to parse from GenerateMqttToken response
func CreateGenerateMqttTokenResponse() (response *GenerateMqttTokenResponse) {
	response = &GenerateMqttTokenResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
