package openanalytics_open

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DropPartition invokes the openanalytics_open.DropPartition API synchronously
func (client *Client) DropPartition(request *DropPartitionRequest) (response *DropPartitionResponse, err error) {
	response = CreateDropPartitionResponse()
	err = client.DoAction(request, response)
	return
}

// DropPartitionWithChan invokes the openanalytics_open.DropPartition API asynchronously
func (client *Client) DropPartitionWithChan(request *DropPartitionRequest) (<-chan *DropPartitionResponse, <-chan error) {
	responseChan := make(chan *DropPartitionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DropPartition(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DropPartitionWithCallback invokes the openanalytics_open.DropPartition API asynchronously
func (client *Client) DropPartitionWithCallback(request *DropPartitionRequest, callback func(response *DropPartitionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DropPartitionResponse
		var err error
		defer close(result)
		response, err = client.DropPartition(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DropPartitionRequest is the request struct for api DropPartition
type DropPartitionRequest struct {
	*requests.RpcRequest
	DbName     string `position:"Query" name:"DbName"`
	PartValues string `position:"Query" name:"PartValues"`
	TableName  string `position:"Query" name:"TableName"`
}

// DropPartitionResponse is the response struct for api DropPartition
type DropPartitionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	Data      bool   `json:"Data" xml:"Data"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateDropPartitionRequest creates a request to invoke DropPartition API
func CreateDropPartitionRequest() (request *DropPartitionRequest) {
	request = &DropPartitionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("openanalytics-open", "2020-09-28", "DropPartition", "openanalytics", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDropPartitionResponse creates a response to parse from DropPartition response
func CreateDropPartitionResponse() (response *DropPartitionResponse) {
	response = &DropPartitionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
