package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BatchBindDevicesIntoProject invokes the iot.BatchBindDevicesIntoProject API synchronously
func (client *Client) BatchBindDevicesIntoProject(request *BatchBindDevicesIntoProjectRequest) (response *BatchBindDevicesIntoProjectResponse, err error) {
	response = CreateBatchBindDevicesIntoProjectResponse()
	err = client.DoAction(request, response)
	return
}

// BatchBindDevicesIntoProjectWithChan invokes the iot.BatchBindDevicesIntoProject API asynchronously
func (client *Client) BatchBindDevicesIntoProjectWithChan(request *BatchBindDevicesIntoProjectRequest) (<-chan *BatchBindDevicesIntoProjectResponse, <-chan error) {
	responseChan := make(chan *BatchBindDevicesIntoProjectResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BatchBindDevicesIntoProject(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BatchBindDevicesIntoProjectWithCallback invokes the iot.BatchBindDevicesIntoProject API asynchronously
func (client *Client) BatchBindDevicesIntoProjectWithCallback(request *BatchBindDevicesIntoProjectRequest, callback func(response *BatchBindDevicesIntoProjectResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BatchBindDevicesIntoProjectResponse
		var err error
		defer close(result)
		response, err = client.BatchBindDevicesIntoProject(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BatchBindDevicesIntoProjectRequest is the request struct for api BatchBindDevicesIntoProject
type BatchBindDevicesIntoProjectRequest struct {
	*requests.RpcRequest
	IotInstanceId string                                `position:"Body" name:"IotInstanceId"`
	ProjectId     string                                `position:"Body" name:"ProjectId"`
	Devices       *[]BatchBindDevicesIntoProjectDevices `position:"Body" name:"Devices"  type:"Repeated"`
	ApiProduct    string                                `position:"Body" name:"ApiProduct"`
	ApiRevision   string                                `position:"Body" name:"ApiRevision"`
}

// BatchBindDevicesIntoProjectDevices is a repeated param struct in BatchBindDevicesIntoProjectRequest
type BatchBindDevicesIntoProjectDevices struct {
	DeviceName string `name:"DeviceName"`
	ProductKey string `name:"ProductKey"`
}

// BatchBindDevicesIntoProjectResponse is the response struct for api BatchBindDevicesIntoProject
type BatchBindDevicesIntoProjectResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         bool   `json:"Data" xml:"Data"`
}

// CreateBatchBindDevicesIntoProjectRequest creates a request to invoke BatchBindDevicesIntoProject API
func CreateBatchBindDevicesIntoProjectRequest() (request *BatchBindDevicesIntoProjectRequest) {
	request = &BatchBindDevicesIntoProjectRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "BatchBindDevicesIntoProject", "", "")
	request.Method = requests.POST
	return
}

// CreateBatchBindDevicesIntoProjectResponse creates a response to parse from BatchBindDevicesIntoProject response
func CreateBatchBindDevicesIntoProjectResponse() (response *BatchBindDevicesIntoProjectResponse) {
	response = &BatchBindDevicesIntoProjectResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
