#ifndef S_ENDIAN_H
#define S_ENDIAN_H

#include <endian.h>

void swap32(unsigned int *x)
{
#if __BYTE_ORDER == __LITTLE_ENDIAN
	*x = (((*x >> 16) & 0x0000ffff) | ((*x << 16) & 0xffff0000));
	*x = (((*x >> 8) & 0x00ff00ff) | ((*x << 8) & 0xff00ff00));
#endif
}

void swap16(unsigned short *x)
{
#if __BYTE_ORDER == __LITTLE_ENDIAN
	*x = (((*x >> 8) & 0x00ff) | ((*x << 8) & 0xff00));
#endif
}

#endif
