/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.jarjar.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

class IoUtil {
    private IoUtil() {
    }

    public static void pipe(InputStream is, OutputStream out, byte[] buf) throws IOException {
        int amt;
        while ((amt = is.read(buf)) >= 0) {
            out.write(buf, 0, amt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File from, File to, byte[] buf) throws IOException {
        FileInputStream in = new FileInputStream(from);
        try {
            FileOutputStream out = new FileOutputStream(to);
            try {
                IoUtil.pipe(in, out, buf);
            }
            finally {
                ((OutputStream)out).close();
            }
        }
        finally {
            ((InputStream)in).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyZipWithoutEmptyDirectories(File inputFile, File outputFile) throws IOException {
        byte[] buf = new byte[8192];
        ZipFile inputZip = new ZipFile(inputFile);
        ZipOutputStream outputStream = new ZipOutputStream(new FileOutputStream(outputFile));
        try {
            Enumeration<? extends ZipEntry> e = inputZip.entries();
            ArrayList<ZipEntry> sortedList = new ArrayList<ZipEntry>();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                sortedList.add(entry);
            }
            Collections.sort(sortedList, new Comparator<ZipEntry>(){

                @Override
                public int compare(ZipEntry o1, ZipEntry o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            for (int i = sortedList.size() - 1; i >= 0; --i) {
                String nextName;
                ZipEntry inputEntry = (ZipEntry)sortedList.get(i);
                String name = inputEntry.getName();
                boolean isEmptyDirectory = inputEntry.isDirectory() ? (i == sortedList.size() - 1 ? true : !(nextName = ((ZipEntry)sortedList.get(i + 1)).getName()).startsWith(name)) : false;
                if (isEmptyDirectory) {
                    sortedList.remove(inputEntry);
                    continue;
                }
                ZipEntry outputEntry = new ZipEntry(inputEntry);
                outputStream.putNextEntry(outputEntry);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                InputStream is = inputZip.getInputStream(inputEntry);
                IoUtil.pipe(is, baos, buf);
                is.close();
                outputStream.write(baos.toByteArray());
            }
        }
        finally {
            outputStream.close();
        }
    }
}

