/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.jarjar;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.pantsbuild.jarjar.DepHandler;
import org.pantsbuild.jarjar.PathClass;

public abstract class AbstractDepHandler
implements DepHandler {
    protected final int level;
    private final Set<List<Object>> seenIt = new HashSet<List<Object>>();

    protected AbstractDepHandler(int level) {
        this.level = level;
    }

    @Override
    public void handle(PathClass from, PathClass to) throws IOException {
        List<Object> pair = this.level == 1 ? AbstractDepHandler.createPair(from.getClassPath(), to.getClassPath()) : AbstractDepHandler.createPair(from.getClassName(), to.getClassName());
        if (!this.seenIt.contains(pair)) {
            this.seenIt.add(pair);
            this.handle(pair.get(0).toString(), pair.get(1).toString());
        }
    }

    protected abstract void handle(String var1, String var2) throws IOException;

    @Override
    public void handleStart() throws IOException {
    }

    @Override
    public void handleEnd() throws IOException {
    }

    private static List<Object> createPair(Object o1, Object o2) {
        ArrayList<Object> list = new ArrayList<Object>(2);
        list.add(o1);
        list.add(o2);
        return list;
    }
}

