/*
 * Decompiled with CFR 0.152.
 */
package classycle.dependency;

import classycle.dependency.DependencyStatement;
import classycle.dependency.LayerDefinitionRepository;
import classycle.dependency.Result;
import classycle.dependency.ResultContainer;
import classycle.dependency.ResultRenderer;
import classycle.dependency.SetDefinitionRepository;
import classycle.dependency.Statement;
import classycle.graph.AtomicVertex;
import classycle.util.StringPattern;

public class LayeringStatement
implements Statement {
    private final StringPattern[][] _layers;
    private final boolean _strictLayering;
    private final SetDefinitionRepository _repository;
    private final LayerDefinitionRepository _layerRepository;
    private final ResultRenderer _renderer;

    public LayeringStatement(StringPattern[][] layers, boolean strictLayering, SetDefinitionRepository repository, LayerDefinitionRepository layerRepository, ResultRenderer renderer) {
        this._layers = layers;
        this._repository = repository;
        this._layerRepository = layerRepository;
        this._strictLayering = strictLayering;
        this._renderer = renderer;
    }

    public Result execute(AtomicVertex[] graph) {
        ResultContainer result = new ResultContainer();
        for (int i = 0; i < this._layers.length; ++i) {
            DependencyStatement s;
            int j;
            this.checkIntraLayerDependencies(result, this._layers[i], graph);
            for (j = i + 1; j < this._layers.length; ++j) {
                s = new DependencyStatement(this._layers[i], this._layers[j], "directlyIndependentOf", this._repository, this._renderer);
                result.add(s.execute(graph));
            }
            if (!this._strictLayering) continue;
            for (j = i - 2; j >= 0; --j) {
                s = new DependencyStatement(this._layers[i], this._layers[j], "directlyIndependentOf", this._repository, this._renderer);
                result.add(s.execute(graph));
            }
        }
        return result;
    }

    private void checkIntraLayerDependencies(ResultContainer result, StringPattern[] patterns, AtomicVertex[] graph) {
        StringPattern[] startSets = new StringPattern[1];
        StringPattern[] endSets = new StringPattern[patterns.length - 1];
        for (int i = 0; i < patterns.length; ++i) {
            startSets[0] = patterns[i];
            System.arraycopy(patterns, 0, endSets, 0, i);
            System.arraycopy(patterns, i + 1, endSets, i, patterns.length - i - 1);
            DependencyStatement s = new DependencyStatement(startSets, endSets, "directlyIndependentOf", this._repository, this._renderer);
            result.add(s.execute(graph));
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("check ");
        buffer.append(this._strictLayering ? "strictLayeringOf" : "layeringOf");
        for (int i = 0; i < this._layers.length; ++i) {
            buffer.append(' ').append(this._layerRepository.getName(this._layers[i]));
        }
        return new String(buffer);
    }
}

