/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.CheckoutConflictException;
import org.eclipse.jgit.api.errors.RefAlreadyExistsException;
import org.eclipse.jgit.api.errors.RefNotFoundException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.eclipse.jgit.pgm.internal.CLIText;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.spi.StopOptionHandler;

@Command(common=true, usage="usage_checkout")
class Checkout
extends TextBuiltin {
    @Option(name="-b", usage="usage_createBranchAndCheckout")
    private boolean createBranch = false;
    @Option(name="--force", aliases={"-f"}, usage="usage_forceCheckout")
    private boolean force = false;
    @Option(name="--orphan", usage="usage_orphan")
    private boolean orphan = false;
    @Argument(required=true, index=0, metaVar="metaVar_name", usage="usage_checkout")
    private String name;
    @Argument(index=1)
    @Option(name="--", metaVar="metaVar_paths", multiValued=true, handler=StopOptionHandler.class)
    private List<String> paths = new ArrayList<String>();

    Checkout() {
    }

    protected void run() throws Exception {
        ObjectId head;
        if (this.createBranch && (head = this.db.resolve("HEAD")) == null) {
            throw Checkout.die(CLIText.get().onBranchToBeBorn);
        }
        CheckoutCommand command = new Git(this.db).checkout();
        if (this.paths.size() > 0) {
            command.setStartPoint(this.name);
            for (String path : this.paths) {
                command.addPath(path);
            }
        } else {
            command.setCreateBranch(this.createBranch);
            command.setName(this.name);
            command.setForce(this.force);
            command.setOrphan(this.orphan);
        }
        try {
            String oldBranch = this.db.getBranch();
            Ref ref = command.call();
            if (ref == null) {
                return;
            }
            if (Repository.shortenRefName((String)ref.getName()).equals(oldBranch)) {
                this.outw.println(MessageFormat.format(CLIText.get().alreadyOnBranch, this.name));
                return;
            }
            if (this.createBranch || this.orphan) {
                this.outw.println(MessageFormat.format(CLIText.get().switchedToNewBranch, this.name));
            } else {
                this.outw.println(MessageFormat.format(CLIText.get().switchedToBranch, Repository.shortenRefName((String)ref.getName())));
            }
        }
        catch (RefNotFoundException e) {
            this.outw.println(MessageFormat.format(CLIText.get().pathspecDidNotMatch, this.name));
        }
        catch (RefAlreadyExistsException e) {
            throw Checkout.die(MessageFormat.format(CLIText.get().branchAlreadyExists, this.name));
        }
        catch (CheckoutConflictException e) {
            this.outw.println(CLIText.get().checkoutConflict);
            for (String path : e.getConflictingPaths()) {
                this.outw.println(MessageFormat.format(CLIText.get().checkoutConflictPathLine, path));
            }
        }
    }
}

