/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.ast.Colon2Node;
import org.jruby.ast.Node;
import org.jruby.exceptions.JumpException;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.opto.ConstantCache;
import org.jruby.runtime.opto.Invalidator;
import org.jruby.util.DefinedMessage;

public class Colon2ConstNode
extends Colon2Node {
    private ConstantCache cache;

    public Colon2ConstNode(ISourcePosition position, Node leftNode, String name2) {
        super(position, leftNode, name2);
        assert (leftNode != null) : "Colon2ConstNode cannot have null leftNode";
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self2, Block aBlock) {
        RubyModule target = Helpers.checkIsModule(this.leftNode.interpret(runtime, context, self2, aBlock));
        IRubyObject value2 = this.getValue(context, target);
        return value2 != null ? value2 : target.getConstantFromConstMissing(this.name);
    }

    @Override
    public RubyString definition(Ruby runtime, ThreadContext context, IRubyObject self2, Block aBlock) {
        IRubyObject lastError = context.getErrorInfo();
        try {
            if (Helpers.isModuleAndHasConstant(this.leftNode.interpret(runtime, context, self2, aBlock), this.name)) {
                return runtime.getDefinedMessage(DefinedMessage.CONSTANT);
            }
        }
        catch (JumpException e) {
            context.setErrorInfo(lastError);
        }
        return null;
    }

    public IRubyObject getValue(ThreadContext context, RubyModule target) {
        ConstantCache cache = this.cache;
        return ConstantCache.isCachedFrom(target, cache) ? cache.value : this.reCache(context, target);
    }

    public IRubyObject reCache(ThreadContext context, RubyModule target) {
        Invalidator invalidator = context.runtime.getConstantInvalidator(this.name);
        Object newGeneration = invalidator.getData();
        IRubyObject value2 = target.getConstantFromNoConstMissing(this.name, false);
        this.cache = value2 != null ? new ConstantCache(value2, newGeneration, invalidator, target.hashCode()) : null;
        return value2;
    }
}

