/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.parser.m2;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.module.descriptor.License;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.plugins.parser.m2.PomReader$1;
import org.apache.ivy.plugins.parser.m2.PomReader$AddDTDFilterInputStream;
import org.apache.ivy.plugins.parser.m2.PomReader$PomDependencyData;
import org.apache.ivy.plugins.parser.m2.PomReader$PomDependencyMgtElement;
import org.apache.ivy.plugins.parser.m2.PomReader$PomPluginElement;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.util.XMLHelper;
import org.apache.ivy.util.url.URLHandlerRegistry;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class PomReader {
    private HashMap properties = new HashMap();
    private final Element projectElement;
    private final Element parentElement;

    public PomReader(URL uRL, Resource resource) {
        PomReader$AddDTDFilterInputStream pomReader$AddDTDFilterInputStream = new PomReader$AddDTDFilterInputStream(URLHandlerRegistry.getDefault().openStream(uRL), 0);
        InputSource inputSource = new InputSource(pomReader$AddDTDFilterInputStream);
        inputSource.setSystemId(XMLHelper.toSystemId(uRL));
        try {
            Document document = XMLHelper.parseToDom(inputSource, new PomReader$1());
            this.projectElement = document.getDocumentElement();
            if (!"project".equals(this.projectElement.getNodeName()) && !"model".equals(this.projectElement.getNodeName())) {
                throw new SAXParseException("project must be the root tag", resource.getName(), resource.getName(), 0, 0);
            }
            this.parentElement = PomReader.getFirstChildElement(this.projectElement, "parent");
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)pomReader$AddDTDFilterInputStream).close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            ((InputStream)pomReader$AddDTDFilterInputStream).close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public final boolean hasParent() {
        return this.parentElement != null;
    }

    public final void setProperty(String string, String string2) {
        if (!this.properties.containsKey(string) && string2 != null) {
            this.properties.put(string, string2);
        }
    }

    public final String getGroupId() {
        String string = PomReader.getFirstChildText(this.projectElement, "groupId");
        if (string == null) {
            string = PomReader.getFirstChildText(this.parentElement, "groupId");
        }
        return this.replaceProps(string);
    }

    public final String getParentGroupId() {
        String string = PomReader.getFirstChildText(this.parentElement, "groupId");
        if (string == null) {
            string = PomReader.getFirstChildText(this.projectElement, "groupId");
        }
        return this.replaceProps(string);
    }

    public final String getArtifactId() {
        String string = PomReader.getFirstChildText(this.projectElement, "artifactId");
        if (string == null) {
            string = PomReader.getFirstChildText(this.parentElement, "artifactId");
        }
        return this.replaceProps(string);
    }

    public final String getParentArtifactId() {
        String string = PomReader.getFirstChildText(this.parentElement, "artifactId");
        if (string == null) {
            string = PomReader.getFirstChildText(this.projectElement, "artifactId");
        }
        return this.replaceProps(string);
    }

    public final String getVersion() {
        String string = PomReader.getFirstChildText(this.projectElement, "version");
        if (string == null) {
            string = PomReader.getFirstChildText(this.parentElement, "version");
        }
        return this.replaceProps(string);
    }

    public final String getParentVersion() {
        String string = PomReader.getFirstChildText(this.parentElement, "version");
        if (string == null) {
            string = PomReader.getFirstChildText(this.projectElement, "version");
        }
        return this.replaceProps(string);
    }

    public final String getPackaging() {
        String string = PomReader.getFirstChildText(this.projectElement, "packaging");
        if (string == null) {
            string = "jar";
        }
        return string;
    }

    public final String getHomePage() {
        String string = PomReader.getFirstChildText(this.projectElement, "url");
        if (string == null) {
            string = "";
        }
        return string;
    }

    public final String getDescription() {
        String string = PomReader.getFirstChildText(this.projectElement, "description");
        if (string == null) {
            string = "";
        }
        return string.trim();
    }

    public final License[] getLicenses() {
        Element element = PomReader.getFirstChildElement(this.projectElement, "licenses");
        if (element == null) {
            return new License[0];
        }
        element.normalize();
        ArrayList<License> arrayList = new ArrayList<License>();
        for (Element element2 : PomReader.getAllChilds(element)) {
            if (!"license".equals(element2.getNodeName())) continue;
            String string = PomReader.getFirstChildText(element2, "name");
            String string2 = PomReader.getFirstChildText(element2, "url");
            if (string == null && string2 == null) continue;
            if (string == null) {
                string = "Unknown License";
            }
            arrayList.add(new License(string, string2));
        }
        return arrayList.toArray(new License[arrayList.size()]);
    }

    public final ModuleRevisionId getRelocation() {
        Element element = PomReader.getFirstChildElement(PomReader.getFirstChildElement(this.projectElement, "distributionManagement"), "relocation");
        if (element == null) {
            return null;
        }
        String string = PomReader.getFirstChildText(element, "groupId");
        String string2 = PomReader.getFirstChildText(element, "artifactId");
        String string3 = PomReader.getFirstChildText(element, "version");
        string = string == null ? this.getGroupId() : string;
        string2 = string2 == null ? this.getArtifactId() : string2;
        string3 = string3 == null ? this.getVersion() : string3;
        return ModuleRevisionId.newInstance(string, string2, string3);
    }

    public final List getDependencies() {
        Element element = PomReader.getFirstChildElement(this.projectElement, "dependencies");
        LinkedList<PomReader$PomDependencyData> linkedList = new LinkedList<PomReader$PomDependencyData>();
        if (element != null) {
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!(node instanceof Element) || !"dependency".equals(node.getNodeName())) continue;
                linkedList.add(new PomReader$PomDependencyData(this, (Element)node));
            }
        }
        return linkedList;
    }

    public final List getDependencyMgt() {
        Element element = PomReader.getFirstChildElement(PomReader.getFirstChildElement(this.projectElement, "dependencyManagement"), "dependencies");
        LinkedList<PomReader$PomDependencyMgtElement> linkedList = new LinkedList<PomReader$PomDependencyMgtElement>();
        if (element != null) {
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!(node instanceof Element) || !"dependency".equals(node.getNodeName())) continue;
                linkedList.add(new PomReader$PomDependencyMgtElement(this, (Element)node));
            }
        }
        return linkedList;
    }

    public final List getPlugins() {
        LinkedList<PomReader$PomPluginElement> linkedList = new LinkedList<PomReader$PomPluginElement>();
        Element element = PomReader.getFirstChildElement(this.projectElement, "build");
        if (element == null) {
            return linkedList;
        }
        Element element2 = PomReader.getFirstChildElement(element, "plugins");
        if (element2 != null) {
            NodeList nodeList = element2.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!(node instanceof Element) || !"plugin".equals(node.getNodeName())) continue;
                linkedList.add(new PomReader$PomPluginElement(this, (Element)node));
            }
        }
        return linkedList;
    }

    public final Map getPomProperties() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Element element = PomReader.getFirstChildElement(this.projectElement, "properties");
        if (element != null) {
            element.normalize();
        }
        for (Element element2 : PomReader.getAllChilds(element)) {
            hashMap.put(element2.getNodeName(), PomReader.getTextContent(element2));
        }
        return hashMap;
    }

    private String replaceProps(String string) {
        if (string == null) {
            return null;
        }
        return IvyPatternHelper.substituteVariables(string, this.properties).trim();
    }

    private static String getTextContent(Element element) {
        StringBuffer stringBuffer = new StringBuffer();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            switch (node.getNodeType()) {
                case 3: 
                case 4: {
                    stringBuffer.append(node.getNodeValue());
                }
            }
        }
        return stringBuffer.toString();
    }

    private static String getFirstChildText(Element element, String string) {
        Element element2 = PomReader.getFirstChildElement(element, string);
        if (element2 != null) {
            return PomReader.getTextContent(element2);
        }
        return null;
    }

    private static Element getFirstChildElement(Element element, String string) {
        if (element == null) {
            return null;
        }
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !string.equals(node.getNodeName())) continue;
            return (Element)node;
        }
        return null;
    }

    private static List getAllChilds(Element element) {
        LinkedList<Node> linkedList = new LinkedList<Node>();
        if (element != null) {
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!(node instanceof Element)) continue;
                linkedList.add(node);
            }
        }
        return linkedList;
    }

    static /* synthetic */ String access$100(Element element, String string) {
        return PomReader.getFirstChildText(element, string);
    }

    static /* synthetic */ String access$200(PomReader pomReader, String string) {
        return pomReader.replaceProps(string);
    }

    static /* synthetic */ Element access$300(Element element, String string) {
        return PomReader.getFirstChildElement(element, string);
    }

    static /* synthetic */ String access$400(Element element) {
        return PomReader.getTextContent(element);
    }
}

