// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.12.3
// source: google/analytics/data/v1alpha/analytics_data_api.proto

package data

import (
	context "context"
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// The request to generate a report.
type RunReportRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A property whose events are tracked. Within a batch request, this entity
	// should either be unspecified or consistent with the batch-level entity.
	Entity *Entity `protobuf:"bytes,1,opt,name=entity,proto3" json:"entity,omitempty"`
	// The dimensions requested and displayed.
	Dimensions []*Dimension `protobuf:"bytes,2,rep,name=dimensions,proto3" json:"dimensions,omitempty"`
	// The metrics requested and displayed.
	Metrics []*Metric `protobuf:"bytes,3,rep,name=metrics,proto3" json:"metrics,omitempty"`
	// Date ranges of data to read. If multiple date ranges are requested, each
	// response row will contain a zero based date range index. If two date
	// ranges overlap, the event data for the overlapping days is included in the
	// response rows for both date ranges.
	DateRanges []*DateRange `protobuf:"bytes,4,rep,name=date_ranges,json=dateRanges,proto3" json:"date_ranges,omitempty"`
	// The row count of the start row. The first row is counted as row 0.
	Offset int64 `protobuf:"varint,5,opt,name=offset,proto3" json:"offset,omitempty"`
	// The number of rows to return.
	// If zero or unspecified, all rows are returned.
	Limit int64 `protobuf:"varint,6,opt,name=limit,proto3" json:"limit,omitempty"`
	// Aggregation of metrics. Aggregated metric values will be shown in rows
	// where the dimension_values are set to "RESERVED_(MetricAggregation)".
	MetricAggregations []MetricAggregation `protobuf:"varint,7,rep,packed,name=metric_aggregations,json=metricAggregations,proto3,enum=google.analytics.data.v1alpha.MetricAggregation" json:"metric_aggregations,omitempty"`
	// The filter clause of dimensions.
	DimensionFilter *FilterExpression `protobuf:"bytes,8,opt,name=dimension_filter,json=dimensionFilter,proto3" json:"dimension_filter,omitempty"`
	// The filter clause of metrics. Applied at post aggregation phase, similar to
	// SQL having-clause.
	MetricFilter *FilterExpression `protobuf:"bytes,9,opt,name=metric_filter,json=metricFilter,proto3" json:"metric_filter,omitempty"`
	// Specifies how rows are ordered in the response.
	OrderBys []*OrderBy `protobuf:"bytes,10,rep,name=order_bys,json=orderBys,proto3" json:"order_bys,omitempty"`
	// A currency code in ISO4217 format, such as "AED", "USD", "JPY".
	// If the field is empty, the report uses the entity's default currency.
	CurrencyCode string `protobuf:"bytes,11,opt,name=currency_code,json=currencyCode,proto3" json:"currency_code,omitempty"`
	// Cohort group associated with this request. If there is a cohort group
	// in the request the 'cohort' dimension must be present.
	CohortSpec *CohortSpec `protobuf:"bytes,12,opt,name=cohort_spec,json=cohortSpec,proto3" json:"cohort_spec,omitempty"`
	// If false, rows with metrics being 0 will not be returned.
	KeepEmptyRows bool `protobuf:"varint,13,opt,name=keep_empty_rows,json=keepEmptyRows,proto3" json:"keep_empty_rows,omitempty"`
	// Toggles whether to return the current state of this Analytics Property's
	// quota. Quota is returned in [PropertyQuota](#PropertyQuota).
	ReturnPropertyQuota bool `protobuf:"varint,14,opt,name=return_property_quota,json=returnPropertyQuota,proto3" json:"return_property_quota,omitempty"`
}

func (x *RunReportRequest) Reset() {
	*x = RunReportRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1alpha_analytics_data_api_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RunReportRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RunReportRequest) ProtoMessage() {}

func (x *RunReportRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1alpha_analytics_data_api_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RunReportRequest.ProtoReflect.Descriptor instead.
func (*RunReportRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_analytics_data_api_proto_rawDescGZIP(), []int{0}
}

func (x *RunReportRequest) GetEntity() *Entity {
	if x != nil {
		return x.Entity
	}
	return nil
}

func (x *RunReportRequest) GetDimensions() []*Dimension {
	if x != nil {
		return x.Dimensions
	}
	return nil
}

func (x *RunReportRequest) GetMetrics() []*Metric {
	if x != nil {
		return x.Metrics
	}
	return nil
}

func (x *RunReportRequest) GetDateRanges() []*DateRange {
	if x != nil {
		return x.DateRanges
	}
	return nil
}

func (x *RunReportRequest) GetOffset() int64 {
	if x != nil {
		return x.Offset
	}
	return 0
}

func (x *RunReportRequest) GetLimit() int64 {
	if x != nil {
		return x.Limit
	}
	return 0
}

func (x *RunReportRequest) GetMetricAggregations() []MetricAggregation {
	if x != nil {
		return x.MetricAggregations
	}
	return nil
}

func (x *RunReportRequest) GetDimensionFilter() *FilterExpression {
	if x != nil {
		return x.DimensionFilter
	}
	return nil
}

func (x *RunReportRequest) GetMetricFilter() *FilterExpression {
	if x != nil {
		return x.MetricFilter
	}
	return nil
}

func (x *RunReportRequest) GetOrderBys() []*OrderBy {
	if x != nil {
		return x.OrderBys
	}
	return nil
}

func (x *RunReportRequest) GetCurrencyCode() string {
	if x != nil {
		return x.CurrencyCode
	}
	return ""
}

func (x *RunReportRequest) GetCohortSpec() *CohortSpec {
	if x != nil {
		return x.CohortSpec
	}
	return nil
}

func (x *RunReportRequest) GetKeepEmptyRows() bool {
	if x != nil {
		return x.KeepEmptyRows
	}
	return false
}

func (x *RunReportRequest) GetReturnPropertyQuota() bool {
	if x != nil {
		return x.ReturnPropertyQuota
	}
	return false
}

// The response report table corresponding to a request.
type RunReportResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Describes metric columns.
	MetricHeaders []*MetricHeader `protobuf:"bytes,1,rep,name=metric_headers,json=metricHeaders,proto3" json:"metric_headers,omitempty"`
	// Rows of dimension value combinations and metric values in the report.
	Rows []*Row `protobuf:"bytes,2,rep,name=rows,proto3" json:"rows,omitempty"`
	// If requested, the totaled values of metrics.
	Totals []*Row `protobuf:"bytes,8,rep,name=totals,proto3" json:"totals,omitempty"`
	// If requested, the maximum values of metrics.
	Maximums []*Row `protobuf:"bytes,9,rep,name=maximums,proto3" json:"maximums,omitempty"`
	// If requested, the minimum values of metrics.
	Minimums []*Row `protobuf:"bytes,10,rep,name=minimums,proto3" json:"minimums,omitempty"`
	// Metadata for the report.
	Metadata *ResponseMetaData `protobuf:"bytes,6,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// This Analytics Property's quota state including this request.
	PropertyQuota *PropertyQuota `protobuf:"bytes,7,opt,name=property_quota,json=propertyQuota,proto3" json:"property_quota,omitempty"`
}

func (x *RunReportResponse) Reset() {
	*x = RunReportResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1alpha_analytics_data_api_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RunReportResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RunReportResponse) ProtoMessage() {}

func (x *RunReportResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1alpha_analytics_data_api_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RunReportResponse.ProtoReflect.Descriptor instead.
func (*RunReportResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_analytics_data_api_proto_rawDescGZIP(), []int{1}
}

func (x *RunReportResponse) GetMetricHeaders() []*MetricHeader {
	if x != nil {
		return x.MetricHeaders
	}
	return nil
}

func (x *RunReportResponse) GetRows() []*Row {
	if x != nil {
		return x.Rows
	}
	return nil
}

func (x *RunReportResponse) GetTotals() []*Row {
	if x != nil {
		return x.Totals
	}
	return nil
}

func (x *RunReportResponse) GetMaximums() []*Row {
	if x != nil {
		return x.Maximums
	}
	return nil
}

func (x *RunReportResponse) GetMinimums() []*Row {
	if x != nil {
		return x.Minimums
	}
	return nil
}

func (x *RunReportResponse) GetMetadata() *ResponseMetaData {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *RunReportResponse) GetPropertyQuota() *PropertyQuota {
	if x != nil {
		return x.PropertyQuota
	}
	return nil
}

// The request to generate a pivot report.
type RunPivotReportRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A property whose events are tracked. Within a batch request, this entity
	// should either be unspecified or consistent with the batch-level entity.
	Entity *Entity `protobuf:"bytes,1,opt,name=entity,proto3" json:"entity,omitempty"`
	// The dimensions requested. All defined dimensions must be used by one of the
	// following: dimension_expression, dimension_filter, pivots, order_bys.
	Dimensions []*Dimension `protobuf:"bytes,2,rep,name=dimensions,proto3" json:"dimensions,omitempty"`
	// The metrics requested, at least one metric needs to be specified. All
	// defined metrics must be used by one of the following: metric_expression,
	// metric_filter, order_bys.
	Metrics []*Metric `protobuf:"bytes,3,rep,name=metrics,proto3" json:"metrics,omitempty"`
	// The filter clause of dimensions. Requests are validated that all
	// field_names in the dimension_filter are dimensions and are defined in
	// Dimensions.
	DimensionFilter *FilterExpression `protobuf:"bytes,4,opt,name=dimension_filter,json=dimensionFilter,proto3" json:"dimension_filter,omitempty"`
	// The filter clause of metrics. Applied at post aggregation phase, similar to
	// SQL having-clause. Requests are validated that all field_names in the
	// metric_filter are metrics and are defined in Metrics.
	MetricFilter *FilterExpression `protobuf:"bytes,5,opt,name=metric_filter,json=metricFilter,proto3" json:"metric_filter,omitempty"`
	// Describes the visual format of the report's dimensions in columns or rows.
	// The union of the fieldNames (dimension names) in all pivots must be a
	// subset of dimension names defined in Dimensions. No two pivots can share a
	// dimension. A dimension is only visible if it appears in a pivot.
	Pivots []*Pivot `protobuf:"bytes,6,rep,name=pivots,proto3" json:"pivots,omitempty"`
	// The date range to retrieve event data for the report. If multiple date
	// ranges are specified, event data from each date range is used in the
	// report. A special dimension with field name "dateRange" can be included in
	// a Pivot's field names; if included, the report compares between date
	// ranges. This dateRanges field is not used in cohorts reports.
	DateRanges []*DateRange `protobuf:"bytes,7,rep,name=date_ranges,json=dateRanges,proto3" json:"date_ranges,omitempty"`
	// A currency code in ISO4217 format, such as "AED", "USD", "JPY".
	// If the field is empty, the report uses the entity's default currency.
	CurrencyCode string `protobuf:"bytes,8,opt,name=currency_code,json=currencyCode,proto3" json:"currency_code,omitempty"`
	// Cohort group associated with this request. If there is a cohort group
	// in the request the 'cohort' dimension must be present.
	CohortSpec *CohortSpec `protobuf:"bytes,9,opt,name=cohort_spec,json=cohortSpec,proto3" json:"cohort_spec,omitempty"`
	// If false, rows with metrics being 0 will not be returned.
	KeepEmptyRows bool `protobuf:"varint,10,opt,name=keep_empty_rows,json=keepEmptyRows,proto3" json:"keep_empty_rows,omitempty"`
	// Toggles whether to return the current state of this Analytics Property's
	// quota. Quota is returned in [PropertyQuota](#PropertyQuota).
	ReturnPropertyQuota bool `protobuf:"varint,11,opt,name=return_property_quota,json=returnPropertyQuota,proto3" json:"return_property_quota,omitempty"`
}

func (x *RunPivotReportRequest) Reset() {
	*x = RunPivotReportRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1alpha_analytics_data_api_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RunPivotReportRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RunPivotReportRequest) ProtoMessage() {}

func (x *RunPivotReportRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1alpha_analytics_data_api_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RunPivotReportRequest.ProtoReflect.Descriptor instead.
func (*RunPivotReportRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_analytics_data_api_proto_rawDescGZIP(), []int{2}
}

func (x *RunPivotReportRequest) GetEntity() *Entity {
	if x != nil {
		return x.Entity
	}
	return nil
}

func (x *RunPivotReportRequest) GetDimensions() []*Dimension {
	if x != nil {
		return x.Dimensions
	}
	return nil
}

func (x *RunPivotReportRequest) GetMetrics() []*Metric {
	if x != nil {
		return x.Metrics
	}
	return nil
}

func (x *RunPivotReportRequest) GetDimensionFilter() *FilterExpression {
	if x != nil {
		return x.DimensionFilter
	}
	return nil
}

func (x *RunPivotReportRequest) GetMetricFilter() *FilterExpression {
	if x != nil {
		return x.MetricFilter
	}
	return nil
}

func (x *RunPivotReportRequest) GetPivots() []*Pivot {
	if x != nil {
		return x.Pivots
	}
	return nil
}

func (x *RunPivotReportRequest) GetDateRanges() []*DateRange {
	if x != nil {
		return x.DateRanges
	}
	return nil
}

func (x *RunPivotReportRequest) GetCurrencyCode() string {
	if x != nil {
		return x.CurrencyCode
	}
	return ""
}

func (x *RunPivotReportRequest) GetCohortSpec() *CohortSpec {
	if x != nil {
		return x.CohortSpec
	}
	return nil
}

func (x *RunPivotReportRequest) GetKeepEmptyRows() bool {
	if x != nil {
		return x.KeepEmptyRows
	}
	return false
}

func (x *RunPivotReportRequest) GetReturnPropertyQuota() bool {
	if x != nil {
		return x.ReturnPropertyQuota
	}
	return false
}

// The response pivot report table corresponding to a pivot request.
type RunPivotReportResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Summarizes the columns and rows created by a pivot. Each pivot in the
	// request produces one header in the response. If we have a request like
	// this:
	//
	//     "pivots": [{
	//       "fieldNames": ["country",
	//         "city"]
	//     },
	//     {
	//       "fieldNames": "eventName"
	//     }]
	//
	// We will have the following `pivotHeaders` in the response:
	//
	//     "pivotHeaders" : [{
	//       "dimensionHeaders": [{
	//         "dimensionValues": [
	//            { "value": "United Kingdom" },
	//            { "value": "London" }
	//          ]
	//       },
	//       {
	//         "dimensionValues": [
	//         { "value": "Japan" },
	//         { "value": "Osaka" }
	//         ]
	//       }]
	//     },
	//     {
	//       "dimensionHeaders": [{
	//         "dimensionValues": [{ "value": "session_start" }]
	//       },
	//       {
	//         "dimensionValues": [{ "value": "scroll" }]
	//       }]
	//     }]
	PivotHeaders []*PivotHeader `protobuf:"bytes,1,rep,name=pivot_headers,json=pivotHeaders,proto3" json:"pivot_headers,omitempty"`
	// Describes metric columns.
	MetricHeaders []*MetricHeader `protobuf:"bytes,2,rep,name=metric_headers,json=metricHeaders,proto3" json:"metric_headers,omitempty"`
	// Rows of dimension value combinations and metric values in the report.
	Rows []*Row `protobuf:"bytes,3,rep,name=rows,proto3" json:"rows,omitempty"`
	// Aggregation of metric values. Can be totals, minimums, or maximums. The
	// returned aggregations are controlled by the metric_aggregations in the
	// pivot. The type of aggregation returned in each row is shown by the
	// dimension_values which are set to "RESERVED_<MetricAggregation>".
	Aggregates []*Row `protobuf:"bytes,4,rep,name=aggregates,proto3" json:"aggregates,omitempty"`
	// Metadata for the report.
	Metadata *ResponseMetaData `protobuf:"bytes,5,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// This Analytics Property's quota state including this request.
	PropertyQuota *PropertyQuota `protobuf:"bytes,6,opt,name=property_quota,json=propertyQuota,proto3" json:"property_quota,omitempty"`
}

func (x *RunPivotReportResponse) Reset() {
	*x = RunPivotReportResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1alpha_analytics_data_api_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RunPivotReportResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RunPivotReportResponse) ProtoMessage() {}

func (x *RunPivotReportResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1alpha_analytics_data_api_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RunPivotReportResponse.ProtoReflect.Descriptor instead.
func (*RunPivotReportResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_analytics_data_api_proto_rawDescGZIP(), []int{3}
}

func (x *RunPivotReportResponse) GetPivotHeaders() []*PivotHeader {
	if x != nil {
		return x.PivotHeaders
	}
	return nil
}

func (x *RunPivotReportResponse) GetMetricHeaders() []*MetricHeader {
	if x != nil {
		return x.MetricHeaders
	}
	return nil
}

func (x *RunPivotReportResponse) GetRows() []*Row {
	if x != nil {
		return x.Rows
	}
	return nil
}

func (x *RunPivotReportResponse) GetAggregates() []*Row {
	if x != nil {
		return x.Aggregates
	}
	return nil
}

func (x *RunPivotReportResponse) GetMetadata() *ResponseMetaData {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *RunPivotReportResponse) GetPropertyQuota() *PropertyQuota {
	if x != nil {
		return x.PropertyQuota
	}
	return nil
}

// The batch request containing multiple report requests.
type BatchRunReportsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A property whose events are tracked. This entity must be specified for the
	// batch. The entity within RunReportRequest may either be unspecified or
	// consistent with this entity.
	Entity *Entity `protobuf:"bytes,1,opt,name=entity,proto3" json:"entity,omitempty"`
	// Individual requests. Each request has a separate report response. Each
	// batch request is allowed up to 5 requests.
	Requests []*RunReportRequest `protobuf:"bytes,2,rep,name=requests,proto3" json:"requests,omitempty"`
}

func (x *BatchRunReportsRequest) Reset() {
	*x = BatchRunReportsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1alpha_analytics_data_api_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchRunReportsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchRunReportsRequest) ProtoMessage() {}

func (x *BatchRunReportsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1alpha_analytics_data_api_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchRunReportsRequest.ProtoReflect.Descriptor instead.
func (*BatchRunReportsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_analytics_data_api_proto_rawDescGZIP(), []int{4}
}

func (x *BatchRunReportsRequest) GetEntity() *Entity {
	if x != nil {
		return x.Entity
	}
	return nil
}

func (x *BatchRunReportsRequest) GetRequests() []*RunReportRequest {
	if x != nil {
		return x.Requests
	}
	return nil
}

// The batch response containing multiple reports.
type BatchRunReportsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Individual responses. Each response has a separate report request.
	Reports []*RunReportResponse `protobuf:"bytes,1,rep,name=reports,proto3" json:"reports,omitempty"`
}

func (x *BatchRunReportsResponse) Reset() {
	*x = BatchRunReportsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1alpha_analytics_data_api_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchRunReportsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchRunReportsResponse) ProtoMessage() {}

func (x *BatchRunReportsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1alpha_analytics_data_api_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchRunReportsResponse.ProtoReflect.Descriptor instead.
func (*BatchRunReportsResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_analytics_data_api_proto_rawDescGZIP(), []int{5}
}

func (x *BatchRunReportsResponse) GetReports() []*RunReportResponse {
	if x != nil {
		return x.Reports
	}
	return nil
}

// The batch request containing multiple pivot report requests.
type BatchRunPivotReportsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A property whose events are tracked. This entity must be specified for the
	// batch. The entity within RunPivotReportRequest may either be unspecified or
	// consistent with this entity.
	Entity *Entity `protobuf:"bytes,1,opt,name=entity,proto3" json:"entity,omitempty"`
	// Individual requests. Each request has a separate pivot report response.
	// Each batch request is allowed up to 5 requests.
	Requests []*RunPivotReportRequest `protobuf:"bytes,2,rep,name=requests,proto3" json:"requests,omitempty"`
}

func (x *BatchRunPivotReportsRequest) Reset() {
	*x = BatchRunPivotReportsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1alpha_analytics_data_api_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchRunPivotReportsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchRunPivotReportsRequest) ProtoMessage() {}

func (x *BatchRunPivotReportsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1alpha_analytics_data_api_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchRunPivotReportsRequest.ProtoReflect.Descriptor instead.
func (*BatchRunPivotReportsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_analytics_data_api_proto_rawDescGZIP(), []int{6}
}

func (x *BatchRunPivotReportsRequest) GetEntity() *Entity {
	if x != nil {
		return x.Entity
	}
	return nil
}

func (x *BatchRunPivotReportsRequest) GetRequests() []*RunPivotReportRequest {
	if x != nil {
		return x.Requests
	}
	return nil
}

// The batch response containing multiple pivot reports.
type BatchRunPivotReportsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Individual responses. Each response has a separate pivot report request.
	PivotReports []*RunPivotReportResponse `protobuf:"bytes,1,rep,name=pivot_reports,json=pivotReports,proto3" json:"pivot_reports,omitempty"`
}

func (x *BatchRunPivotReportsResponse) Reset() {
	*x = BatchRunPivotReportsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_data_v1alpha_analytics_data_api_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchRunPivotReportsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchRunPivotReportsResponse) ProtoMessage() {}

func (x *BatchRunPivotReportsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_data_v1alpha_analytics_data_api_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchRunPivotReportsResponse.ProtoReflect.Descriptor instead.
func (*BatchRunPivotReportsResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_data_v1alpha_analytics_data_api_proto_rawDescGZIP(), []int{7}
}

func (x *BatchRunPivotReportsResponse) GetPivotReports() []*RunPivotReportResponse {
	if x != nil {
		return x.PivotReports
	}
	return nil
}

var File_google_analytics_data_v1alpha_analytics_data_api_proto protoreflect.FileDescriptor

var file_google_analytics_data_v1alpha_analytics_data_api_proto_rawDesc = []byte{
	0x0a, 0x36, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x61,
	0x70, 0x69, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x1a, 0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x2f, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xfc, 0x06, 0x0a, 0x10, 0x52, 0x75, 0x6e,
	0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a,
	0x06, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x45, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x52, 0x06, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x48, 0x0a, 0x0a,
	0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x64, 0x69, 0x6d, 0x65,
	0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x3f, 0x0a, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x07,
	0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x49, 0x0a, 0x0b, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x72, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x61, 0x74,
	0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x0a, 0x64, 0x61, 0x74, 0x65, 0x52, 0x61, 0x6e, 0x67,
	0x65, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x6c, 0x69,
	0x6d, 0x69, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74,
	0x12, 0x61, 0x0a, 0x13, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x61, 0x67, 0x67, 0x72, 0x65,
	0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x30, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x12, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x5a, 0x0a, 0x10, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
	0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x46, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0f,
	0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12,
	0x54, 0x0a, 0x0d, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x45, 0x78, 0x70,
	0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x46,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x43, 0x0a, 0x09, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62,
	0x79, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79,
	0x52, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x63, 0x75,
	0x72, 0x72, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0c, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x79, 0x43, 0x6f, 0x64, 0x65, 0x12,
	0x4a, 0x0a, 0x0b, 0x63, 0x6f, 0x68, 0x6f, 0x72, 0x74, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x0c,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x6f, 0x68, 0x6f, 0x72, 0x74, 0x53, 0x70, 0x65, 0x63, 0x52,
	0x0a, 0x63, 0x6f, 0x68, 0x6f, 0x72, 0x74, 0x53, 0x70, 0x65, 0x63, 0x12, 0x26, 0x0a, 0x0f, 0x6b,
	0x65, 0x65, 0x70, 0x5f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x5f, 0x72, 0x6f, 0x77, 0x73, 0x18, 0x0d,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x6b, 0x65, 0x65, 0x70, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x52,
	0x6f, 0x77, 0x73, 0x12, 0x32, 0x0a, 0x15, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x5f, 0x70, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x5f, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x18, 0x0e, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x13, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x79, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x22, 0xfd, 0x03, 0x0a, 0x11, 0x52, 0x75, 0x6e, 0x52,
	0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x52, 0x0a,
	0x0e, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x48, 0x65, 0x61, 0x64,
	0x65, 0x72, 0x52, 0x0d, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72,
	0x73, 0x12, 0x36, 0x0a, 0x04, 0x72, 0x6f, 0x77, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x52, 0x6f, 0x77, 0x52, 0x04, 0x72, 0x6f, 0x77, 0x73, 0x12, 0x3a, 0x0a, 0x06, 0x74, 0x6f, 0x74,
	0x61, 0x6c, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x52, 0x6f, 0x77, 0x52, 0x06, 0x74,
	0x6f, 0x74, 0x61, 0x6c, 0x73, 0x12, 0x3e, 0x0a, 0x08, 0x6d, 0x61, 0x78, 0x69, 0x6d, 0x75, 0x6d,
	0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x52, 0x6f, 0x77, 0x52, 0x08, 0x6d, 0x61, 0x78,
	0x69, 0x6d, 0x75, 0x6d, 0x73, 0x12, 0x3e, 0x0a, 0x08, 0x6d, 0x69, 0x6e, 0x69, 0x6d, 0x75, 0x6d,
	0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x52, 0x6f, 0x77, 0x52, 0x08, 0x6d, 0x69, 0x6e,
	0x69, 0x6d, 0x75, 0x6d, 0x73, 0x12, 0x4b, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x4d, 0x65, 0x74, 0x61, 0x44, 0x61, 0x74, 0x61, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x12, 0x53, 0x0a, 0x0e, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x5f, 0x71,
	0x75, 0x6f, 0x74, 0x61, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65,
	0x72, 0x74, 0x79, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x52, 0x0d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x79, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x22, 0xe9, 0x05, 0x0a, 0x15, 0x52, 0x75, 0x6e, 0x50,
	0x69, 0x76, 0x6f, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x3d, 0x0a, 0x06, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x06, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x12, 0x48, 0x0a, 0x0a, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0a,
	0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x3f, 0x0a, 0x07, 0x6d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x52, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x5a, 0x0a, 0x10, 0x64,
	0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x45, 0x78, 0x70, 0x72,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x54, 0x0a, 0x0d, 0x6d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x46,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52,
	0x0c, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x3c, 0x0a,
	0x06, 0x70, 0x69, 0x76, 0x6f, 0x74, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x50, 0x69,
	0x76, 0x6f, 0x74, 0x52, 0x06, 0x70, 0x69, 0x76, 0x6f, 0x74, 0x73, 0x12, 0x49, 0x0a, 0x0b, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x44, 0x61, 0x74, 0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x0a, 0x64, 0x61, 0x74, 0x65,
	0x52, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e,
	0x63, 0x79, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x63,
	0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x79, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x4a, 0x0a, 0x0b, 0x63,
	0x6f, 0x68, 0x6f, 0x72, 0x74, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x43, 0x6f, 0x68, 0x6f, 0x72, 0x74, 0x53, 0x70, 0x65, 0x63, 0x52, 0x0a, 0x63, 0x6f, 0x68,
	0x6f, 0x72, 0x74, 0x53, 0x70, 0x65, 0x63, 0x12, 0x26, 0x0a, 0x0f, 0x6b, 0x65, 0x65, 0x70, 0x5f,
	0x65, 0x6d, 0x70, 0x74, 0x79, 0x5f, 0x72, 0x6f, 0x77, 0x73, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x0d, 0x6b, 0x65, 0x65, 0x70, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x52, 0x6f, 0x77, 0x73, 0x12,
	0x32, 0x0a, 0x15, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x79, 0x5f, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x08, 0x52, 0x13,
	0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x51, 0x75,
	0x6f, 0x74, 0x61, 0x22, 0xdb, 0x03, 0x0a, 0x16, 0x52, 0x75, 0x6e, 0x50, 0x69, 0x76, 0x6f, 0x74,
	0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4f,
	0x0a, 0x0d, 0x70, 0x69, 0x76, 0x6f, 0x74, 0x5f, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x50, 0x69, 0x76, 0x6f, 0x74, 0x48, 0x65, 0x61, 0x64, 0x65,
	0x72, 0x52, 0x0c, 0x70, 0x69, 0x76, 0x6f, 0x74, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x12,
	0x52, 0x0a, 0x0e, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x48, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x52, 0x0d, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x48, 0x65, 0x61, 0x64,
	0x65, 0x72, 0x73, 0x12, 0x36, 0x0a, 0x04, 0x72, 0x6f, 0x77, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x52, 0x6f, 0x77, 0x52, 0x04, 0x72, 0x6f, 0x77, 0x73, 0x12, 0x42, 0x0a, 0x0a, 0x61,
	0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x52, 0x6f, 0x77, 0x52, 0x0a, 0x61, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x65, 0x73, 0x12,
	0x4b, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x44, 0x61,
	0x74, 0x61, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x53, 0x0a, 0x0e,
	0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x5f, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x51, 0x75, 0x6f,
	0x74, 0x61, 0x52, 0x0d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x51, 0x75, 0x6f, 0x74,
	0x61, 0x22, 0xa4, 0x01, 0x0a, 0x16, 0x42, 0x61, 0x74, 0x63, 0x68, 0x52, 0x75, 0x6e, 0x52, 0x65,
	0x70, 0x6f, 0x72, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x06,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x45, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x52, 0x06, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x4b, 0x0a, 0x08, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x52, 0x75,
	0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x08,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x22, 0x65, 0x0a, 0x17, 0x42, 0x61, 0x74, 0x63,
	0x68, 0x52, 0x75, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x4a, 0x0a, 0x07, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x52, 0x75, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x52, 0x07, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x22,
	0xae, 0x01, 0x0a, 0x1b, 0x42, 0x61, 0x74, 0x63, 0x68, 0x52, 0x75, 0x6e, 0x50, 0x69, 0x76, 0x6f,
	0x74, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x3d, 0x0a, 0x06, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x06, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x50,
	0x0a, 0x08, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x52, 0x75, 0x6e, 0x50, 0x69, 0x76, 0x6f, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x08, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73,
	0x22, 0x7a, 0x0a, 0x1c, 0x42, 0x61, 0x74, 0x63, 0x68, 0x52, 0x75, 0x6e, 0x50, 0x69, 0x76, 0x6f,
	0x74, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x5a, 0x0a, 0x0d, 0x70, 0x69, 0x76, 0x6f, 0x74, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x52, 0x75, 0x6e, 0x50, 0x69, 0x76, 0x6f, 0x74,
	0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x52, 0x0c,
	0x70, 0x69, 0x76, 0x6f, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x32, 0xac, 0x06, 0x0a,
	0x12, 0x41, 0x6c, 0x70, 0x68, 0x61, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x44,
	0x61, 0x74, 0x61, 0x12, 0x8d, 0x01, 0x0a, 0x09, 0x52, 0x75, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72,
	0x74, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x52, 0x75, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x52, 0x75, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x1d, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x17, 0x22, 0x12, 0x2f, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x3a, 0x72, 0x75, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74,
	0x3a, 0x01, 0x2a, 0x12, 0xa1, 0x01, 0x0a, 0x0e, 0x52, 0x75, 0x6e, 0x50, 0x69, 0x76, 0x6f, 0x74,
	0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x52, 0x75, 0x6e, 0x50, 0x69, 0x76, 0x6f, 0x74, 0x52,
	0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x52, 0x75, 0x6e,
	0x50, 0x69, 0x76, 0x6f, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x22, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1c, 0x22, 0x17, 0x2f, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x3a, 0x72, 0x75, 0x6e, 0x50, 0x69, 0x76, 0x6f, 0x74, 0x52, 0x65,
	0x70, 0x6f, 0x72, 0x74, 0x3a, 0x01, 0x2a, 0x12, 0xa5, 0x01, 0x0a, 0x0f, 0x42, 0x61, 0x74, 0x63,
	0x68, 0x52, 0x75, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x12, 0x35, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x42, 0x61, 0x74, 0x63,
	0x68, 0x52, 0x75, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x52, 0x75, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72,
	0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x23, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x1d, 0x22, 0x18, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x3a, 0x62, 0x61, 0x74,
	0x63, 0x68, 0x52, 0x75, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x3a, 0x01, 0x2a, 0x12,
	0xb9, 0x01, 0x0a, 0x14, 0x42, 0x61, 0x74, 0x63, 0x68, 0x52, 0x75, 0x6e, 0x50, 0x69, 0x76, 0x6f,
	0x74, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x52, 0x75,
	0x6e, 0x50, 0x69, 0x76, 0x6f, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x52, 0x75, 0x6e, 0x50, 0x69, 0x76,
	0x6f, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x28, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x22, 0x22, 0x1d, 0x2f, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x52, 0x75, 0x6e, 0x50, 0x69, 0x76, 0x6f,
	0x74, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x3a, 0x01, 0x2a, 0x1a, 0x7e, 0xca, 0x41, 0x1c,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x5c, 0x68,
	0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f,
	0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x72, 0x65, 0x61, 0x64, 0x6f, 0x6e, 0x6c, 0x79, 0x42, 0x7f, 0x0a, 0x21, 0x63,
	0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x42, 0x15, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x44, 0x61, 0x74, 0x61, 0x41,
	0x70, 0x69, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x41, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x2f,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x3b, 0x64, 0x61, 0x74, 0x61, 0x62, 0x06, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_analytics_data_v1alpha_analytics_data_api_proto_rawDescOnce sync.Once
	file_google_analytics_data_v1alpha_analytics_data_api_proto_rawDescData = file_google_analytics_data_v1alpha_analytics_data_api_proto_rawDesc
)

func file_google_analytics_data_v1alpha_analytics_data_api_proto_rawDescGZIP() []byte {
	file_google_analytics_data_v1alpha_analytics_data_api_proto_rawDescOnce.Do(func() {
		file_google_analytics_data_v1alpha_analytics_data_api_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_analytics_data_v1alpha_analytics_data_api_proto_rawDescData)
	})
	return file_google_analytics_data_v1alpha_analytics_data_api_proto_rawDescData
}

var file_google_analytics_data_v1alpha_analytics_data_api_proto_msgTypes = make([]protoimpl.MessageInfo, 8)
var file_google_analytics_data_v1alpha_analytics_data_api_proto_goTypes = []interface{}{
	(*RunReportRequest)(nil),             // 0: google.analytics.data.v1alpha.RunReportRequest
	(*RunReportResponse)(nil),            // 1: google.analytics.data.v1alpha.RunReportResponse
	(*RunPivotReportRequest)(nil),        // 2: google.analytics.data.v1alpha.RunPivotReportRequest
	(*RunPivotReportResponse)(nil),       // 3: google.analytics.data.v1alpha.RunPivotReportResponse
	(*BatchRunReportsRequest)(nil),       // 4: google.analytics.data.v1alpha.BatchRunReportsRequest
	(*BatchRunReportsResponse)(nil),      // 5: google.analytics.data.v1alpha.BatchRunReportsResponse
	(*BatchRunPivotReportsRequest)(nil),  // 6: google.analytics.data.v1alpha.BatchRunPivotReportsRequest
	(*BatchRunPivotReportsResponse)(nil), // 7: google.analytics.data.v1alpha.BatchRunPivotReportsResponse
	(*Entity)(nil),                       // 8: google.analytics.data.v1alpha.Entity
	(*Dimension)(nil),                    // 9: google.analytics.data.v1alpha.Dimension
	(*Metric)(nil),                       // 10: google.analytics.data.v1alpha.Metric
	(*DateRange)(nil),                    // 11: google.analytics.data.v1alpha.DateRange
	(MetricAggregation)(0),               // 12: google.analytics.data.v1alpha.MetricAggregation
	(*FilterExpression)(nil),             // 13: google.analytics.data.v1alpha.FilterExpression
	(*OrderBy)(nil),                      // 14: google.analytics.data.v1alpha.OrderBy
	(*CohortSpec)(nil),                   // 15: google.analytics.data.v1alpha.CohortSpec
	(*MetricHeader)(nil),                 // 16: google.analytics.data.v1alpha.MetricHeader
	(*Row)(nil),                          // 17: google.analytics.data.v1alpha.Row
	(*ResponseMetaData)(nil),             // 18: google.analytics.data.v1alpha.ResponseMetaData
	(*PropertyQuota)(nil),                // 19: google.analytics.data.v1alpha.PropertyQuota
	(*Pivot)(nil),                        // 20: google.analytics.data.v1alpha.Pivot
	(*PivotHeader)(nil),                  // 21: google.analytics.data.v1alpha.PivotHeader
}
var file_google_analytics_data_v1alpha_analytics_data_api_proto_depIdxs = []int32{
	8,  // 0: google.analytics.data.v1alpha.RunReportRequest.entity:type_name -> google.analytics.data.v1alpha.Entity
	9,  // 1: google.analytics.data.v1alpha.RunReportRequest.dimensions:type_name -> google.analytics.data.v1alpha.Dimension
	10, // 2: google.analytics.data.v1alpha.RunReportRequest.metrics:type_name -> google.analytics.data.v1alpha.Metric
	11, // 3: google.analytics.data.v1alpha.RunReportRequest.date_ranges:type_name -> google.analytics.data.v1alpha.DateRange
	12, // 4: google.analytics.data.v1alpha.RunReportRequest.metric_aggregations:type_name -> google.analytics.data.v1alpha.MetricAggregation
	13, // 5: google.analytics.data.v1alpha.RunReportRequest.dimension_filter:type_name -> google.analytics.data.v1alpha.FilterExpression
	13, // 6: google.analytics.data.v1alpha.RunReportRequest.metric_filter:type_name -> google.analytics.data.v1alpha.FilterExpression
	14, // 7: google.analytics.data.v1alpha.RunReportRequest.order_bys:type_name -> google.analytics.data.v1alpha.OrderBy
	15, // 8: google.analytics.data.v1alpha.RunReportRequest.cohort_spec:type_name -> google.analytics.data.v1alpha.CohortSpec
	16, // 9: google.analytics.data.v1alpha.RunReportResponse.metric_headers:type_name -> google.analytics.data.v1alpha.MetricHeader
	17, // 10: google.analytics.data.v1alpha.RunReportResponse.rows:type_name -> google.analytics.data.v1alpha.Row
	17, // 11: google.analytics.data.v1alpha.RunReportResponse.totals:type_name -> google.analytics.data.v1alpha.Row
	17, // 12: google.analytics.data.v1alpha.RunReportResponse.maximums:type_name -> google.analytics.data.v1alpha.Row
	17, // 13: google.analytics.data.v1alpha.RunReportResponse.minimums:type_name -> google.analytics.data.v1alpha.Row
	18, // 14: google.analytics.data.v1alpha.RunReportResponse.metadata:type_name -> google.analytics.data.v1alpha.ResponseMetaData
	19, // 15: google.analytics.data.v1alpha.RunReportResponse.property_quota:type_name -> google.analytics.data.v1alpha.PropertyQuota
	8,  // 16: google.analytics.data.v1alpha.RunPivotReportRequest.entity:type_name -> google.analytics.data.v1alpha.Entity
	9,  // 17: google.analytics.data.v1alpha.RunPivotReportRequest.dimensions:type_name -> google.analytics.data.v1alpha.Dimension
	10, // 18: google.analytics.data.v1alpha.RunPivotReportRequest.metrics:type_name -> google.analytics.data.v1alpha.Metric
	13, // 19: google.analytics.data.v1alpha.RunPivotReportRequest.dimension_filter:type_name -> google.analytics.data.v1alpha.FilterExpression
	13, // 20: google.analytics.data.v1alpha.RunPivotReportRequest.metric_filter:type_name -> google.analytics.data.v1alpha.FilterExpression
	20, // 21: google.analytics.data.v1alpha.RunPivotReportRequest.pivots:type_name -> google.analytics.data.v1alpha.Pivot
	11, // 22: google.analytics.data.v1alpha.RunPivotReportRequest.date_ranges:type_name -> google.analytics.data.v1alpha.DateRange
	15, // 23: google.analytics.data.v1alpha.RunPivotReportRequest.cohort_spec:type_name -> google.analytics.data.v1alpha.CohortSpec
	21, // 24: google.analytics.data.v1alpha.RunPivotReportResponse.pivot_headers:type_name -> google.analytics.data.v1alpha.PivotHeader
	16, // 25: google.analytics.data.v1alpha.RunPivotReportResponse.metric_headers:type_name -> google.analytics.data.v1alpha.MetricHeader
	17, // 26: google.analytics.data.v1alpha.RunPivotReportResponse.rows:type_name -> google.analytics.data.v1alpha.Row
	17, // 27: google.analytics.data.v1alpha.RunPivotReportResponse.aggregates:type_name -> google.analytics.data.v1alpha.Row
	18, // 28: google.analytics.data.v1alpha.RunPivotReportResponse.metadata:type_name -> google.analytics.data.v1alpha.ResponseMetaData
	19, // 29: google.analytics.data.v1alpha.RunPivotReportResponse.property_quota:type_name -> google.analytics.data.v1alpha.PropertyQuota
	8,  // 30: google.analytics.data.v1alpha.BatchRunReportsRequest.entity:type_name -> google.analytics.data.v1alpha.Entity
	0,  // 31: google.analytics.data.v1alpha.BatchRunReportsRequest.requests:type_name -> google.analytics.data.v1alpha.RunReportRequest
	1,  // 32: google.analytics.data.v1alpha.BatchRunReportsResponse.reports:type_name -> google.analytics.data.v1alpha.RunReportResponse
	8,  // 33: google.analytics.data.v1alpha.BatchRunPivotReportsRequest.entity:type_name -> google.analytics.data.v1alpha.Entity
	2,  // 34: google.analytics.data.v1alpha.BatchRunPivotReportsRequest.requests:type_name -> google.analytics.data.v1alpha.RunPivotReportRequest
	3,  // 35: google.analytics.data.v1alpha.BatchRunPivotReportsResponse.pivot_reports:type_name -> google.analytics.data.v1alpha.RunPivotReportResponse
	0,  // 36: google.analytics.data.v1alpha.AlphaAnalyticsData.RunReport:input_type -> google.analytics.data.v1alpha.RunReportRequest
	2,  // 37: google.analytics.data.v1alpha.AlphaAnalyticsData.RunPivotReport:input_type -> google.analytics.data.v1alpha.RunPivotReportRequest
	4,  // 38: google.analytics.data.v1alpha.AlphaAnalyticsData.BatchRunReports:input_type -> google.analytics.data.v1alpha.BatchRunReportsRequest
	6,  // 39: google.analytics.data.v1alpha.AlphaAnalyticsData.BatchRunPivotReports:input_type -> google.analytics.data.v1alpha.BatchRunPivotReportsRequest
	1,  // 40: google.analytics.data.v1alpha.AlphaAnalyticsData.RunReport:output_type -> google.analytics.data.v1alpha.RunReportResponse
	3,  // 41: google.analytics.data.v1alpha.AlphaAnalyticsData.RunPivotReport:output_type -> google.analytics.data.v1alpha.RunPivotReportResponse
	5,  // 42: google.analytics.data.v1alpha.AlphaAnalyticsData.BatchRunReports:output_type -> google.analytics.data.v1alpha.BatchRunReportsResponse
	7,  // 43: google.analytics.data.v1alpha.AlphaAnalyticsData.BatchRunPivotReports:output_type -> google.analytics.data.v1alpha.BatchRunPivotReportsResponse
	40, // [40:44] is the sub-list for method output_type
	36, // [36:40] is the sub-list for method input_type
	36, // [36:36] is the sub-list for extension type_name
	36, // [36:36] is the sub-list for extension extendee
	0,  // [0:36] is the sub-list for field type_name
}

func init() { file_google_analytics_data_v1alpha_analytics_data_api_proto_init() }
func file_google_analytics_data_v1alpha_analytics_data_api_proto_init() {
	if File_google_analytics_data_v1alpha_analytics_data_api_proto != nil {
		return
	}
	file_google_analytics_data_v1alpha_data_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_analytics_data_v1alpha_analytics_data_api_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RunReportRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1alpha_analytics_data_api_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RunReportResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1alpha_analytics_data_api_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RunPivotReportRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1alpha_analytics_data_api_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RunPivotReportResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1alpha_analytics_data_api_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchRunReportsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1alpha_analytics_data_api_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchRunReportsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1alpha_analytics_data_api_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchRunPivotReportsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_data_v1alpha_analytics_data_api_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchRunPivotReportsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_analytics_data_v1alpha_analytics_data_api_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   8,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_analytics_data_v1alpha_analytics_data_api_proto_goTypes,
		DependencyIndexes: file_google_analytics_data_v1alpha_analytics_data_api_proto_depIdxs,
		MessageInfos:      file_google_analytics_data_v1alpha_analytics_data_api_proto_msgTypes,
	}.Build()
	File_google_analytics_data_v1alpha_analytics_data_api_proto = out.File
	file_google_analytics_data_v1alpha_analytics_data_api_proto_rawDesc = nil
	file_google_analytics_data_v1alpha_analytics_data_api_proto_goTypes = nil
	file_google_analytics_data_v1alpha_analytics_data_api_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// AlphaAnalyticsDataClient is the client API for AlphaAnalyticsData service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AlphaAnalyticsDataClient interface {
	// Returns a customized report of your Google Analytics event data. Reports
	// contain statistics derived from data collected by the Google Analytics
	// tracking code. The data returned from the API is as a table with columns
	// for the requested dimensions and metrics. Metrics are individual
	// measurements of user activity on your property, such as active users or
	// event count. Dimensions break down metrics across some common criteria,
	// such as country or event name.
	RunReport(ctx context.Context, in *RunReportRequest, opts ...grpc.CallOption) (*RunReportResponse, error)
	// Returns a customized pivot report of your Google Analytics event data.
	// Pivot reports are more advanced and expressive formats than regular
	// reports. In a pivot report, dimensions are only visible if they are
	// included in a pivot. Multiple pivots can be specified to further dissect
	// your data.
	RunPivotReport(ctx context.Context, in *RunPivotReportRequest, opts ...grpc.CallOption) (*RunPivotReportResponse, error)
	// Returns multiple reports in a batch. All reports must be for the same
	// Entity.
	BatchRunReports(ctx context.Context, in *BatchRunReportsRequest, opts ...grpc.CallOption) (*BatchRunReportsResponse, error)
	// Returns multiple pivot reports in a batch. All reports must be for the same
	// Entity.
	BatchRunPivotReports(ctx context.Context, in *BatchRunPivotReportsRequest, opts ...grpc.CallOption) (*BatchRunPivotReportsResponse, error)
}

type alphaAnalyticsDataClient struct {
	cc grpc.ClientConnInterface
}

func NewAlphaAnalyticsDataClient(cc grpc.ClientConnInterface) AlphaAnalyticsDataClient {
	return &alphaAnalyticsDataClient{cc}
}

func (c *alphaAnalyticsDataClient) RunReport(ctx context.Context, in *RunReportRequest, opts ...grpc.CallOption) (*RunReportResponse, error) {
	out := new(RunReportResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.data.v1alpha.AlphaAnalyticsData/RunReport", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *alphaAnalyticsDataClient) RunPivotReport(ctx context.Context, in *RunPivotReportRequest, opts ...grpc.CallOption) (*RunPivotReportResponse, error) {
	out := new(RunPivotReportResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.data.v1alpha.AlphaAnalyticsData/RunPivotReport", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *alphaAnalyticsDataClient) BatchRunReports(ctx context.Context, in *BatchRunReportsRequest, opts ...grpc.CallOption) (*BatchRunReportsResponse, error) {
	out := new(BatchRunReportsResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.data.v1alpha.AlphaAnalyticsData/BatchRunReports", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *alphaAnalyticsDataClient) BatchRunPivotReports(ctx context.Context, in *BatchRunPivotReportsRequest, opts ...grpc.CallOption) (*BatchRunPivotReportsResponse, error) {
	out := new(BatchRunPivotReportsResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.data.v1alpha.AlphaAnalyticsData/BatchRunPivotReports", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AlphaAnalyticsDataServer is the server API for AlphaAnalyticsData service.
type AlphaAnalyticsDataServer interface {
	// Returns a customized report of your Google Analytics event data. Reports
	// contain statistics derived from data collected by the Google Analytics
	// tracking code. The data returned from the API is as a table with columns
	// for the requested dimensions and metrics. Metrics are individual
	// measurements of user activity on your property, such as active users or
	// event count. Dimensions break down metrics across some common criteria,
	// such as country or event name.
	RunReport(context.Context, *RunReportRequest) (*RunReportResponse, error)
	// Returns a customized pivot report of your Google Analytics event data.
	// Pivot reports are more advanced and expressive formats than regular
	// reports. In a pivot report, dimensions are only visible if they are
	// included in a pivot. Multiple pivots can be specified to further dissect
	// your data.
	RunPivotReport(context.Context, *RunPivotReportRequest) (*RunPivotReportResponse, error)
	// Returns multiple reports in a batch. All reports must be for the same
	// Entity.
	BatchRunReports(context.Context, *BatchRunReportsRequest) (*BatchRunReportsResponse, error)
	// Returns multiple pivot reports in a batch. All reports must be for the same
	// Entity.
	BatchRunPivotReports(context.Context, *BatchRunPivotReportsRequest) (*BatchRunPivotReportsResponse, error)
}

// UnimplementedAlphaAnalyticsDataServer can be embedded to have forward compatible implementations.
type UnimplementedAlphaAnalyticsDataServer struct {
}

func (*UnimplementedAlphaAnalyticsDataServer) RunReport(context.Context, *RunReportRequest) (*RunReportResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RunReport not implemented")
}
func (*UnimplementedAlphaAnalyticsDataServer) RunPivotReport(context.Context, *RunPivotReportRequest) (*RunPivotReportResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RunPivotReport not implemented")
}
func (*UnimplementedAlphaAnalyticsDataServer) BatchRunReports(context.Context, *BatchRunReportsRequest) (*BatchRunReportsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchRunReports not implemented")
}
func (*UnimplementedAlphaAnalyticsDataServer) BatchRunPivotReports(context.Context, *BatchRunPivotReportsRequest) (*BatchRunPivotReportsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchRunPivotReports not implemented")
}

func RegisterAlphaAnalyticsDataServer(s *grpc.Server, srv AlphaAnalyticsDataServer) {
	s.RegisterService(&_AlphaAnalyticsData_serviceDesc, srv)
}

func _AlphaAnalyticsData_RunReport_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RunReportRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AlphaAnalyticsDataServer).RunReport(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.data.v1alpha.AlphaAnalyticsData/RunReport",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AlphaAnalyticsDataServer).RunReport(ctx, req.(*RunReportRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AlphaAnalyticsData_RunPivotReport_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RunPivotReportRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AlphaAnalyticsDataServer).RunPivotReport(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.data.v1alpha.AlphaAnalyticsData/RunPivotReport",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AlphaAnalyticsDataServer).RunPivotReport(ctx, req.(*RunPivotReportRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AlphaAnalyticsData_BatchRunReports_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchRunReportsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AlphaAnalyticsDataServer).BatchRunReports(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.data.v1alpha.AlphaAnalyticsData/BatchRunReports",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AlphaAnalyticsDataServer).BatchRunReports(ctx, req.(*BatchRunReportsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AlphaAnalyticsData_BatchRunPivotReports_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchRunPivotReportsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AlphaAnalyticsDataServer).BatchRunPivotReports(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.data.v1alpha.AlphaAnalyticsData/BatchRunPivotReports",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AlphaAnalyticsDataServer).BatchRunPivotReports(ctx, req.(*BatchRunPivotReportsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _AlphaAnalyticsData_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.analytics.data.v1alpha.AlphaAnalyticsData",
	HandlerType: (*AlphaAnalyticsDataServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "RunReport",
			Handler:    _AlphaAnalyticsData_RunReport_Handler,
		},
		{
			MethodName: "RunPivotReport",
			Handler:    _AlphaAnalyticsData_RunPivotReport_Handler,
		},
		{
			MethodName: "BatchRunReports",
			Handler:    _AlphaAnalyticsData_BatchRunReports_Handler,
		},
		{
			MethodName: "BatchRunPivotReports",
			Handler:    _AlphaAnalyticsData_BatchRunPivotReports_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/analytics/data/v1alpha/analytics_data_api.proto",
}
