/* ds-registry.c generated by valac 0.39.91, the Vala compiler
 * generated from ds-registry.vala, do not modify */

/* ds-registry.vala
 *
 * Copyright © 2011 Michal Hruby <michal.mhr@gmail.com>
 * Copyright © 2011 Collabora Ltd.
 *             By Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
 *
 * Based upon a Python implementation (2009-2010) by:
 *  Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
 *  Mikkel Kamstrup Erlandsen <mikkel.kamstrup@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "zeitgeist-datamodel.h"
#include "zeitgeist-engine.h"
#include "zeitgeist.h"
#include <gio/gio.h>

#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define ZEITGEIST_TYPE_DATA_SOURCE_REGISTRY_EXTENSION (zeitgeist_data_source_registry_extension_get_type ())
#define ZEITGEIST_DATA_SOURCE_REGISTRY_EXTENSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_DATA_SOURCE_REGISTRY_EXTENSION, ZeitgeistDataSourceRegistryExtension))
#define ZEITGEIST_DATA_SOURCE_REGISTRY_EXTENSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_DATA_SOURCE_REGISTRY_EXTENSION, ZeitgeistDataSourceRegistryExtensionClass))
#define ZEITGEIST_IS_DATA_SOURCE_REGISTRY_EXTENSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_DATA_SOURCE_REGISTRY_EXTENSION))
#define ZEITGEIST_IS_DATA_SOURCE_REGISTRY_EXTENSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_DATA_SOURCE_REGISTRY_EXTENSION))
#define ZEITGEIST_DATA_SOURCE_REGISTRY_EXTENSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_DATA_SOURCE_REGISTRY_EXTENSION, ZeitgeistDataSourceRegistryExtensionClass))

typedef struct _ZeitgeistDataSourceRegistryExtension ZeitgeistDataSourceRegistryExtension;
typedef struct _ZeitgeistDataSourceRegistryExtensionClass ZeitgeistDataSourceRegistryExtensionClass;
typedef struct _ZeitgeistDataSourceRegistryExtensionPrivate ZeitgeistDataSourceRegistryExtensionPrivate;
enum  {
	ZEITGEIST_DATA_SOURCE_REGISTRY_EXTENSION_0_PROPERTY,
	ZEITGEIST_DATA_SOURCE_REGISTRY_EXTENSION_NUM_PROPERTIES
};
static GParamSpec* zeitgeist_data_source_registry_extension_properties[ZEITGEIST_DATA_SOURCE_REGISTRY_EXTENSION_NUM_PROPERTIES];
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ZeitgeistDataSourceRegistryExtensionGetDataSourcesData ZeitgeistDataSourceRegistryExtensionGetDataSourcesData;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _ZeitgeistDataSourceRegistryExtensionRegisterDataSourceData ZeitgeistDataSourceRegistryExtensionRegisterDataSourceData;
typedef struct _ZeitgeistDataSourceRegistryExtensionSetDataSourceEnabledData ZeitgeistDataSourceRegistryExtensionSetDataSourceEnabledData;
typedef struct _ZeitgeistDataSourceRegistryExtensionGetDataSourceFromIdData ZeitgeistDataSourceRegistryExtensionGetDataSourceFromIdData;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

struct _ZeitgeistDataSourceRegistryExtension {
	ZeitgeistExtension parent_instance;
	ZeitgeistDataSourceRegistryExtensionPrivate * priv;
};

struct _ZeitgeistDataSourceRegistryExtensionClass {
	ZeitgeistExtensionClass parent_class;
};

struct _ZeitgeistDataSourceRegistryExtensionPrivate {
	GHashTable* sources;
	GHashTable* running_ds;
	GHashTable* bus_name_2_ds;
	guint registration_id;
	gboolean dirty;
};

struct _ZeitgeistDataSourceRegistryExtensionGetDataSourcesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	ZeitgeistDataSourceRegistryExtension* self;
	GCancellable* cancellable;
	GVariant* result;
	GHashTable* _tmp0_;
	GVariant* _tmp1_;
};

struct _ZeitgeistDataSourceRegistryExtensionRegisterDataSourceData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	ZeitgeistDataSourceRegistryExtension* self;
	gchar* unique_id;
	gchar* name;
	gchar* description;
	GVariant* event_templates;
	GCancellable* cancellable;
	char* sender;
	gboolean result;
	GPtrArray* sender_array;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	GPtrArray* _tmp2_;
	GPtrArray* _tmp3_;
	GPtrArray* _tmp4_;
	GPtrArray* _tmp5_;
	char* _tmp6_;
	GHashTable* _tmp7_;
	gchar* _tmp8_;
	GPtrArray* _tmp9_;
	GPtrArray* _tmp10_;
	GPtrArray* _tmp11_;
	GPtrArray* _tmp12_;
	char* _tmp13_;
	const gchar* ds_id;
	GHashTable* _tmp14_;
	gconstpointer _tmp15_;
	const gchar* _tmp16_;
	GHashTable* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gboolean _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	GHashTable* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	GPtrArray* templates;
	ZeitgeistDataSource* ds;
	GHashTable* _tmp26_;
	gconstpointer _tmp27_;
	ZeitgeistDataSource* _tmp28_;
	GPtrArray* _tmp29_;
	GPtrArray* _tmp30_;
	GPtrArray* _tmp31_;
	ZeitgeistDataSource* _tmp32_;
	ZeitgeistDataSource* _tmp33_;
	ZeitgeistDataSource* _tmp34_;
	GPtrArray* _tmp35_;
	ZeitgeistDataSource* _tmp36_;
	ZeitgeistDataSource* _tmp37_;
	ZeitgeistDataSource* _tmp38_;
	GVariant* _tmp39_;
	GVariant* _tmp40_;
	ZeitgeistDataSource* _tmp41_;
	gboolean _tmp42_;
	gboolean _tmp43_;
	GPtrArray* _tmp44_;
	GPtrArray* _tmp45_;
	GPtrArray* _tmp46_;
	ZeitgeistDataSource* new_ds;
	GPtrArray* _tmp47_;
	ZeitgeistDataSource* _tmp48_;
	ZeitgeistDataSource* _tmp49_;
	ZeitgeistDataSource* _tmp50_;
	ZeitgeistDataSource* _tmp51_;
	GHashTable* _tmp52_;
	gchar* _tmp53_;
	ZeitgeistDataSource* _tmp54_;
	ZeitgeistDataSource* _tmp55_;
	ZeitgeistDataSource* _tmp56_;
	GVariant* _tmp57_;
	GVariant* _tmp58_;
	ZeitgeistDataSource* _tmp59_;
	gboolean _tmp60_;
	gboolean _tmp61_;
	GError * _inner_error_;
};

struct _ZeitgeistDataSourceRegistryExtensionSetDataSourceEnabledData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	ZeitgeistDataSourceRegistryExtension* self;
	gchar* unique_id;
	gboolean enabled;
	GCancellable* cancellable;
	ZeitgeistDataSource* ds;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	ZeitgeistDataSource* _tmp2_;
	ZeitgeistDataSource* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	ZeitgeistDataSource* _tmp6_;
};

struct _ZeitgeistDataSourceRegistryExtensionGetDataSourceFromIdData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	ZeitgeistDataSourceRegistryExtension* self;
	gchar* unique_id;
	GCancellable* cancellable;
	GVariant* result;
	ZeitgeistDataSource* ds;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	ZeitgeistDataSource* _tmp2_;
	ZeitgeistDataSource* _tmp3_;
	GVariant* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GError* _tmp7_;
	GError* _tmp8_;
	GError * _inner_error_;
};


static gpointer zeitgeist_data_source_registry_extension_parent_class = NULL;
static ZeitgeistRemoteRegistryIface * zeitgeist_data_source_registry_extension_zeitgeist_remote_registry_parent_iface = NULL;
static GType zeitgeist_data_source_registry_extension_type_id = 0;

GHashTable* zeitgeist_data_sources_registry_from_variant (GVariant* sources_variant,
                                                          gboolean reset_running,
                                                          GError** error);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
GType zeitgeist_data_source_registry_extension_get_type (void) G_GNUC_CONST;
#define ZEITGEIST_DATA_SOURCE_REGISTRY_EXTENSION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ZEITGEIST_TYPE_DATA_SOURCE_REGISTRY_EXTENSION, ZeitgeistDataSourceRegistryExtensionPrivate))
#define ZEITGEIST_DATA_SOURCE_REGISTRY_EXTENSION_MULTIPLE_MARKER "<multiple>"
#define ZEITGEIST_DATA_SOURCE_REGISTRY_EXTENSION_DISK_WRITE_TIMEOUT ((guint) (5 * 60))
static ZeitgeistDataSourceRegistryExtension* zeitgeist_data_source_registry_extension_new (void);
static ZeitgeistDataSourceRegistryExtension* zeitgeist_data_source_registry_extension_construct (GType object_type);
static void zeitgeist_data_source_registry_extension_real_unload (ZeitgeistExtension* base);
static gboolean zeitgeist_data_source_registry_extension_flush (ZeitgeistDataSourceRegistryExtension* self);
static void zeitgeist_data_source_registry_extension_real_get_data_sources_data_free (gpointer _data);
static void zeitgeist_data_source_registry_extension_real_get_data_sources_async_ready_wrapper (GObject *source_object,
                                                                                         GAsyncResult *res,
                                                                                         void *user_data);
static void zeitgeist_data_source_registry_extension_real_get_data_sources (ZeitgeistRemoteRegistry* base,
                                                                     GCancellable* cancellable,
                                                                     GAsyncReadyCallback _callback_,
                                                                     gpointer _user_data_);
static gboolean zeitgeist_data_source_registry_extension_real_get_data_sources_co (ZeitgeistDataSourceRegistryExtensionGetDataSourcesData* _data_);
static gboolean zeitgeist_data_source_registry_extension_is_sender_known (ZeitgeistDataSourceRegistryExtension* self,
                                                                   const char* sender,
                                                                   GPtrArray* sender_array);
static void zeitgeist_data_source_registry_extension_real_register_data_source_data_free (gpointer _data);
static void zeitgeist_data_source_registry_extension_real_register_data_source_async_ready_wrapper (GObject *source_object,
                                                                                             GAsyncResult *res,
                                                                                             void *user_data);
static void zeitgeist_data_source_registry_extension_real_register_data_source (ZeitgeistRemoteRegistry* base,
                                                                         const gchar* unique_id,
                                                                         const gchar* name,
                                                                         const gchar* description,
                                                                         GVariant* event_templates,
                                                                         GCancellable* cancellable,
                                                                         const char* sender,
                                                                         GAsyncReadyCallback _callback_,
                                                                         gpointer _user_data_);
static gboolean zeitgeist_data_source_registry_extension_real_register_data_source_co (ZeitgeistDataSourceRegistryExtensionRegisterDataSourceData* _data_);
static void zeitgeist_data_source_registry_extension_real_set_data_source_enabled_data_free (gpointer _data);
static void zeitgeist_data_source_registry_extension_real_set_data_source_enabled_async_ready_wrapper (GObject *source_object,
                                                                                                GAsyncResult *res,
                                                                                                void *user_data);
static void zeitgeist_data_source_registry_extension_real_set_data_source_enabled (ZeitgeistRemoteRegistry* base,
                                                                            const gchar* unique_id,
                                                                            gboolean enabled,
                                                                            GCancellable* cancellable,
                                                                            GAsyncReadyCallback _callback_,
                                                                            gpointer _user_data_);
static gboolean zeitgeist_data_source_registry_extension_real_set_data_source_enabled_co (ZeitgeistDataSourceRegistryExtensionSetDataSourceEnabledData* _data_);
static void zeitgeist_data_source_registry_extension_real_get_data_source_from_id_data_free (gpointer _data);
static void zeitgeist_data_source_registry_extension_real_get_data_source_from_id_async_ready_wrapper (GObject *source_object,
                                                                                                GAsyncResult *res,
                                                                                                void *user_data);
static void zeitgeist_data_source_registry_extension_real_get_data_source_from_id (ZeitgeistRemoteRegistry* base,
                                                                            const gchar* unique_id,
                                                                            GCancellable* cancellable,
                                                                            GAsyncReadyCallback _callback_,
                                                                            gpointer _user_data_);
static gboolean zeitgeist_data_source_registry_extension_real_get_data_source_from_id_co (ZeitgeistDataSourceRegistryExtensionGetDataSourceFromIdData* _data_);
static void zeitgeist_data_source_registry_extension_real_pre_insert_events (ZeitgeistExtension* base,
                                                                      GPtrArray* events,
                                                                      const char* sender);
static void zeitgeist_data_source_registry_extension_name_owner_changed (ZeitgeistDataSourceRegistryExtension* self,
                                                                  GDBusConnection* conn,
                                                                  const gchar* sender,
                                                                  const gchar* path,
                                                                  const gchar* interface_name,
                                                                  const gchar* signal_name,
                                                                  GVariant* parameters);
static GObject * zeitgeist_data_source_registry_extension_constructor (GType type,
                                                                guint n_construct_properties,
                                                                GObjectConstructParam * construct_properties);
static void _g_ptr_array_unref0_ (gpointer var);
static void _zeitgeist_data_source_registry_extension_name_owner_changed_gd_bus_signal_callback (GDBusConnection* connection,
                                                                                          const gchar* sender_name,
                                                                                          const gchar* object_path,
                                                                                          const gchar* interface_name,
                                                                                          const gchar* signal_name,
                                                                                          GVariant* parameters,
                                                                                          gpointer self);
static gboolean _zeitgeist_data_source_registry_extension_flush_gsource_func (gpointer self);
static void zeitgeist_data_source_registry_extension_finalize (GObject * obj);
GType zeitgeist_extension_register (GTypeModule* module);
GType zeitgeist_data_source_registry_extension_register_type (GTypeModule * module);


static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}


static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


GHashTable*
zeitgeist_data_sources_registry_from_variant (GVariant* sources_variant,
                                              gboolean reset_running,
                                              GError** error)
{
	GHashTable* result = NULL;
	GHashTable* registry = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	const gchar* _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (sources_variant != NULL, NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_object_unref0_);
	registry = _tmp2_;
	_tmp3_ = g_variant_get_type_string (sources_variant);
	g_warn_if_fail (g_strcmp0 (_tmp3_, ZEITGEIST_DATA_SOURCES_SIG_DATASOURCES) == 0);
	{
		GVariantIter* _ds_variant_it = NULL;
		GVariantIter* _tmp4_;
		GVariant* ds_variant = NULL;
		_tmp4_ = g_variant_iter_new (sources_variant);
		_ds_variant_it = _tmp4_;
		while (TRUE) {
			GVariantIter* _tmp5_;
			GVariant* _tmp6_;
			GVariant* _tmp7_;
			ZeitgeistDataSource* ds = NULL;
			GVariant* _tmp8_;
			ZeitgeistDataSource* _tmp9_;
			GHashTable* _tmp10_;
			ZeitgeistDataSource* _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			gchar* _tmp14_;
			ZeitgeistDataSource* _tmp15_;
			ZeitgeistDataSource* _tmp16_;
			_tmp5_ = _ds_variant_it;
			_tmp6_ = g_variant_iter_next_value (_tmp5_);
			_g_variant_unref0 (ds_variant);
			ds_variant = _tmp6_;
			_tmp7_ = ds_variant;
			if (!(_tmp7_ != NULL)) {
				break;
			}
			_tmp8_ = ds_variant;
			_tmp9_ = zeitgeist_data_source_new_from_variant (_tmp8_, reset_running, &_inner_error_);
			ds = _tmp9_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == ZEITGEIST_DATA_MODEL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_variant_unref0 (ds_variant);
					_g_variant_iter_free0 (_ds_variant_it);
					_g_hash_table_unref0 (registry);
					return NULL;
				} else {
					_g_variant_unref0 (ds_variant);
					_g_variant_iter_free0 (_ds_variant_it);
					_g_hash_table_unref0 (registry);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp10_ = registry;
			_tmp11_ = ds;
			_tmp12_ = zeitgeist_data_source_get_unique_id (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = g_strdup (_tmp13_);
			_tmp15_ = ds;
			_tmp16_ = _g_object_ref0 (_tmp15_);
			g_hash_table_insert (_tmp10_, _tmp14_, _tmp16_);
			_g_object_unref0 (ds);
		}
		_g_variant_unref0 (ds_variant);
		_g_variant_iter_free0 (_ds_variant_it);
	}
	result = registry;
	return result;
}


static ZeitgeistDataSourceRegistryExtension*
zeitgeist_data_source_registry_extension_construct (GType object_type)
{
	ZeitgeistDataSourceRegistryExtension * self = NULL;
	self = (ZeitgeistDataSourceRegistryExtension*) g_object_new (object_type, NULL);
	return self;
}


static ZeitgeistDataSourceRegistryExtension*
zeitgeist_data_source_registry_extension_new (void)
{
	return zeitgeist_data_source_registry_extension_construct (ZEITGEIST_TYPE_DATA_SOURCE_REGISTRY_EXTENSION);
}


static void
zeitgeist_data_source_registry_extension_real_unload (ZeitgeistExtension* base)
{
	ZeitgeistDataSourceRegistryExtension * self;
	guint _tmp5_;
	GError * _inner_error_ = NULL;
	self = (ZeitgeistDataSourceRegistryExtension*) base;
	{
		GDBusConnection* connection = NULL;
		GDBusConnection* _tmp0_;
		guint _tmp1_;
		_tmp0_ = g_bus_get_sync (G_BUS_TYPE_SESSION, NULL, &_inner_error_);
		connection = _tmp0_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp1_ = self->priv->registration_id;
		if (_tmp1_ != ((guint) 0)) {
			guint _tmp2_;
			_tmp2_ = self->priv->registration_id;
			g_dbus_connection_unregister_object (connection, _tmp2_);
			self->priv->registration_id = (guint) 0;
		}
		_g_object_unref0 (connection);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = err;
		_tmp4_ = _tmp3_->message;
		g_warning ("ds-registry.vala:129: %s", _tmp4_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	zeitgeist_data_source_registry_extension_flush (self);
	_tmp5_ = ((GObject*) self)->ref_count;
	g_debug ("ds-registry.vala:133: %s, this.ref_count = %u", "Zeitgeist.DataSourceRegistryExtension.unload", _tmp5_);
}


static void
zeitgeist_data_source_registry_extension_real_get_data_sources_data_free (gpointer _data)
{
	ZeitgeistDataSourceRegistryExtensionGetDataSourcesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_variant_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (ZeitgeistDataSourceRegistryExtensionGetDataSourcesData, _data_);
}


static void
zeitgeist_data_source_registry_extension_real_get_data_sources_async_ready_wrapper (GObject *source_object,
                                                                                    GAsyncResult *res,
                                                                                    void *user_data)
{
	ZeitgeistDataSourceRegistryExtensionGetDataSourcesData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static void
zeitgeist_data_source_registry_extension_real_get_data_sources (ZeitgeistRemoteRegistry* base,
                                                                GCancellable* cancellable,
                                                                GAsyncReadyCallback _callback_,
                                                                gpointer _user_data_)
{
	ZeitgeistDataSourceRegistryExtension * self;
	ZeitgeistDataSourceRegistryExtensionGetDataSourcesData* _data_;
	ZeitgeistDataSourceRegistryExtension* _tmp0_;
	GCancellable* _tmp1_;
	self = (ZeitgeistDataSourceRegistryExtension*) base;
	_data_ = g_slice_new0 (ZeitgeistDataSourceRegistryExtensionGetDataSourcesData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, zeitgeist_data_source_registry_extension_real_get_data_sources_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, zeitgeist_data_source_registry_extension_real_get_data_sources_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	zeitgeist_data_source_registry_extension_real_get_data_sources_co (_data_);
}


static GVariant*
zeitgeist_data_source_registry_extension_real_get_data_sources_finish (ZeitgeistRemoteRegistry* base,
                                                                       GAsyncResult* _res_,
                                                                       GError** error)
{
	GVariant* result;
	ZeitgeistDataSourceRegistryExtensionGetDataSourcesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static gboolean
zeitgeist_data_source_registry_extension_real_get_data_sources_co (ZeitgeistDataSourceRegistryExtensionGetDataSourcesData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->sources;
	_data_->_tmp1_ = zeitgeist_data_sources_to_variant (_data_->_tmp0_);
	_data_->result = _data_->_tmp1_;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gint
g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->len;
	result = (gint) _tmp0_;
	return result;
}


static void
g_ptr_array_set_length (GPtrArray* self,
                        gint value)
{
	g_return_if_fail (self != NULL);
	g_ptr_array_set_size (self, value);
}


static gboolean
zeitgeist_data_source_registry_extension_is_sender_known (ZeitgeistDataSourceRegistryExtension* self,
                                                          const char* sender,
                                                          GPtrArray* sender_array)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sender != NULL, FALSE);
	g_return_val_if_fail (sender_array != NULL, FALSE);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				gconstpointer _tmp6_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = g_ptr_array_get_length (sender_array);
				_tmp4_ = _tmp3_;
				if (!(_tmp2_ < _tmp4_)) {
					break;
				}
				_tmp5_ = i;
				_tmp6_ = g_ptr_array_index (sender_array, (guint) _tmp5_);
				if (g_strcmp0 (sender, (const char*) _tmp6_) == 0) {
					result = TRUE;
					return result;
				}
			}
		}
	}
	result = FALSE;
	return result;
}


static void
zeitgeist_data_source_registry_extension_real_register_data_source_data_free (gpointer _data)
{
	ZeitgeistDataSourceRegistryExtensionRegisterDataSourceData* _data_;
	_data_ = _data;
	_g_free0 (_data_->unique_id);
	_g_free0 (_data_->name);
	_g_free0 (_data_->description);
	_g_variant_unref0 (_data_->event_templates);
	_g_object_unref0 (_data_->cancellable);
	_g_free0 (_data_->sender);
	_g_object_unref0 (_data_->self);
	g_slice_free (ZeitgeistDataSourceRegistryExtensionRegisterDataSourceData, _data_);
}


static void
zeitgeist_data_source_registry_extension_real_register_data_source_async_ready_wrapper (GObject *source_object,
                                                                                        GAsyncResult *res,
                                                                                        void *user_data)
{
	ZeitgeistDataSourceRegistryExtensionRegisterDataSourceData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static gpointer
_g_variant_ref0 (gpointer self)
{
	return self ? g_variant_ref (self) : NULL;
}


static void
zeitgeist_data_source_registry_extension_real_register_data_source (ZeitgeistRemoteRegistry* base,
                                                                    const gchar* unique_id,
                                                                    const gchar* name,
                                                                    const gchar* description,
                                                                    GVariant* event_templates,
                                                                    GCancellable* cancellable,
                                                                    const char* sender,
                                                                    GAsyncReadyCallback _callback_,
                                                                    gpointer _user_data_)
{
	ZeitgeistDataSourceRegistryExtension * self;
	ZeitgeistDataSourceRegistryExtensionRegisterDataSourceData* _data_;
	ZeitgeistDataSourceRegistryExtension* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GVariant* _tmp4_;
	GCancellable* _tmp5_;
	char* _tmp6_;
	self = (ZeitgeistDataSourceRegistryExtension*) base;
	_data_ = g_slice_new0 (ZeitgeistDataSourceRegistryExtensionRegisterDataSourceData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, zeitgeist_data_source_registry_extension_real_register_data_source_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, zeitgeist_data_source_registry_extension_real_register_data_source_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (unique_id);
	_g_free0 (_data_->unique_id);
	_data_->unique_id = _tmp1_;
	_tmp2_ = g_strdup (name);
	_g_free0 (_data_->name);
	_data_->name = _tmp2_;
	_tmp3_ = g_strdup (description);
	_g_free0 (_data_->description);
	_data_->description = _tmp3_;
	_tmp4_ = _g_variant_ref0 (event_templates);
	_g_variant_unref0 (_data_->event_templates);
	_data_->event_templates = _tmp4_;
	_tmp5_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp5_;
	_tmp6_ = g_strdup (sender);
	_g_free0 (_data_->sender);
	_data_->sender = _tmp6_;
	zeitgeist_data_source_registry_extension_real_register_data_source_co (_data_);
}


static gboolean
zeitgeist_data_source_registry_extension_real_register_data_source_finish (ZeitgeistRemoteRegistry* base,
                                                                           GAsyncResult* _res_,
                                                                           GError** error)
{
	gboolean result;
	ZeitgeistDataSourceRegistryExtensionRegisterDataSourceData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		gboolean _tmp0_ = FALSE;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}


static gpointer
_g_ptr_array_ref0 (gpointer self)
{
	return self ? g_ptr_array_ref (self) : NULL;
}


static gboolean
zeitgeist_data_source_registry_extension_real_register_data_source_co (ZeitgeistDataSourceRegistryExtensionRegisterDataSourceData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_debug ("ds-registry.vala:157: %s: %s, %s, %s", "Zeitgeist.DataSourceRegistryExtension.register_data_source", _data_->unique_id, _data_->name, _data_->description);
	if (_data_->sender == NULL) {
		g_warning ("ds-registry.vala:161: %s: sender == null, ignoring request", "Zeitgeist.DataSourceRegistryExtension.register_data_source");
		_data_->result = FALSE;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (_data_->_task_complete_ != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp0_ = _data_->self->priv->running_ds;
	_data_->_tmp1_ = g_hash_table_lookup (_data_->_tmp0_, _data_->unique_id);
	_data_->_tmp2_ = _g_ptr_array_ref0 ((GPtrArray*) _data_->_tmp1_);
	_data_->sender_array = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->sender_array;
	if (_data_->_tmp3_ == NULL) {
		_data_->_tmp4_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
		_g_ptr_array_unref0 (_data_->sender_array);
		_data_->sender_array = _data_->_tmp4_;
		_data_->_tmp5_ = _data_->sender_array;
		_data_->_tmp6_ = g_strdup (_data_->sender);
		g_ptr_array_add (_data_->_tmp5_, _data_->_tmp6_);
		_data_->_tmp7_ = _data_->self->priv->running_ds;
		_data_->_tmp8_ = g_strdup (_data_->unique_id);
		_data_->_tmp9_ = _data_->sender_array;
		_data_->_tmp10_ = _g_ptr_array_ref0 (_data_->_tmp9_);
		g_hash_table_insert (_data_->_tmp7_, _data_->_tmp8_, _data_->_tmp10_);
	} else {
		_data_->_tmp11_ = _data_->sender_array;
		if (!zeitgeist_data_source_registry_extension_is_sender_known (_data_->self, _data_->sender, _data_->_tmp11_)) {
			_data_->_tmp12_ = _data_->sender_array;
			_data_->_tmp13_ = g_strdup (_data_->sender);
			g_ptr_array_add (_data_->_tmp12_, _data_->_tmp13_);
		}
	}
	_data_->_tmp14_ = _data_->self->priv->bus_name_2_ds;
	_data_->_tmp15_ = g_hash_table_lookup (_data_->_tmp14_, (const gchar*) _data_->sender);
	_data_->ds_id = (const gchar*) _data_->_tmp15_;
	_data_->_tmp16_ = _data_->ds_id;
	if (_data_->_tmp16_ == NULL) {
		_data_->_tmp17_ = _data_->self->priv->bus_name_2_ds;
		_data_->_tmp18_ = g_strdup ((gchar*) _data_->sender);
		_data_->_tmp19_ = g_strdup (_data_->unique_id);
		g_hash_table_insert (_data_->_tmp17_, _data_->_tmp18_, _data_->_tmp19_);
	} else {
		_data_->_tmp21_ = _data_->ds_id;
		if (g_strcmp0 (_data_->_tmp21_, _data_->unique_id) != 0) {
			_data_->_tmp22_ = _data_->ds_id;
			_data_->_tmp20_ = g_strcmp0 (_data_->_tmp22_, ZEITGEIST_DATA_SOURCE_REGISTRY_EXTENSION_MULTIPLE_MARKER) != 0;
		} else {
			_data_->_tmp20_ = FALSE;
		}
		if (_data_->_tmp20_) {
			_data_->_tmp23_ = _data_->self->priv->bus_name_2_ds;
			_data_->_tmp24_ = g_strdup ((gchar*) _data_->sender);
			_data_->_tmp25_ = g_strdup (ZEITGEIST_DATA_SOURCE_REGISTRY_EXTENSION_MULTIPLE_MARKER);
			g_hash_table_insert (_data_->_tmp23_, _data_->_tmp24_, _data_->_tmp25_);
		}
	}
	_data_->_tmp26_ = _data_->self->priv->sources;
	_data_->_tmp27_ = g_hash_table_lookup (_data_->_tmp26_, _data_->unique_id);
	_data_->ds = (ZeitgeistDataSource*) _data_->_tmp27_;
	_data_->_tmp28_ = _data_->ds;
	if (_data_->_tmp28_ != NULL) {
		_data_->_tmp30_ = zeitgeist_events_from_variant (_data_->event_templates, &_data_->_inner_error_);
		_data_->_tmp29_ = _data_->_tmp30_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			if (_data_->_inner_error_->domain == ZEITGEIST_DATA_MODEL_ERROR) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error_);
				_g_ptr_array_unref0 (_data_->templates);
				_g_ptr_array_unref0 (_data_->sender_array);
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				_g_ptr_array_unref0 (_data_->templates);
				_g_ptr_array_unref0 (_data_->sender_array);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
		_data_->_tmp31_ = _data_->_tmp29_;
		_data_->_tmp29_ = NULL;
		_g_ptr_array_unref0 (_data_->templates);
		_data_->templates = _data_->_tmp31_;
		_data_->_tmp32_ = _data_->ds;
		zeitgeist_data_source_set_name (_data_->_tmp32_, _data_->name);
		_data_->_tmp33_ = _data_->ds;
		zeitgeist_data_source_set_description (_data_->_tmp33_, _data_->description);
		_data_->_tmp34_ = _data_->ds;
		_data_->_tmp35_ = _data_->templates;
		zeitgeist_data_source_set_event_templates (_data_->_tmp34_, _data_->_tmp35_);
		_data_->_tmp36_ = _data_->ds;
		zeitgeist_data_source_set_timestamp (_data_->_tmp36_, zeitgeist_timestamp_from_now ());
		_data_->_tmp37_ = _data_->ds;
		zeitgeist_data_source_set_running (_data_->_tmp37_, TRUE);
		_data_->self->priv->dirty = TRUE;
		_data_->_tmp38_ = _data_->ds;
		_data_->_tmp39_ = zeitgeist_data_source_to_variant (_data_->_tmp38_);
		_data_->_tmp40_ = _data_->_tmp39_;
		g_signal_emit_by_name ((ZeitgeistRemoteRegistry*) _data_->self, "data-source-registered", _data_->_tmp40_);
		_g_variant_unref0 (_data_->_tmp40_);
		_data_->_tmp41_ = _data_->ds;
		_data_->_tmp42_ = zeitgeist_data_source_get_enabled (_data_->_tmp41_);
		_data_->_tmp43_ = _data_->_tmp42_;
		_data_->result = _data_->_tmp43_;
		_g_ptr_array_unref0 (_data_->_tmp29_);
		_g_ptr_array_unref0 (_data_->templates);
		_g_ptr_array_unref0 (_data_->sender_array);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (_data_->_task_complete_ != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		_data_->_tmp45_ = zeitgeist_events_from_variant (_data_->event_templates, &_data_->_inner_error_);
		_data_->_tmp44_ = _data_->_tmp45_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			if (_data_->_inner_error_->domain == ZEITGEIST_DATA_MODEL_ERROR) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error_);
				_g_ptr_array_unref0 (_data_->templates);
				_g_ptr_array_unref0 (_data_->sender_array);
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				_g_ptr_array_unref0 (_data_->templates);
				_g_ptr_array_unref0 (_data_->sender_array);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
		_data_->_tmp46_ = _data_->_tmp44_;
		_data_->_tmp44_ = NULL;
		_g_ptr_array_unref0 (_data_->templates);
		_data_->templates = _data_->_tmp46_;
		_data_->_tmp47_ = _data_->templates;
		_data_->_tmp48_ = zeitgeist_data_source_new_full (_data_->unique_id, _data_->name, _data_->description, _data_->_tmp47_);
		_data_->new_ds = _data_->_tmp48_;
		_data_->_tmp49_ = _data_->new_ds;
		zeitgeist_data_source_set_enabled (_data_->_tmp49_, TRUE);
		_data_->_tmp50_ = _data_->new_ds;
		zeitgeist_data_source_set_running (_data_->_tmp50_, TRUE);
		_data_->_tmp51_ = _data_->new_ds;
		zeitgeist_data_source_set_timestamp (_data_->_tmp51_, zeitgeist_timestamp_from_now ());
		_data_->_tmp52_ = _data_->self->priv->sources;
		_data_->_tmp53_ = g_strdup (_data_->unique_id);
		_data_->_tmp54_ = _data_->new_ds;
		_data_->_tmp55_ = _g_object_ref0 (_data_->_tmp54_);
		g_hash_table_insert (_data_->_tmp52_, _data_->_tmp53_, _data_->_tmp55_);
		_data_->self->priv->dirty = TRUE;
		_data_->_tmp56_ = _data_->new_ds;
		_data_->_tmp57_ = zeitgeist_data_source_to_variant (_data_->_tmp56_);
		_data_->_tmp58_ = _data_->_tmp57_;
		g_signal_emit_by_name ((ZeitgeistRemoteRegistry*) _data_->self, "data-source-registered", _data_->_tmp58_);
		_g_variant_unref0 (_data_->_tmp58_);
		_data_->_tmp59_ = _data_->new_ds;
		_data_->_tmp60_ = zeitgeist_data_source_get_enabled (_data_->_tmp59_);
		_data_->_tmp61_ = _data_->_tmp60_;
		_data_->result = _data_->_tmp61_;
		_g_object_unref0 (_data_->new_ds);
		_g_ptr_array_unref0 (_data_->_tmp44_);
		_g_ptr_array_unref0 (_data_->templates);
		_g_ptr_array_unref0 (_data_->sender_array);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (_data_->_task_complete_ != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_ptr_array_unref0 (_data_->templates);
	_g_ptr_array_unref0 (_data_->sender_array);
}


static void
zeitgeist_data_source_registry_extension_real_set_data_source_enabled_data_free (gpointer _data)
{
	ZeitgeistDataSourceRegistryExtensionSetDataSourceEnabledData* _data_;
	_data_ = _data;
	_g_free0 (_data_->unique_id);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (ZeitgeistDataSourceRegistryExtensionSetDataSourceEnabledData, _data_);
}


static void
zeitgeist_data_source_registry_extension_real_set_data_source_enabled_async_ready_wrapper (GObject *source_object,
                                                                                           GAsyncResult *res,
                                                                                           void *user_data)
{
	ZeitgeistDataSourceRegistryExtensionSetDataSourceEnabledData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static void
zeitgeist_data_source_registry_extension_real_set_data_source_enabled (ZeitgeistRemoteRegistry* base,
                                                                       const gchar* unique_id,
                                                                       gboolean enabled,
                                                                       GCancellable* cancellable,
                                                                       GAsyncReadyCallback _callback_,
                                                                       gpointer _user_data_)
{
	ZeitgeistDataSourceRegistryExtension * self;
	ZeitgeistDataSourceRegistryExtensionSetDataSourceEnabledData* _data_;
	ZeitgeistDataSourceRegistryExtension* _tmp0_;
	gchar* _tmp1_;
	GCancellable* _tmp2_;
	self = (ZeitgeistDataSourceRegistryExtension*) base;
	_data_ = g_slice_new0 (ZeitgeistDataSourceRegistryExtensionSetDataSourceEnabledData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, zeitgeist_data_source_registry_extension_real_set_data_source_enabled_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, zeitgeist_data_source_registry_extension_real_set_data_source_enabled_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (unique_id);
	_g_free0 (_data_->unique_id);
	_data_->unique_id = _tmp1_;
	_data_->enabled = enabled;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	zeitgeist_data_source_registry_extension_real_set_data_source_enabled_co (_data_);
}


static void
zeitgeist_data_source_registry_extension_real_set_data_source_enabled_finish (ZeitgeistRemoteRegistry* base,
                                                                              GAsyncResult* _res_,
                                                                              GError** error)
{
	ZeitgeistDataSourceRegistryExtensionSetDataSourceEnabledData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	if (NULL == _data_) {
		return;
	}
}


static gboolean
zeitgeist_data_source_registry_extension_real_set_data_source_enabled_co (ZeitgeistDataSourceRegistryExtensionSetDataSourceEnabledData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_debug ("ds-registry.vala:225: %s: %s, %d", "Zeitgeist.DataSourceRegistryExtension.set_data_source_enabled", _data_->unique_id, (gint) _data_->enabled);
	_data_->_tmp0_ = _data_->self->priv->sources;
	_data_->_tmp1_ = g_hash_table_lookup (_data_->_tmp0_, _data_->unique_id);
	_data_->ds = (ZeitgeistDataSource*) _data_->_tmp1_;
	_data_->_tmp2_ = _data_->ds;
	if (_data_->_tmp2_ != NULL) {
		_data_->_tmp3_ = _data_->ds;
		_data_->_tmp4_ = zeitgeist_data_source_get_enabled (_data_->_tmp3_);
		_data_->_tmp5_ = _data_->_tmp4_;
		if (_data_->_tmp5_ != _data_->enabled) {
			_data_->_tmp6_ = _data_->ds;
			zeitgeist_data_source_set_enabled (_data_->_tmp6_, _data_->enabled);
			_data_->self->priv->dirty = TRUE;
			g_signal_emit_by_name ((ZeitgeistRemoteRegistry*) _data_->self, "data-source-enabled", _data_->unique_id, _data_->enabled);
		}
	} else {
		g_warning ("ds-registry.vala:238: DataSource \"%s\" isn't registered!", _data_->unique_id);
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void
zeitgeist_data_source_registry_extension_real_get_data_source_from_id_data_free (gpointer _data)
{
	ZeitgeistDataSourceRegistryExtensionGetDataSourceFromIdData* _data_;
	_data_ = _data;
	_g_free0 (_data_->unique_id);
	_g_object_unref0 (_data_->cancellable);
	_g_variant_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (ZeitgeistDataSourceRegistryExtensionGetDataSourceFromIdData, _data_);
}


static void
zeitgeist_data_source_registry_extension_real_get_data_source_from_id_async_ready_wrapper (GObject *source_object,
                                                                                           GAsyncResult *res,
                                                                                           void *user_data)
{
	ZeitgeistDataSourceRegistryExtensionGetDataSourceFromIdData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static void
zeitgeist_data_source_registry_extension_real_get_data_source_from_id (ZeitgeistRemoteRegistry* base,
                                                                       const gchar* unique_id,
                                                                       GCancellable* cancellable,
                                                                       GAsyncReadyCallback _callback_,
                                                                       gpointer _user_data_)
{
	ZeitgeistDataSourceRegistryExtension * self;
	ZeitgeistDataSourceRegistryExtensionGetDataSourceFromIdData* _data_;
	ZeitgeistDataSourceRegistryExtension* _tmp0_;
	gchar* _tmp1_;
	GCancellable* _tmp2_;
	self = (ZeitgeistDataSourceRegistryExtension*) base;
	_data_ = g_slice_new0 (ZeitgeistDataSourceRegistryExtensionGetDataSourceFromIdData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, zeitgeist_data_source_registry_extension_real_get_data_source_from_id_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, zeitgeist_data_source_registry_extension_real_get_data_source_from_id_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (unique_id);
	_g_free0 (_data_->unique_id);
	_data_->unique_id = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	zeitgeist_data_source_registry_extension_real_get_data_source_from_id_co (_data_);
}


static GVariant*
zeitgeist_data_source_registry_extension_real_get_data_source_from_id_finish (ZeitgeistRemoteRegistry* base,
                                                                              GAsyncResult* _res_,
                                                                              GError** error)
{
	GVariant* result;
	ZeitgeistDataSourceRegistryExtensionGetDataSourceFromIdData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static gboolean
zeitgeist_data_source_registry_extension_real_get_data_source_from_id_co (ZeitgeistDataSourceRegistryExtensionGetDataSourceFromIdData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->sources;
	_data_->_tmp1_ = g_hash_table_lookup (_data_->_tmp0_, _data_->unique_id);
	_data_->ds = (ZeitgeistDataSource*) _data_->_tmp1_;
	_data_->_tmp2_ = _data_->ds;
	if (_data_->_tmp2_ != NULL) {
		_data_->_tmp3_ = _data_->ds;
		_data_->_tmp4_ = zeitgeist_data_source_to_variant (_data_->_tmp3_);
		_data_->result = _data_->_tmp4_;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (_data_->_task_complete_ != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp5_ = g_strdup_printf ("Datasource with unique ID: %s not found", _data_->unique_id);
	_data_->_tmp6_ = _data_->_tmp5_;
	_data_->_tmp7_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_INVALID_KEY, _data_->_tmp6_);
	_data_->_tmp8_ = _data_->_tmp7_;
	_g_free0 (_data_->_tmp6_);
	_data_->_inner_error_ = _data_->_tmp8_;
	g_task_return_error (_data_->_async_result, _data_->_inner_error_);
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void
g_ptr_array_set (GPtrArray* self,
                 guint index,
                 gpointer data)
{
	gpointer _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = data;
	data = NULL;
	g_ptr_array_add (self, _tmp0_);
	g_ptr_array_remove_index_fast (self, index);
}


static void
zeitgeist_data_source_registry_extension_real_pre_insert_events (ZeitgeistExtension* base,
                                                                 GPtrArray* events,
                                                                 const char* sender)
{
	ZeitgeistDataSourceRegistryExtension * self;
	GHashTable* _tmp0_;
	GList* _tmp1_;
	self = (ZeitgeistDataSourceRegistryExtension*) base;
	g_return_if_fail (events != NULL);
	_tmp0_ = self->priv->running_ds;
	_tmp1_ = g_hash_table_get_keys (_tmp0_);
	{
		GList* unique_id_collection = NULL;
		GList* unique_id_it = NULL;
		unique_id_collection = _tmp1_;
		for (unique_id_it = unique_id_collection; unique_id_it != NULL; unique_id_it = unique_id_it->next) {
			const gchar* unique_id = NULL;
			unique_id = (const gchar*) unique_id_it->data;
			{
				GPtrArray* bus_names = NULL;
				GHashTable* _tmp2_;
				const gchar* _tmp3_;
				gconstpointer _tmp4_;
				GPtrArray* _tmp5_;
				GPtrArray* _tmp6_;
				_tmp2_ = self->priv->running_ds;
				_tmp3_ = unique_id;
				_tmp4_ = g_hash_table_lookup (_tmp2_, _tmp3_);
				_tmp5_ = _g_ptr_array_ref0 ((GPtrArray*) _tmp4_);
				bus_names = _tmp5_;
				_tmp6_ = bus_names;
				if (zeitgeist_data_source_registry_extension_is_sender_known (self, sender, _tmp6_)) {
					ZeitgeistDataSource* data_source = NULL;
					GHashTable* _tmp7_;
					const gchar* _tmp8_;
					gconstpointer _tmp9_;
					ZeitgeistDataSource* _tmp10_;
					ZeitgeistDataSource* _tmp11_;
					const gchar* ds_id = NULL;
					GHashTable* _tmp12_;
					gconstpointer _tmp13_;
					gboolean _tmp14_ = FALSE;
					ZeitgeistDataSource* _tmp15_;
					gboolean _tmp16_;
					gboolean _tmp17_;
					_tmp7_ = self->priv->sources;
					_tmp8_ = unique_id;
					_tmp9_ = g_hash_table_lookup (_tmp7_, _tmp8_);
					_tmp10_ = _g_object_ref0 ((ZeitgeistDataSource*) _tmp9_);
					data_source = _tmp10_;
					_tmp11_ = data_source;
					zeitgeist_data_source_set_timestamp (_tmp11_, zeitgeist_timestamp_from_now ());
					self->priv->dirty = TRUE;
					_tmp12_ = self->priv->bus_name_2_ds;
					_tmp13_ = g_hash_table_lookup (_tmp12_, (const gchar*) sender);
					ds_id = (const gchar*) _tmp13_;
					_tmp15_ = data_source;
					_tmp16_ = zeitgeist_data_source_get_enabled (_tmp15_);
					_tmp17_ = _tmp16_;
					if (!_tmp17_) {
						const gchar* _tmp18_;
						_tmp18_ = ds_id;
						_tmp14_ = g_strcmp0 (_tmp18_, ZEITGEIST_DATA_SOURCE_REGISTRY_EXTENSION_MULTIPLE_MARKER) != 0;
					} else {
						_tmp14_ = FALSE;
					}
					if (_tmp14_) {
						{
							gint i = 0;
							i = 0;
							{
								gboolean _tmp19_ = FALSE;
								_tmp19_ = TRUE;
								while (TRUE) {
									gint _tmp21_;
									gint _tmp22_;
									gint _tmp23_;
									gint _tmp24_;
									if (!_tmp19_) {
										gint _tmp20_;
										_tmp20_ = i;
										i = _tmp20_ + 1;
									}
									_tmp19_ = FALSE;
									_tmp21_ = i;
									_tmp22_ = g_ptr_array_get_length (events);
									_tmp23_ = _tmp22_;
									if (!(_tmp21_ < _tmp23_)) {
										break;
									}
									_tmp24_ = i;
									g_ptr_array_set (events, (guint) _tmp24_, NULL);
								}
							}
						}
					}
					_g_object_unref0 (data_source);
				}
				_g_ptr_array_unref0 (bus_names);
			}
		}
		_g_list_free0 (unique_id_collection);
	}
}


static void
zeitgeist_data_source_registry_extension_name_owner_changed (ZeitgeistDataSourceRegistryExtension* self,
                                                             GDBusConnection* conn,
                                                             const gchar* sender,
                                                             const gchar* path,
                                                             const gchar* interface_name,
                                                             const gchar* signal_name,
                                                             GVariant* parameters)
{
	gchar* name = NULL;
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* new_owner = NULL;
	GVariant* _tmp4_;
	GVariant* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	GPtrArray* disconnected_ds = NULL;
	GPtrArray* _tmp9_;
	GPtrArray* _tmp31_;
	gint _tmp32_;
	gint _tmp33_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (conn != NULL);
	g_return_if_fail (sender != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (interface_name != NULL);
	g_return_if_fail (signal_name != NULL);
	g_return_if_fail (parameters != NULL);
	_tmp0_ = g_variant_get_child_value (parameters, (gsize) 0);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_dup_string (_tmp1_, NULL);
	_tmp3_ = _tmp2_;
	_g_variant_unref0 (_tmp1_);
	name = _tmp3_;
	_tmp4_ = g_variant_get_child_value (parameters, (gsize) 2);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_variant_dup_string (_tmp5_, NULL);
	_tmp7_ = _tmp6_;
	_g_variant_unref0 (_tmp5_);
	new_owner = _tmp7_;
	_tmp8_ = new_owner;
	if (g_strcmp0 (_tmp8_, "") != 0) {
		_g_free0 (new_owner);
		_g_free0 (name);
		return;
	}
	_tmp9_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	disconnected_ds = _tmp9_;
	{
		GHashTableIter iter = {0};
		GHashTable* _tmp10_;
		const gchar* uid = NULL;
		GPtrArray* name_arr = NULL;
		_tmp10_ = self->priv->running_ds;
		g_hash_table_iter_init (&iter, _tmp10_);
		while (TRUE) {
			gconstpointer _tmp11_ = NULL;
			gconstpointer _tmp12_ = NULL;
			gboolean _tmp13_;
			_tmp13_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp11_), (gpointer*) (&_tmp12_));
			uid = _tmp11_;
			name_arr = _tmp12_;
			if (!_tmp13_) {
				break;
			}
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp14_ = FALSE;
					_tmp14_ = TRUE;
					while (TRUE) {
						gint _tmp16_;
						GPtrArray* _tmp17_;
						gint _tmp18_;
						gint _tmp19_;
						GPtrArray* _tmp20_;
						gint _tmp21_;
						gconstpointer _tmp22_;
						const gchar* _tmp23_;
						if (!_tmp14_) {
							gint _tmp15_;
							_tmp15_ = i;
							i = _tmp15_ + 1;
						}
						_tmp14_ = FALSE;
						_tmp16_ = i;
						_tmp17_ = name_arr;
						_tmp18_ = g_ptr_array_get_length (_tmp17_);
						_tmp19_ = _tmp18_;
						if (!(_tmp16_ < _tmp19_)) {
							break;
						}
						_tmp20_ = name_arr;
						_tmp21_ = i;
						_tmp22_ = g_ptr_array_index (_tmp20_, (guint) _tmp21_);
						_tmp23_ = name;
						if (g_strcmp0 ((const char*) _tmp22_, _tmp23_) == 0) {
							GPtrArray* _tmp24_;
							GHashTable* _tmp25_;
							const gchar* _tmp26_;
							gconstpointer _tmp27_;
							ZeitgeistDataSource* _tmp28_;
							GPtrArray* _tmp29_;
							gint _tmp30_;
							_tmp24_ = disconnected_ds;
							_tmp25_ = self->priv->sources;
							_tmp26_ = uid;
							_tmp27_ = g_hash_table_lookup (_tmp25_, _tmp26_);
							_tmp28_ = _g_object_ref0 ((ZeitgeistDataSource*) _tmp27_);
							g_ptr_array_add (_tmp24_, _tmp28_);
							_tmp29_ = name_arr;
							_tmp30_ = i;
							i = _tmp30_ - 1;
							g_ptr_array_remove_index_fast (_tmp29_, (guint) _tmp30_);
						}
					}
				}
			}
		}
	}
	_tmp31_ = disconnected_ds;
	_tmp32_ = g_ptr_array_get_length (_tmp31_);
	_tmp33_ = _tmp32_;
	if (_tmp33_ == 0) {
		_g_ptr_array_unref0 (disconnected_ds);
		_g_free0 (new_owner);
		_g_free0 (name);
		return;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp34_ = FALSE;
			_tmp34_ = TRUE;
			while (TRUE) {
				gint _tmp36_;
				GPtrArray* _tmp37_;
				gint _tmp38_;
				gint _tmp39_;
				ZeitgeistDataSource* ds = NULL;
				GPtrArray* _tmp40_;
				gint _tmp41_;
				gconstpointer _tmp42_;
				ZeitgeistDataSource* _tmp43_;
				const gchar* uid = NULL;
				ZeitgeistDataSource* _tmp44_;
				const gchar* _tmp45_;
				const gchar* _tmp46_;
				ZeitgeistDataSource* _tmp47_;
				const gchar* _tmp48_;
				const gchar* _tmp49_;
				const gchar* _tmp50_;
				ZeitgeistDataSource* _tmp51_;
				GHashTable* _tmp52_;
				const gchar* _tmp53_;
				gconstpointer _tmp54_;
				gint _tmp55_;
				gint _tmp56_;
				if (!_tmp34_) {
					gint _tmp35_;
					_tmp35_ = i;
					i = _tmp35_ + 1;
				}
				_tmp34_ = FALSE;
				_tmp36_ = i;
				_tmp37_ = disconnected_ds;
				_tmp38_ = g_ptr_array_get_length (_tmp37_);
				_tmp39_ = _tmp38_;
				if (!(_tmp36_ < _tmp39_)) {
					break;
				}
				_tmp40_ = disconnected_ds;
				_tmp41_ = i;
				_tmp42_ = g_ptr_array_index (_tmp40_, (guint) _tmp41_);
				_tmp43_ = _g_object_ref0 ((ZeitgeistDataSource*) _tmp42_);
				ds = _tmp43_;
				_tmp44_ = ds;
				_tmp45_ = zeitgeist_data_source_get_unique_id (_tmp44_);
				_tmp46_ = _tmp45_;
				uid = _tmp46_;
				_tmp47_ = ds;
				_tmp48_ = zeitgeist_data_source_get_name (_tmp47_);
				_tmp49_ = _tmp48_;
				_tmp50_ = uid;
				g_debug ("ds-registry.vala:320: Client disconnected: %s [%s]", _tmp49_, _tmp50_);
				_tmp51_ = ds;
				zeitgeist_data_source_set_timestamp (_tmp51_, zeitgeist_timestamp_from_now ());
				self->priv->dirty = TRUE;
				_tmp52_ = self->priv->running_ds;
				_tmp53_ = uid;
				_tmp54_ = g_hash_table_lookup (_tmp52_, _tmp53_);
				_tmp55_ = g_ptr_array_get_length ((GPtrArray*) _tmp54_);
				_tmp56_ = _tmp55_;
				if (_tmp56_ == 0) {
					ZeitgeistDataSource* _tmp57_;
					const gchar* _tmp58_;
					const gchar* _tmp59_;
					const gchar* _tmp60_;
					GHashTable* _tmp61_;
					const gchar* _tmp62_;
					ZeitgeistDataSource* _tmp63_;
					ZeitgeistDataSource* _tmp64_;
					GVariant* _tmp65_;
					GVariant* _tmp66_;
					_tmp57_ = ds;
					_tmp58_ = zeitgeist_data_source_get_name (_tmp57_);
					_tmp59_ = _tmp58_;
					_tmp60_ = uid;
					g_debug ("ds-registry.vala:328: No remaining client running: %s [%s]", _tmp59_, _tmp60_);
					_tmp61_ = self->priv->running_ds;
					_tmp62_ = uid;
					g_hash_table_remove (_tmp61_, _tmp62_);
					_tmp63_ = ds;
					zeitgeist_data_source_set_running (_tmp63_, FALSE);
					_tmp64_ = ds;
					_tmp65_ = zeitgeist_data_source_to_variant (_tmp64_);
					_tmp66_ = _tmp65_;
					g_signal_emit_by_name ((ZeitgeistRemoteRegistry*) self, "data-source-disconnected", _tmp66_);
					_g_variant_unref0 (_tmp66_);
				}
				_g_object_unref0 (ds);
			}
		}
	}
	_g_ptr_array_unref0 (disconnected_ds);
	_g_free0 (new_owner);
	_g_free0 (name);
}


static gboolean
zeitgeist_data_source_registry_extension_flush (ZeitgeistDataSourceRegistryExtension* self)
{
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->dirty;
	if (_tmp0_) {
		GVariant* v = NULL;
		GHashTable* _tmp1_;
		GVariant* _tmp2_;
		GVariant* _tmp3_;
		_tmp1_ = self->priv->sources;
		_tmp2_ = zeitgeist_data_sources_to_variant (_tmp1_);
		v = _tmp2_;
		_tmp3_ = v;
		zeitgeist_extension_store_config ((ZeitgeistExtension*) self, "registry", _tmp3_);
		self->priv->dirty = FALSE;
		_g_variant_unref0 (v);
	}
	result = TRUE;
	return result;
}


static void
_g_ptr_array_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL));
}


static void
_zeitgeist_data_source_registry_extension_name_owner_changed_gd_bus_signal_callback (GDBusConnection* connection,
                                                                                     const gchar* sender_name,
                                                                                     const gchar* object_path,
                                                                                     const gchar* interface_name,
                                                                                     const gchar* signal_name,
                                                                                     GVariant* parameters,
                                                                                     gpointer self)
{
	zeitgeist_data_source_registry_extension_name_owner_changed ((ZeitgeistDataSourceRegistryExtension*) self, connection, sender_name, object_path, interface_name, signal_name, parameters);
}


static gboolean
_zeitgeist_data_source_registry_extension_flush_gsource_func (gpointer self)
{
	gboolean result;
	result = zeitgeist_data_source_registry_extension_flush ((ZeitgeistDataSourceRegistryExtension*) self);
	return result;
}


static GObject *
zeitgeist_data_source_registry_extension_constructor (GType type,
                                                      guint n_construct_properties,
                                                      GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ZeitgeistDataSourceRegistryExtension * self;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GHashFunc _tmp3_;
	GEqualFunc _tmp4_;
	GHashTable* _tmp5_;
	GVariant* registry = NULL;
	GVariant* _tmp6_;
	GVariant* _tmp7_;
	GError * _inner_error_ = NULL;
	parent_class = G_OBJECT_CLASS (zeitgeist_data_source_registry_extension_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZEITGEIST_TYPE_DATA_SOURCE_REGISTRY_EXTENSION, ZeitgeistDataSourceRegistryExtension);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_free0_);
	_g_hash_table_unref0 (self->priv->bus_name_2_ds);
	self->priv->bus_name_2_ds = _tmp2_;
	_tmp3_ = g_str_hash;
	_tmp4_ = g_str_equal;
	_tmp5_ = g_hash_table_new_full (_tmp3_, _tmp4_, _g_free0_, _g_ptr_array_unref0_);
	_g_hash_table_unref0 (self->priv->running_ds);
	self->priv->running_ds = _tmp5_;
	_tmp6_ = zeitgeist_extension_retrieve_config ((ZeitgeistExtension*) self, "registry", ZEITGEIST_DATA_SOURCES_SIG_DATASOURCES);
	registry = _tmp6_;
	_tmp7_ = registry;
	if (_tmp7_ != NULL) {
		{
			GHashTable* _tmp8_ = NULL;
			GVariant* _tmp9_;
			GHashTable* _tmp10_;
			GHashTable* _tmp11_;
			_tmp9_ = registry;
			_tmp10_ = zeitgeist_data_sources_registry_from_variant (_tmp9_, TRUE, &_inner_error_);
			_tmp8_ = _tmp10_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == ZEITGEIST_DATA_MODEL_ERROR) {
					goto __catch1_zeitgeist_data_model_error;
				}
				_g_variant_unref0 (registry);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
			}
			_tmp11_ = _tmp8_;
			_tmp8_ = NULL;
			_g_hash_table_unref0 (self->priv->sources);
			self->priv->sources = _tmp11_;
			_g_hash_table_unref0 (_tmp8_);
		}
		goto __finally1;
		__catch1_zeitgeist_data_model_error:
		{
			GError* e = NULL;
			GError* _tmp12_;
			const gchar* _tmp13_;
			GHashFunc _tmp14_;
			GEqualFunc _tmp15_;
			GHashTable* _tmp16_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp12_ = e;
			_tmp13_ = _tmp12_->message;
			g_warning ("ds-registry.vala:84: Error while loading datasource registry: %s", _tmp13_);
			_tmp14_ = g_str_hash;
			_tmp15_ = g_str_equal;
			_tmp16_ = g_hash_table_new_full (_tmp14_, _tmp15_, _g_free0_, _g_object_unref0_);
			_g_hash_table_unref0 (self->priv->sources);
			self->priv->sources = _tmp16_;
			_g_error_free0 (e);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_variant_unref0 (registry);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
	} else {
		GHashFunc _tmp17_;
		GEqualFunc _tmp18_;
		GHashTable* _tmp19_;
		_tmp17_ = g_str_hash;
		_tmp18_ = g_str_equal;
		_tmp19_ = g_hash_table_new_full (_tmp17_, _tmp18_, _g_free0_, _g_object_unref0_);
		_g_hash_table_unref0 (self->priv->sources);
		self->priv->sources = _tmp19_;
	}
	{
		GDBusConnection* connection = NULL;
		GDBusConnection* _tmp20_;
		guint _tmp21_ = 0U;
		GDBusConnection* _tmp22_;
		guint _tmp23_;
		GDBusConnection* _tmp24_;
		_tmp20_ = g_bus_get_sync (G_BUS_TYPE_SESSION, NULL, &_inner_error_);
		connection = _tmp20_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch2_g_error;
		}
		_tmp22_ = connection;
		_tmp23_ = zeitgeist_remote_registry_register_object ((ZeitgeistRemoteRegistry*) self, _tmp22_, "/org/gnome/zeitgeist/data_source_registry", &_inner_error_);
		_tmp21_ = _tmp23_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (connection);
			goto __catch2_g_error;
		}
		self->priv->registration_id = _tmp21_;
		_tmp24_ = connection;
		g_dbus_connection_signal_subscribe (_tmp24_, "org.freedesktop.DBus", "org.freedesktop.DBus", "NameOwnerChanged", "/org/freedesktop/DBus", NULL, 0, _zeitgeist_data_source_registry_extension_name_owner_changed_gd_bus_signal_callback, g_object_ref (self), g_object_unref);
		_g_object_unref0 (connection);
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* err = NULL;
		GError* _tmp25_;
		const gchar* _tmp26_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp25_ = err;
		_tmp26_ = _tmp25_->message;
		g_warning ("ds-registry.vala:109: %s", _tmp26_);
		_g_error_free0 (err);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_variant_unref0 (registry);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	g_timeout_add_seconds_full (G_PRIORITY_LOW, ZEITGEIST_DATA_SOURCE_REGISTRY_EXTENSION_DISK_WRITE_TIMEOUT, _zeitgeist_data_source_registry_extension_flush_gsource_func, g_object_ref (self), g_object_unref);
	_g_variant_unref0 (registry);
	return obj;
}


static void
zeitgeist_data_source_registry_extension_class_init (ZeitgeistDataSourceRegistryExtensionClass * klass)
{
	zeitgeist_data_source_registry_extension_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ZeitgeistDataSourceRegistryExtensionPrivate));
	((ZeitgeistExtensionClass *) klass)->unload = (void (*) (ZeitgeistExtension *)) zeitgeist_data_source_registry_extension_real_unload;
	((ZeitgeistExtensionClass *) klass)->pre_insert_events = (void (*) (ZeitgeistExtension *, GPtrArray*, const char*)) zeitgeist_data_source_registry_extension_real_pre_insert_events;
	G_OBJECT_CLASS (klass)->constructor = zeitgeist_data_source_registry_extension_constructor;
	G_OBJECT_CLASS (klass)->finalize = zeitgeist_data_source_registry_extension_finalize;
}


static void
zeitgeist_data_source_registry_extension_zeitgeist_remote_registry_interface_init (ZeitgeistRemoteRegistryIface * iface)
{
	zeitgeist_data_source_registry_extension_zeitgeist_remote_registry_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_data_sources = (void (*) (ZeitgeistRemoteRegistry *, GCancellable*, GAsyncReadyCallback, gpointer)) zeitgeist_data_source_registry_extension_real_get_data_sources;
	iface->get_data_sources_finish = (GVariant* (*) (ZeitgeistRemoteRegistry *, GAsyncResult*, GError**)) zeitgeist_data_source_registry_extension_real_get_data_sources_finish;
	iface->register_data_source = (void (*) (ZeitgeistRemoteRegistry *, const gchar*, const gchar*, const gchar*, GVariant*, GCancellable*, const char*, GAsyncReadyCallback, gpointer)) zeitgeist_data_source_registry_extension_real_register_data_source;
	iface->register_data_source_finish = (gboolean (*) (ZeitgeistRemoteRegistry *, GAsyncResult*, GError**)) zeitgeist_data_source_registry_extension_real_register_data_source_finish;
	iface->set_data_source_enabled = (void (*) (ZeitgeistRemoteRegistry *, const gchar*, gboolean, GCancellable*, GAsyncReadyCallback, gpointer)) zeitgeist_data_source_registry_extension_real_set_data_source_enabled;
	iface->set_data_source_enabled_finish = (void (*) (ZeitgeistRemoteRegistry *, GAsyncResult*, GError**)) zeitgeist_data_source_registry_extension_real_set_data_source_enabled_finish;
	iface->get_data_source_from_id = (void (*) (ZeitgeistRemoteRegistry *, const gchar*, GCancellable*, GAsyncReadyCallback, gpointer)) zeitgeist_data_source_registry_extension_real_get_data_source_from_id;
	iface->get_data_source_from_id_finish = (GVariant* (*) (ZeitgeistRemoteRegistry *, GAsyncResult*, GError**)) zeitgeist_data_source_registry_extension_real_get_data_source_from_id_finish;
}


static void
zeitgeist_data_source_registry_extension_instance_init (ZeitgeistDataSourceRegistryExtension * self)
{
	self->priv = ZEITGEIST_DATA_SOURCE_REGISTRY_EXTENSION_GET_PRIVATE (self);
}


static void
zeitgeist_data_source_registry_extension_finalize (GObject * obj)
{
	ZeitgeistDataSourceRegistryExtension * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZEITGEIST_TYPE_DATA_SOURCE_REGISTRY_EXTENSION, ZeitgeistDataSourceRegistryExtension);
	_g_hash_table_unref0 (self->priv->sources);
	_g_hash_table_unref0 (self->priv->running_ds);
	_g_hash_table_unref0 (self->priv->bus_name_2_ds);
	G_OBJECT_CLASS (zeitgeist_data_source_registry_extension_parent_class)->finalize (obj);
}


GType
zeitgeist_data_source_registry_extension_get_type (void)
{
	return zeitgeist_data_source_registry_extension_type_id;
}


GType
zeitgeist_data_source_registry_extension_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistDataSourceRegistryExtensionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_data_source_registry_extension_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistDataSourceRegistryExtension), 0, (GInstanceInitFunc) zeitgeist_data_source_registry_extension_instance_init, NULL };
	static const GInterfaceInfo zeitgeist_remote_registry_info = { (GInterfaceInitFunc) zeitgeist_data_source_registry_extension_zeitgeist_remote_registry_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	zeitgeist_data_source_registry_extension_type_id = g_type_module_register_type (module, ZEITGEIST_TYPE_EXTENSION, "ZeitgeistDataSourceRegistryExtension", &g_define_type_info, 0);
	g_type_module_add_interface (module, zeitgeist_data_source_registry_extension_type_id, ZEITGEIST_TYPE_REMOTE_REGISTRY, &zeitgeist_remote_registry_info);
	return zeitgeist_data_source_registry_extension_type_id;
}


GType
zeitgeist_extension_register (GTypeModule* module)
{
	GType result = 0UL;
	g_return_val_if_fail (module != NULL, 0UL);
	zeitgeist_data_source_registry_extension_register_type (module);
	result = ZEITGEIST_TYPE_DATA_SOURCE_REGISTRY_EXTENSION;
	return result;
}



