# Contributing to Eclipse Sumo

Thanks for your interest in this project.

## Project description

Eclipse Simulation of Urban Mobility (SUMO) is a free and open traffic
simulation toolsuite. SUMO allows modelling and analyzing intermodal traffic
systems, including road vehicles, public transport, cargo logistics and
pedestrians. Included with SUMO is a wealth of supporting tools, which handle
tasks like route finding, visualization, network import and emission
calculation. SUMO can be enhanced with custom models and it provides various
APIs to remotely control and influence the simulation.

* https://eclipse.org/sumo

## Developer resources

Information regarding source code management, builds, coding standards, and
more.

* http://sumo.dlr.de/wiki/Developer/Main

The project maintains the following source code repositories

* https://github.com/eclipse/sumo

We are happily reviewing pull requests against the master of this repository.
For details see below and http://sumo.dlr.de/wiki/FAQ#How_do_code_contributions_work.3F.

## Eclipse Contributor Agreement

Before your contribution can be accepted by the project team contributors must
electronically sign the Eclipse Contributor Agreement (ECA).

* http://www.eclipse.org/legal/ECA.php

Commits that are provided by non-committers must have a Signed-off-by field in
the footer indicating that the author is aware of the terms by which the
contribution has been provided to the project. The non-committer must
additionally have an Eclipse Foundation account and must have a signed Eclipse
Contributor Agreement (ECA) on file.

For more information, please see the Eclipse Committer Handbook:
https://www.eclipse.org/projects/handbook/#resources-commit

## Contact

Contact the project developers via the project's "dev" list.

* https://dev.eclipse.org/mailman/listinfo/sumo-dev
