MODULE dr_hook_watch_mod

USE PARKIND1  ,ONLY : JPIM, JPIB, JPRM, JPRB

!-- Watch point creation interface for Dr.Hook
IMPLICIT NONE
SAVE
PRIVATE

INTERFACE DR_HOOK_WATCH
MODULE PROCEDURE &
  DR_HOOK_WATCH_CHARACTER, &
  DR_HOOK_WATCH_LOGICAL_SCALAR, &
  DR_HOOK_WATCH_LOGICAL_1D, &
  DR_HOOK_WATCH_LOGICAL_2D, &
  DR_HOOK_WATCH_I4_SCALAR, &
  DR_HOOK_WATCH_I4_1D, &
  DR_HOOK_WATCH_I4_2D, &
  DR_HOOK_WATCH_I8_SCALAR, &
  DR_HOOK_WATCH_I8_1D, &
  DR_HOOK_WATCH_I8_2D, &
  DR_HOOK_WATCH_R4_SCALAR, &
  DR_HOOK_WATCH_R4_1D, &
  DR_HOOK_WATCH_R4_2D, &
  DR_HOOK_WATCH_R8_SCALAR, &
  DR_HOOK_WATCH_R8_1D, &
  DR_HOOK_WATCH_R8_2D
END INTERFACE 

PUBLIC :: DR_HOOK_WATCH

CONTAINS

SUBROUTINE DR_HOOK_WATCH_CHARACTER(CDNAME, PTR, &
          &                        LDABORT, LDACTIVE)
INTEGER(KIND=JPIM), PARAMETER :: JP_BYTES_PER_ELEM = 1
CHARACTER(LEN=*), INTENT(IN) :: CDNAME
CHARACTER(LEN=*), INTENT(IN) :: PTR
LOGICAL, INTENT(IN), OPTIONAL :: LDABORT, LDACTIVE
LOGICAL :: LLABORT, LLACTIVE
INTEGER(KIND=JPIM) :: IBYTES, IABORT, IACTIVE
IBYTES = LEN(PTR) * JP_BYTES_PER_ELEM
IF (IBYTES <= 0) RETURN
IABORT = 0
LLABORT = .TRUE.
IF (PRESENT(LDABORT)) LLABORT = LDABORT
IF (LLABORT) IABORT = 1
IACTIVE = 0
LLACTIVE = .TRUE.
IF (PRESENT(LDACTIVE)) LLACTIVE = LDACTIVE
IF (LLACTIVE) IACTIVE = 1
CALL C_DRHOOK_WATCH(IACTIVE, CDNAME, PTR(1:1), IBYTES, IABORT)
END SUBROUTINE DR_HOOK_WATCH_CHARACTER

SUBROUTINE DR_HOOK_WATCH_LOGICAL_SCALAR(CDNAME, PTR, &
          &                             LDABORT, LDACTIVE)
INTEGER(KIND=JPIM), PARAMETER :: JP_BYTES_PER_ELEM = 4
CHARACTER(LEN=*), INTENT(IN) :: CDNAME
LOGICAL, INTENT(IN) :: PTR
LOGICAL, INTENT(IN), OPTIONAL :: LDABORT, LDACTIVE
LOGICAL :: LLABORT, LLACTIVE
INTEGER(KIND=JPIM) :: IBYTES, IABORT, IACTIVE
IBYTES = JP_BYTES_PER_ELEM
IABORT = 0
LLABORT = .TRUE.
IF (PRESENT(LDABORT)) LLABORT = LDABORT
IF (LLABORT) IABORT = 1
IACTIVE = 0
LLACTIVE = .TRUE.
IF (PRESENT(LDACTIVE)) LLACTIVE = LDACTIVE
IF (LLACTIVE) IACTIVE = 1
CALL C_DRHOOK_WATCH(IACTIVE, CDNAME, PTR, IBYTES, IABORT)
END SUBROUTINE DR_HOOK_WATCH_LOGICAL_SCALAR

SUBROUTINE DR_HOOK_WATCH_LOGICAL_1D(CDNAME, PTR, &
          &                         LDABORT, LDACTIVE)
INTEGER(KIND=JPIM), PARAMETER :: JP_BYTES_PER_ELEM = 4
CHARACTER(LEN=*), INTENT(IN) :: CDNAME
LOGICAL, INTENT(IN) :: PTR(:)
LOGICAL, INTENT(IN), OPTIONAL :: LDABORT, LDACTIVE
LOGICAL :: LLABORT, LLACTIVE
INTEGER(KIND=JPIM) :: IBYTES, IABORT, IACTIVE
IBYTES = SIZE(PTR) * JP_BYTES_PER_ELEM
IF (IBYTES <= 0) RETURN
IABORT = 0
LLABORT = .TRUE.
IF (PRESENT(LDABORT)) LLABORT = LDABORT
IF (LLABORT) IABORT = 1
IACTIVE = 0
LLACTIVE = .TRUE.
IF (PRESENT(LDACTIVE)) LLACTIVE = LDACTIVE
IF (LLACTIVE) IACTIVE = 1
CALL C_DRHOOK_WATCH(IACTIVE, CDNAME, PTR(1), IBYTES, IABORT)
END SUBROUTINE DR_HOOK_WATCH_LOGICAL_1D

SUBROUTINE DR_HOOK_WATCH_LOGICAL_2D(CDNAME, PTR, &
          &                         LDABORT, LDACTIVE)
INTEGER(KIND=JPIM), PARAMETER :: JP_BYTES_PER_ELEM = 4
CHARACTER(LEN=*), INTENT(IN) :: CDNAME
LOGICAL, INTENT(IN) :: PTR(:,:)
LOGICAL, INTENT(IN), OPTIONAL :: LDABORT, LDACTIVE
LOGICAL :: LLABORT, LLACTIVE
INTEGER(KIND=JPIM) :: IBYTES, IABORT, IACTIVE
IBYTES = SIZE(PTR) * JP_BYTES_PER_ELEM
IF (IBYTES <= 0) RETURN
IABORT = 0
LLABORT = .TRUE.
IF (PRESENT(LDABORT)) LLABORT = LDABORT
IF (LLABORT) IABORT = 1
IACTIVE = 0
LLACTIVE = .TRUE.
IF (PRESENT(LDACTIVE)) LLACTIVE = LDACTIVE
IF (LLACTIVE) IACTIVE = 1
CALL C_DRHOOK_WATCH(IACTIVE, CDNAME, PTR(1,1), IBYTES, IABORT)
END SUBROUTINE DR_HOOK_WATCH_LOGICAL_2D

SUBROUTINE DR_HOOK_WATCH_I4_SCALAR(CDNAME, PTR, &
          &                        LDABORT, LDACTIVE)
INTEGER(KIND=JPIM), PARAMETER :: JP_BYTES_PER_ELEM = 4
CHARACTER(LEN=*), INTENT(IN) :: CDNAME
INTEGER(KIND=JPIM), INTENT(IN) :: PTR
LOGICAL, INTENT(IN), OPTIONAL :: LDABORT, LDACTIVE
LOGICAL :: LLABORT, LLACTIVE
INTEGER(KIND=JPIM) :: IBYTES, IABORT, IACTIVE
IBYTES = JP_BYTES_PER_ELEM
IABORT = 0
LLABORT = .TRUE.
IF (PRESENT(LDABORT)) LLABORT = LDABORT
IF (LLABORT) IABORT = 1
IACTIVE = 0
LLACTIVE = .TRUE.
IF (PRESENT(LDACTIVE)) LLACTIVE = LDACTIVE
IF (LLACTIVE) IACTIVE = 1
CALL C_DRHOOK_WATCH(IACTIVE, CDNAME, PTR, IBYTES, IABORT)
END SUBROUTINE DR_HOOK_WATCH_I4_SCALAR

SUBROUTINE DR_HOOK_WATCH_I4_1D(CDNAME, PTR, &
          &                    LDABORT, LDACTIVE)
INTEGER(KIND=JPIM), PARAMETER :: JP_BYTES_PER_ELEM = 4
CHARACTER(LEN=*), INTENT(IN) :: CDNAME
INTEGER(KIND=JPIM), INTENT(IN) :: PTR(:)
LOGICAL, INTENT(IN), OPTIONAL :: LDABORT, LDACTIVE
LOGICAL :: LLABORT, LLACTIVE
INTEGER(KIND=JPIM) :: IBYTES, IABORT, IACTIVE
IBYTES = SIZE(PTR) * JP_BYTES_PER_ELEM
IF (IBYTES <= 0) RETURN
IABORT = 0
LLABORT = .TRUE.
IF (PRESENT(LDABORT)) LLABORT = LDABORT
IF (LLABORT) IABORT = 1
IACTIVE = 0
LLACTIVE = .TRUE.
IF (PRESENT(LDACTIVE)) LLACTIVE = LDACTIVE
IF (LLACTIVE) IACTIVE = 1
CALL C_DRHOOK_WATCH(IACTIVE, CDNAME, PTR(1), IBYTES, IABORT)
END SUBROUTINE DR_HOOK_WATCH_I4_1D

SUBROUTINE DR_HOOK_WATCH_I4_2D(CDNAME, PTR, &
          &                    LDABORT, LDACTIVE)
INTEGER(KIND=JPIM), PARAMETER :: JP_BYTES_PER_ELEM = 4
CHARACTER(LEN=*), INTENT(IN) :: CDNAME
INTEGER(KIND=JPIM), INTENT(IN) :: PTR(:,:)
LOGICAL, INTENT(IN), OPTIONAL :: LDABORT, LDACTIVE
LOGICAL :: LLABORT, LLACTIVE
INTEGER(KIND=JPIM) :: IBYTES, IABORT, IACTIVE
IBYTES = SIZE(PTR) * JP_BYTES_PER_ELEM
IF (IBYTES <= 0) RETURN
IABORT = 0
LLABORT = .TRUE.
IF (PRESENT(LDABORT)) LLABORT = LDABORT
IF (LLABORT) IABORT = 1
IACTIVE = 0
LLACTIVE = .TRUE.
IF (PRESENT(LDACTIVE)) LLACTIVE = LDACTIVE
IF (LLACTIVE) IACTIVE = 1
CALL C_DRHOOK_WATCH(IACTIVE, CDNAME, PTR(1,1), IBYTES, IABORT)
END SUBROUTINE DR_HOOK_WATCH_I4_2D

SUBROUTINE DR_HOOK_WATCH_I8_SCALAR(CDNAME, PTR, &
          &                        LDABORT, LDACTIVE)
INTEGER(KIND=JPIM), PARAMETER :: JP_BYTES_PER_ELEM = 8
CHARACTER(LEN=*), INTENT(IN) :: CDNAME
INTEGER(KIND=JPIB), INTENT(IN) :: PTR
LOGICAL, INTENT(IN), OPTIONAL :: LDABORT, LDACTIVE
LOGICAL :: LLABORT, LLACTIVE
INTEGER(KIND=JPIM) :: IBYTES, IABORT, IACTIVE
IBYTES = JP_BYTES_PER_ELEM
IABORT = 0
LLABORT = .TRUE.
IF (PRESENT(LDABORT)) LLABORT = LDABORT
IF (LLABORT) IABORT = 1
IACTIVE = 0
LLACTIVE = .TRUE.
IF (PRESENT(LDACTIVE)) LLACTIVE = LDACTIVE
IF (LLACTIVE) IACTIVE = 1
CALL C_DRHOOK_WATCH(IACTIVE, CDNAME, PTR, IBYTES, IABORT)
END SUBROUTINE DR_HOOK_WATCH_I8_SCALAR

SUBROUTINE DR_HOOK_WATCH_I8_1D(CDNAME, PTR, &
          &                    LDABORT, LDACTIVE)
INTEGER(KIND=JPIM), PARAMETER :: JP_BYTES_PER_ELEM = 8
CHARACTER(LEN=*), INTENT(IN) :: CDNAME
INTEGER(KIND=JPIB), INTENT(IN) :: PTR(:)
LOGICAL, INTENT(IN), OPTIONAL :: LDABORT, LDACTIVE
LOGICAL :: LLABORT, LLACTIVE
INTEGER(KIND=JPIM) :: IBYTES, IABORT, IACTIVE
IBYTES = SIZE(PTR) * JP_BYTES_PER_ELEM
IF (IBYTES <= 0) RETURN
IABORT = 0
LLABORT = .TRUE.
IF (PRESENT(LDABORT)) LLABORT = LDABORT
IF (LLABORT) IABORT = 1
IACTIVE = 0
LLACTIVE = .TRUE.
IF (PRESENT(LDACTIVE)) LLACTIVE = LDACTIVE
IF (LLACTIVE) IACTIVE = 1
CALL C_DRHOOK_WATCH(IACTIVE, CDNAME, PTR(1), IBYTES, IABORT)
END SUBROUTINE DR_HOOK_WATCH_I8_1D

SUBROUTINE DR_HOOK_WATCH_I8_2D(CDNAME, PTR, &
          &                    LDABORT, LDACTIVE)
INTEGER(KIND=JPIM), PARAMETER :: JP_BYTES_PER_ELEM = 8
CHARACTER(LEN=*), INTENT(IN) :: CDNAME
INTEGER(KIND=JPIB), INTENT(IN) :: PTR(:,:)
LOGICAL, INTENT(IN), OPTIONAL :: LDABORT, LDACTIVE
LOGICAL :: LLABORT, LLACTIVE
INTEGER(KIND=JPIM) :: IBYTES, IABORT, IACTIVE
IBYTES = SIZE(PTR) * JP_BYTES_PER_ELEM
IF (IBYTES <= 0) RETURN
IABORT = 0
LLABORT = .TRUE.
IF (PRESENT(LDABORT)) LLABORT = LDABORT
IF (LLABORT) IABORT = 1
IACTIVE = 0
LLACTIVE = .TRUE.
IF (PRESENT(LDACTIVE)) LLACTIVE = LDACTIVE
IF (LLACTIVE) IACTIVE = 1
CALL C_DRHOOK_WATCH(IACTIVE, CDNAME, PTR(1,1), IBYTES, IABORT)
END SUBROUTINE DR_HOOK_WATCH_I8_2D

SUBROUTINE DR_HOOK_WATCH_R4_SCALAR(CDNAME, PTR, &
          &                        LDABORT, LDACTIVE)
INTEGER(KIND=JPIM), PARAMETER :: JP_BYTES_PER_ELEM = 4
CHARACTER(LEN=*), INTENT(IN) :: CDNAME
REAL(KIND=JPRM), INTENT(IN) :: PTR
LOGICAL, INTENT(IN), OPTIONAL :: LDABORT, LDACTIVE
LOGICAL :: LLABORT, LLACTIVE
INTEGER(KIND=JPIM) :: IBYTES, IABORT, IACTIVE
IBYTES = JP_BYTES_PER_ELEM
IABORT = 0
LLABORT = .TRUE.
IF (PRESENT(LDABORT)) LLABORT = LDABORT
IF (LLABORT) IABORT = 1
IACTIVE = 0
LLACTIVE = .TRUE.
IF (PRESENT(LDACTIVE)) LLACTIVE = LDACTIVE
IF (LLACTIVE) IACTIVE = 1
CALL C_DRHOOK_WATCH(IACTIVE, CDNAME, PTR, IBYTES, IABORT)
END SUBROUTINE DR_HOOK_WATCH_R4_SCALAR

SUBROUTINE DR_HOOK_WATCH_R4_1D(CDNAME, PTR, &
          &                    LDABORT, LDACTIVE)
INTEGER(KIND=JPIM), PARAMETER :: JP_BYTES_PER_ELEM = 4
CHARACTER(LEN=*), INTENT(IN) :: CDNAME
REAL(KIND=JPRM), INTENT(IN) :: PTR(:)
LOGICAL, INTENT(IN), OPTIONAL :: LDABORT, LDACTIVE
LOGICAL :: LLABORT, LLACTIVE
INTEGER(KIND=JPIM) :: IBYTES, IABORT, IACTIVE
IBYTES = SIZE(PTR) * JP_BYTES_PER_ELEM
IF (IBYTES <= 0) RETURN
IABORT = 0
LLABORT = .TRUE.
IF (PRESENT(LDABORT)) LLABORT = LDABORT
IF (LLABORT) IABORT = 1
IACTIVE = 0
LLACTIVE = .TRUE.
IF (PRESENT(LDACTIVE)) LLACTIVE = LDACTIVE
IF (LLACTIVE) IACTIVE = 1
CALL C_DRHOOK_WATCH(IACTIVE, CDNAME, PTR(1), IBYTES, IABORT)
END SUBROUTINE DR_HOOK_WATCH_R4_1D

SUBROUTINE DR_HOOK_WATCH_R4_2D(CDNAME, PTR, &
          &                    LDABORT, LDACTIVE)
INTEGER(KIND=JPIM), PARAMETER :: JP_BYTES_PER_ELEM = 4
CHARACTER(LEN=*), INTENT(IN) :: CDNAME
REAL(KIND=JPRM), INTENT(IN) :: PTR(:,:)
LOGICAL, INTENT(IN), OPTIONAL :: LDABORT, LDACTIVE
LOGICAL :: LLABORT, LLACTIVE
INTEGER(KIND=JPIM) :: IBYTES, IABORT, IACTIVE
IBYTES = SIZE(PTR) * JP_BYTES_PER_ELEM
IF (IBYTES <= 0) RETURN
IABORT = 0
LLABORT = .TRUE.
IF (PRESENT(LDABORT)) LLABORT = LDABORT
IF (LLABORT) IABORT = 1
IACTIVE = 0
LLACTIVE = .TRUE.
IF (PRESENT(LDACTIVE)) LLACTIVE = LDACTIVE
IF (LLACTIVE) IACTIVE = 1
CALL C_DRHOOK_WATCH(IACTIVE, CDNAME, PTR(1,1), IBYTES, IABORT)
END SUBROUTINE DR_HOOK_WATCH_R4_2D

SUBROUTINE DR_HOOK_WATCH_R8_SCALAR(CDNAME, PTR, &
          &                        LDABORT, LDACTIVE)
INTEGER(KIND=JPIM), PARAMETER :: JP_BYTES_PER_ELEM = 8
CHARACTER(LEN=*), INTENT(IN) :: CDNAME
REAL(KIND=JPRB), INTENT(IN) :: PTR
LOGICAL, INTENT(IN), OPTIONAL :: LDABORT, LDACTIVE
LOGICAL :: LLABORT, LLACTIVE
INTEGER(KIND=JPIM) :: IBYTES, IABORT, IACTIVE
IBYTES = JP_BYTES_PER_ELEM
IABORT = 0
LLABORT = .TRUE.
IF (PRESENT(LDABORT)) LLABORT = LDABORT
IF (LLABORT) IABORT = 1
IACTIVE = 0
LLACTIVE = .TRUE.
IF (PRESENT(LDACTIVE)) LLACTIVE = LDACTIVE
IF (LLACTIVE) IACTIVE = 1
CALL C_DRHOOK_WATCH(IACTIVE, CDNAME, PTR, IBYTES, IABORT)
END SUBROUTINE DR_HOOK_WATCH_R8_SCALAR

SUBROUTINE DR_HOOK_WATCH_R8_1D(CDNAME, PTR, &
          &                    LDABORT, LDACTIVE)
INTEGER(KIND=JPIM), PARAMETER :: JP_BYTES_PER_ELEM = 8
CHARACTER(LEN=*), INTENT(IN) :: CDNAME
REAL(KIND=JPRB), INTENT(IN) :: PTR(:)
LOGICAL, INTENT(IN), OPTIONAL :: LDABORT, LDACTIVE
LOGICAL :: LLABORT, LLACTIVE
INTEGER(KIND=JPIM) :: IBYTES, IABORT, IACTIVE
IBYTES = SIZE(PTR) * JP_BYTES_PER_ELEM
IF (IBYTES <= 0) RETURN
IABORT = 0
LLABORT = .TRUE.
IF (PRESENT(LDABORT)) LLABORT = LDABORT
IF (LLABORT) IABORT = 1
IACTIVE = 0
LLACTIVE = .TRUE.
IF (PRESENT(LDACTIVE)) LLACTIVE = LDACTIVE
IF (LLACTIVE) IACTIVE = 1
CALL C_DRHOOK_WATCH(IACTIVE, CDNAME, PTR(1), IBYTES, IABORT)
END SUBROUTINE DR_HOOK_WATCH_R8_1D

SUBROUTINE DR_HOOK_WATCH_R8_2D(CDNAME, PTR, &
          &                    LDABORT, LDACTIVE)
INTEGER(KIND=JPIM), PARAMETER :: JP_BYTES_PER_ELEM = 8
CHARACTER(LEN=*), INTENT(IN) :: CDNAME
REAL(KIND=JPRB), INTENT(IN) :: PTR(:,:)
LOGICAL, INTENT(IN), OPTIONAL :: LDABORT, LDACTIVE
LOGICAL :: LLABORT, LLACTIVE
INTEGER(KIND=JPIM) :: IBYTES, IABORT, IACTIVE
IBYTES = SIZE(PTR) * JP_BYTES_PER_ELEM
IF (IBYTES <= 0) RETURN
IABORT = 0
LLABORT = .TRUE.
IF (PRESENT(LDABORT)) LLABORT = LDABORT
IF (LLABORT) IABORT = 1
IACTIVE = 0
LLACTIVE = .TRUE.
IF (PRESENT(LDACTIVE)) LLACTIVE = LDACTIVE
IF (LLACTIVE) IACTIVE = 1
CALL C_DRHOOK_WATCH(IACTIVE, CDNAME, PTR(1,1), IBYTES, IABORT)
END SUBROUTINE DR_HOOK_WATCH_R8_2D

END MODULE dr_hook_watch_mod
