/***********************************************************************************

    Copyright (C) 2007-2018 Ahmet Öztürk (aoz_2@yahoo.com)

    This file is part of Lifeograph.

    Lifeograph is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Lifeograph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <gtkmm/application.h>

#include "lifeograph.hpp"


int
main( int argc, char* argv[] )
{
    LIFEO::Lifeograph::init_paths();

    // LIBGETTEXT REQUIREMENTS
    setlocale( LC_ALL, "" );
    bindtextdomain( PACKAGE, LIFEO::Lifeograph::LOCALEDIR.c_str() );
    textdomain( PACKAGE );

    // APPLICATION
    Glib::RefPtr< LIFEO::Lifeograph > app = LIFEO::Lifeograph::create();

    return app->run( argc, argv );
}
