// -*- C++ -*-
// --------------------------------------------------------------------
// MainWindow
// --------------------------------------------------------------------
/*

    This file is part of the extensible drawing editor Ipe.
    Copyright (c) 1993-2019 Otfried Cheong

    Ipe is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    As a special exception, you have permission to link Ipe with the
    CGAL library and distribute executables, as long as you follow the
    requirements of the Gnu General Public License in regard to all of
    the software in the executable aside from CGAL.

    Ipe is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
    or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
    License for more details.

    You should have received a copy of the GNU General Public License
    along with Ipe; if not, you can find it at
    "http://www.gnu.org/copyleft/gpl.html", or write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include "ipecanvas_qt.h"
#include "ipeselector_qt.h"

#include "canvasview_qt.h"
#include "ui_mainwindow.h"

#include <QMainWindow>
#include <QAction>
#include <QTimer>
#include <QTime>

using namespace ipe;

// --------------------------------------------------------------------

class MainWindow: public QMainWindow, Ui::MainWindow
{
  Q_OBJECT

public:
  enum TAction {
    EOpen, EQuit, EFullScreen, EFitPage,
    EZoomIn, EZoomOut, ENextView, EPreviousView, EFirstView, ELastView,
    ENextPage, EPreviousPage,
    ENumActions, EToggleTimeCounting, ETimeCountdown, ESetTime,
    EJumpTo, EShowPresentation
  };

public:
  MainWindow(CanvasView* cv, Qt::WindowFlags f=0);

  void nextView(int delta);
  void nextPage(int delta);
  void firstView();
  void lastView();
  void fitBox(const Rect &box, Canvas* canvas);
  void updateLabel();
  bool load(const char* fn);

public slots:
  void cmd(int cmd);
  std::pair<int,int> nextPageView(int delta);
  void setNextViewCanvas();
  void closeEvent(QCloseEvent *event);

protected:
  void resizeEvent (QResizeEvent *event);

private:
  void setView();

private:
  Document *iDoc;
  Snap iSnap;

  QMenu* iViewMenu;
  QMenu* iMoveMenu;
  IpeAction* iTimeCountdown;

  String iFileName;
  int iPageNo;
  int iViewNo;

  CanvasView* canvas_view;

private slots:
  void splitterMoved(int pos, int index);
};

// --------------------------------------------------------------------
#endif
