#pragma once
#include "utils/global.h"
#include "utils/FsTab.h"
#include "utils/data-collection/EventData.h"
#include <QString>
#include <QSharedPointer>
#include <QObject>

class UserDataRecovery : public QObject
{
    Q_OBJECT
public:
    explicit UserDataRecovery();
    ~UserDataRecovery() override;

    virtual bool supported(FSTabInfoList &fsTabInfoList) = 0;
    //备份用户数据
    virtual ErrorCode userDataBackup(UserDataBackupRequest &request) = 0;
    //还原用户数据
    virtual ErrorCode userDataRestore(UserDataRestoreRequest &request) = 0;

    // 通过 dry-run 方式获取实际备份需要的空间，结果通过spaceChanged信号上报
    virtual ErrorCode checkUserDataBackupSpace(UserDataBackupRequest &request) = 0;

    virtual BackupInfoList listUserDataBackup(const QString &username) = 0;

    virtual ErrorCode removeUserDataBackup(RemoveUserDataBackupRequest &request) = 0;

    // 上报数据埋点信息
    virtual void reportEventLog(const ResultInfo &resultInfo, OperateType opType, RecoveryType recoveryType);
Q_SIGNALS:
    void progressChanged(const QString &progress);
    void spaceChanged(const QString &space);  // 上报备份需要的实际空间
    void error(const QString &errMsg);
    void success(const QString &msg);

protected:
    QString m_defaultBackupDeviceUUID;
};




typedef QSharedPointer<UserDataRecovery> UserDataRecoveryPtr;