#include "BtrfsUserData.h"
#include "utils/Device.h"
#include "utils/Utils.h"
#include <QDir>
#include <QFile>
#include <QDebug>
#include <QUuid>
#include <QException>


static const QString USER_DATA_BACKUP_PATH = "/backup/userdata/snapshots/";
static const QString BACKUP_INFO_JSON = "/backup_info.json";

BtrfsUserData::BtrfsUserData()
{

}

BtrfsUserData::~BtrfsUserData()
{

}

bool BtrfsUserData::supported(FSTabInfoList &fsTabInfoList)
{
    bool support = false;
    // TODO
    return support;
}

ErrorCode BtrfsUserData::parseUserDataBackupReq(const UserDataBackupRequest &request)
{
    if (request.rootUUID.isEmpty()) {
        qCritical() << Q_FUNC_INFO << "error: rootUUID isEmpty";
        return ErrorCode::RootUuidIsEmpty;
    }

    if (request.destUUID.isEmpty()) {
        qCritical() << Q_FUNC_INFO << "error: destUUID isEmpty";
        return ErrorCode::DestUuidIsEmpty;
    }

    m_request = request;
    m_backupInfo.username = request.username;
    m_backupInfo.operateID = QUuid::createUuid().toString();
    m_backupInfo.startTime = QDateTime::currentSecsSinceEpoch();
    m_backupInfo.remark = request.remark;
    m_backupInfo.operateType = UserDataBackup;
    m_backupInfo.recoveryType = Rsync;
    m_backupInfo.rootUUID = request.rootUUID;
    m_backupInfo.backupDevUUID = request.destUUID;
    m_backupInfo.size = 0;

    // TODO: 细节待实现

    return OK;
}

ErrorCode BtrfsUserData::checkUserDataBackupSpace(UserDataBackupRequest &request)
{
    ErrorCode errCode = this->parseUserDataBackupReq(request);
    if (errCode != OK) {
        return errCode;
    }

    // TODO: 待实现
    return OK;
}

ErrorCode BtrfsUserData::userDataBackup(UserDataBackupRequest &request)
{
    // TODO: 待实现
    return UnKnow;
}

ErrorCode BtrfsUserData::userDataRestore(UserDataRestoreRequest &request)
{
    // TODO: 待实现
    return UnKnow;

}

BackupInfoList BtrfsUserData::listUserDataBackup(const QString &username)
{
    BackupInfoList backupList;
    // TODO: 待实现

    return backupList;
}

void BtrfsUserData::writeBackupInfo()
{
    // TODO: 待实现
}

ErrorCode BtrfsUserData::fillBackupInfo()
{
    m_backupInfo.username = m_request.username;
    m_backupInfo.operateID = QUuid::createUuid().toString();
    m_backupInfo.startTime = QDateTime::currentSecsSinceEpoch();
    m_backupInfo.remark = m_request.remark;
    m_backupInfo.operateType = UserDataBackup;
    m_backupInfo.recoveryType = BtrfsSnapshot;
    m_backupInfo.rootUUID = m_request.rootUUID;
    m_backupInfo.backupDevUUID = m_request.destUUID;
    m_backupInfo.size = 0;

    // TODO: 细节待实现
    return OK;
}

ErrorCode BtrfsUserData::removeUserDataBackup(RemoveUserDataBackupRequest &request)
{
    // TODO: 待实现
    return UnKnow;
}
