#pragma once

#include <QString>

class ModuleInterface;
class QWidget;
class QString;
class FrameProxyInterface
{
public:
    virtual ~FrameProxyInterface(){};
    // Module request to into next page
    // 推窗口进显示栈
    virtual void pushWidget(ModuleInterface *const inter, QWidget *const w) = 0;
    // 将窗口出显示栈
    virtual void popWidget() = 0;

    virtual void popAllWidget() = 0;

    virtual void popWidgetAndDelete() = 0;
    //显示上一步界面
    virtual void back() = 0;

    // 回退到主页
    virtual void backHome() = 0;

    virtual void enableBackWard(bool enable) = 0;

    virtual void enableModule(bool enable) = 0;

    // 设置模块可见
    virtual void setModuleVisible(ModuleInterface *const inter, const bool visible) = 0;
    // 设置当前显示窗口
    virtual void setCurrentWidget(ModuleInterface *const inter, QWidget *const w) = 0;
    // 获取当前显示栈的索引
    virtual ModuleInterface *getCurrentModule() = 0;

    virtual void setMenuDisabled(bool disabled) = 0;

    // disabled: true 置灰“退出”菜单;
    virtual void setQuitMenuDisabled(bool disabled) = 0;

    // enabled: false 置灰菜单项是actionText的;
    virtual void setMenuActionEnabled(const QString &actionText, bool enabled) = 0;

    // enabled: false 置灰主窗口的 X 关闭按钮;
    virtual void setWindowFuncClose(bool enabled) = 0;

    virtual void showSettingDialog() = 0;

    virtual void showLogDialog() = 0;

    virtual void showBackupFileManagerDialog() = 0;

    virtual QString rootUUID() { return m_rootUUID; }

    virtual QString destUUID() { return m_destUUID; }
protected:
    QString m_rootUUID;
    QString m_destUUID;
};
