#include "audioaiassistantmainwindowproxy.h"
#include "audioaiassistantsetting.h"
#include "audioaiassistant.h"
#include "serverwrapper.h"
#include <QLoggingCategory>

UOSAI_USE_NAMESPACE

Q_DECLARE_LOGGING_CATEGORY(logAudioWizard)

AudioAiassistantMainWindowProxy::AudioAiassistantMainWindowProxy(AudioAiassistant *parent)
    : QObject(parent)
    , q(parent)
{
    connect(q,&AudioAiassistant::onNotify,this,&AudioAiassistantMainWindowProxy::onNotify,Qt::DirectConnection);
}

AudioAiassistantMainWindowProxy::~AudioAiassistantMainWindowProxy()
{

}

void AudioAiassistantMainWindowProxy::SpeechToText()
{
    qCDebug(logAudioWizard) << "Initiating speech-to-text conversion";
    q->speechToText();
}

void AudioAiassistantMainWindowProxy::TextToSpeech()
{
    qCDebug(logAudioWizard) << "Initiating text-to-speech conversion";
    q->textToSpeech();
}

//转写
QString AudioAiassistantMainWindowProxy::startAsr(const QVariantMap &param)
{
    qCDebug(logAudioWizard) << "Starting ASR with parameters:" << param.keys();
    return q->startAsr(param);
}

void AudioAiassistantMainWindowProxy::stopAsr()
{
    qCDebug(logAudioWizard) << "Stopping ASR";
    q->stopAsr();
}

void AudioAiassistantMainWindowProxy::TextToTranslate()
{
    //随航翻译快捷键
    qCDebug(logAudioWizard) << "Initiating text translation";
    emit ServerWrapper::instance()->sigToTranslate();
}

