#include "treelandeventmonitor.h"

#include <QDebug>

UOSAI_USE_NAMESPACE

TreelandEventMonitor::TreelandEventMonitor(QObject *parent) : BaseMonitor(parent)
{
    m_manager.reset(new TreelandDDEShellManageV1);
    QObject::connect(m_manager.get(), &TreelandDDEShellManageV1::activeChanged, this, [this](){
        if (m_manager->isActive()) {
            auto waylandApp = qGuiApp->nativeInterface<QNativeInterface::QWaylandApplication>();
            if (!waylandApp) {
                return;
            }
            auto seat = waylandApp->seat();

            if (!seat)
                qFatal("Failed to get wl_seat from QtWayland QPA!");

            m_active.reset(new TreelandDDEActiveV1(m_manager->get_treeland_dde_active(seat)));
        }
    });

    m_manager->instantiate();

    QObject::connect(m_active.get(), &TreelandDDEActiveV1::mousePress, this, [this](){
        Q_EMIT mousePress(-1, -1);
    });

    QObject::connect(m_active.get(), &TreelandDDEActiveV1::mouseRelease, this, [this](){
        Q_EMIT mouseRelease(-1, -1);
    });
}

