/*
 * Copyright (C) 2023 ~ 2023 Deepin Technology Co., Ltd.
 *
 * Author:     zhangyu <zhangyud@uniontech.com>
 *
 * Maintainer: zhangyu <zhangyud@uniontech.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#include <QApplication>
#include <QDBusConnection>
#include <QDBusInterface>
#include <QDBusReply>
#include <QThread>
#include <iostream>
#include <string>

#include "deepinwatermarkdbus.h"
#include "watermarkadaptor.h"

using namespace std;

#define Service "com.deepin.watermark"
#define Path "/com/deepin/watermark"
#define Interface "com.deepin.watermark"

int main(int argc, char *argv[])
{
    if (qgetenv("DISPLAY").isEmpty()) {
        QThread::msleep(1000);
        return -1;
    }

    QApplication app(argc, argv);
    DeepinWatermarkDbus watermarkdbus;

    WatermarkAdaptor adapter(&watermarkdbus);
    Q_UNUSED(adapter);

    if (!QDBusConnection::sessionBus().registerService(Service)) {
        return -1;
    }

    if (!QDBusConnection::sessionBus().registerObject(Path, Interface,
                                                      &watermarkdbus)) {
        return -2;
    }
    return app.exec();
}
