#include "dvsrv.h"

#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <errno.h>
#include <fcntl.h>

#define  PID_LEN   (20)
#define  LOCK_FILE  "/tmp/dvid"

// 返回值
// -1: 出错
//  1: 运行
//  0: 未运行
int check_is_running() {
    char pid[PID_LEN] = {0};

    int fd = open(LOCK_FILE, O_WRONLY|O_CREAT, 644);
    if(fd < 0) return -1;

    if(flock(fd, LOCK_EX|LOCK_NB) == -1) {
        close(fd);
        return 1;
    }

    snprintf(pid, sizeof(pid)-1, "%ld\n", (long)getpid());

    write(fd, pid, strlen(pid));
    return 0;
}

int main (int argc, char *argv[]) {
    int status = check_is_running();

    if (!status)
        status = srv_loop();

    return status;
}
