# 系统登录认证接口

## 系统登录接口

系统在Session DBus上提供统一登录接口，应用程序调用登录接口完成unionid用户的OAuth2登录流程。

### 应用注册接口

```c++
void Register(QString clientID, QString service, QString path, QString interface);
```

| 参数 | 说明 |
| ---- | ---- |
| clientID | 申请的unionid应用ID |
| service | 本地应用的dbus服务的servicename |
| path | 本地应用的dbus服务的path |
| interface | 本地应用的dbus服务的interface |

程序在启动或者调用Authorize接口前，需要向系统注册应用的dbus信息。
在异步完成验证后，系统会调用应用的对应接口发送认证参数。

### 认证接口

```c++
void Authorize(QString clientID, QStringList scopes, QString redirectURI, QString state)
```

| 参数 | 说明 |
| ---- | ---- |
| clientID | 申请的unionid应用ID |
| scopes | 申请的权限，如`"base,user:read`或`["base","user:read"]`，留空表示使用应用默认权限 |
| redirectURI | 回调地址，用于验证 |
| state | state参数，请务必使用服务器来生成 |

## 应用接口

应用程序必须实现如下接口：

```c++
void OnAuthorized(code string, state string);
```

在认证成功时调用，应用程序获取code和state后去应用服务器验证，并交换token。

```c++
void OnCancel();
```

认证取消时调用，当用户放弃输入时会调用该接口。

## 登录流程

1 应用调用 com.deepin.deepinid.Client.Register 注册应用

2 调用com.deepin.deepinid.Client.Authorize接口进行认证

3 系统自动调用系统级别的登录界面，完成登录功能

4 系统登录后向应用签发OAuth需要的code和state，并通过应用的dbus接口发送给应用

5 应用程序收到code和state后，将code和state发送到应用服务器，在服务器端发起发起OAuth2的token流程

### 参考实现

Qt开发请参考unionid-app源码