# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=wrong-import-position

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from ._patch import *  # pylint: disable=unused-wildcard-import


from ._models_py3 import (  # type: ignore
    CheckNameAvailabilityResult,
    CustomDomain,
    Encryption,
    EncryptionService,
    EncryptionServices,
    Endpoints,
    Resource,
    Sku,
    StorageAccount,
    StorageAccountCheckNameAvailabilityParameters,
    StorageAccountCreateParameters,
    StorageAccountKey,
    StorageAccountListKeysResult,
    StorageAccountListResult,
    StorageAccountRegenerateKeyParameters,
    StorageAccountUpdateParameters,
    Usage,
    UsageListResult,
    UsageName,
)

from ._storage_management_client_enums import (  # type: ignore
    AccessTier,
    AccountStatus,
    EncryptionKeySource,
    KeyPermission,
    Kind,
    ProvisioningState,
    Reason,
    SkuName,
    SkuTier,
    StorageAccountCheckNameAvailabilityParametersType,
    UsageUnit,
)
from ._patch import __all__ as _patch_all
from ._patch import *
from ._patch import patch_sdk as _patch_sdk

__all__ = [
    "CheckNameAvailabilityResult",
    "CustomDomain",
    "Encryption",
    "EncryptionService",
    "EncryptionServices",
    "Endpoints",
    "Resource",
    "Sku",
    "StorageAccount",
    "StorageAccountCheckNameAvailabilityParameters",
    "StorageAccountCreateParameters",
    "StorageAccountKey",
    "StorageAccountListKeysResult",
    "StorageAccountListResult",
    "StorageAccountRegenerateKeyParameters",
    "StorageAccountUpdateParameters",
    "Usage",
    "UsageListResult",
    "UsageName",
    "AccessTier",
    "AccountStatus",
    "EncryptionKeySource",
    "KeyPermission",
    "Kind",
    "ProvisioningState",
    "Reason",
    "SkuName",
    "SkuTier",
    "StorageAccountCheckNameAvailabilityParametersType",
    "UsageUnit",
]
__all__.extend([p for p in _patch_all if p not in __all__])  # pyright: ignore
_patch_sdk()
