# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class BinaryHardeningFeatures(_serialization.Model):
    """Binary hardening features.

    :ivar nx: NX (no-execute) flag.
    :vartype nx: bool
    :ivar pie: PIE (position independent executable) flag.
    :vartype pie: bool
    :ivar relro: RELRO (relocation read-only) flag.
    :vartype relro: bool
    :ivar canary: Canary (stack canaries) flag.
    :vartype canary: bool
    :ivar stripped: Stripped flag.
    :vartype stripped: bool
    """

    _attribute_map = {
        "nx": {"key": "nx", "type": "bool"},
        "pie": {"key": "pie", "type": "bool"},
        "relro": {"key": "relro", "type": "bool"},
        "canary": {"key": "canary", "type": "bool"},
        "stripped": {"key": "stripped", "type": "bool"},
    }

    def __init__(
        self,
        *,
        nx: Optional[bool] = None,
        pie: Optional[bool] = None,
        relro: Optional[bool] = None,
        canary: Optional[bool] = None,
        stripped: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword nx: NX (no-execute) flag.
        :paramtype nx: bool
        :keyword pie: PIE (position independent executable) flag.
        :paramtype pie: bool
        :keyword relro: RELRO (relocation read-only) flag.
        :paramtype relro: bool
        :keyword canary: Canary (stack canaries) flag.
        :paramtype canary: bool
        :keyword stripped: Stripped flag.
        :paramtype stripped: bool
        """
        super().__init__(**kwargs)
        self.nx = nx
        self.pie = pie
        self.relro = relro
        self.canary = canary
        self.stripped = stripped


class BinaryHardeningListResult(_serialization.Model):
    """List of binary hardening results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of binary hardening results.
    :vartype value: list[~azure.mgmt.iotfirmwaredefense.models.BinaryHardeningResource]
    :ivar next_link: The uri to fetch the next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[BinaryHardeningResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword next_link: The uri to fetch the next page of resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.iotfirmwaredefense.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class BinaryHardeningResource(Resource):
    """binary hardening analysis result resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.iotfirmwaredefense.models.SystemData
    :ivar properties: The properties of a binary hardening result found within a firmware image.
    :vartype properties: ~azure.mgmt.iotfirmwaredefense.models.BinaryHardeningResult
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "BinaryHardeningResult"},
    }

    def __init__(self, *, properties: Optional["_models.BinaryHardeningResult"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: The properties of a binary hardening result found within a firmware image.
        :paramtype properties: ~azure.mgmt.iotfirmwaredefense.models.BinaryHardeningResult
        """
        super().__init__(**kwargs)
        self.properties = properties


class BinaryHardeningResult(_serialization.Model):
    """Binary hardening of a firmware.

    :ivar binary_hardening_id: ID for the binary hardening result.
    :vartype binary_hardening_id: str
    :ivar features: Binary hardening features.
    :vartype features: ~azure.mgmt.iotfirmwaredefense.models.BinaryHardeningFeatures
    :ivar architecture: The architecture of the uploaded firmware.
    :vartype architecture: str
    :ivar file_path: The executable path.
    :vartype file_path: str
    :ivar class_property: The executable class to indicate 32 or 64 bit.
    :vartype class_property: str
    :ivar runpath: The runpath of the uploaded firmware.
    :vartype runpath: str
    :ivar rpath: The rpath of the uploaded firmware.
    :vartype rpath: str
    """

    _attribute_map = {
        "binary_hardening_id": {"key": "binaryHardeningId", "type": "str"},
        "features": {"key": "features", "type": "BinaryHardeningFeatures"},
        "architecture": {"key": "architecture", "type": "str"},
        "file_path": {"key": "filePath", "type": "str"},
        "class_property": {"key": "class", "type": "str"},
        "runpath": {"key": "runpath", "type": "str"},
        "rpath": {"key": "rpath", "type": "str"},
    }

    def __init__(
        self,
        *,
        binary_hardening_id: Optional[str] = None,
        features: Optional["_models.BinaryHardeningFeatures"] = None,
        architecture: Optional[str] = None,
        file_path: Optional[str] = None,
        class_property: Optional[str] = None,
        runpath: Optional[str] = None,
        rpath: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword binary_hardening_id: ID for the binary hardening result.
        :paramtype binary_hardening_id: str
        :keyword features: Binary hardening features.
        :paramtype features: ~azure.mgmt.iotfirmwaredefense.models.BinaryHardeningFeatures
        :keyword architecture: The architecture of the uploaded firmware.
        :paramtype architecture: str
        :keyword file_path: The executable path.
        :paramtype file_path: str
        :keyword class_property: The executable class to indicate 32 or 64 bit.
        :paramtype class_property: str
        :keyword runpath: The runpath of the uploaded firmware.
        :paramtype runpath: str
        :keyword rpath: The rpath of the uploaded firmware.
        :paramtype rpath: str
        """
        super().__init__(**kwargs)
        self.binary_hardening_id = binary_hardening_id
        self.features = features
        self.architecture = architecture
        self.file_path = file_path
        self.class_property = class_property
        self.runpath = runpath
        self.rpath = rpath


class SummaryResourceProperties(_serialization.Model):
    """Properties of an analysis summary.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    BinaryHardeningSummaryResource, CveSummary, CryptoCertificateSummaryResource,
    CryptoKeySummaryResource, FirmwareSummary

    All required parameters must be populated in order to send to Azure.

    :ivar summary_type: Describes the type of summary. Required. Known values are: "Firmware",
     "CVE", "BinaryHardening", "CryptoCertificate", and "CryptoKey".
    :vartype summary_type: str or ~azure.mgmt.iotfirmwaredefense.models.SummaryType
    """

    _validation = {
        "summary_type": {"required": True},
    }

    _attribute_map = {
        "summary_type": {"key": "summaryType", "type": "str"},
    }

    _subtype_map = {
        "summary_type": {
            "BinaryHardening": "BinaryHardeningSummaryResource",
            "CVE": "CveSummary",
            "CryptoCertificate": "CryptoCertificateSummaryResource",
            "CryptoKey": "CryptoKeySummaryResource",
            "Firmware": "FirmwareSummary",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.summary_type: Optional[str] = None


class BinaryHardeningSummaryResource(SummaryResourceProperties):
    """Properties for a binary hardening analysis summary.

    All required parameters must be populated in order to send to Azure.

    :ivar summary_type: Describes the type of summary. Required. Known values are: "Firmware",
     "CVE", "BinaryHardening", "CryptoCertificate", and "CryptoKey".
    :vartype summary_type: str or ~azure.mgmt.iotfirmwaredefense.models.SummaryType
    :ivar total_files: Total number of binaries that were analyzed.
    :vartype total_files: int
    :ivar nx: NX summary percentage.
    :vartype nx: int
    :ivar pie: PIE summary percentage.
    :vartype pie: int
    :ivar relro: RELRO summary percentage.
    :vartype relro: int
    :ivar canary: Canary summary percentage.
    :vartype canary: int
    :ivar stripped: Stripped summary percentage.
    :vartype stripped: int
    """

    _validation = {
        "summary_type": {"required": True},
    }

    _attribute_map = {
        "summary_type": {"key": "summaryType", "type": "str"},
        "total_files": {"key": "totalFiles", "type": "int"},
        "nx": {"key": "nx", "type": "int"},
        "pie": {"key": "pie", "type": "int"},
        "relro": {"key": "relro", "type": "int"},
        "canary": {"key": "canary", "type": "int"},
        "stripped": {"key": "stripped", "type": "int"},
    }

    def __init__(
        self,
        *,
        total_files: Optional[int] = None,
        nx: Optional[int] = None,
        pie: Optional[int] = None,
        relro: Optional[int] = None,
        canary: Optional[int] = None,
        stripped: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword total_files: Total number of binaries that were analyzed.
        :paramtype total_files: int
        :keyword nx: NX summary percentage.
        :paramtype nx: int
        :keyword pie: PIE summary percentage.
        :paramtype pie: int
        :keyword relro: RELRO summary percentage.
        :paramtype relro: int
        :keyword canary: Canary summary percentage.
        :paramtype canary: int
        :keyword stripped: Stripped summary percentage.
        :paramtype stripped: int
        """
        super().__init__(**kwargs)
        self.summary_type: str = "BinaryHardening"
        self.total_files = total_files
        self.nx = nx
        self.pie = pie
        self.relro = relro
        self.canary = canary
        self.stripped = stripped


class CryptoCertificate(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Crypto certificate properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar crypto_cert_id: ID for the certificate result.
    :vartype crypto_cert_id: str
    :ivar name: Name of the certificate.
    :vartype name: str
    :ivar subject: Subject information of the certificate.
    :vartype subject: ~azure.mgmt.iotfirmwaredefense.models.CryptoCertificateEntity
    :ivar issuer: Issuer information of the certificate.
    :vartype issuer: ~azure.mgmt.iotfirmwaredefense.models.CryptoCertificateEntity
    :ivar issued_date: Issue date for the certificate.
    :vartype issued_date: ~datetime.datetime
    :ivar expiration_date: Expiration date for the certificate.
    :vartype expiration_date: ~datetime.datetime
    :ivar role: Role of the certificate (Root CA, etc).
    :vartype role: str
    :ivar signature_algorithm: The signature algorithm used in the certificate.
    :vartype signature_algorithm: str
    :ivar key_size: Size of the certificate's key in bits.
    :vartype key_size: int
    :ivar key_algorithm: Key algorithm used in the certificate.
    :vartype key_algorithm: str
    :ivar encoding: Encoding used for the certificate.
    :vartype encoding: str
    :ivar serial_number: Serial number of the certificate.
    :vartype serial_number: str
    :ivar fingerprint: Fingerprint of the certificate.
    :vartype fingerprint: str
    :ivar usage: List of functions the certificate can fulfill.
    :vartype usage: list[str]
    :ivar file_paths: List of files where this certificate was found.
    :vartype file_paths: list[str]
    :ivar paired_key: A matching paired private key.
    :vartype paired_key: ~azure.mgmt.iotfirmwaredefense.models.PairedKey
    :ivar is_expired: Indicates if the certificate is expired.
    :vartype is_expired: bool
    :ivar is_self_signed: Indicates if the certificate is self-signed.
    :vartype is_self_signed: bool
    :ivar is_weak_signature: Indicates the signature algorithm used is insecure.
    :vartype is_weak_signature: bool
    :ivar is_short_key_size: Indicates the certificate's key size is considered too small to be
     secure for the key algorithm.
    :vartype is_short_key_size: bool
    """

    _validation = {
        "file_paths": {"readonly": True},
    }

    _attribute_map = {
        "crypto_cert_id": {"key": "cryptoCertId", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "subject": {"key": "subject", "type": "CryptoCertificateEntity"},
        "issuer": {"key": "issuer", "type": "CryptoCertificateEntity"},
        "issued_date": {"key": "issuedDate", "type": "iso-8601"},
        "expiration_date": {"key": "expirationDate", "type": "iso-8601"},
        "role": {"key": "role", "type": "str"},
        "signature_algorithm": {"key": "signatureAlgorithm", "type": "str"},
        "key_size": {"key": "keySize", "type": "int"},
        "key_algorithm": {"key": "keyAlgorithm", "type": "str"},
        "encoding": {"key": "encoding", "type": "str"},
        "serial_number": {"key": "serialNumber", "type": "str"},
        "fingerprint": {"key": "fingerprint", "type": "str"},
        "usage": {"key": "usage", "type": "[str]"},
        "file_paths": {"key": "filePaths", "type": "[str]"},
        "paired_key": {"key": "pairedKey", "type": "PairedKey"},
        "is_expired": {"key": "isExpired", "type": "bool"},
        "is_self_signed": {"key": "isSelfSigned", "type": "bool"},
        "is_weak_signature": {"key": "isWeakSignature", "type": "bool"},
        "is_short_key_size": {"key": "isShortKeySize", "type": "bool"},
    }

    def __init__(
        self,
        *,
        crypto_cert_id: Optional[str] = None,
        name: Optional[str] = None,
        subject: Optional["_models.CryptoCertificateEntity"] = None,
        issuer: Optional["_models.CryptoCertificateEntity"] = None,
        issued_date: Optional[datetime.datetime] = None,
        expiration_date: Optional[datetime.datetime] = None,
        role: Optional[str] = None,
        signature_algorithm: Optional[str] = None,
        key_size: Optional[int] = None,
        key_algorithm: Optional[str] = None,
        encoding: Optional[str] = None,
        serial_number: Optional[str] = None,
        fingerprint: Optional[str] = None,
        usage: Optional[List[str]] = None,
        paired_key: Optional["_models.PairedKey"] = None,
        is_expired: Optional[bool] = None,
        is_self_signed: Optional[bool] = None,
        is_weak_signature: Optional[bool] = None,
        is_short_key_size: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword crypto_cert_id: ID for the certificate result.
        :paramtype crypto_cert_id: str
        :keyword name: Name of the certificate.
        :paramtype name: str
        :keyword subject: Subject information of the certificate.
        :paramtype subject: ~azure.mgmt.iotfirmwaredefense.models.CryptoCertificateEntity
        :keyword issuer: Issuer information of the certificate.
        :paramtype issuer: ~azure.mgmt.iotfirmwaredefense.models.CryptoCertificateEntity
        :keyword issued_date: Issue date for the certificate.
        :paramtype issued_date: ~datetime.datetime
        :keyword expiration_date: Expiration date for the certificate.
        :paramtype expiration_date: ~datetime.datetime
        :keyword role: Role of the certificate (Root CA, etc).
        :paramtype role: str
        :keyword signature_algorithm: The signature algorithm used in the certificate.
        :paramtype signature_algorithm: str
        :keyword key_size: Size of the certificate's key in bits.
        :paramtype key_size: int
        :keyword key_algorithm: Key algorithm used in the certificate.
        :paramtype key_algorithm: str
        :keyword encoding: Encoding used for the certificate.
        :paramtype encoding: str
        :keyword serial_number: Serial number of the certificate.
        :paramtype serial_number: str
        :keyword fingerprint: Fingerprint of the certificate.
        :paramtype fingerprint: str
        :keyword usage: List of functions the certificate can fulfill.
        :paramtype usage: list[str]
        :keyword paired_key: A matching paired private key.
        :paramtype paired_key: ~azure.mgmt.iotfirmwaredefense.models.PairedKey
        :keyword is_expired: Indicates if the certificate is expired.
        :paramtype is_expired: bool
        :keyword is_self_signed: Indicates if the certificate is self-signed.
        :paramtype is_self_signed: bool
        :keyword is_weak_signature: Indicates the signature algorithm used is insecure.
        :paramtype is_weak_signature: bool
        :keyword is_short_key_size: Indicates the certificate's key size is considered too small to be
         secure for the key algorithm.
        :paramtype is_short_key_size: bool
        """
        super().__init__(**kwargs)
        self.crypto_cert_id = crypto_cert_id
        self.name = name
        self.subject = subject
        self.issuer = issuer
        self.issued_date = issued_date
        self.expiration_date = expiration_date
        self.role = role
        self.signature_algorithm = signature_algorithm
        self.key_size = key_size
        self.key_algorithm = key_algorithm
        self.encoding = encoding
        self.serial_number = serial_number
        self.fingerprint = fingerprint
        self.usage = usage
        self.file_paths = None
        self.paired_key = paired_key
        self.is_expired = is_expired
        self.is_self_signed = is_self_signed
        self.is_weak_signature = is_weak_signature
        self.is_short_key_size = is_short_key_size


class CryptoCertificateEntity(_serialization.Model):
    """Information on an entity (distinguished name) in a cryptographic certificate.

    :ivar common_name: Common name of the certificate entity.
    :vartype common_name: str
    :ivar organization: Organization of the certificate entity.
    :vartype organization: str
    :ivar organizational_unit: The organizational unit of the certificate entity.
    :vartype organizational_unit: str
    :ivar state: Geographical state or province of the certificate entity.
    :vartype state: str
    :ivar country: Country code of the certificate entity.
    :vartype country: str
    """

    _attribute_map = {
        "common_name": {"key": "commonName", "type": "str"},
        "organization": {"key": "organization", "type": "str"},
        "organizational_unit": {"key": "organizationalUnit", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "country": {"key": "country", "type": "str"},
    }

    def __init__(
        self,
        *,
        common_name: Optional[str] = None,
        organization: Optional[str] = None,
        organizational_unit: Optional[str] = None,
        state: Optional[str] = None,
        country: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword common_name: Common name of the certificate entity.
        :paramtype common_name: str
        :keyword organization: Organization of the certificate entity.
        :paramtype organization: str
        :keyword organizational_unit: The organizational unit of the certificate entity.
        :paramtype organizational_unit: str
        :keyword state: Geographical state or province of the certificate entity.
        :paramtype state: str
        :keyword country: Country code of the certificate entity.
        :paramtype country: str
        """
        super().__init__(**kwargs)
        self.common_name = common_name
        self.organization = organization
        self.organizational_unit = organizational_unit
        self.state = state
        self.country = country


class CryptoCertificateListResult(_serialization.Model):
    """List of crypto certificates.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of crypto certificate results.
    :vartype value: list[~azure.mgmt.iotfirmwaredefense.models.CryptoCertificateResource]
    :ivar next_link: The uri to fetch the next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[CryptoCertificateResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword next_link: The uri to fetch the next page of resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class CryptoCertificateResource(Resource):
    """Crypto certificate resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.iotfirmwaredefense.models.SystemData
    :ivar properties: The properties of a crypto certificate found within a firmware image.
    :vartype properties: ~azure.mgmt.iotfirmwaredefense.models.CryptoCertificate
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "CryptoCertificate"},
    }

    def __init__(self, *, properties: Optional["_models.CryptoCertificate"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: The properties of a crypto certificate found within a firmware image.
        :paramtype properties: ~azure.mgmt.iotfirmwaredefense.models.CryptoCertificate
        """
        super().__init__(**kwargs)
        self.properties = properties


class CryptoCertificateSummaryResource(SummaryResourceProperties):
    """Properties for cryptographic certificate summary.

    All required parameters must be populated in order to send to Azure.

    :ivar summary_type: Describes the type of summary. Required. Known values are: "Firmware",
     "CVE", "BinaryHardening", "CryptoCertificate", and "CryptoKey".
    :vartype summary_type: str or ~azure.mgmt.iotfirmwaredefense.models.SummaryType
    :ivar total_certificates: Total number of certificates found.
    :vartype total_certificates: int
    :ivar paired_keys: Total number of paired private keys found for the certificates.
    :vartype paired_keys: int
    :ivar expired: Total number of expired certificates found.
    :vartype expired: int
    :ivar expiring_soon: Total number of nearly expired certificates found.
    :vartype expiring_soon: int
    :ivar weak_signature: Total number of certificates found using a weak signature algorithm.
    :vartype weak_signature: int
    :ivar self_signed: Total number of certificates found that are self-signed.
    :vartype self_signed: int
    :ivar short_key_size: Total number of certificates found that have an insecure key size for the
     key algorithm.
    :vartype short_key_size: int
    """

    _validation = {
        "summary_type": {"required": True},
    }

    _attribute_map = {
        "summary_type": {"key": "summaryType", "type": "str"},
        "total_certificates": {"key": "totalCertificates", "type": "int"},
        "paired_keys": {"key": "pairedKeys", "type": "int"},
        "expired": {"key": "expired", "type": "int"},
        "expiring_soon": {"key": "expiringSoon", "type": "int"},
        "weak_signature": {"key": "weakSignature", "type": "int"},
        "self_signed": {"key": "selfSigned", "type": "int"},
        "short_key_size": {"key": "shortKeySize", "type": "int"},
    }

    def __init__(
        self,
        *,
        total_certificates: Optional[int] = None,
        paired_keys: Optional[int] = None,
        expired: Optional[int] = None,
        expiring_soon: Optional[int] = None,
        weak_signature: Optional[int] = None,
        self_signed: Optional[int] = None,
        short_key_size: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword total_certificates: Total number of certificates found.
        :paramtype total_certificates: int
        :keyword paired_keys: Total number of paired private keys found for the certificates.
        :paramtype paired_keys: int
        :keyword expired: Total number of expired certificates found.
        :paramtype expired: int
        :keyword expiring_soon: Total number of nearly expired certificates found.
        :paramtype expiring_soon: int
        :keyword weak_signature: Total number of certificates found using a weak signature algorithm.
        :paramtype weak_signature: int
        :keyword self_signed: Total number of certificates found that are self-signed.
        :paramtype self_signed: int
        :keyword short_key_size: Total number of certificates found that have an insecure key size for
         the key algorithm.
        :paramtype short_key_size: int
        """
        super().__init__(**kwargs)
        self.summary_type: str = "CryptoCertificate"
        self.total_certificates = total_certificates
        self.paired_keys = paired_keys
        self.expired = expired
        self.expiring_soon = expiring_soon
        self.weak_signature = weak_signature
        self.self_signed = self_signed
        self.short_key_size = short_key_size


class CryptoKey(_serialization.Model):
    """Crypto key properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar crypto_key_id: ID for the key result.
    :vartype crypto_key_id: str
    :ivar key_type: Type of the key (public or private).
    :vartype key_type: str
    :ivar key_size: Size of the key in bits.
    :vartype key_size: int
    :ivar key_algorithm: Key algorithm name.
    :vartype key_algorithm: str
    :ivar usage: Functions the key can fulfill.
    :vartype usage: list[str]
    :ivar file_paths: List of files where this key was found.
    :vartype file_paths: list[str]
    :ivar paired_key: A matching paired key or certificate.
    :vartype paired_key: ~azure.mgmt.iotfirmwaredefense.models.PairedKey
    :ivar is_short_key_size: Indicates the key size is considered too small to be secure for the
     algorithm.
    :vartype is_short_key_size: bool
    """

    _validation = {
        "file_paths": {"readonly": True},
    }

    _attribute_map = {
        "crypto_key_id": {"key": "cryptoKeyId", "type": "str"},
        "key_type": {"key": "keyType", "type": "str"},
        "key_size": {"key": "keySize", "type": "int"},
        "key_algorithm": {"key": "keyAlgorithm", "type": "str"},
        "usage": {"key": "usage", "type": "[str]"},
        "file_paths": {"key": "filePaths", "type": "[str]"},
        "paired_key": {"key": "pairedKey", "type": "PairedKey"},
        "is_short_key_size": {"key": "isShortKeySize", "type": "bool"},
    }

    def __init__(
        self,
        *,
        crypto_key_id: Optional[str] = None,
        key_type: Optional[str] = None,
        key_size: Optional[int] = None,
        key_algorithm: Optional[str] = None,
        usage: Optional[List[str]] = None,
        paired_key: Optional["_models.PairedKey"] = None,
        is_short_key_size: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword crypto_key_id: ID for the key result.
        :paramtype crypto_key_id: str
        :keyword key_type: Type of the key (public or private).
        :paramtype key_type: str
        :keyword key_size: Size of the key in bits.
        :paramtype key_size: int
        :keyword key_algorithm: Key algorithm name.
        :paramtype key_algorithm: str
        :keyword usage: Functions the key can fulfill.
        :paramtype usage: list[str]
        :keyword paired_key: A matching paired key or certificate.
        :paramtype paired_key: ~azure.mgmt.iotfirmwaredefense.models.PairedKey
        :keyword is_short_key_size: Indicates the key size is considered too small to be secure for the
         algorithm.
        :paramtype is_short_key_size: bool
        """
        super().__init__(**kwargs)
        self.crypto_key_id = crypto_key_id
        self.key_type = key_type
        self.key_size = key_size
        self.key_algorithm = key_algorithm
        self.usage = usage
        self.file_paths = None
        self.paired_key = paired_key
        self.is_short_key_size = is_short_key_size


class CryptoKeyListResult(_serialization.Model):
    """List of crypto keys.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of crypto key results.
    :vartype value: list[~azure.mgmt.iotfirmwaredefense.models.CryptoKeyResource]
    :ivar next_link: The uri to fetch the next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[CryptoKeyResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword next_link: The uri to fetch the next page of resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class CryptoKeyResource(Resource):
    """Crypto key resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.iotfirmwaredefense.models.SystemData
    :ivar properties: The properties of a crypto key found within a firmware image.
    :vartype properties: ~azure.mgmt.iotfirmwaredefense.models.CryptoKey
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "CryptoKey"},
    }

    def __init__(self, *, properties: Optional["_models.CryptoKey"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: The properties of a crypto key found within a firmware image.
        :paramtype properties: ~azure.mgmt.iotfirmwaredefense.models.CryptoKey
        """
        super().__init__(**kwargs)
        self.properties = properties


class CryptoKeySummaryResource(SummaryResourceProperties):
    """Properties for cryptographic key summary.

    All required parameters must be populated in order to send to Azure.

    :ivar summary_type: Describes the type of summary. Required. Known values are: "Firmware",
     "CVE", "BinaryHardening", "CryptoCertificate", and "CryptoKey".
    :vartype summary_type: str or ~azure.mgmt.iotfirmwaredefense.models.SummaryType
    :ivar total_keys: Total number of cryptographic keys found.
    :vartype total_keys: int
    :ivar public_keys: Total number of (non-certificate) public keys found.
    :vartype public_keys: int
    :ivar private_keys: Total number of private keys found.
    :vartype private_keys: int
    :ivar paired_keys: Total number of keys found that have a matching paired key or certificate.
    :vartype paired_keys: int
    :ivar short_key_size: Total number of keys found that have an insecure key size for the
     algorithm.
    :vartype short_key_size: int
    """

    _validation = {
        "summary_type": {"required": True},
    }

    _attribute_map = {
        "summary_type": {"key": "summaryType", "type": "str"},
        "total_keys": {"key": "totalKeys", "type": "int"},
        "public_keys": {"key": "publicKeys", "type": "int"},
        "private_keys": {"key": "privateKeys", "type": "int"},
        "paired_keys": {"key": "pairedKeys", "type": "int"},
        "short_key_size": {"key": "shortKeySize", "type": "int"},
    }

    def __init__(
        self,
        *,
        total_keys: Optional[int] = None,
        public_keys: Optional[int] = None,
        private_keys: Optional[int] = None,
        paired_keys: Optional[int] = None,
        short_key_size: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword total_keys: Total number of cryptographic keys found.
        :paramtype total_keys: int
        :keyword public_keys: Total number of (non-certificate) public keys found.
        :paramtype public_keys: int
        :keyword private_keys: Total number of private keys found.
        :paramtype private_keys: int
        :keyword paired_keys: Total number of keys found that have a matching paired key or
         certificate.
        :paramtype paired_keys: int
        :keyword short_key_size: Total number of keys found that have an insecure key size for the
         algorithm.
        :paramtype short_key_size: int
        """
        super().__init__(**kwargs)
        self.summary_type: str = "CryptoKey"
        self.total_keys = total_keys
        self.public_keys = public_keys
        self.private_keys = private_keys
        self.paired_keys = paired_keys
        self.short_key_size = short_key_size


class CveComponent(_serialization.Model):
    """Properties of the SBOM component for a CVE.

    :ivar component_id: ID of the SBOM component.
    :vartype component_id: str
    :ivar name: Name of the SBOM component.
    :vartype name: str
    :ivar version: Version of the SBOM component.
    :vartype version: str
    """

    _attribute_map = {
        "component_id": {"key": "componentId", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "version": {"key": "version", "type": "str"},
    }

    def __init__(
        self,
        *,
        component_id: Optional[str] = None,
        name: Optional[str] = None,
        version: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword component_id: ID of the SBOM component.
        :paramtype component_id: str
        :keyword name: Name of the SBOM component.
        :paramtype name: str
        :keyword version: Version of the SBOM component.
        :paramtype version: str
        """
        super().__init__(**kwargs)
        self.component_id = component_id
        self.name = name
        self.version = version


class CveLink(_serialization.Model):
    """Properties of a reference link for a CVE.

    :ivar href: The destination of the reference link.
    :vartype href: str
    :ivar label: The label of the reference link.
    :vartype label: str
    """

    _attribute_map = {
        "href": {"key": "href", "type": "str"},
        "label": {"key": "label", "type": "str"},
    }

    def __init__(self, *, href: Optional[str] = None, label: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword href: The destination of the reference link.
        :paramtype href: str
        :keyword label: The label of the reference link.
        :paramtype label: str
        """
        super().__init__(**kwargs)
        self.href = href
        self.label = label


class CveListResult(_serialization.Model):
    """List of CVE results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of CVE results.
    :vartype value: list[~azure.mgmt.iotfirmwaredefense.models.CveResource]
    :ivar next_link: The uri to fetch the next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[CveResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword next_link: The uri to fetch the next page of resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class CveResource(Resource):
    """CVE analysis result resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.iotfirmwaredefense.models.SystemData
    :ivar properties: The properties of a CVE result found within a firmware image.
    :vartype properties: ~azure.mgmt.iotfirmwaredefense.models.CveResult
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "CveResult"},
    }

    def __init__(self, *, properties: Optional["_models.CveResult"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: The properties of a CVE result found within a firmware image.
        :paramtype properties: ~azure.mgmt.iotfirmwaredefense.models.CveResult
        """
        super().__init__(**kwargs)
        self.properties = properties


class CveResult(_serialization.Model):
    """Details of a CVE detected in firmware.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar cve_id: ID of the CVE result.
    :vartype cve_id: str
    :ivar component: The SBOM component for the CVE.
    :vartype component: ~azure.mgmt.iotfirmwaredefense.models.CveComponent
    :ivar severity: Severity of the CVE.
    :vartype severity: str
    :ivar name: Name of the CVE.
    :vartype name: str
    :ivar cvss_score: A single CVSS score to represent the CVE. If a V3 score is specified, then it
     will use the V3 score. Otherwise if the V2 score is specified it will be the V2 score.
    :vartype cvss_score: str
    :ivar cvss_version: CVSS version of the CVE.
    :vartype cvss_version: str
    :ivar cvss_v2_score: CVSS V2 score of the CVE.
    :vartype cvss_v2_score: str
    :ivar cvss_v3_score: CVSS V3 score of the CVE.
    :vartype cvss_v3_score: str
    :ivar links: The list of reference links for the CVE.
    :vartype links: list[~azure.mgmt.iotfirmwaredefense.models.CveLink]
    :ivar description: The CVE description.
    :vartype description: str
    """

    _validation = {
        "links": {"readonly": True},
    }

    _attribute_map = {
        "cve_id": {"key": "cveId", "type": "str"},
        "component": {"key": "component", "type": "CveComponent"},
        "severity": {"key": "severity", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "cvss_score": {"key": "cvssScore", "type": "str"},
        "cvss_version": {"key": "cvssVersion", "type": "str"},
        "cvss_v2_score": {"key": "cvssV2Score", "type": "str"},
        "cvss_v3_score": {"key": "cvssV3Score", "type": "str"},
        "links": {"key": "links", "type": "[CveLink]"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        cve_id: Optional[str] = None,
        component: Optional["_models.CveComponent"] = None,
        severity: Optional[str] = None,
        name: Optional[str] = None,
        cvss_score: Optional[str] = None,
        cvss_version: Optional[str] = None,
        cvss_v2_score: Optional[str] = None,
        cvss_v3_score: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword cve_id: ID of the CVE result.
        :paramtype cve_id: str
        :keyword component: The SBOM component for the CVE.
        :paramtype component: ~azure.mgmt.iotfirmwaredefense.models.CveComponent
        :keyword severity: Severity of the CVE.
        :paramtype severity: str
        :keyword name: Name of the CVE.
        :paramtype name: str
        :keyword cvss_score: A single CVSS score to represent the CVE. If a V3 score is specified, then
         it will use the V3 score. Otherwise if the V2 score is specified it will be the V2 score.
        :paramtype cvss_score: str
        :keyword cvss_version: CVSS version of the CVE.
        :paramtype cvss_version: str
        :keyword cvss_v2_score: CVSS V2 score of the CVE.
        :paramtype cvss_v2_score: str
        :keyword cvss_v3_score: CVSS V3 score of the CVE.
        :paramtype cvss_v3_score: str
        :keyword description: The CVE description.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.cve_id = cve_id
        self.component = component
        self.severity = severity
        self.name = name
        self.cvss_score = cvss_score
        self.cvss_version = cvss_version
        self.cvss_v2_score = cvss_v2_score
        self.cvss_v3_score = cvss_v3_score
        self.links = None
        self.description = description


class CveSummary(SummaryResourceProperties):
    """Properties for a CVE analysis summary.

    All required parameters must be populated in order to send to Azure.

    :ivar summary_type: Describes the type of summary. Required. Known values are: "Firmware",
     "CVE", "BinaryHardening", "CryptoCertificate", and "CryptoKey".
    :vartype summary_type: str or ~azure.mgmt.iotfirmwaredefense.models.SummaryType
    :ivar critical: The total number of critical severity CVEs detected.
    :vartype critical: int
    :ivar high: The total number of high severity CVEs detected.
    :vartype high: int
    :ivar medium: The total number of medium severity CVEs detected.
    :vartype medium: int
    :ivar low: The total number of low severity CVEs detected.
    :vartype low: int
    :ivar unknown: The total number of unknown severity CVEs detected.
    :vartype unknown: int
    """

    _validation = {
        "summary_type": {"required": True},
    }

    _attribute_map = {
        "summary_type": {"key": "summaryType", "type": "str"},
        "critical": {"key": "critical", "type": "int"},
        "high": {"key": "high", "type": "int"},
        "medium": {"key": "medium", "type": "int"},
        "low": {"key": "low", "type": "int"},
        "unknown": {"key": "unknown", "type": "int"},
    }

    def __init__(
        self,
        *,
        critical: Optional[int] = None,
        high: Optional[int] = None,
        medium: Optional[int] = None,
        low: Optional[int] = None,
        unknown: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword critical: The total number of critical severity CVEs detected.
        :paramtype critical: int
        :keyword high: The total number of high severity CVEs detected.
        :paramtype high: int
        :keyword medium: The total number of medium severity CVEs detected.
        :paramtype medium: int
        :keyword low: The total number of low severity CVEs detected.
        :paramtype low: int
        :keyword unknown: The total number of unknown severity CVEs detected.
        :paramtype unknown: int
        """
        super().__init__(**kwargs)
        self.summary_type: str = "CVE"
        self.critical = critical
        self.high = high
        self.medium = medium
        self.low = low
        self.unknown = unknown


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.iotfirmwaredefense.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.iotfirmwaredefense.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.iotfirmwaredefense.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.iotfirmwaredefense.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class Firmware(Resource):
    """Firmware definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.iotfirmwaredefense.models.SystemData
    :ivar properties: The properties of a firmware.
    :vartype properties: ~azure.mgmt.iotfirmwaredefense.models.FirmwareProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "FirmwareProperties"},
    }

    def __init__(self, *, properties: Optional["_models.FirmwareProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: The properties of a firmware.
        :paramtype properties: ~azure.mgmt.iotfirmwaredefense.models.FirmwareProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class FirmwareList(_serialization.Model):
    """List of firmwares.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of firmwares.
    :vartype value: list[~azure.mgmt.iotfirmwaredefense.models.Firmware]
    :ivar next_link: The uri to fetch the next page of asset.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Firmware]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword next_link: The uri to fetch the next page of asset.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class FirmwareProperties(_serialization.Model):
    """Firmware properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar file_name: File name for a firmware that user uploaded.
    :vartype file_name: str
    :ivar vendor: Firmware vendor.
    :vartype vendor: str
    :ivar model: Firmware model.
    :vartype model: str
    :ivar version: Firmware version.
    :vartype version: str
    :ivar description: User-specified description of the firmware.
    :vartype description: str
    :ivar file_size: File size of the uploaded firmware image.
    :vartype file_size: int
    :ivar status: The status of firmware scan. Known values are: "Pending", "Extracting",
     "Analyzing", "Ready", and "Error".
    :vartype status: str or ~azure.mgmt.iotfirmwaredefense.models.Status
    :ivar status_messages: A list of errors or other messages generated during firmware analysis.
    :vartype status_messages: list[~azure.mgmt.iotfirmwaredefense.models.StatusMessage]
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Accepted",
     "Succeeded", "Canceled", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.iotfirmwaredefense.models.ProvisioningState
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "file_name": {"key": "fileName", "type": "str"},
        "vendor": {"key": "vendor", "type": "str"},
        "model": {"key": "model", "type": "str"},
        "version": {"key": "version", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "file_size": {"key": "fileSize", "type": "int"},
        "status": {"key": "status", "type": "str"},
        "status_messages": {"key": "statusMessages", "type": "[StatusMessage]"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        file_name: Optional[str] = None,
        vendor: Optional[str] = None,
        model: Optional[str] = None,
        version: Optional[str] = None,
        description: Optional[str] = None,
        file_size: Optional[int] = None,
        status: Union[str, "_models.Status"] = "Pending",
        status_messages: Optional[List["_models.StatusMessage"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword file_name: File name for a firmware that user uploaded.
        :paramtype file_name: str
        :keyword vendor: Firmware vendor.
        :paramtype vendor: str
        :keyword model: Firmware model.
        :paramtype model: str
        :keyword version: Firmware version.
        :paramtype version: str
        :keyword description: User-specified description of the firmware.
        :paramtype description: str
        :keyword file_size: File size of the uploaded firmware image.
        :paramtype file_size: int
        :keyword status: The status of firmware scan. Known values are: "Pending", "Extracting",
         "Analyzing", "Ready", and "Error".
        :paramtype status: str or ~azure.mgmt.iotfirmwaredefense.models.Status
        :keyword status_messages: A list of errors or other messages generated during firmware
         analysis.
        :paramtype status_messages: list[~azure.mgmt.iotfirmwaredefense.models.StatusMessage]
        """
        super().__init__(**kwargs)
        self.file_name = file_name
        self.vendor = vendor
        self.model = model
        self.version = version
        self.description = description
        self.file_size = file_size
        self.status = status
        self.status_messages = status_messages
        self.provisioning_state = None


class FirmwareSummary(SummaryResourceProperties):
    """Properties for high level summary of firmware analysis results.

    All required parameters must be populated in order to send to Azure.

    :ivar summary_type: Describes the type of summary. Required. Known values are: "Firmware",
     "CVE", "BinaryHardening", "CryptoCertificate", and "CryptoKey".
    :vartype summary_type: str or ~azure.mgmt.iotfirmwaredefense.models.SummaryType
    :ivar extracted_size: Total extracted size of the firmware in bytes.
    :vartype extracted_size: int
    :ivar file_size: Firmware file size in bytes.
    :vartype file_size: int
    :ivar extracted_file_count: Extracted file count.
    :vartype extracted_file_count: int
    :ivar component_count: Components count.
    :vartype component_count: int
    :ivar binary_count: Binary count.
    :vartype binary_count: int
    :ivar analysis_time_seconds: Time used for analysis.
    :vartype analysis_time_seconds: int
    :ivar root_file_systems: The number of root file systems found.
    :vartype root_file_systems: int
    """

    _validation = {
        "summary_type": {"required": True},
    }

    _attribute_map = {
        "summary_type": {"key": "summaryType", "type": "str"},
        "extracted_size": {"key": "extractedSize", "type": "int"},
        "file_size": {"key": "fileSize", "type": "int"},
        "extracted_file_count": {"key": "extractedFileCount", "type": "int"},
        "component_count": {"key": "componentCount", "type": "int"},
        "binary_count": {"key": "binaryCount", "type": "int"},
        "analysis_time_seconds": {"key": "analysisTimeSeconds", "type": "int"},
        "root_file_systems": {"key": "rootFileSystems", "type": "int"},
    }

    def __init__(
        self,
        *,
        extracted_size: Optional[int] = None,
        file_size: Optional[int] = None,
        extracted_file_count: Optional[int] = None,
        component_count: Optional[int] = None,
        binary_count: Optional[int] = None,
        analysis_time_seconds: Optional[int] = None,
        root_file_systems: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword extracted_size: Total extracted size of the firmware in bytes.
        :paramtype extracted_size: int
        :keyword file_size: Firmware file size in bytes.
        :paramtype file_size: int
        :keyword extracted_file_count: Extracted file count.
        :paramtype extracted_file_count: int
        :keyword component_count: Components count.
        :paramtype component_count: int
        :keyword binary_count: Binary count.
        :paramtype binary_count: int
        :keyword analysis_time_seconds: Time used for analysis.
        :paramtype analysis_time_seconds: int
        :keyword root_file_systems: The number of root file systems found.
        :paramtype root_file_systems: int
        """
        super().__init__(**kwargs)
        self.summary_type: str = "Firmware"
        self.extracted_size = extracted_size
        self.file_size = file_size
        self.extracted_file_count = extracted_file_count
        self.component_count = component_count
        self.binary_count = binary_count
        self.analysis_time_seconds = analysis_time_seconds
        self.root_file_systems = root_file_systems


class FirmwareUpdateDefinition(_serialization.Model):
    """Firmware definition.

    :ivar properties: The editable properties of a firmware.
    :vartype properties: ~azure.mgmt.iotfirmwaredefense.models.FirmwareProperties
    """

    _attribute_map = {
        "properties": {"key": "properties", "type": "FirmwareProperties"},
    }

    def __init__(self, *, properties: Optional["_models.FirmwareProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: The editable properties of a firmware.
        :paramtype properties: ~azure.mgmt.iotfirmwaredefense.models.FirmwareProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class GenerateUploadUrlRequest(_serialization.Model):
    """Properties for generating an upload URL.

    :ivar firmware_id: A unique ID for the firmware to be uploaded.
    :vartype firmware_id: str
    """

    _attribute_map = {
        "firmware_id": {"key": "firmwareId", "type": "str"},
    }

    def __init__(self, *, firmware_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword firmware_id: A unique ID for the firmware to be uploaded.
        :paramtype firmware_id: str
        """
        super().__init__(**kwargs)
        self.firmware_id = firmware_id


class Operation(_serialization.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for ARM/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.iotfirmwaredefense.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.iotfirmwaredefense.models.Origin
    :ivar action_type: Enum. Indicates the action type. "Internal" refers to actions that are for
     internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.iotfirmwaredefense.models.ActionType
    """

    _validation = {
        "name": {"readonly": True},
        "is_data_action": {"readonly": True},
        "origin": {"readonly": True},
        "action_type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "action_type": {"key": "actionType", "type": "str"},
    }

    def __init__(self, *, display: Optional["_models.OperationDisplay"] = None, **kwargs: Any) -> None:
        """
        :keyword display: Localized display information for this particular operation.
        :paramtype display: ~azure.mgmt.iotfirmwaredefense.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name = None
        self.is_data_action = None
        self.display = display
        self.origin = None
        self.action_type = None


class OperationDisplay(_serialization.Model):
    """Localized display information for this particular operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    _validation = {
        "provider": {"readonly": True},
        "resource": {"readonly": True},
        "operation": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(_serialization.Model):
    """A list of REST API operations supported by an Azure Resource Provider. It contains an URL link
    to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations supported by the resource provider.
    :vartype value: list[~azure.mgmt.iotfirmwaredefense.models.Operation]
    :ivar next_link: URL to get the next set of operation list results (if there are any).
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class PairedKey(_serialization.Model):
    """Details of a matching paired key or certificate.

    :ivar id: ID of the paired key or certificate.
    :vartype id: str
    :ivar type: The type indicating whether the paired object is a key or certificate.
    :vartype type: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        type: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: ID of the paired key or certificate.
        :paramtype id: str
        :keyword type: The type indicating whether the paired object is a key or certificate.
        :paramtype type: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.type = type


class PasswordHash(_serialization.Model):
    """Password hash properties.

    :ivar password_hash_id: ID for password hash.
    :vartype password_hash_id: str
    :ivar file_path: File path of the password hash.
    :vartype file_path: str
    :ivar salt: Salt of the password hash.
    :vartype salt: str
    :ivar hash: Hash of the password.
    :vartype hash: str
    :ivar context: Context of password hash.
    :vartype context: str
    :ivar username: User name of password hash.
    :vartype username: str
    :ivar algorithm: Algorithm of the password hash.
    :vartype algorithm: str
    """

    _attribute_map = {
        "password_hash_id": {"key": "passwordHashId", "type": "str"},
        "file_path": {"key": "filePath", "type": "str"},
        "salt": {"key": "salt", "type": "str"},
        "hash": {"key": "hash", "type": "str"},
        "context": {"key": "context", "type": "str"},
        "username": {"key": "username", "type": "str"},
        "algorithm": {"key": "algorithm", "type": "str"},
    }

    def __init__(
        self,
        *,
        password_hash_id: Optional[str] = None,
        file_path: Optional[str] = None,
        salt: Optional[str] = None,
        hash: Optional[str] = None,
        context: Optional[str] = None,
        username: Optional[str] = None,
        algorithm: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword password_hash_id: ID for password hash.
        :paramtype password_hash_id: str
        :keyword file_path: File path of the password hash.
        :paramtype file_path: str
        :keyword salt: Salt of the password hash.
        :paramtype salt: str
        :keyword hash: Hash of the password.
        :paramtype hash: str
        :keyword context: Context of password hash.
        :paramtype context: str
        :keyword username: User name of password hash.
        :paramtype username: str
        :keyword algorithm: Algorithm of the password hash.
        :paramtype algorithm: str
        """
        super().__init__(**kwargs)
        self.password_hash_id = password_hash_id
        self.file_path = file_path
        self.salt = salt
        self.hash = hash
        self.context = context
        self.username = username
        self.algorithm = algorithm


class PasswordHashListResult(_serialization.Model):
    """List of password hash results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of password hash results.
    :vartype value: list[~azure.mgmt.iotfirmwaredefense.models.PasswordHashResource]
    :ivar next_link: The uri to fetch the next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[PasswordHashResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword next_link: The uri to fetch the next page of resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class PasswordHashResource(Resource):
    """Password hash resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.iotfirmwaredefense.models.SystemData
    :ivar properties: The properties of a password hash found within a firmware image.
    :vartype properties: ~azure.mgmt.iotfirmwaredefense.models.PasswordHash
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "PasswordHash"},
    }

    def __init__(self, *, properties: Optional["_models.PasswordHash"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: The properties of a password hash found within a firmware image.
        :paramtype properties: ~azure.mgmt.iotfirmwaredefense.models.PasswordHash
        """
        super().__init__(**kwargs)
        self.properties = properties


class SbomComponent(_serialization.Model):
    """SBOM component of a firmware.

    :ivar component_id: ID for the component.
    :vartype component_id: str
    :ivar component_name: Name for the component.
    :vartype component_name: str
    :ivar version: Version for the component.
    :vartype version: str
    :ivar license: License for the component.
    :vartype license: str
    :ivar file_paths: File paths related to the component.
    :vartype file_paths: list[str]
    """

    _attribute_map = {
        "component_id": {"key": "componentId", "type": "str"},
        "component_name": {"key": "componentName", "type": "str"},
        "version": {"key": "version", "type": "str"},
        "license": {"key": "license", "type": "str"},
        "file_paths": {"key": "filePaths", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        component_id: Optional[str] = None,
        component_name: Optional[str] = None,
        version: Optional[str] = None,
        license: Optional[str] = None,
        file_paths: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword component_id: ID for the component.
        :paramtype component_id: str
        :keyword component_name: Name for the component.
        :paramtype component_name: str
        :keyword version: Version for the component.
        :paramtype version: str
        :keyword license: License for the component.
        :paramtype license: str
        :keyword file_paths: File paths related to the component.
        :paramtype file_paths: list[str]
        """
        super().__init__(**kwargs)
        self.component_id = component_id
        self.component_name = component_name
        self.version = version
        self.license = license
        self.file_paths = file_paths


class SbomComponentListResult(_serialization.Model):
    """List of SBOM results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of SBOM components.
    :vartype value: list[~azure.mgmt.iotfirmwaredefense.models.SbomComponentResource]
    :ivar next_link: The uri to fetch the next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SbomComponentResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword next_link: The uri to fetch the next page of resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class SbomComponentResource(Resource):
    """SBOM analysis result resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.iotfirmwaredefense.models.SystemData
    :ivar properties: The properties of an SBOM component found within a firmware image.
    :vartype properties: ~azure.mgmt.iotfirmwaredefense.models.SbomComponent
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "SbomComponent"},
    }

    def __init__(self, *, properties: Optional["_models.SbomComponent"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: The properties of an SBOM component found within a firmware image.
        :paramtype properties: ~azure.mgmt.iotfirmwaredefense.models.SbomComponent
        """
        super().__init__(**kwargs)
        self.properties = properties


class StatusMessage(_serialization.Model):
    """Error and status message.

    :ivar error_code: The error code.
    :vartype error_code: int
    :ivar message: The error or status message.
    :vartype message: str
    """

    _attribute_map = {
        "error_code": {"key": "errorCode", "type": "int"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, *, error_code: Optional[int] = None, message: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword error_code: The error code.
        :paramtype error_code: int
        :keyword message: The error or status message.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.error_code = error_code
        self.message = message


class SummaryListResult(_serialization.Model):
    """List of analysis summaries.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of summaries.
    :vartype value: list[~azure.mgmt.iotfirmwaredefense.models.SummaryResource]
    :ivar next_link: The uri to fetch the next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SummaryResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword next_link: The uri to fetch the next page of resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class SummaryResource(Resource):
    """The object representing a firmware analysis summary resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.iotfirmwaredefense.models.SystemData
    :ivar properties: Properties of an analysis summary.
    :vartype properties: ~azure.mgmt.iotfirmwaredefense.models.SummaryResourceProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "properties": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "SummaryResourceProperties"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.properties = None


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.iotfirmwaredefense.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.iotfirmwaredefense.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.iotfirmwaredefense.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.iotfirmwaredefense.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.iotfirmwaredefense.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class UrlToken(_serialization.Model):
    """Url data for creating or accessing a blob file.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar url: SAS URL for creating or accessing a blob file.
    :vartype url: str
    """

    _validation = {
        "url": {"readonly": True},
    }

    _attribute_map = {
        "url": {"key": "url", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.url = None


class Workspace(TrackedResource):
    """Firmware analysis workspace.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.iotfirmwaredefense.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: Workspace properties.
    :vartype properties: ~azure.mgmt.iotfirmwaredefense.models.WorkspaceProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "properties": {"key": "properties", "type": "WorkspaceProperties"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.WorkspaceProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword properties: Workspace properties.
        :paramtype properties: ~azure.mgmt.iotfirmwaredefense.models.WorkspaceProperties
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.properties = properties


class WorkspaceList(_serialization.Model):
    """Return a list of firmware analysis workspaces.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of firmware analysis workspaces.
    :vartype value: list[~azure.mgmt.iotfirmwaredefense.models.Workspace]
    :ivar next_link: The uri to fetch the next page of asset.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Workspace]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword next_link: The uri to fetch the next page of asset.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class WorkspaceProperties(_serialization.Model):
    """Workspace properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Accepted",
     "Succeeded", "Canceled", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.iotfirmwaredefense.models.ProvisioningState
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provisioning_state = None


class WorkspaceUpdateDefinition(_serialization.Model):
    """Firmware analysis workspace.

    :ivar properties: The editable workspace properties.
    :vartype properties: ~azure.mgmt.iotfirmwaredefense.models.WorkspaceProperties
    """

    _attribute_map = {
        "properties": {"key": "properties", "type": "WorkspaceProperties"},
    }

    def __init__(self, *, properties: Optional["_models.WorkspaceProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: The editable workspace properties.
        :paramtype properties: ~azure.mgmt.iotfirmwaredefense.models.WorkspaceProperties
        """
        super().__init__(**kwargs)
        self.properties = properties
