# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.cosmosdb.aio import CosmosDBManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestCosmosDBManagementCassandraDataCentersOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(CosmosDBManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_cassandra_data_centers_list(self, resource_group):
        response = self.client.cassandra_data_centers.list(
            resource_group_name=resource_group.name,
            cluster_name="str",
            api_version="2024-12-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_cassandra_data_centers_get(self, resource_group):
        response = await self.client.cassandra_data_centers.get(
            resource_group_name=resource_group.name,
            cluster_name="str",
            data_center_name="str",
            api_version="2024-12-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_cassandra_data_centers_begin_delete(self, resource_group):
        response = await (
            await self.client.cassandra_data_centers.begin_delete(
                resource_group_name=resource_group.name,
                cluster_name="str",
                data_center_name="str",
                api_version="2024-12-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_cassandra_data_centers_begin_create_update(self, resource_group):
        response = await (
            await self.client.cassandra_data_centers.begin_create_update(
                resource_group_name=resource_group.name,
                cluster_name="str",
                data_center_name="str",
                body={
                    "id": "str",
                    "name": "str",
                    "properties": {
                        "authenticationMethodLdapProperties": {
                            "connectionTimeoutInMs": 0,
                            "searchBaseDistinguishedName": "str",
                            "searchFilterTemplate": "str",
                            "serverCertificates": [{"pem": "str"}],
                            "serverHostname": "str",
                            "serverPort": 0,
                            "serviceUserDistinguishedName": "str",
                            "serviceUserPassword": "str",
                        },
                        "availabilityZone": bool,
                        "backupStorageCustomerKeyUri": "str",
                        "base64EncodedCassandraYamlFragment": "str",
                        "dataCenterLocation": "str",
                        "deallocated": bool,
                        "delegatedSubnetId": "str",
                        "diskCapacity": 0,
                        "diskSku": "str",
                        "managedDiskCustomerKeyUri": "str",
                        "nodeCount": 0,
                        "privateEndpointIpAddress": "str",
                        "provisionError": {
                            "additionalErrorInfo": "str",
                            "code": "str",
                            "message": "str",
                            "target": "str",
                        },
                        "provisioningState": "str",
                        "seedNodes": [{"ipAddress": "str"}],
                        "sku": "str",
                    },
                    "type": "str",
                },
                api_version="2024-12-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_cassandra_data_centers_begin_update(self, resource_group):
        response = await (
            await self.client.cassandra_data_centers.begin_update(
                resource_group_name=resource_group.name,
                cluster_name="str",
                data_center_name="str",
                body={
                    "id": "str",
                    "name": "str",
                    "properties": {
                        "authenticationMethodLdapProperties": {
                            "connectionTimeoutInMs": 0,
                            "searchBaseDistinguishedName": "str",
                            "searchFilterTemplate": "str",
                            "serverCertificates": [{"pem": "str"}],
                            "serverHostname": "str",
                            "serverPort": 0,
                            "serviceUserDistinguishedName": "str",
                            "serviceUserPassword": "str",
                        },
                        "availabilityZone": bool,
                        "backupStorageCustomerKeyUri": "str",
                        "base64EncodedCassandraYamlFragment": "str",
                        "dataCenterLocation": "str",
                        "deallocated": bool,
                        "delegatedSubnetId": "str",
                        "diskCapacity": 0,
                        "diskSku": "str",
                        "managedDiskCustomerKeyUri": "str",
                        "nodeCount": 0,
                        "privateEndpointIpAddress": "str",
                        "provisionError": {
                            "additionalErrorInfo": "str",
                            "code": "str",
                            "message": "str",
                            "target": "str",
                        },
                        "provisioningState": "str",
                        "seedNodes": [{"ipAddress": "str"}],
                        "sku": "str",
                    },
                    "type": "str",
                },
                api_version="2024-12-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
