# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class ArmOperationStatus(_serialization.Model):
    """Standard ARM operation status response.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar status: The operation status. Required. Known values are: "Succeeded", "Failed", and
     "Canceled".
    :vartype status: str or ~azure.ai.resources.autogen.models.ResourceProvisioningState
    :ivar name: The name of the  operationStatus resource.
    :vartype name: str
    :ivar start_time: Operation start time.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: Operation complete time.
    :vartype end_time: ~datetime.datetime
    :ivar percent_complete: The progress made toward completing the operation.
    :vartype percent_complete: float
    :ivar error: Errors that occurred if the operation ended with Canceled or Failed status.
    :vartype error: ~azure.ai.resources.autogen.models.ErrorDetail
    """

    _validation = {
        "status": {"required": True},
    }

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "percent_complete": {"key": "percentComplete", "type": "float"},
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(
        self,
        *,
        status: Union[str, "_models.ResourceProvisioningState"],
        name: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        percent_complete: Optional[float] = None,
        error: Optional["_models.ErrorDetail"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status: The operation status. Required. Known values are: "Succeeded", "Failed", and
         "Canceled".
        :paramtype status: str or ~azure.ai.resources.autogen.models.ResourceProvisioningState
        :keyword name: The name of the  operationStatus resource.
        :paramtype name: str
        :keyword start_time: Operation start time.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: Operation complete time.
        :paramtype end_time: ~datetime.datetime
        :keyword percent_complete: The progress made toward completing the operation.
        :paramtype percent_complete: float
        :keyword error: Errors that occurred if the operation ended with Canceled or Failed status.
        :paramtype error: ~azure.ai.resources.autogen.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.status = status
        self.name = name
        self.start_time = start_time
        self.end_time = end_time
        self.percent_complete = percent_complete
        self.error = error


class ArmResourceBase(_serialization.Model):
    """Base class used for type definitions."""


class ArmResource(ArmResourceBase):
    """Common properties for all ARM resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
     Required.
    :vartype id: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts". Required.
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.ai.resources.autogen.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(
        self,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Fully qualified resource ID for the resource. Ex -
         /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
         Required.
        :paramtype id: str
        :keyword type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
         "Microsoft.Storage/storageAccounts". Required.
        :paramtype type: str
        :keyword system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
         information.
        :paramtype system_data: ~azure.ai.resources.autogen.models.SystemData
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class ProxyResourceBase(ArmResource):
    """The base proxy resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
     Required.
    :vartype id: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts". Required.
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.ai.resources.autogen.models.SystemData
    """


class AzureOpenAIDeployment(ProxyResourceBase):
    """Concrete proxy resource types can be created by aliasing this type using a specific property
    type.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
     Required.
    :vartype id: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts". Required.
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.ai.resources.autogen.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.ai.resources.autogen.models.AzureOpenAIDeploymentProperties
    :ivar name: The name of the deployment. Required.
    :vartype name: str
    :ivar sku: SKU information for deployment. Required.
    :vartype sku: ~azure.ai.resources.autogen.models.AzureOpenAISku
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "sku": {"required": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "AzureOpenAIDeploymentProperties"},
        "name": {"key": "name", "type": "str"},
        "sku": {"key": "sku", "type": "AzureOpenAISku"},
    }

    def __init__(
        self,
        *,
        sku: "_models.AzureOpenAISku",
        properties: Optional["_models.AzureOpenAIDeploymentProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Fully qualified resource ID for the resource. Ex -
         /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
         Required.
        :paramtype id: str
        :keyword type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
         "Microsoft.Storage/storageAccounts". Required.
        :paramtype type: str
        :keyword system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
         information.
        :paramtype system_data: ~azure.ai.resources.autogen.models.SystemData
        :keyword properties: The resource-specific properties for this resource.
        :paramtype properties: ~azure.ai.resources.autogen.models.AzureOpenAIDeploymentProperties
        :keyword name: The name of the deployment. Required.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.sku = sku
        self.properties = properties


class AzureOpenAIDeploymentProperties(_serialization.Model):
    """Deployment properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar type: Type of the deployment, defaults to Azure.OpenAI. Required.
    :vartype type: str
    :ivar provisioning_state: provisioning state of deployment. Required.
    :vartype provisioning_state: str
    :ivar model: Model information for deployment. Required.
    :vartype model: ~azure.ai.resources.autogen.models.AzureOpenAIModel
    """

    _validation = {
        "type": {"required": True},
        "provisioning_state": {"readonly": True},
        "model": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "model": {"key": "model", "type": "AzureOpenAIModel"},
    }

    def __init__(
        self,
        *,
        model: "_models.AzureOpenAIModel",
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Type of the deployment, defaults to Azure.OpenAI. Required.
        :paramtype type: str
        :keyword provisioning_state: provisioning state of deployment. Required.
        :paramtype provisioning_state: str
        :keyword model: Model information for deployment. Required.
        :paramtype model: ~azure.ai.resources.autogen.models.AzureOpenAIModel
        """
        super().__init__(**kwargs)
        self.type = "Azure.OpenAI"
        self.provisioning_state = None
        self.model = model


class AzureOpenAIDeploymentUpdate(_serialization.Model):
    """The type used for update operations of the AzureOpenAIDeployment.

    :ivar properties:
    :vartype properties: ~azure.ai.resources.autogen.models.AzureOpenAIDeploymentUpdateProperties
    """

    _attribute_map = {
        "properties": {"key": "properties", "type": "AzureOpenAIDeploymentUpdateProperties"},
    }

    def __init__(
        self, *, properties: Optional["_models.AzureOpenAIDeploymentUpdateProperties"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword properties:
        :paramtype properties: ~azure.ai.resources.autogen.models.AzureOpenAIDeploymentUpdateProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class AzureOpenAIDeploymentUpdateProperties(_serialization.Model):
    """The updatable properties of the AzureOpenAIDeployment.

    :ivar type: Type of the deployment, defaults to Azure.OpenAI.
    :vartype type: str
    :ivar model: Model information for deployment.
    :vartype model: ~azure.ai.resources.autogen.models.AzureOpenAIModel
    :ivar sku: SKU information for deployment.
    :vartype sku: ~azure.ai.resources.autogen.models.AzureOpenAISku
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "model": {"key": "model", "type": "AzureOpenAIModel"},
        "sku": {"key": "sku", "type": "AzureOpenAISku"},
    }

    def __init__(
        self,
        *,
        type: Optional[str] = None,
        model: Optional["_models.AzureOpenAIModel"] = None,
        sku: Optional["_models.AzureOpenAISku"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Type of the deployment, defaults to Azure.OpenAI.
        :paramtype type: str
        :keyword model: Model information for deployment.
        :paramtype model: ~azure.ai.resources.autogen.models.AzureOpenAIModel
        :keyword sku: SKU information for deployment.
        :paramtype sku: ~azure.ai.resources.autogen.models.AzureOpenAISku
        """
        super().__init__(**kwargs)
        self.type = type
        self.model = model
        self.sku = sku


class AzureOpenAIModel(_serialization.Model):
    """Model information for Azure OpenAI Deployment.

    All required parameters must be populated in order to send to server.

    :ivar format: Format of the model, defaults to OpenAI. Required.
    :vartype format: str
    :ivar name: Name of the model, eg. gpt-35-turbo, gpt-4. Required.
    :vartype name: str
    :ivar version: Version of the model. Required.
    :vartype version: str
    """

    _validation = {
        "format": {"required": True},
        "name": {"required": True},
        "version": {"required": True},
    }

    _attribute_map = {
        "format": {"key": "format", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "version": {"key": "version", "type": "str"},
    }

    def __init__(self, *, name: str, version: str, **kwargs: Any) -> None:
        """
        :keyword format: Format of the model, defaults to OpenAI. Required.
        :paramtype format: str
        :keyword name: Name of the model, eg. gpt-35-turbo, gpt-4. Required.
        :paramtype name: str
        :keyword version: Version of the model. Required.
        :paramtype version: str
        """
        super().__init__(**kwargs)
        self.format = "OpenAI"
        self.name = name
        self.version = version


class AzureOpenAISku(_serialization.Model):
    """Sku informatioin for Azure OpenAI Deployment.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar name: name of the SKU, defaults to 'standard'. Required.
    :vartype name: str
    :ivar capacity: Token RPM of the deployment. Required.
    :vartype capacity: int
    """

    _validation = {
        "name": {"required": True},
        "capacity": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "capacity": {"key": "capacity", "type": "int"},
    }

    def __init__(self, *, capacity: int, **kwargs: Any) -> None:
        """
        :keyword name: name of the SKU, defaults to 'standard'. Required.
        :paramtype name: str
        :keyword capacity: Token RPM of the deployment. Required.
        :paramtype capacity: int
        """
        super().__init__(**kwargs)
        self.name = "Standard"
        self.capacity = capacity


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, *, type: Optional[str] = None, info: Optional[Any] = None, **kwargs: Any) -> None:
        """
        :keyword type: The additional info type.
        :paramtype type: str
        :keyword info: The additional info.
        :paramtype info: any
        """
        super().__init__(**kwargs)
        self.type = type
        self.info = info


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.ai.resources.autogen.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.ai.resources.autogen.models.ErrorAdditionalInfo]
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        target: Optional[str] = None,
        details: Optional[List["_models.ErrorDetail"]] = None,
        additional_info: Optional[List["_models.ErrorAdditionalInfo"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword code: The error code.
        :paramtype code: str
        :keyword message: The error message.
        :paramtype message: str
        :keyword target: The error target.
        :paramtype target: str
        :keyword details: The error details.
        :paramtype details: list[~azure.ai.resources.autogen.models.ErrorDetail]
        :keyword additional_info: The error additional info.
        :paramtype additional_info: list[~azure.ai.resources.autogen.models.ErrorAdditionalInfo]
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details
        self.additional_info = additional_info


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations.

    :ivar error: The error object.
    :vartype error: ~azure.ai.resources.autogen.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.ai.resources.autogen.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.ai.resources.autogen.models.CreatedByType
    :ivar created_at: The type of identity that created the resource.
    :vartype created_at: str
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.ai.resources.autogen.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: str
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "str"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "str"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[str] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.ai.resources.autogen.models.CreatedByType
        :keyword created_at: The type of identity that created the resource.
        :paramtype created_at: str
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.ai.resources.autogen.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: str
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at

class AzureOpenAIDeploymentListResult(_serialization.Model):
    """The response of a AzureOpenAIDeployment list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The AzureOpenAIDeployment items on this page. Required.
    :vartype value: list[~azure.ai.resources.autogen.models.AzureOpenAIDeployment]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AzureOpenAIDeployment]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.AzureOpenAIDeployment"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The AzureOpenAIDeployment items on this page. Required.
        :paramtype value: list[~azure.ai.resources.autogen.models.AzureOpenAIDeployment]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link