/*
 * Copyright (C) 2022 ~ 2024 Deepin Technology Co., Ltd.
 *
 * Author:     xupeidong <xupeidong@uniontech.com>
 *
 * Maintainer: xupeidong <xupeidong@uniontech.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef WATERMARK_H
#define WATERMARK_H

#include <QWidget>
#include <QDBusContext>
#include <QSet>
#include <QLoggingCategory>

Q_DECLARE_LOGGING_CATEGORY(WATERMARK)

#define FORMAT_HORIZONTAL 1
#define FORMAT_LEAN 2

class Watermark : public QWidget, protected QDBusContext
{
    Q_OBJECT

public:
    explicit Watermark(bool active, QWidget *parent = 0);
    ~Watermark();

    enum DisplayOrder {
        displayCustom = 0,
        displayUser,
        displayHost,
        displayTerminal,
        displayTime,
        displayIp,
        displayMac,
    };

protected:
    void paintEvent(QPaintEvent *event);

public:
    void setWaterMarkGeometry(int x, int y, int width, int height);
    void setCompositorActive(bool active) {
    	m_compositorActive = active;
    }
    void compositingSetup();
    bool watermarkOpen();
    bool lockFrontStatus();
    void clearConfig();
    bool isValidInvoker(const uint &pid);
    void updateVisable();
private:
    void writeConfig();
    void readConfig();
    void refreshWindow();
    QString getCustomContent() const;
    QString jsonAutoTest() const;
    int calculateCoordinate(const int &index, const int &textWidth, const int &hSpace);

private:
    QString m_fontFamily;
    int m_x;
    int m_y;
    int m_screenWidth;
    int m_screenHeight;
    int m_primaryScreenWidth{0};
    int m_primaryScreenHeight{0};
    QTimer *m_getDesktopStatusTimer{nullptr};
    bool m_isOpenScreenSaver{false};

    bool m_isX11Server{false};
    bool m_watermarkStatus{false};
    QTimer *m_currentTime{nullptr};
    QPainter *m_painter{nullptr};
    bool m_compositorActive{false};
    QSet<QString> m_whiteProcess;
    QMap<int, int> m_redisplayOrder;
    QMap<int, int> m_displayOrder;

    bool m_lockFrontStatus{false}; // com.deepin.dde.lockFront
    bool m_shutDownFrontStatus{false}; // com.deepin.dde.shutdownFront, Maybe not necessary?
    bool m_lockPropertyStatus{false}; // com.deepin.SessionManager, Maybe not necessary?
    bool m_isOpen{false}; // set by `setScreenWatermark`
    QString m_content{""};
    bool m_showTime{false};
    QString m_currentTimeString{""};
    int m_fontSize{11};
    int m_transparency{50};
    int m_density{5};
    int m_fontFormate{FORMAT_LEAN};

    bool m_showUsrName{false};
    QString m_usrName{""};
    bool m_showHostName{false};
    QString m_hostName{""};
    bool m_showTerminalAliasName{false};
    QString m_terminalAliasName{""};
    bool m_showIpAddress{false};
    QString m_ipAddress{""};
    bool m_showMacAddress{false};
    QString m_macAddress{""};
    QImage m_buffer;

public Q_SLOTS:
    void setScreenWatermark(const QString &strPolicy);
    bool watermarkStatus() const;
private Q_SLOTS:
    void initConfig();
    void onlockFrontStatusChanged(bool visible);
    void onShutdownFrontVisibleChanged(bool visible);
    void fontChanged(const QString &fontType, const QString &fontName);
    void updateTime();
    void displayProperty(QString type, QVariantMap map, QStringList list);
    void LockProperty(QString type, QVariantMap map, QStringList list);
};

#endif // WATERMARK_H
