/*
 * Copyright (C) 2023 ~ 2023 Deepin Technology Co., Ltd.
 *
 * Author:     zhangyu <zhangyud@uniontech.com>
 *
 * Maintainer: zhangyu <zhangyud@uniontech.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef DEEPIN_WATER_MARK_DBUS_H
#define DEEPIN_WATER_MARK_DBUS_H

#include <QDBusContext>

class DeepinWatermarkDbus : public QObject, protected QDBusContext
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "com.deepin.watermark")

public:
    explicit DeepinWatermarkDbus();
    ~DeepinWatermarkDbus();

public Q_SLOTS:
    void freeScreenWatermark();
    void setScreenWatermark(const QString &strPolicy);
    bool watermarkStatus();

private:
    void loadWaterMarkSo();
    void freeWaterMarkSo();
    void setStartUpStatus(bool flag);

public:
    void *handle = nullptr;
    uint invokerPid = 0;
};

#endif