# CiviCRM 5.3.0

Released July 3, 2018

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| **Require attention to configuration options?**                 | **yes** |
| Fix problems installing or upgrading to a previous version?     |   no    |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **[dev/accessibility#4](https://lab.civicrm.org/dev/accessibility/issues/4)
  Make alerts accessible
  ([12158](https://github.com/civicrm/civicrm-core/pull/12158))**

  A new setting allows a site administrator to disable the automatic
  disappearance of alerts.

  In addition, alerts are denoted so that screen readers can provide audible
  notice.

- **Permit UI editing of custom data on other entities (here relationship_type)
  when enabled in an extension
  ([12128](https://github.com/civicrm/civicrm-core/pull/12128))**

- **[CRM-20565](https://issues.civicrm.org/jira/browse/CRM-20565) Better & more
  configurable dedupe lookups when adding a contact
  ([10341](https://github.com/civicrm/civicrm-core/pull/10341))**

  When saving a new contact if an existing contact was found with a similar last
  name saving the form would be blocked. This change makes it so that the
  settings for what to dedupe new contacts on are more robust and so that the by
  default new contacts are dedupped by first name, last name and email.

- **[dev/core#160](https://lab.civicrm.org/dev/core/issues/160) Import Progress
  bar polls server too often
  ([12252](https://github.com/civicrm/civicrm-core/pull/12252))**

  This change sets the interval at which the import progress bar polls the server
  to be 5s rather than 5ms to improve performance.

- **[CRM-21120](https://issues.civicrm.org/jira/browse/CRM-21120) Warn if no
  crypt functions available
  ([12215](https://github.com/civicrm/civicrm-core/pull/12215))**

  This change adds an alert when Mcrypt extension is not available.

- **[CRM-21821](https://issues.civicrm.org/jira/browse/CRM-21821) navigationMenu
  hook should take account of weight attributes
  ([11772](https://github.com/civicrm/civicrm-core/pull/11772))**

  This change makes it so that hook_civicrm_navigationMenu accepts a weight
  attribute for menu items and places menu items in the menu accordingly. If no
  weight is specified items are added to the end of the menu as they were prior
  to this change.

- **[dev/core#152](https://lab.civicrm.org/dev/core/issues/152) Remove
  AdvMulti-Select custom field type
  ([12267](https://github.com/civicrm/civicrm-core/pull/12267)) and
  ([12238](https://github.com/civicrm/civicrm-core/pull/12238))**

  This change removes the error thrown when the Advanced Multi-Select widget
  (which has been deprecated since 2014) was selected.

- **[dev/core#162](https://lab.civicrm.org/dev/core/issues/162) Use checksum to
  access user dashboard
  ([12254](https://github.com/civicrm/civicrm-core/pull/12254))**

  This change allows contacts to access the user dashboard from a checksum link
  ex: /civicrm/user?reset=1&id=<contact_id>&cs=<contact_checksum>

- **Auto-open tagset fields
  ([12248](https://github.com/civicrm/civicrm-core/pull/12248))**

  This change makes it so that when opening a tagset widget the first 10 tags
  appear in alphabetical order. Before this change the select2 would wait for
  the user to type before showing any results.

- **[CRM-21811](https://issues.civicrm.org/jira/browse/CRM-21811) Optimize
  advanced search by relationship with target group for reciprocal relationship
  types ([11732](https://github.com/civicrm/civicrm-core/pull/11732))**

  This change improves performance of the advanced search page when searching
  for reciprocal relationships.

- **[CRM-19948](https://issues.civicrm.org/jira/browse/CRM-19948) Store the
  Attachment uploader information
  ([11739](https://github.com/civicrm/civicrm-core/pull/11739))**

  This PR changes the Attachment API so that it saves the current logged in
  contact as the uploader of the file.

- **Upgrade Smarty to 2.6.31 to solve issues on PHP7.2
  ([208](https://github.com/civicrm/civicrm-packages/pull/208))**

  The Smarty templating engine has been updated.

- **ApiExplorer - Output short array syntax
  ([12108](https://github.com/civicrm/civicrm-core/pull/12108))**

  The API explorer now produces array syntax using square brackets rather than
  `array()`.

- **Extend fiscal year relative options to better match other periods
  ([12137](https://github.com/civicrm/civicrm-core/pull/12137))**

  Filters for fiscal year can now handle relative dates for previous single and
  multiple fiscal years.

- **Adjust creation of markup for Open Flash Chart
  ([11951](https://github.com/civicrm/civicrm-core/pull/11951))**

  This avoids problems that can be triggered in certain environments by the
  `<html>`, `<head>`, and `<title>` elements coming in a row within the chart
  markup.

- **Change custom contact ref groups selector to use select2
  ([12234](https://github.com/civicrm/civicrm-core/pull/12234))**

  The groups selector for limiting the contacts available to a contact reference
  custom field now uses a Select2 widget rather than a multiple-select element.

### CiviCase

- **Add inplace edit for timeline name
  ([12000](https://github.com/civicrm/civicrm-core/pull/12000))**

  The name of a case type timeline can now be edited from within the tab header
  of the timeline editing screen.

### CiviContribute

- **[dev/financial#12](https://lab.civicrm.org/dev/financial/issues/12) move
  soft credit item count to an object property so it can be modified via hook
  ([12011](https://github.com/civicrm/civicrm-core/pull/12011))**

  This makes it simpler for an extension to modify the hard-coded number of rows
  available for recording soft credits on a contribution.

### CiviMail

- **[dev/mail#11](https://lab.civicrm.org/dev/mail/issues/11) Add pre/post hook
  for CRM_Mailing_BAO_MailingJob
  ([12275](https://github.com/civicrm/civicrm-core/pull/12275))**

  This change adds a mailing job delete function with pre/post hooks.

### CiviMember

- **[dev/membership#2](https://lab.civicrm.org/dev/membership/issues/2) Add
  'membership start date' as an option when creating Scheduled Reminder based on
  Membership ([12114](https://github.com/civicrm/civicrm-core/pull/12114))**

  When setting up a scheduled reminder for a membership this change adds an
  option to send the scheduled reminder based on the "Membership Start Date".
  Additionally, when setting up a scheduled reminder for an event this change
  adds the options to schedule the reminder based on the "Registration Start
  Date" or "Registration End Date".

- **[dev/core#38](https://lab.civicrm.org/dev/core/issues/38) Recurring
  Contribution Information on Membership Modal
  ([11903](https://github.com/civicrm/civicrm-core/pull/11903) and
  [12203](https://github.com/civicrm/civicrm-core/pull/12203)**

  When viewing the details of a contact's membership, you can now see
  information about any recurring contribution series that auto-renews the
  membership rather than just the payments themselves.

### Backdrop integration

- **Backdrop - update styles for status messages
  ([12227](https://github.com/civicrm/civicrm-core/pull/12227))**

### Drupal integration

- **[dev/drupal#17](https://lab.civicrm.org/dev/drupal/issues/17) Drupal8: Get
  UF locale/language is not supported (ex: for inheritLocale)
  ([12139](https://github.com/civicrm/civicrm-core/pull/12139))**

  This adds support for inheriting a user's language from the CMS on a Drupal 8
  site.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **[CRM-21816](https://issues.civicrm.org/jira/browse/CRM-21816) Relative dates
  in searches cause some other conditions to be ignored
  ([11737](https://github.com/civicrm/civicrm-core/pull/11737))**

- **[dev/core#43](https://lab.civicrm.org/dev/core/issues/43) Google geocoding
  now seems to require an API key, settings page text needs update
  ([12188](https://github.com/civicrm/civicrm-core/pull/12188))**

- **[dev/core#127](https://lab.civicrm.org/dev/core/issues/127) Smart Group
  incorrect counts ([12255](https://github.com/civicrm/civicrm-core/pull/12255)
  and [12249](https://github.com/civicrm/civicrm-core/pull/12249))**

- **Re-instate Dedupe limit functionality & fix select toggle functionality
  ([12305](https://github.com/civicrm/civicrm-core/pull/12305))**

  This change fixes two bugs when deduping contacts. First, it makes sure that
  the limit parameter passed in the url is respected and second, it makes sure
  the criteria parameter passed in the url is respected.

- **Fix non-display of conflicts after batch dedupe from dedupe screen
  ([12193](https://github.com/civicrm/civicrm-core/pull/12193))**

  This change fixes a bug where if a batch dedupe was run for all contacts (not
  'selected contacts only') conflicts were not displayed so that conflicts are
  displayed.

- **[dev/core#80](https://lab.civicrm.org/dev/core/issues/80)] Current Employer
  is not reset after relationship is updated
  ([12032](https://github.com/civicrm/civicrm-core/pull/12032))**

  Changing the relationship type for a current employer relationship would not
  remove the organization from being listed as the individual's current
  employer.

- **[CRM-20621](https://issues.civicrm.org/jira/browse/CRM-20621) manage tags:
  the tag usage count is not accurate
  ([12256](https://github.com/civicrm/civicrm-core/pull/12256)) (preliminary
  work)**

- **[CRM-21853](https://issues.civicrm.org/jira/browse/CRM-21853) Editing
  CustomGroup always sets is_multiple to false by default
  ([11877](https://github.com/civicrm/civicrm-core/pull/11877) and
  [12116](https://github.com/civicrm/civicrm-core/pull/12116)) and
  [12400](https://github.com/civicrm/civicrm-core/pull/12400))**

  When editing a custom data set in the API, the value of whether the set
  supports multiple values would be set to false when the `is_multiple`
  parameter was absent.  This is now resolved.

- **[dev/core#98](https://lab.civicrm.org/dev/core/issues/98) Searching by any
  Address fields with location type other than primary throw DB error
  ([12074](https://github.com/civicrm/civicrm-core/pull/12074))**

- **[dev/core#99](https://lab.civicrm.org/dev/core/issues/99) Search builder
  doesn't retain selected (boolean) option after searching
  ([12076](https://github.com/civicrm/civicrm-core/pull/12076))**

- **[CRM-20922](https://issues.civicrm.org/jira/browse/CRM-20922) Can't set
  default value via URL query string, for custom date fields
  ([11868](https://github.com/civicrm/civicrm-core/pull/11868))**

- **Fix e-notice ([12090](https://github.com/civicrm/civicrm-core/pull/12090))**

  This resolves a PHP notice that appears in some circumstances when a field
  does not specify a maximum length.

- **[dev/core#8](https://lab.civicrm.org/dev/core/issues/8) Fatal error on
  Print/Merge Document for Cases
  ([11936](https://github.com/civicrm/civicrm-core/pull/11936)) (completes prior
  work)**

- **Fix fatal error on logging tab when hook alters logging tables.
  ([12070](https://github.com/civicrm/civicrm-core/pull/12070))**

- **[dev/core#30](https://lab.civicrm.org/dev/core/issues/30) Exporting master
  address contact even if no master address contact is defined
  ([12004](https://github.com/civicrm/civicrm-core/pull/12004))**

- **Hide Adding Option Value for Locked Groups
  ([11962](https://github.com/civicrm/civicrm-core/pull/11962))**

  This resolves some places where it was possible to delete values for option
  groups that are locked.

- **dev/core#122 Wrong Action Links Shown for Reserved and Locked Option Groups
  ([12154](https://github.com/civicrm/civicrm-core/pull/12154))**

- **[dev/core#69](https://lab.civicrm.org/dev/core/issues/69)
  'state_province_name' token not working for alternate billing addresses
  ([12003](https://github.com/civicrm/civicrm-core/pull/12003))**

- **[CRM-21675](https://issues.civicrm.org/jira/browse/CRM-21675) scheduled
  reminders: limit to group doesn't support smart groups
  ([11629](https://github.com/civicrm/civicrm-core/pull/11629))**

  Smart groups and child groups now work as expected when limiting the
  recipients of scheduled reminders.

- **[CRM-21769](https://issues.civicrm.org/jira/browse/CRM-21769) Show
  unsupported locale for parsing warning only when when enabling address parsing
  ([11672](https://github.com/civicrm/civicrm-core/pull/11672))**

  This change improves the warning thrown when the Street Address Parsing
  setting is set to be an unsupported locale so that is is thrown when that
  change is made as opposed to anytime one goes to edit a street address.

- **[dev/report#4](https://lab.civicrm.org/dev/report/issues/4) CiviReports
  issue with boolean fields
  ([12382](https://github.com/civicrm/civicrm-core/pull/12382))**

  This change fixes a bug where contact and membership reports displayed all
  boolean fields (Deceased, Do Not Email, Do Not SMS, etc) as yes regardless of
  their actual values so that these reports show the correct data for those
  fields.

- **[CRM-20841](https://issues.civicrm.org/jira/browse/CRM-20841) Manual Merge -
  on_hold, is_bulkmail or signature information lost
  ([10630](https://github.com/civicrm/civicrm-core/pull/10630))**

  When deduping contacts, on the merge form, this change makes it so that the
  on_hold, bulkmail and signature status are displayed with the email address.
  If there is a difference between the statuses of the emails being deduped the
  email row is highlighted as a conflict.

- **Fix enotice when updating a custom group with is_multiple = 1
  ([12243](https://github.com/civicrm/civicrm-core/pull/12243))**

  This change fixes a bug where an e-notice was being thrown when updating a
  group with is_multiple = 1 so that no e-notice is thrown.

- **ensure that the indexed column is not an FK before deleting the index
  ([12241](https://github.com/civicrm/civicrm-core/pull/12241))**

  This change fixes a bug where when changing a custom field from searchable to
  not searchable, CiviCRM tries to remove the index. This causes a fatal error
  when the column is also a foreign key to another table because the index is
  needed for the foreign key so that civi checks if the column is not a foreign
  key before removing the index.

- **[dev/core#147](https://lab.civicrm.org/dev/core/issues/147) One of
  parameters is not of the type MysqlColumnNameOrAlias when using Non-ASCII
  display names. ([12226](https://github.com/civicrm/civicrm-core/pull/12226))**

  This change fixes a bug where using a display name for a location type with
  Non-ASCII text would result in a fatal error when searching using that
  location type.

- **[CRM-21553](https://issues.civicrm.org/jira/browse/CRM-21553) can not update
  primary location type field details if same field available for other location
  types ([11407](https://github.com/civicrm/civicrm-core/pull/11407))**

  This change fixes a bug where a profile could not include a primary email
  field (or any field that uses location types) and a email field of any other
  location type so that a profile can include two fields one with the location
  type Primary and one with a different location type.

- **[dev/core#149](https://lab.civicrm.org/dev/core/issues/149) Fatal Error on
  customvalue get api
  ([12225](https://github.com/civicrm/civicrm-core/pull/12225))**

  This change fixes a fatal error when running the customvalue get api.

- **Only set defaults when creating a custom field (not when editing one)
  ([12240](https://github.com/civicrm/civicrm-core/pull/12240))**

  This change fixes a bug where when editing a custom field any empty fields
  would revert to the default values so that they revert to what they were saved
  as (empty).

- **[dev/core#131](https://lab.civicrm.org/dev/core/issues/131) Add in missing
  UK shire Monmouthshire
  ([12168](https://github.com/civicrm/civicrm-core/pull/12168))**

  The Welsh county of Monmouthshire was missing from `civicrm_state_province`.

- **[CRM-21776](https://issues.civicrm.org/jira/browse/CRM-21776) DB Error when
  printing advanced search results sorted by custom field.
  ([11679](https://github.com/civicrm/civicrm-core/pull/11679))**

- **[dev/core#85](https://lab.civicrm.org/dev/core/issues/85) mail() backend
  fails when empty Cc and Bcc parameters are passed
  ([12036](https://github.com/civicrm/civicrm-core/pull/12036))**

- **[dev/core#116](https://lab.civicrm.org/dev/core/issues/116) Search builder
  searches on primary addresses are producing unexpected results
  ([12153](https://github.com/civicrm/civicrm-core/pull/12153))**

- **[dev/core#126](https://lab.civicrm.org/dev/core/issues/126) Soft Credit
  report redirect to Contribution Detail report doesn't filter contact id
  ([12172](https://github.com/civicrm/civicrm-core/pull/12172))**

  This resolves a regression in the basic report template where contact ID was
  no longer supported as a filter.

- **[dev/accessibility#3](https://lab.civicrm.org/dev/accessibility/issues/3)
  Add aria-label (and label?) to form elements missing them
  ([11944](https://github.com/civicrm/civicrm-core/pull/11944) and
  [12208](https://github.com/civicrm/civicrm-core/pull/12208)) (partial work)**

  This consolidates CMS-specific templates for including the page header and
  footer elements in each page.  It also adds the `aria-label` attribute to the
  datepicker date and time fields.

- **More robust managed entity deletion
  ([12021](https://github.com/civicrm/civicrm-core/pull/12021))**

  This resolves certain situations where managed entities created by an
  extension could be left orphaned in the database even after the extension is
  uninstalled.

- **[dev/core#143](https://lab.civicrm.org/dev/core/issues/143) Contact 'World
  Region' Field not functioning properly in Search Builder
  ([12214](https://github.com/civicrm/civicrm-core/pull/12214))**

- **[dev/core#142](https://lab.civicrm.org/dev/core/issues/142) States and
  Counties don't chain in Search Builder
  ([12213](https://github.com/civicrm/civicrm-core/pull/12213))**

- **[dev/core#155](https://lab.civicrm.org/dev/core/issues/155) Improvements and
  bugfixes to Option Groups UI
  ([12229](https://github.com/civicrm/civicrm-core/pull/12229)) (partially
  complete)**

  This resolves a bug where it was impossible to save an option value with a
  value of zero.

### CiviCase

- **getCaseRoles not working when supplied relationship id.
  civicrm_relationship table name changed to alias name rel because its changed
  in the actual query
  ([12245](https://github.com/civicrm/civicrm-core/pull/12245))**

  This change fixes a bug in the getCaseRoles function so it works properly when
  supplied a relationship id

- **[CRM-21598](https://issues.civicrm.org/jira/browse/CRM-21598) Case Activity
  issues with custom Completed Status Type.
  ([11456](https://github.com/civicrm/civicrm-core/pull/11456))**

  Activities with custom statuses that have a "completed" status type were
  treated as incomplete in the display of case activities and the treatment of a
  case sequence.

### CiviContribute

- **[dev/core#35](https://lab.civicrm.org/dev/core/issues/35) avoid template
  variable leakage when processing more than one recurring contribution in a
  session ([12175](https://github.com/civicrm/civicrm-core/pull/12175))**

  Soft credits and other values for a recurring contribution would get picked up
  by recurring contributions processed later in the same process.

- **Payflow Pro not payflo
  ([12083](https://github.com/civicrm/civicrm-core/pull/12083))**

  This standardizes the spelling of "PayFlow Pro" in error messages and code
  comments.

- **[dev/core#105](https://lab.civicrm.org/dev/core/issues/105) Manage PCP URL
  Wrong for the notification email under wordpress
  ([12093](https://github.com/civicrm/civicrm-core/pull/12093))**

  The notification for administrators to manage a newly-created personal
  campaign page would link to the front end in Joomla and WordPress sites.

- **Fix issue where non numeric number was encounted in running unit test...
  ([12156](https://github.com/civicrm/civicrm-core/pull/12156))**

- **[dev/financial#14](https://lab.civicrm.org/dev/financial/issues/14) PayPal
  Express recurring payment causes warning messages
  ([12171](https://github.com/civicrm/civicrm-core/pull/12171)) (preliminary
  work)**

- **[dev/financial#16](https://lab.civicrm.org/dev/financial/issues/16) Paypal
  unreliable getting payment processor type
  ([12174](https://github.com/civicrm/civicrm-core/pull/12174)) (preliminary
  work)**

- **[dev/core#139](https://lab.civicrm.org/dev/core/issues/139) Contribution
  Details Report throws DB error When trying to filter by soft_credit_type but
  not including soft credits
  ([12205](https://github.com/civicrm/civicrm-core/pull/12205))**

- **[dev/core#211](https://lab.civicrm.org/dev/core/issues/211) Fix mis-allocation of financial transactions when editing payment method on a completed payment ([12409] https://github.com/civicrm/civicrm-core/pull/12409))**
  

### CiviEvent

- **[dev/core#108](https://lab.civicrm.org/dev/core/issues/108) unable to create
  new event location without impacting other events
  ([12104](https://github.com/civicrm/civicrm-core/pull/12104))**

- **[dev/core#185](https://lab.civicrm.org/dev/core/issues/185) “Print selected
  rows” option missing in Event Participant listing dropdown actions
  ([12326](https://github.com/civicrm/civicrm-core/pull/12326))**

  This change fixes a bug where when a user ran a search for Event Participants
  and then checked some rows the "Print selected rows" option was not showing so
  that the "Print selected rows" option shows as expected.

- **[dev/core#68](https://lab.civicrm.org/dev/core/issues/68) DB Error on 'Find
  Participant' page when MySQL `FULL_GROUP_BY_MODE` is enabled
  ([11996](https://github.com/civicrm/civicrm-core/pull/11996))**

- **[dev/core#74](https://lab.civicrm.org/dev/core/issues/74) 'Price Set Details
  for Event Participants' gives DB error if the price fields are disabled.
  ([12024](https://github.com/civicrm/civicrm-core/pull/12024)) (resolved for
  some situations)**

- **[dev/core#123](https://lab.civicrm.org/dev/core/issues/123) Import -
  Participant - Custom participant date fields are not formatted
  ([12159](https://github.com/civicrm/civicrm-core/pull/12159))**

### CiviMail

- **only add a closing quote if it is not already present
  ([12182](https://github.com/civicrm/civicrm-core/pull/12182))**

  This resolves a bug where CiviMail would add a quote character at the end of
  link URLs too aggressively.

- **[dev/core#163](https://lab.civicrm.org/dev/core/issues/163) Disabled Groups
  used for mailings block access to mailing reports
  ([12277](https://github.com/civicrm/civicrm-core/pull/12277)) and
  ([12259](https://github.com/civicrm/civicrm-core/pull/12259))**

  This change fixes a bug where When a group that was used to send a mailing is
  disabled, access to the past mailing was blocked because mailingACLIDs only
  checked for enabled groups.

- **[dev/mail#12](https://lab.civicrm.org/dev/mail/issues/12) Incorrect Total
  Count on mail summary report
  ([12247](https://github.com/civicrm/civicrm-core/pull/12247))**

  This change fixes a bug where the Mail Summary Report "Total Opens" field was
  showing the open count for all mailings so that it shows the open count for
  only the corresponding mailing.

### CiviMember

- **Removing related memberships if parent membership type is changed which does
  not have relation type associated.
  ([12180](https://github.com/civicrm/civicrm-core/pull/12180))**

  If you change a membership with inherited members to a type that does not
  allow inherited memberships, the inherited memberships are now completely
  deleted.

- **[dev/core#154](https://lab.civicrm.org/dev/core/issues/154) Can't edit
  related records when current employer has a pending membership
  ([12266](https://github.com/civicrm/civicrm-core/pull/12266))**

  This change fixes a bug where creating a relationship thru which a contact
  should inherit a membership to a contact with a pending membership resulted in
  a fatal error so that the relationship is saved successfully.

- **[CRM-21632](https://issues.civicrm.org/jira/browse/CRM-21632)
  {membership.fee} prints out in documents with 9 decimal places
  ([12196](https://github.com/civicrm/civicrm-core/pull/12196))**

- **[dev/core#100](https://lab.civicrm.org/dev/core/issues/100) Membership
  Detail report throw DB error
  ([12094](https://github.com/civicrm/civicrm-core/pull/12094))**

  If ACLs are enabled, a fatal error would appear when running the membership
  detail report due to the ACLs being applied twice.

- **Support hooks for MembershipType entity
  ([11908](https://github.com/civicrm/civicrm-core/pull/11908))**

  The `hook_civicrm_pre` and `hook_civicrm_post` hooks are now invoked when
  creating or editing a membership type.

## <a name="misc"></a>Miscellany

- **Function extraction (Move towards generic custom data support for all
  entities) ([12095](https://github.com/civicrm/civicrm-core/pull/12095))**

- **tpl extraction of shared code for customDataBlock
  ([12122](https://github.com/civicrm/civicrm-core/pull/12122))**

- **Strip trailing whitespace in quickform package
  ([209](https://github.com/civicrm/civicrm-packages/pull/209))**

- **(NFC) Update karma conf for more recent karma
  ([12087](https://github.com/civicrm/civicrm-core/pull/12087))**

- **(NFC) Change use createMock in tests otherwise stick with getMock to fix
  deprecated warning...
  ([12086](https://github.com/civicrm/civicrm-core/pull/12086))**

- **Run master tests using phpunit5
  ([12084](https://github.com/civicrm/civicrm-core/pull/12084))**

- **Upgrade Karma phantomjs launcher to latest version
  ([12101](https://github.com/civicrm/civicrm-core/pull/12101))**

- **Fix Relationship Type form to use the metadata for fields & api in
  postProcess ([12097](https://github.com/civicrm/civicrm-core/pull/12097))**

- **karma.conf.js - Switch singleRun back to `false` default
  ([12105](https://github.com/civicrm/civicrm-core/pull/12105))**

- **(NFC) Fix use of undefined constant USD in MoneyTest
  ([12102](https://github.com/civicrm/civicrm-core/pull/12102))**

- **Preliminary cleanup for Custom data support for MembershipType form
  ([12126](https://github.com/civicrm/civicrm-core/pull/12126))**

- **[NFC] Fix leakage of Form entity
  ([12125](https://github.com/civicrm/civicrm-core/pull/12125))**

- **Preliminary tidy up of  MembershipType form (towards custom data support)
  ([12123](https://github.com/civicrm/civicrm-core/pull/12123))**

- **Add field metadata to MembershipType schema info (xml)
  ([12124](https://github.com/civicrm/civicrm-core/pull/12124))**

- **Set Default values on is_active, is_searchable, is_view and is_active...
  ([12131](https://github.com/civicrm/civicrm-core/pull/12131))**

  This modifies the XML to define these columns' defaults on
  `civicrm_custom_field`.

- **Use getter function for entity id as on some forms  is protected.
  ([12127](https://github.com/civicrm/civicrm-core/pull/12127))**

- **(NFC) Disable tests performing quick search with no orderby as provin...
  ([12136](https://github.com/civicrm/civicrm-core/pull/12136))**

- **(NFC) Update to latest versions of karma and jasmine used only in tes...
  ([12130](https://github.com/civicrm/civicrm-core/pull/12130))**

- **[NFC] Cleanup on ActivityTest class.
  ([12106](https://github.com/civicrm/civicrm-core/pull/12106))**

- **Add labels to membership type metadata, allowing for addField method to be
  used ([12132](https://github.com/civicrm/civicrm-core/pull/12132))**

- **(NFC) Update view issues and report bugs link in footer to point to the lab
  ([12103](https://github.com/civicrm/civicrm-core/pull/12103))**

- **added unit test
  ([12135](https://github.com/civicrm/civicrm-core/pull/12135))**

- **Fix file perms on files back to 664
  ([12141](https://github.com/civicrm/civicrm-core/pull/12141))**

- **[dev/core#117](https://lab.civicrm.org/dev/core/issues/117) Remove usage of
  each() This is deprecated in php7.2
  ([12155](https://github.com/civicrm/civicrm-core/pull/12155),
  [12165](https://github.com/civicrm/civicrm-core/pull/12165),
  [12166](https://github.com/civicrm/civicrm-core/pull/12166),
  [12167](https://github.com/civicrm/civicrm-core/pull/12167),
  [12170](https://github.com/civicrm/civicrm-core/pull/12170),
  [12189](https://github.com/civicrm/civicrm-core/pull/12189),
  [12199](https://github.com/civicrm/civicrm-core/pull/12199),
  [12201](https://github.com/civicrm/civicrm-core/pull/12201),
  [12202](https://github.com/civicrm/civicrm-core/pull/12202), and
  [12210](https://github.com/civicrm/civicrm-core/pull/12210))**

- **[dev/core#130](https://lab.civicrm.org/dev/core/issues/130) create_function
  is deprecated in php7.2
  ([12164](https://github.com/civicrm/civicrm-core/pull/12164))**

- **[dev/core#118](https://lab.civicrm.org/dev/core/issues/118) Fix where
  count() is used on an object that isn't an array nor implements Countable for
  php7.2 (tested instances)
  ([12162](https://github.com/civicrm/civicrm-core/pull/12162),
  [12163](https://github.com/civicrm/civicrm-core/pull/12163) and
  [12146](https://github.com/civicrm/civicrm-core/pull/12146))**

- **Remove pass by reference for some mailing functions
  ([12157](https://github.com/civicrm/civicrm-core/pull/12157))**

- **Update variable name as per upgraded Mime_mail package to support PHP7.2
  ([12169](https://github.com/civicrm/civicrm-core/pull/12169))**

- **Add utils for finding nested array items
  ([12187](https://github.com/civicrm/civicrm-core/pull/12187))**

- **[dev/core#135](https://lab.civicrm.org/dev/core/issues/135) Non Numeric
  value encountered in CRM_Batch_Form_entryTest on PHP7.1 and 7.2
  ([12190](https://github.com/civicrm/civicrm-core/pull/12190) and
  [12191](https://github.com/civicrm/civicrm-core/pull/12191))**

- **[NFC] code changes for export with merge household
  ([12177](https://github.com/civicrm/civicrm-core/pull/12177))**

- **[NFC] test clean up.
  ([12204](https://github.com/civicrm/civicrm-core/pull/12204))**

- **Further additional utility function for handling odd array structure
  ([12192](https://github.com/civicrm/civicrm-core/pull/12192))**

- **[dev/core#128](https://lab.civicrm.org/dev/core/issues/128) Add deprecated
  warning helper function
  ([12216](https://github.com/civicrm/civicrm-core/pull/12216))**

- **Remove inheritance of MembershipConfig form from MembershipStatus form.
  ([12184](https://github.com/civicrm/civicrm-core/pull/12184))**

- **[NFC] minor function tidy up - stop using  $ids array
  ([12206](https://github.com/civicrm/civicrm-core/pull/12206))**

- **Fix re-delcare issue
  ([12222](https://github.com/civicrm/civicrm-core/pull/12222))**

- **Code cleanup on export
  ([12212](https://github.com/civicrm/civicrm-core/pull/12212))**

- **Add api testing / custom data support for MailingJob.
  ([12221](https://github.com/civicrm/civicrm-core/pull/12221))
  ([12399](https://github.com/civicrm/civicrm-core/pull/12399))**

- **Move upgrade message to right file
  ([12242](https://github.com/civicrm/civicrm-core/pull/12242))**

- **Preliminary tidy up on PriceSet form.
  ([12211](https://github.com/civicrm/civicrm-core/pull/12211))**

- **[CRM-21111](https://issues.civicrm.org/jira/browse/CRM-21111) getActivities
  cleanup ([10909](https://github.com/civicrm/civicrm-core/pull/10909))**

- **[CRM-20459](https://issues.civicrm.org/jira/browse/CRM-20459) Actively
  deprecate CRM_Core_OptionGroup::getValue
  ([12092](https://github.com/civicrm/civicrm-core/pull/12092),
  [12075](https://github.com/civicrm/civicrm-core/pull/12075), and
  [12050](https://github.com/civicrm/civicrm-core/pull/12050))**

- **Improve CRM_Utils_Array::recursiveBuild to work with existing arrays.
  ([12293](https://github.com/civicrm/civicrm-core/pull/12293))**

- **Fix incorrect operator on previous Export fix
  ([12278](https://github.com/civicrm/civicrm-core/pull/12278))**

- **Accessibility #9: Regression - js error due to alertDismissal setting fixed.
  ([12265](https://github.com/civicrm/civicrm-core/pull/12265))**

- **Fix unreleased regression - fatal when editing relationship type Employer
  ([12257](https://github.com/civicrm/civicrm-core/pull/12257))**

- **Add 'Alphanumeric' rule type
  ([12258](https://github.com/civicrm/civicrm-core/pull/12258))**

- **(NFC) fix file permissions on civicrm-version.php
  ([12140](https://github.com/civicrm/civicrm-core/pull/12140))**

- **[dev/drupal#10](https://lab.civicrm.org/dev/drupal/issues/10) Keep
  `civicrm-version.php` up-to-date without running GenCode on all builds
  ([12113](https://github.com/civicrm/civicrm-core/pull/12113))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Andie Hunt; Agileware - Alok Patel; applicado; Australian
Greens - Seamus Lee; Blackfly Solutions - Alan Dixon; CEDC - Laryn Kragt Bakker;
Chris Burgess; CiviCRM - Coleman Watts, Tim Otten; CiviDesk - Sunil Pawar,
Yashodha Chaku; CompuCorp - Camilo Rodriguez, Davi Alexandre, Debarshi Bhaumik,
Michael Devery, Omar Abu Hussein, Vinu Varshith Sekar; Coop SymbioTIC - Samuel
Vanhove; Fuzion - Jitendra Purohit; Hossein Amin; JMA Consulting - Monish Deb;
Joinery - Allen Shaw; Left Join Labs - Sean Madsen; Lighthouse Design and
Consulting - Brian Shaughnessy; MJW Consulting - Matthew Wire; Oxfam Germany -
Thomas Schüttler; Pradeep Nayak; Progressive Technology Project - Jamie
McClelland; Squiffle Consulting - Aidan Saunders; Tadpole Collective - Kevin
Cristiano; Third Sector Design - Michael McAndrew; Wikimedia Foundation - Eileen
McNaughton; Wildsight - Lars Sanders-Green; Will Long

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

Agileware - Justin Freeman; Alan Puccinelli; Aniessh Sethh; BackOffice Thinking -
Hassan Farooq; CiviCoop - Erik Hommel; Donald Hirst; Hudson-Essex-Terraplane
Club - Paul Butler; Jens Schuppe; JMA Consulting - Joe Murray; Megaphone
Technology Consulting - Jon Goldberg; MikeyMJCO; Phil McKerracher; Richard van
Oosterhout; Samson Alajede; Skvare - Mark Hanna; Tech To The People - Xavier
Dutoit

## <a name="feedback"></a>Feedback

These release notes are edited by Alice Frumin and Andie Hunt.  If you'd like
to provide feedback on them, please login to https://chat.civicrm.org/civicrm
and contact `@agh1`.
