/*
 * Copyright (C) 2024 Uniontech Technology Co., Ltd.
 *
 * Author:     liuzheng <liuzheng@uniontech.com>
 *
 * Maintainer: liuzheng <liuzheng@uniontech.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "clipdata.h"
#include "clipdataproperty.h"
#include "clipdatarecord.h"

ClipData::ClipData()
{
    m_propertys = nullptr;
    m_enable = false;
}

ClipData::~ClipData()
{
    clear();
}

int ClipData::getRecordCount()
{
    return (int)m_listrecorddata.size();
}

string ClipData::getRecordMimeType(int index)
{
    if (index < m_listrecorddata.size()) {
        return m_listrecorddata[index]->getMimeType();
    }
    return string();
}

ClipDataRecord *ClipData::getRecordAt(int index)
{
    if (index < m_listrecorddata.size()) {
        return m_listrecorddata[index];
    }
    return nullptr;
}

void ClipData::removeRecordAt(int index)
{
    if (index < m_listrecorddata.size()) {
        delete m_listrecorddata[index];
        m_listrecorddata[index] = nullptr;
        m_listrecorddata.erase(m_listrecorddata.begin() + index);
    }
}

ClipDataRecord *ClipData::createRecordData()
{
    ClipDataRecord *t_data = new ClipDataRecord();
    m_listrecorddata.push_back(t_data);
    return t_data;
}

int ClipData::addRecordData(ClipDataRecord *_data)
{
    m_listrecorddata.push_back(_data);
    return m_listrecorddata.size() - 1;
}

vector<string> ClipData::getMimeTypes()
{
    vector<string> t_MimeData;

    for (size_t i = 0; i < m_listrecorddata.size(); i++) {
        /* code */
        t_MimeData.push_back(m_listrecorddata[i]->getMimeType());
    }

    return t_MimeData;
}

ClipDataProperty *ClipData::getProperty()
{
    return m_propertys;
}

void ClipData::setProperty(ClipDataProperty *propetry)
{
    m_propertys = propetry;
}

bool ClipData::getDataState()
{
    return m_enable;
}

void ClipData::setDataState(bool flag)
{
    m_enable = flag;
}

void ClipData::clear()
{
    if (m_propertys != NULL) {
        delete m_propertys;
        m_propertys = nullptr;
    }
    for (int i = 0; i < m_listrecorddata.size(); i++) {
        delete m_listrecorddata[i];
        m_listrecorddata[i] = nullptr;
    }
    m_listrecorddata.clear();
}

void ClipData::save(ofstream &file)
{
    // 写入数据类型的长度和内容
    int len = m_name.size();
    file.write((char *)&len, sizeof(int));
    file.write(m_name.c_str(), len);

    // 写入数据状态
    file.write((char *)&m_enable, sizeof(bool));

    // 写入属性数据
    m_propertys->save(file);

    // 写入记录数据的数量
    int count = getRecordCount();
    file.write((char *)&count, sizeof(int));

    // 遍历每个记录数据对象，并调用其save方法将其写入文件
    for (int i = 0; i < count; i++) {
        ClipDataRecord *record = getRecordAt(i);
        record->save(file);
    }
}

void ClipData::load(ifstream &file)
{

    int len = 0;
    file.read((char *)&len, sizeof(int));
    char *datatype = new char[len + 1];
    file.read(datatype, len);
    datatype[len] = '\0';
    m_name = string(datatype);

    // 读取数据状态
    file.read((char *)&m_enable, sizeof(bool));

    m_propertys = new ClipDataProperty();
    // 读取属性数据
    m_propertys->load(file);

    // 读取记录数据的数量
    int count = 0;
    file.read((char *)&count, sizeof(int));

    // 遍历每个记录数据对象，并调用其load方法将其从文件中读取
    for (int i = 0; i < count; i++) {
        ClipDataRecord *record = createRecordData();
        record->load(file);
    }
}

void ClipData::setName(string name)
{
    m_name = name;
}

string ClipData::getName()
{
    return m_name;
}
