/*
 * Copyright (C) 2020 Uniontech Technology Co., Ltd.
 *
 * Author:     xinbo wang <wangxinbo@uniontech.com>
 *
 * Maintainer: xinbo wang <wangxinbo@uniontech.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "mainwindow.h"
#include "ui_mainwindow.h"
#include "SecurityTool.h"

#include "dnd_security.h"

#include <QDebug>

MainWindow::MainWindow(QWidget *parent)
    : QMainWindow(parent)
    , ui(new Ui::MainWindow)
{
    m_security = new SecurityTool(this);

    ui->setupUi(this);

    ui->lineEdit_permission_copy->setPlaceholderText("请输入权限...");

    ui->label_current_permission->setText(m_security->permission() == PermissionAllow ? "当前授权：允许" : "当前授权：禁止");

    connect(ui->pushButton_permission_set, &QPushButton::clicked, this, &MainWindow::onSetNewPermission);
    connect(ui->pushButton_dump_security, &QPushButton::clicked, this, &MainWindow::onDumpSecurityInfo);
}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::onSetNewPermission()
{
    int permission = ui->lineEdit_permission_copy->text().toUInt();
    permission = m_security->setPermission(permission);
    if (permission < 0) {
        ui->label_current_permission->setText("当前授权：无效输入");
        return;
    }
    ui->label_current_permission->setText(permission == PermissionAllow ? "当前授权：允许" : "当前授权：禁止");
}

void MainWindow::onDumpSecurityInfo()
{
    ui->label_security_info->setText(m_security->dump());
}
