/*
* Copyright (C) 2019 ~ 2019 Deepin Technology Co., Ltd.
*
* Author: zhanglei <zhanglei_hlj@nfschina.com>
*
* Maintainer: zhanglei <zhanglei_hlj@nfschina.com>
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

#include "tableview.h"
#include <QDebug>
#include <QTableWidget>

TableView::TableView(int Flag)
    :QTableView ()
{
    table_mode=new TableViewModel(Flag);
    Table_Flag=Flag;
    initUI();
}
void TableView::initUI()
{
    this->setModel(table_mode);
    itemdegegate= new ItemDelegate(this,Table_Flag);
    this->setItemDelegate(itemdegegate);
    //this->setLineWidth(0);
    this->setFrameShape(QFrame::NoFrame);
    this->setMinimumWidth(636);
    this->setMouseTracking(true);

    //this->setMaximumWidth(2000);
    this->verticalHeader()->hide();
    //this->verticalHeader()->setDefaultSectionSize(56);
    HeaderView *my_headerView = new  HeaderView(Qt::Horizontal,this);
    connect(my_headerView,&HeaderView::get_stateChanged,this,&TableView::header_stateChanged);
    connect(this,&TableView::clear_header_check,my_headerView,&HeaderView::get_clear_header_check);
    connect(table_mode,&TableViewModel::tableView_allChecked_or_allUnchecked,this,&TableView::get_tableview_allchecked);
    connect(this,&TableView::get_tableview_allchecked,my_headerView,&HeaderView::get_checkall_signals);
    connect(this, &TableView::signal_hoverChanged, itemdegegate, &ItemDelegate::slot_hoverChanged);

    this->setHorizontalHeader(my_headerView);
    my_headerView->setDefaultSectionSize(20);
    my_headerView->setSortIndicatorShown(false);
    my_headerView->setDefaultAlignment( Qt::AlignVCenter|Qt::AlignLeft);
    this->setColumnWidth(0, 20);

    my_headerView->setSectionResizeMode(0, QHeaderView::Fixed);
    my_headerView->setSectionResizeMode(1, QHeaderView::Stretch);
    my_headerView->setSectionResizeMode(2, QHeaderView::Stretch);
    my_headerView->setSectionResizeMode(3, QHeaderView::Stretch);
    my_headerView->setSectionResizeMode(4, QHeaderView::Stretch);
    setSelectionBehavior(QAbstractItemView::SelectRows);
    setEditTriggers(QAbstractItemView::NoEditTriggers);
    //setSelectionMode(QAbstractItemView::ExtendedSelection);
    setVerticalScrollMode(QAbstractItemView::ScrollPerPixel);
    setHorizontalScrollMode(QAbstractItemView::ScrollPerPixel);
    setAlternatingRowColors(true);
    setShowGrid(false);

    setSelectionMode(QAbstractItemView::SingleSelection);


}
void TableView::initConnections()
{

}
void TableView::initTableView()
{

}
TableViewModel* TableView::get_tableViewModel()
{
    return table_mode;
}

void TableView::reset(bool switched)
{
    QModelIndex idx= this->selectionModel()->currentIndex();
    int size=QTableView::verticalScrollBar()->value();
    QTableView::reset();

    this->selectRow(idx.row());
    if(switched)
        size=0;
    QTableView::verticalScrollBar()->setValue(size);
}

void TableView::mousePressEvent(QMouseEvent *event)
{
    if(event->button()==Qt::LeftButton)
    {

          setCurrentIndex(QModelIndex());
           QTableView::mousePressEvent(event);
           QModelIndex index=currentIndex();
           if(index.row()<0&&index.column()<0)
               return;
    }

}
void TableView::mouseMoveEvent(QMouseEvent *event)
{
    QModelIndex idx = this->indexAt(event->pos());
    emit signal_hoverChanged(idx);
}

void TableView::leaveEvent(QEvent *event)
{
    this->reset();
    emit signal_hoverChanged(QModelIndex());
}
void TableView::keyPressEvent(QKeyEvent *event)
{
    if(event->modifiers()==Qt::ControlModifier&&event->key() == Qt::Key_C)
    {
        return;
    }
    QWidget::keyPressEvent(event);
}
