/* ====================================================================
 * Copyright (c) 2003-2008  Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_MAIN_WINDOW_H
#define _SC_MAIN_WINDOW_H

// sc
#include "DiffParam.h"
#include "DiffInfoModel.h"
#include "util/String.h"
class Diff;
class Diff3Widget;
class FileSelectDialog;
class ConfigManager;
class ActionStorage;
namespace sc {
  class Error;
}

// qt
#include <QtGui/QMainWindow>
class QToolButton;
class QLabel;


class MainWindow : public QMainWindow
{
  typedef QMainWindow super;
  Q_OBJECT 

public:
  MainWindow( ConfigManager*, QWidget *parent=0 );
  virtual ~MainWindow();

  Diff3Widget* getDiffWidget() const;

  const sc::Error* diff( const DiffParamPtr param );
  const sc::Error* diff3( const DiffParamPtr param );

  const sc::Error* save( const char* file );

  void setDiffCnt( int );
  void showOptions( bool whitespace );
  void showEncoding( const sc::String& );

  void showError( const sc::Error* error );

  void showEvent( QShowEvent* e );
  void closeEvent( QCloseEvent* e );

public slots:
  void open();
  void save();
  void saveAs();
  void settings();
  void about();

  void nextDiff();
  void prevDiff();
  void nextConflict();
  void prevConflict();
  void merge();
  void refresh();
  void whitespace(bool);

  void diffChanged(int diff);

  void oDropped( const QString& f );
  void mDropped( const QString& f );
  void lDropped( const QString& f );

private:
  FileDataPtr getEmptyFile();

  Diff3Widget*      _dw;
  QLabel*           _sbarDiffCnt;
  QLabel*           _sbarWhitespace;
  QLabel*           _sbarEncoding;
  QLabel*           _sbar4;

  ActionStorage*    _actions;

  FileSelectDialog* _file;
  ConfigManager*    _config;

  // diff
  DiffInfoModelPtr  _diffInfo;

  // last parameter set
  DiffParamPtr      _lastParam;
};


#endif // _SC_MAIN_WINDOW_H
