/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _LINETOKENIZER_H
#define _LINETOKENIZER_H

// sc
#include "Tokenizer.h"



class LineTokenizer : public Tokenizer
{
public:
  LineTokenizer();
  LineTokenizer( const unsigned char* buf, size_t size );
  LineTokenizer( const LineTokenizer& );

  bool nextToken( char** token, size_t* size );

private:
  const unsigned char* findLineEnd( const unsigned char* buf, size_t count );

  const unsigned char* _buf;
  size_t               _size;
};


/////////////////////////////////////////////////////////////////////

// sys
#include <iosfwd>


class LineTokenizer2 : public Tokenizer
{
public:
  LineTokenizer2( std::istream& in );
  ~LineTokenizer2();

  bool nextToken( char** token, size_t* size );

private:
  void clearToken();

  std::istream& _in;
  char*         _tokenbuf;
};


#endif //  _LINETOKENIZER_H

