## Description
[Tell us about your new feature, improvement, or fix! If relevant, please supplement the PR with images.]


## Checklist
[It's fine to submit PRs which are a work in progress! But before they are merged, all PRs should provide:]
- [ ] Clean style in [the spirit of PEP8](https://www.python.org/dev/peps/pep-0008/)
- [ ] [Docstrings for all functions](https://github.com/numpy/numpy/blob/master/doc/example.py)
- [ ] Gallery example in `./doc/examples` (new features only)
- [ ] Unit tests

[For detailed information on these and other aspects see [scikit-image contribution guidelines](http://scikit-image.org/docs/dev/contribute.html)]


## References
[If this is a bug-fix or enhancement, it closes issue # ]
[If this is a new feature, it implements the following paper: ]

## For reviewers

(Don't remove the checklist below.)

- [ ] Check that the PR title is short, concise, and will make sense 1 year
  later.
- [ ] Check that new functions are imported in corresponding `__init__.py`.
- [ ] Check that new features, API changes, and deprecations are mentioned in
      `doc/release/release_dev.rst`.
