% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/request_class.R
\docType{data}
\name{Request}
\alias{Request}
\title{The request of an HTTPInteraction}
\format{An object of class \code{R6ClassGenerator} of length 24.}
\usage{
Request
}
\arguments{
\item{method}{the HTTP method (i.e. :head, :options, :get, :post, :put,
:patch or :delete)}

\item{uri}{the request URI}

\item{body}{the request body}

\item{headers}{the request headers}
}
\description{
The request of an HTTPInteraction
}
\details{
\strong{Methods}
\describe{
\item{\code{to_hash()}}{
Get a hash from the class itself
}
\item{\code{from_hash()}}{
Create a \code{Request} class object from a hash
}
}
}
\examples{
url <- "https://eu.httpbin.org/post"
body <- list(foo = "bar")
headers <- list(
  `User-Agent` = "libcurl/7.54.0 r-curl/3.2 crul/0.5.2",
  `Accept-Encoding` = "gzip, deflate",
  Accept = "application/json, text/xml, application/xml, */*"
)

(x <- Request$new("POST", url, body, headers))
x$body
x$method
x$uri
x$host
x$path
x$headers
h <- x$to_hash()
x$from_hash(h)
}
\keyword{internal}
