% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tp_dist.R
\name{tp_dist}
\alias{tp_dist}
\title{Return all distribution records for for a taxon name with a given id.}
\usage{
tp_dist(id, key = NULL, ...)
}
\arguments{
\item{id}{the taxon identifier code}

\item{key}{Your Tropicos API key; See \code{\link{taxize-authentication}} 
for help on authentication}

\item{...}{Curl options passed on to \code{\link[crul]{HttpClient}}}
}
\value{
List of two data.frame's, one named "location", and one "reference".
}
\description{
Return all distribution records for for a taxon name with a given id.
}
\examples{
\dontrun{
# Query using a taxon name Id
out <- tp_dist(id = 25509881)
## just location data
head(out[['location']])
## just reference data
head(out[['reference']])
}
}
\references{
\url{http://services.tropicos.org/help?method=GetNameDistributionsXml}
}
