% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attr_access.R
\name{remove_branches_edgePar}
\alias{remove_branches_edgePar}
\title{Remove all edgePar values from a dendrogram's branches}
\usage{
remove_branches_edgePar(dend, ...)
}
\arguments{
\item{dend}{a dendrogram object}

\item{...}{not used}
}
\value{
A dendrogram, after removing the edgePar attribute in all of its branches,
}
\description{
Go through the dendrogram branches and remove its edgePar.
}
\examples{

\dontrun{

dend <- USArrests[1:5,] \%>\% dist \%>\% hclust \%>\% as.dendrogram
dend <- color_branches(dend, 3)
par(mfrow = c(1,2))
plot(dend)
plot(remove_branches_edgePar(dend))

}

}
\seealso{
\link{get_root_branches_attr}, \link{assign_values_to_branches_edgePar}
}
