# Getting help

You may encounter a problem when using guizero, so here are some ways you can get help to solve your problem.

### Getting help

If you have a question about your guizero program it is a good idea to join a community to ask for support:

* [Raspberry Pi Forums](https://www.raspberrypi.org/forums/viewforum.php?f=32&sid=b95bfdce6565681fad633c58a7e0e686) - some people post questions about guizero on these forums and other members of the community step in to help. The creators of guizero periodically check the Python forum.
* [Stack Overflow](https://stackoverflow.com/) - a popular site for techy questions
* [Computing at School](https://www.computingatschool.org.uk/) - a useful site for teachers

If you would like to read guides and resources for guizero there are many freely available:

- [Example programs](https://github.com/lawsie/guizero/tree/master/examples) - some example programs to get you going.

- [Using guizero with hardware](https://github.com/bennuttall/guizero-examples) - Ben Nuttall's projects using guizero combined with hardware

- [Getting started with GUIs](https://projects.raspberrypi.org/en/projects/getting-started-with-guis) - a beginners guide to guizero by the Raspberry Pi Foundation

- [Cat name generator](http://www.cotswoldjam.org/downloads/2017-03/cat-name-generator/) - materials for a kids workshop, first run at the [Cotswold Jam](http://www.cotswoldjam.org)

- [Name your pet](https://helloworld.raspberrypi.org/issues/2) - article on page 42 of [Hello World](https://helloworld.raspberrypi.org/) magazine issue 2.




### Bugs and feature requests

Like many Python libraries, guizero has a [GitHub repository](https://github.com/lawsie/guizero) where you can add issues. These issues come under two headings:

+ You found a bug in guizero
+ You would like to request we consider including a new feature

We look at and respond to all issues created on GitHub. However, we ask that you only create issues for bugs and feature requests, rather than support, as we do not have time to answer everything :)
