# ![OTB](https://gitlab.orfeo-toolbox.org/orfeotoolbox/otb/raw/master/Utilities/Doxygen/logoVectoriel.png) Orfeo Toolbox
## Open Source processing of remote sensing images

Orfeo ToolBox (OTB) is an open-source project for state-of-the-art remote
sensing. Built on the shoulders of the open-source geospatial community, it can
process high resolution optical, multispectral and radar images at the terabyte
scale. A wide variety of applications are available: from ortho-rectification
or pansharpening, all the way to classification, SAR processing, and much more!

All of OTB's algorithms are accessible from Monteverdi, QGIS, Python, the
command line or C++. Monteverdi is an easy to use visualization tool with an
emphasis on hardware accelerated rendering for high resolution imagery (optical
and SAR).  With it, end-users can visualize huge raw imagery products and
access all of the applications in the toolbox. From resource limited laptops
to high performance MPI clusters, OTB is available on Windows, Linux and Mac.
It is community driven, extensible and heavily documented.  Orfeo ToolBox is
not a black box!

[![Travis Build Status](https://travis-ci.org/orfeotoolbox/OTB.png?branch=develop)](https://travis-ci.org/orfeotoolbox/OTB)
[![Coverity Scan Build Status](https://scan.coverity.com/projects/2405/badge.svg)](https://scan.coverity.com/projects/orfeotoolbox)

### Resources
* [OTB's website](https://www.orfeo-toolbox.org/)
* [Documentation](https://www.orfeo-toolbox.org/documentation/)
* [Downloads](https://www.orfeo-toolbox.org/download/)
* [Public git repositories](https://gitlab.orfeo-toolbox.org/orfeotoolbox/otb)
* [GitHub mirror](https://github.com/orfeotoolbox/)
* [Build status](http://dash.orfeo-toolbox.org/index.php?project=OTB)
* [Bug tracker](https://gitlab.orfeo-toolbox.org/orfeotoolbox/otb/issues?label_name%5B%5D=bug)
* [Wiki](http://wiki.orfeo-toolbox.org/index.php/Main_Page)
* [Task tracking](https://gitlab.orfeo-toolbox.org/orfeotoolbox/otb/issues)

### Join the community
Get help, share your experience and contribute to the Orfeo-Toolbox project by
joining our community and mailing lists.

[https://www.orfeo-toolbox.org/community/](https://www.orfeo-toolbox.org/community/)

### Contributing
Please see [CONTRIBUTING.md](CONTRIBUTING.md) for contributors guidelines.

### License
Please see the license and the Copyright directory for legal issues on the use of the software.

### Issues
Please report any issue you might encouter to [our bugtracker](https://gitlab.orfeo-toolbox.org/orfeotoolbox/otb/issues?label_name%5B%5D=bug).

### Governance
The Orfeo ToolBox project is governed by the [Project Steering Committee](PSC.md) and its members.
