/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.contrib.html;

import java.awt.Color;
import java.io.IOException;
import java.io.Serializable;
import org.jhotdraw.contrib.html.ContentProducerContext;
import org.jhotdraw.contrib.html.FigureDataContentProducer;
import org.jhotdraw.util.StorableInput;
import org.jhotdraw.util.StorableOutput;

public class ColorContentProducer
extends FigureDataContentProducer
implements Serializable {
    private Color fColor = null;

    public ColorContentProducer() {
    }

    public ColorContentProducer(Color color) {
        this.setColor(color);
    }

    public Object getContent(ContentProducerContext contentProducerContext, String string, Object object) {
        Color color = this.getColor() != null ? this.getColor() : (Color)object;
        String string2 = Integer.toHexString(color.getRGB());
        return "0x" + string2.substring(string2.length() - 6);
    }

    public void setColor(Color color) {
        this.fColor = color;
    }

    public Color getColor() {
        return this.fColor;
    }

    public void write(StorableOutput storableOutput) {
        super.write(storableOutput);
        storableOutput.writeBoolean(this.getColor() != null);
        if (this.getColor() != null) {
            storableOutput.writeInt(this.getColor().getRGB());
        }
    }

    public void read(StorableInput storableInput) throws IOException {
        super.read(storableInput);
        boolean bl = storableInput.readBoolean();
        if (bl) {
            this.setColor(new Color(storableInput.readInt()));
        } else {
            this.setColor(null);
        }
    }
}

