### Prior Release Notes

Noto Sans CJK 2.003 Release Notes
April 8, 2021

Release Date: April 8, 2021.
Listed below are the changes that were made in this release:

* The copyright year was changed from “2014–2020” to “2014–2021.”
* All fonts have been built as variable fonts.
* The following JP glyphs have been adjusted to work better with the variable font format: 僎, 噵, 庚, 惺, 意, 摝, 摹, 撰, 暒, 栁, 樚, 漉, 潠, 煋, 牃, 猩, 瑆, 疲, 瘒, 瘼, 盬, 眔, 睲, 腥, 舞, 苨, 菫, 菷, 蔓, 蕁, 蕐, 蕒, 薑, 薥, 薨, 薯, 薰, 蘙, 虂, 蟇, 蟤, 譔, 蹙, 鄜, 醒, 鐉, 饌, 驀, 鬃, 鹿, 隆, 巽, 攇, 葺, 選, 櫶, 靌, 讒, 亴, 舞 
* The scale of glyphs in the intermediate weights (Light, Normal, Regular, Medium, Bold) has been adjusted slightly. 
* Fixed TW mapping for 𰻞 U+30EDE Issue [#280](https://github.com/adobe-fonts/source-han-sans/issues/280)
* Fixed incorrect mappings for 請 U+8ACB Issue [#276](https://github.com/adobe-fonts/source-han-sans/issues/276)
* Fixed Heavy weight for 𥱊 U+25C4A Issue [#283](https://github.com/adobe-fonts/source-han-sans/issues/283)
* Fixed the Heavy weight for 丈 U+4E08 from Issue [#207](https://github.com/adobe-fonts/source-han-sans/issues/207) which was not updated as previously noted.


Noto Sans CJK 2.002 Release Notes

November 3, 2020

Version 2.002

Release Date: Nov 3, 2020.
Listed below are the changes that were made in this release:
* The copyright year was changed from “2014–2019” to “2014–2020.”

* Addressed Issue [#207](https://github.com/adobe-fonts/source-han-sans/issues/207) including glyph changes to U+4E08 and U+5C83. Extension G encodings were added for U+30729, U+30EDD, U+30EDE, and U+3106C and the previous GSUB rules were removed.

* Updated Korean glyph for U+58C4 as reported in Source Han Serif Issue [#87](https://github.com/adobe-fonts/source-han-serif/issues/87)

* Addressed Issue [#204](https://github.com/adobe-fonts/source-han-sans/issues/204) for U+50E7, U+89E6, U+8FD0, U+9EA4, U+25C4A 

* Mapped HK U+5C13 尓 to JP glyph

* Fixed U+21B9 as reported in Issue [#260](https://github.com/adobe-fonts/source-han-sans/issues/260)

* Changed Korean mapping for U+51A4 as reported in Issue [#202](https://github.com/adobe-fonts/source-han-sans/issues/202)

* The weights for Kanbun glyphs U+3191–U+319F have been adjusted as mentioned in the table at the beginning of Issue [#205](https://github.com/adobe-fonts/source-han-sans/issues/205). 

* Fixed Korean IVS mapping for U+8ACB as reported in Issue [#276](https://github.com/adobe-fonts/source-han-sans/issues/276)


Noto Sans CJK 2.001 Release Notes

April 9, 2019

This is an update to Noto Sans CJK.

Changes

Version 2.001

Build Date: April 4, 2019. Built By: Dr. Ken Lunde (小林劍󠄁). Release Date: April 9, 2019.

Listed below are the changes that were made in this release:

* The copyright year was changed from “2014, 2015, 2018” to the range “2014–2019.”

* The placeholder (aka blank) glyphs for U+32FF ㋿, uni32FF-JP (CID+2184) and uni32FF-JP-V (CID+65359),
which is the code point that represents the two-ideograph square ligature form of the name of Japan’s
forthcoming new era, 令和 (reiwa), that takes effect on 2019-05-01, are now the actual glyphs. U+32FF will
be included in Unicode Version 12.1 (2019-05-07).

* All of the mapping changes that were made to the fonts in this release are provided in the table at the beginning of Issue [#202](https://github.com/adobe-fonts/source-han-sans/issues/202).

* All of the glyph corrections that were made to the fonts in this release are provided in the table at the beginning of Issue [#204](https://github.com/adobe-fonts/source-han-sans/issues/204).

* All of the glyphs that were redesigned in this release are provided in the table at the beginning of Issue [#205](https://github.com/adobe-fonts/source-han-sans/issues/205).

* The 45 glyphs that were added in this release, which replaced 45 of the 50 reserved glyphs, are provided in

the table at the beginning of Issue [#206](https://github.com/adobe-fonts/source-han-sans/issues/206). The glyphs are at CIDs 65485 through 65529. Two of the new glyphs
are mapped from code points that are now supported.

* Miscellaneous changes that were made in this release are provided in the table at the beginning of Issue [#207](https://github.com/adobe-fonts/source-han-sans/issues/207).

* The following 33 glyphs for ideographs are no longer used, and are expected to be removed in Version 3.000
(currently unplanned and unscheduled): uni58A6-TW (CID+13852), uni5B0F-TW (CID+15204), uni5B38-TW
(CID+15300), uni5D45-TW (CID+16313), uni5D93-TW (CID+16476), uni5E61-TW (CID+16819), uni61BE-TW
(CID+18366), uni64BC-TW (CID+19658), uni6937-TW (CID+21605), uni69F9-CN (CID+21965), uni7158-TW
(CID+25284), uni71D4-TW (CID+25554), uni720B-JP (CID+25667), uni756A-TW (CID+27154), uni7690-CN
(CID+27719), uni78FB-TW (CID+28713), uni7BB4-TW (CID+30074), uni7C53-TW (CID+30421), uni7DD8-TW
(CID+31252), uni7E59-TW (CID+31534), uni7FB3-TW (CID+32075), uni81B0-TW (CID+33147), uni8543-TW
(CID+35181), uni85E9-TW (CID+35584), uni87E0-TW (CID+36504), uni8B52-TW (CID+38257), uni8B85-TW
(CID+38372), uni8E6F-TW (CID+39481), uni8F53-TW (CID+39883), uni8F57-TW (CID+39895), uni9407-TW
(CID+42337), uni9C55-TW (CID+45975), and u24A01-KR (CID+60576).

* The seven per-weight glyph synopsis PDFs now include 2,090 pages, with the first 132 pages showing all
65,535 glyphs indexed by CID.


### Noto Sans CJK 2.000 Release Notes

19 November 2018

This is an update to Noto Sans CJK.

Changes

Version 2.000

Build Date: November 2, 2018. Built By: Dr. Ken Lunde (小林劍󠄁). Release Date: November 19, 2018.

Compared to the previous release—Version 1.004 that was released on 2015-06-16 a large number of changes were made, 
far too many to list here. Listed below are some of the more significant changes that were made in this release:

* A second flavor of Traditional Chinese, for Hong Kong and supporting the HKSCS-2016 standard, was added, 
which increased the total number of font resources by 16, from 72 to 88.

* 155 new mappings have been added to the CMap resources. 66 are from BMP code points, 22 are from Plane 1 code points, 
and the remaining 67 are from Plane 2 code points. Among the 67 new Plane 2 code points, 57 are from Extension B, 
two are from Extension C, three are from Extension E, and the remaining five are from Extension F.

* As a result of removing approximately 1,750 glyphs in order to make room for approximately 1,750 new glyphs, the CID 
assignments of the glyphs necessarily and drastically changed. The CID assignments of exactly 200 glyphs are unchanged 
from Version 1.004: 0–107, 2570–2633, 47223–47232, 47262–47272, 47281–47286, and 65484.

* The Traditional Chinese form of the Radical #162 辶 component was improved.

* The URO is complete up through U+9FEF (Unicode Version 11.0).

* The glyphs for some of the kana were tweaked.

* The glyphs and support for bopomofo, along with their tone marks, were improved. This involved adding the 'GDEF' (Glyph Definition) 
table, the 'mark' (Mark Positioning) GPOS feature, and the 'ruby' (Ruby Notation Forms) GSUB feature.

* The language and script declarations in the 'locl' and 'vert' GSUB features were improved.

* The 13-page glyph synopsis PDFs for the 500 pre-composed high-frequency hangul syllables have been incorporated into the 
Unicode-base glyph synopsis PDFs, and are bookmarked under the “Korean” bookmark.

* Placeholder glyphs for U+32FF, uni32FF (CID+2184) and uni32FF-V (CID+65359), are included. This character has 
been reserved for the two-ideograph square ligature that represents the name of Japan’s forthcoming new era which 
starts on 2019-05-01, and will be the only character added in Unicode Version 12.1.

* Like Source Han Serif, the CIDFont and CMap resources do not include XUID arrays.

* Like Source Han Serif, there are no mappings for the range U+0000 through U+001F.

* Like Source Han Serif, the code points that correspond to Halfwidth Jamo variants map to glyphs that 
correspond to code points in the Hangul Compatibility Jamo block. In other words, the glyphs for half-width jamo have been removed.

* Like Source Han Serif, the 'name' table does not includes any Macintosh (PlatformID=1) strings.

* Like Source Han Serif, the Regular weight is now style-linked to the Bold weight. This means that the Bold 
weight may not appear in the font menu, particularly when using applications that support style-linking as a way to make text bold.

* Like Source Han Serif, the 'vert' GPOS feature is included.

* Like Source Han Serif, the deprecated 'hngl' (Hangul) GSUB feature is not included in the Korean fonts and font instances.


Known Issues

Please report all issues in the GitHub repository so that they can be properly tracked and addressed, and for greater 
visibility among the user community. The Wiki also conveys some useful information about upcoming releases. Also, be sure 
to thoroughly check the closed issues prior to submitting a new issue, being sure to exercise the search feature.

Because these fonts exercise several architectural limits, particularly the ones that include 65,535 glyphs, some 
environments may have difficulties using them properly, sometimes due to implementation limits or poor assumptions. 
If this is the case, please report such issues so that they can be recorded and tracked. You are also strongly encouraged 
to contact the developer of such environments to report the same.

General

* While not an issue per se, all of the fonts include placeholder (aka blank) glyphs for U+32FF, uni32FF (CID+2184) and 
uni32FF-V (CID+65359), which is the code point that has been reserved for the two-ideograph square ligature form of the 
name of Japan’s forthcoming new era that takes effect on 2019-05-01. U+32FF is expected to be included in Unicode 
Version 12.1. The purpose of including the placeholder glyphs is to facilitate a dot-release shortly after the official 
announcement of the era name is made.

* The glyphs for the four CJK Unified Ideographs Extension G ideographs, which are made accessible via the 'ccmp' GSUB 
feature using their IDSes, will be mapped from the appropriate Plane 3 code points as soon as their code points have been 
deemed stable enough to implement.


####General Notes

* The OS/2.usWeightClass value for ExtraLight was changed from 250 to 200.
See Issue [#86](https://github.com/googlei18n/noto-cjk/issues/86).

* Mappings for U+3164 and U+2D544 (Extension F) were added to all CMap resources,
and the Adobe-Japan1 IVS <U+2D544,U+E0100> was added to the Japanese IVS definition
file, SourceHanSerif_JP_sequences.txt.
See Issue [#37](https://github.com/adobe-fonts/source-han-serif/issues/37).

* The glyphs for U+2EC1 ⻁, U+2EEA ⻪, U+2F2C 屮, and U+4EBD 亽 now map to
uni864EuE0101-JP, uni9EFE-CN, uni5C6E-CN, and uni4EBD-CN, respectively, in
all CMap resources.
See Issue [#37](https://github.com/adobe-fonts/source-han-serif/issues/37).

* The glyphs for the 52 half-width jamo—U+FFA0 through U+FFBE, U+FFC2 through U+FFC7,
U+FFCA through U+FFCF, U+FFD2 through U+FFD7, and U+FFDA through U+FFDC—now map to
the glyphs for compatibility jamo (U+3131 through U+3164).

* The alternate proportional digits and punctuation, along with the alternate
half-width punctuation, were added to the scope of the ‘fwid’, ‘hwid’, and ‘pwid’ GSUB features.

####Simplified Chinese

* CN glyphs for U+35EB 㗫, U+385C 㡜, U+5015 倕, U+57F5 埵, U+618F 憏, U+63EF 揯, U+6456 摖, U+6660 晠,
U+66A9 暩, U+68B1 梱, U+6F08 漈, U+76E4 盤, U+7808 砈, U+78DC 磜, U+7A07 稇, U+7A44 穄, U+7BA0 箠,
U+83D9 菙, U+92EE 鋮, U+9318 錘, U+969B 際, U+9BCE 鯎, and U+9C36 鰶 were added.
See Issue [#40](https://github.com/adobe-fonts/source-han-serif/issues/40).

* The glyphs for U+2F22 夊, U+2F58 爻, U+4F8D 侍, U+62FF 拿, U+6301 持, U+6641 晁, U+6C35 氵, U+6DE6 淦,
U+6DFC 淼, U+6EB4 溴, and U+81EC 臬 now map to uni590A-CN, uni723B-CN, uni4F8D-JP, uni62FF-JP,
uni6301-JP, uni6641-JP, uni6C35-JP, uni6DE6-JP, uni6DFC-JP, uni6EB4-JP, and uni81EC-JP, respectively.
See [#37](https://github.com/adobe-fonts/source-han-serif/issues/37).

* The CN glyphs uni3E76-CN, uni414D-CN, uni4A60-CN, uni4BD5-CN, uni4C53-CN, uni4F5B-CN, uni4FB9-CN,
uni596E-CN, uni5957-CN, uni5A17-CN, uni5EAD-CN, uni5EF7-CN, uni5F73-CN, uni602B-CN, uni62C2-CN,
uni633A-CN, uni6883-CN, uni6C11-CN, uni6C1F-CN, uni6CB8-CN, uni6D8F-CN, uni6E88-CN, uni70F6-CN,
uni73FD-CN, uni7829-CN, uni7D8E-CN, uni7ECB-CN, uni8121-CN, uni8247-CN, uni8713-CN, uni8A94-CN,
uni8B04-CN, uni92CC-CN, uni94E4-CN, uni95AE-CN, uni9F2E-CN, uniFF1B-CN, uniFE14-CN, and u2CD9F-CN
were tweaked or corrected.
See Issue [#36](https://github.com/adobe-fonts/source-han-serif/issues/36) and
[#39](https://github.com/adobe-fonts/source-han-serif/issues/39).

####Traditional Chinese—TW

* TW glyphs for U+4FB9 侹, U+5EAD 庭, U+5EF7 廷, U+633A 挺, U+6883 梃, U+6D8F 涏, U+6DEB 淫, U+73FD 珽,
U+7D8E 綎, U+7F54 罔, U+8713 蜓, U+8DA3 趣, U+92CC 鋌, U+95AE 閮, and U+9832 頲 were added.
See [#40](https://github.com/adobe-fonts/source-han-serif/issues/40).

* The glyphs for U+2F61 瓦, U+2FCC 黽, U+504F 偏, U+5553 啓, U+555F 啟, U+58F3 壳, U+58FE 壾, U+591A 多,
U+61DC 懜, U+627F 承, U+6902 椂, U+6903 椃, U+6947 楇, U+7171 煱, U+76EC 盬, U+77A2 瞢, U+77D2 矒,
U+8019 耙, U+803B 耻, U+8B04 謄, and U+9BF1 鯱 now map to uni74E6-JP, uni9EFD-JP, uni504FuE0101-JP,
uni5553uE0101-JP, uni555F-JP, uni58F3-JP, uni58FE-JP, uni591A-JP, uni61DC-JP, uni627F-JP, uni6902-JP,
uni6903-JP, uni6947-JP, uni7171-JP, uni76EC-CN, uni77A2uE0101-JP, uni77D2-JP, uni8019-JP, uni803B-JP,
uni8B04-CN, and uni9BF1-JP, respectively.
See [#37](https://github.com/adobe-fonts/source-han-serif/issues/37).

* The glyphs uni511A-TW, uni5922-TW, uni5A6C-TW, uni5FB5-TW, uni61F5-TW, uni750B-TW, uni750D-TW,
uni7AC5-TW, uni7D73-TW, uni83E1-TW, uni858E-TW, uni85A8-TW, uni8609-TW, uni9138-TW, uni91C5-TW, and
uniFF0C-TW were tweaked or corrected.
See [#36](https://github.com/adobe-fonts/source-han-serif/issues/36) and
[#39](https://github.com/adobe-fonts/source-han-serif/issues/39).

####Japanese

* The JP glyphs uni3CDA-JP, uni3D93-JP, uni507D-JP, uni5316uE0101-JP, uni595C-JP, uni6C2B-JP, uni70BA-JP,
uni7669-JP, uni81F7-JP, uni8285-JP, uni82B1uE0101-JP, and uni9B58-JP were tweaked or corrected.
See [#36](https://github.com/adobe-fonts/source-han-serif/issues/36) and
[#39](https://github.com/adobe-fonts/source-han-serif/issues/39).

* The glyphs for a small number of kana, to include annotated versions thereof, were tweaked in very minor
ways.

####Korean

* The glyphs for U+5173 关 and U+5BE7 寧 now map to uni5173-CN and uni5BE7uE0100-JP, respectively.
See [#37](https://github.com/adobe-fonts/source-han-serif/issues/37).

* The glyphs uniC625, uniC73D, uni1178, uni118C.vjmo01, uni1190.vjmo01, uni1192.vjmo01, uni11ED,
uni11ED.tjmo01, uni11ED.tjmo02, uni11ED.tjmo03, uni11ED.tjmo04, uniD7B5, uniD7B5.vjmo01,
uniD7F5, uniD7F5.tjmo01, uniD7F5.tjmo02, uniD7F5.tjmo03, uniD7F5.tjmo04, uniD7F6, uniD7F6.tjmo01,
uniD7F6.tjmo02, uniD7F6.tjmo03, uniD7F6.tjmo04, uni1112uni119Euni11D9, uni1140uni1175uni11D9, and
uni114Cuni116Funi11D9 were corrected.
See [#39](https://github.com/adobe-fonts/source-han-serif/issues/39).

* The no-op uni115F to uni115F substitutions were removed from the six “ljmo_0n” lookups, referenc-
es to uni115F were removed from the six “ljmo_xxxxxx” lookups, and glyph classes are now used for the
“ljmo_xxxxxx,” “vjmo_xxxxxx,” and “tjmo_xxxxxx” lookups.


###Noto Sans CJK 1.004 Release Notes

June 15, 2015

* Restore correct vertical Japanese Kana forms

The vertical kana glyphs that are made accessible via the 'vert' GSUB feature were
inadvertently reverted to their Version 1.000 forms (except for those that were added in
Version 1.002, meaning CIDs 65496 through 65505) in Version 1.002, which affected CIDs
65166 through 65251, 65256 through 65258, 65260 through 65352, 65354 through 65369, and
65471 through 65484. The correct forms, which were present in Version 1.001, are now
included.


###Noto Sans CJK 1.003 Release Notes

June 8, 2015

- Regularized the vertical metrics across all weights by setting the O/2.uWinAscent and
  O/2.uWinDescent values to 1160 and 320 respectively and using those sames values in the
  horizontal header (hhea) table.
- The ‘locl’ GSUB feature was reconfigured to be usable in a broader range of contexts.


###Noto Sans CJK 1.002 Release Notes

April 20, 2015

This release includes a license change, the addition of several new font instances, and a
number of bug fixes.

----------------------
License Change
----------------------
The open source license is changed from Apache License, Version 2.0 to SIL Open Font
License, Version 1.1.

---------------------------
New Font Instances
---------------------------
In total eight (4 languages x 2 weights) monospaced half-width OTF fonts were added, in
regular and bold weights.

 - Noto Sans Mono CJK SC Regular and Bold
 - Noto Sans Mono CJK JP Regular and Bold
 - Noto Sans Mono CJK KR Regular and Bold
 - Noto Sans Mono CJK TC Regular and Bold

The monospace fonts differ from the existing ones only in that the default (encoded)
glyphs for ASCII (U+0020 to U+007E), U+00A0 ( ), U+00A5 (¥), U+2011 (‑), and U+20A9 (₩)
are half-width instead of proportional.

The new monospace fonts can be found in:
 - All-in-one CJK super OTC font (now includes 36 font instances)
 - CJK OTF fonts with different default language (two additional font instances for each
   language)
 - NotoSansCJK-Regular.ttc and NotoSansCJK-Bold.ttc (four additional font instances in
   each)

Although eight new font instances were added, the footprint of the super OTC only
increased by 1M or so, mainly due to the four additional 'cmap' tables. Two of the seven
OTC now contain eight font instances.

--------------
Bug Fixes
--------------
The Noto issues that have been fixed include:

 - https://code.google.com/p/noto/issues/detail?id=74
 - https://code.google.com/p/noto/issues/detail?id=126
 - https://code.google.com/p/noto/issues/detail?id=136
 - https://code.google.com/p/noto/issues/detail?id=151
 - https://code.google.com/p/noto/issues/detail?id=182
 - https://code.google.com/p/noto/issues/detail?id=193
 - https://code.google.com/p/noto/issues/detail?id=266

In addition to the issues tracked at code.google.com/p/noto/issues, there are also a
number of fixes to issues tracked at https://github.com/adobe-fonts/source-han-sans.
Please find the details in the release notes for Source Han Sans.


Noto Sans CJK 1.001 Release Notes
=================================

September 12, 2014

With this release there have been a number of bug fixes and some
reorganization of the packages.  The package reorganization carries with it
a small name change that affects the name of the file, menu name, and the
internal PostScript name of the original OTF format font.  This is a one
time name change only and names will be stable going forward.

Bug Fixes
---------
There have been a number of fixes but the two most obvious ones are the fix
in the alignment of the traditional Chinese punctuation and adjustment of
the designs used for traditional Chinese to align better for usage in Hong
Kong.

https://code.google.com/p/noto/issues/detail?id=38
https://code.google.com/p/noto/issues/detail?id=54

Package Reorganization
----------------------
With this release there was an expansion in the number of file formats and
combinations in which the fonts are being made available.

There are now four major groups of font files by package in this release.
These are:

* Super OpenType Collection (Super OTC)
    - This is a new format this release that bundles all 7 weights for all 4
      languages into one large font resource.  It is smaller overall than
      the combination of the 28 fonts that would be used otherwise because
      of resource sharing and it is much easier to install.

* OpenType Collection (OTC)
    - Each OTC fully supports each of the four languages. There are 7 of these
      with one for each weight.

* Language Specific OTF
    - Each font file supports each of the four languages by using the OpenType
      ‘locl’ feature. However, by default, when the ‘locl’ feature is not
      used, each font file supports a specific language.  That means that
      there are 28 font files - 4 languages x 7 weights.
    - This format of 4 language specific variants is new with this release and
      replaces the previous single language variant that required the use of
      the ‘locl’ feature.  This is where the name change occurred as we now
      tag the various versions with the name of the default language.

* Region Specific OTF subsets
    - Each font file supports a region specific subset of the full fonts.
      These contain only the glyphs needed for the specific region.  There
      are 28 of these font files - 4 languages x 7 weights.
