/*
 * Copyright (C) 2006-2014 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>
#include <string.h>

#include "conv_zero.h"

void *
conv_zero_open(const char *filename, uint64_t size)
{
	return (void *) 1;
}

int
conv_zero_close(void *_c)
{
	assert(_c == (void *) 1);

	return 0;
}

int64_t
conv_zero_read(void *_c, void *_buf, uint64_t buflen, uint64_t pos)
{
	assert(_c == (void *) 1);
	
	memset(_buf, 0, buflen);

	return buflen;
}
